/*
 * Decompiled with CFR 0.152.
 */
package com.backblaze.b2.client;

import com.backblaze.b2.util.B2ByteProgressListener;
import com.backblaze.b2.util.B2Clock;

class B2ByteProgressFilteringListener
implements B2ByteProgressListener {
    private final B2ByteProgressListener listener;
    private final long nMillisBetween;
    private long millisThreshold;
    private long bytesSoFar;

    private B2ByteProgressFilteringListener(B2ByteProgressListener listener, long nMillisBetween) {
        this.listener = listener;
        this.nMillisBetween = nMillisBetween;
    }

    B2ByteProgressFilteringListener(B2ByteProgressListener listener) {
        this(listener, 5000L);
    }

    @Override
    public void progress(long nBytesSoFar) {
        this.bytesSoFar = nBytesSoFar;
        long monoMillis = B2Clock.get().monotonicMillis();
        if (monoMillis >= this.millisThreshold) {
            this.listener.progress(nBytesSoFar);
            this.millisThreshold = monoMillis + this.nMillisBetween;
        }
    }

    @Override
    public void hitException(Exception e, long nBytesSoFar) {
        this.bytesSoFar = nBytesSoFar;
        this.listener.hitException(e, nBytesSoFar);
    }

    @Override
    public void reachedEof(long nBytesSoFar) {
        this.bytesSoFar = nBytesSoFar;
        this.listener.reachedEof(nBytesSoFar);
    }

    public long getBytesSoFar() {
        return this.bytesSoFar;
    }
}

