/*
 * Decompiled with CFR 0.152.
 */
package javafx.scene.control;

import java.lang.ref.WeakReference;
import javafx.beans.NamedArg;
import javafx.scene.control.TableColumnBase;
import javafx.scene.control.TablePositionBase;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeTableColumn;
import javafx.scene.control.TreeTableView;

public class TreeTablePosition<S, T>
extends TablePositionBase<TreeTableColumn<S, T>> {
    private final WeakReference<TreeTableView<S>> controlRef;
    private final WeakReference<TreeItem<S>> treeItemRef;
    int fixedColumnIndex = -1;

    public TreeTablePosition(@NamedArg(value="treeTableView") TreeTableView<S> treeTableView, @NamedArg(value="row") int row, @NamedArg(value="tableColumn") TreeTableColumn<S, T> tableColumn) {
        super(row, tableColumn);
        this.controlRef = new WeakReference<TreeTableView<S>>(treeTableView);
        this.treeItemRef = new WeakReference<TreeItem<S>>(treeTableView.getTreeItem(row));
    }

    @Override
    public int getColumn() {
        if (this.fixedColumnIndex > -1) {
            return this.fixedColumnIndex;
        }
        TreeTableView<S> tableView = this.getTreeTableView();
        TableColumnBase tableColumn = this.getTableColumn();
        return tableView == null || tableColumn == null ? -1 : tableView.getVisibleLeafIndex((TreeTableColumn<S, ?>)tableColumn);
    }

    public final TreeTableView<S> getTreeTableView() {
        return (TreeTableView)this.controlRef.get();
    }

    @Override
    public final TreeTableColumn<S, T> getTableColumn() {
        return (TreeTableColumn)super.getTableColumn();
    }

    public final TreeItem<S> getTreeItem() {
        return (TreeItem)this.treeItemRef.get();
    }
}

