/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections.transformation;

import com.sun.javafx.collections.NonIterableChange;
import com.sun.javafx.collections.SortHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.ListIterator;
import java.util.function.Predicate;
import javafx.beans.NamedArg;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.TransformationList;

public final class FilteredList<E>
extends TransformationList<E, E> {
    private int[] filtered;
    private int size;
    private SortHelper helper;
    private static final Predicate ALWAYS_TRUE = t -> true;
    private ObjectProperty<Predicate<? super E>> predicate;

    public FilteredList(@NamedArg(value="source") ObservableList<E> source, @NamedArg(value="predicate") Predicate<? super E> predicate) {
        super(source);
        this.filtered = new int[source.size() * 3 / 2 + 1];
        if (predicate != null) {
            this.setPredicate(predicate);
        } else {
            this.size = 0;
            while (this.size < source.size()) {
                this.filtered[this.size] = this.size;
                ++this.size;
            }
        }
    }

    public FilteredList(@NamedArg(value="source") ObservableList<E> source) {
        this(source, null);
    }

    public final ObjectProperty<Predicate<? super E>> predicateProperty() {
        if (this.predicate == null) {
            this.predicate = new ObjectPropertyBase<Predicate<? super E>>(){

                @Override
                protected void invalidated() {
                    FilteredList.this.refilter();
                }

                @Override
                public Object getBean() {
                    return FilteredList.this;
                }

                @Override
                public String getName() {
                    return "predicate";
                }
            };
        }
        return this.predicate;
    }

    public final Predicate<? super E> getPredicate() {
        return this.predicate == null ? null : (Predicate)this.predicate.get();
    }

    public final void setPredicate(Predicate<? super E> predicate) {
        this.predicateProperty().set(predicate);
    }

    private Predicate<? super E> getPredicateImpl() {
        if (this.getPredicate() != null) {
            return this.getPredicate();
        }
        return ALWAYS_TRUE;
    }

    @Override
    protected void sourceChanged(ListChangeListener.Change<? extends E> c) {
        this.beginChange();
        while (c.next()) {
            if (c.wasPermutated()) {
                this.permutate(c);
                continue;
            }
            if (c.wasUpdated()) {
                this.update(c);
                continue;
            }
            this.addRemove(c);
        }
        this.endChange();
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public E get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.getSource().get(this.filtered[index]);
    }

    @Override
    public int getSourceIndex(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.filtered[index];
    }

    private SortHelper getSortHelper() {
        if (this.helper == null) {
            this.helper = new SortHelper();
        }
        return this.helper;
    }

    private int findPosition(int p) {
        if (this.filtered.length == 0) {
            return 0;
        }
        if (p == 0) {
            return 0;
        }
        int pos = Arrays.binarySearch(this.filtered, 0, this.size, p);
        if (pos < 0) {
            pos ^= 0xFFFFFFFF;
        }
        return pos;
    }

    private void ensureSize(int size) {
        if (this.filtered.length < size) {
            int[] replacement = new int[size * 3 / 2 + 1];
            System.arraycopy(this.filtered, 0, replacement, 0, this.size);
            this.filtered = replacement;
        }
    }

    private void updateIndexes(int from, int delta) {
        int i = from;
        while (i < this.size) {
            int n = i++;
            this.filtered[n] = this.filtered[n] + delta;
        }
    }

    private void permutate(ListChangeListener.Change<? extends E> c) {
        int from = this.findPosition(c.getFrom());
        int to = this.findPosition(c.getTo());
        if (to > from) {
            for (int i = from; i < to; ++i) {
                this.filtered[i] = c.getPermutation(this.filtered[i]);
            }
            int[] perm = this.getSortHelper().sort(this.filtered, from, to);
            this.nextPermutation(from, to, perm);
        }
    }

    private void addRemove(ListChangeListener.Change<? extends E> c) {
        Predicate<E> pred = this.getPredicateImpl();
        this.ensureSize(this.getSource().size());
        int from = this.findPosition(c.getFrom());
        int to = this.findPosition(c.getFrom() + c.getRemovedSize());
        for (int i = from; i < to; ++i) {
            this.nextRemove(from, c.getRemoved().get(this.filtered[i] - c.getFrom()));
        }
        this.updateIndexes(to, c.getAddedSize() - c.getRemovedSize());
        int fpos = from;
        int pos = c.getFrom();
        ListIterator it = this.getSource().listIterator(pos);
        while (fpos < to && it.nextIndex() < c.getTo()) {
            if (!pred.test(it.next())) continue;
            this.filtered[fpos] = it.previousIndex();
            this.nextAdd(fpos, fpos + 1);
            ++fpos;
        }
        if (fpos < to) {
            System.arraycopy(this.filtered, to, this.filtered, fpos, this.size - to);
            this.size -= to - fpos;
        } else {
            while (it.nextIndex() < c.getTo()) {
                if (pred.test(it.next())) {
                    System.arraycopy(this.filtered, fpos, this.filtered, fpos + 1, this.size - fpos);
                    this.filtered[fpos] = it.previousIndex();
                    this.nextAdd(fpos, fpos + 1);
                    ++fpos;
                    ++this.size;
                }
                ++pos;
            }
        }
    }

    private void update(ListChangeListener.Change<? extends E> c) {
        int sourceFrom;
        Predicate<E> pred = this.getPredicateImpl();
        this.ensureSize(this.getSource().size());
        int sourceTo = c.getTo();
        int filterFrom = this.findPosition(sourceFrom);
        int filterTo = this.findPosition(sourceTo);
        ListIterator it = this.getSource().listIterator(sourceFrom);
        int pos = filterFrom;
        for (sourceFrom = c.getFrom(); pos < filterTo || sourceFrom < sourceTo; ++sourceFrom) {
            Object el = it.next();
            if (pos < this.size && this.filtered[pos] == sourceFrom) {
                if (!pred.test(el)) {
                    this.nextRemove(pos, el);
                    System.arraycopy(this.filtered, pos + 1, this.filtered, pos, this.size - pos - 1);
                    --this.size;
                    --filterTo;
                    continue;
                }
                this.nextUpdate(pos);
                ++pos;
                continue;
            }
            if (!pred.test(el)) continue;
            this.nextAdd(pos, pos + 1);
            System.arraycopy(this.filtered, pos, this.filtered, pos + 1, this.size - pos);
            this.filtered[pos] = sourceFrom;
            ++this.size;
            ++pos;
            ++filterTo;
        }
    }

    private void refilter() {
        this.ensureSize(this.getSource().size());
        ArrayList removed = null;
        if (this.hasListeners()) {
            removed = new ArrayList(this);
        }
        this.size = 0;
        int i = 0;
        Predicate<E> pred = this.getPredicateImpl();
        for (Object next : this.getSource()) {
            if (pred.test(next)) {
                this.filtered[this.size++] = i;
            }
            ++i;
        }
        if (this.hasListeners()) {
            this.fireChange(new NonIterableChange.GenericAddRemoveChange(0, this.size, removed, this));
        }
    }
}

