/*
 * Decompiled with CFR 0.152.
 */
package javafx.collections;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import javafx.collections.ObservableListBase;

public abstract class ModifiableObservableListBase<E>
extends ObservableListBase<E> {
    @Override
    public boolean setAll(Collection<? extends E> col) {
        this.beginChange();
        try {
            this.clear();
            this.addAll(col);
        }
        finally {
            this.endChange();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(Collection<? extends E> c) {
        this.beginChange();
        try {
            boolean res;
            boolean bl = res = super.addAll(c);
            return bl;
        }
        finally {
            this.endChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        this.beginChange();
        try {
            boolean res;
            boolean bl = res = super.addAll(index, c);
            return bl;
        }
        finally {
            this.endChange();
        }
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.beginChange();
        try {
            super.removeRange(fromIndex, toIndex);
        }
        finally {
            this.endChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeAll(Collection<?> c) {
        this.beginChange();
        try {
            boolean res;
            boolean bl = res = super.removeAll(c);
            return bl;
        }
        finally {
            this.endChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        this.beginChange();
        try {
            boolean res;
            boolean bl = res = super.retainAll(c);
            return bl;
        }
        finally {
            this.endChange();
        }
    }

    @Override
    public void add(int index, E element) {
        this.doAdd(index, element);
        this.beginChange();
        this.nextAdd(index, index + 1);
        ++this.modCount;
        this.endChange();
    }

    @Override
    public E set(int index, E element) {
        E old = this.doSet(index, element);
        this.beginChange();
        this.nextSet(index, old);
        this.endChange();
        return old;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i != -1) {
            this.remove(i);
            return true;
        }
        return false;
    }

    @Override
    public E remove(int index) {
        E old = this.doRemove(index);
        this.beginChange();
        this.nextRemove(index, old);
        ++this.modCount;
        this.endChange();
        return old;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new SubObservableList(super.subList(fromIndex, toIndex));
    }

    @Override
    public abstract E get(int var1);

    @Override
    public abstract int size();

    protected abstract void doAdd(int var1, E var2);

    protected abstract E doSet(int var1, E var2);

    protected abstract E doRemove(int var1);

    private class SubObservableList
    implements List<E> {
        private List<E> sublist;

        public SubObservableList(List<E> sublist) {
            this.sublist = sublist;
        }

        @Override
        public int size() {
            return this.sublist.size();
        }

        @Override
        public boolean isEmpty() {
            return this.sublist.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.sublist.contains(o);
        }

        @Override
        public Iterator<E> iterator() {
            return this.sublist.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.sublist.toArray();
        }

        @Override
        public <T> T[] toArray(T[] a) {
            return this.sublist.toArray(a);
        }

        @Override
        public boolean add(E e) {
            return this.sublist.add(e);
        }

        @Override
        public boolean remove(Object o) {
            return this.sublist.remove(o);
        }

        @Override
        public boolean containsAll(Collection<?> c) {
            return this.sublist.containsAll(c);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(Collection<? extends E> c) {
            ModifiableObservableListBase.this.beginChange();
            try {
                boolean res;
                boolean bl = res = this.sublist.addAll(c);
                return bl;
            }
            finally {
                ModifiableObservableListBase.this.endChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            ModifiableObservableListBase.this.beginChange();
            try {
                boolean res;
                boolean bl = res = this.sublist.addAll(index, c);
                return bl;
            }
            finally {
                ModifiableObservableListBase.this.endChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            ModifiableObservableListBase.this.beginChange();
            try {
                boolean res;
                boolean bl = res = this.sublist.removeAll(c);
                return bl;
            }
            finally {
                ModifiableObservableListBase.this.endChange();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            ModifiableObservableListBase.this.beginChange();
            try {
                boolean res;
                boolean bl = res = this.sublist.retainAll(c);
                return bl;
            }
            finally {
                ModifiableObservableListBase.this.endChange();
            }
        }

        @Override
        public void clear() {
            ModifiableObservableListBase.this.beginChange();
            try {
                this.sublist.clear();
            }
            finally {
                ModifiableObservableListBase.this.endChange();
            }
        }

        @Override
        public E get(int index) {
            return this.sublist.get(index);
        }

        @Override
        public E set(int index, E element) {
            return this.sublist.set(index, element);
        }

        @Override
        public void add(int index, E element) {
            this.sublist.add(index, element);
        }

        @Override
        public E remove(int index) {
            return this.sublist.remove(index);
        }

        @Override
        public int indexOf(Object o) {
            return this.sublist.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.sublist.lastIndexOf(o);
        }

        @Override
        public ListIterator<E> listIterator() {
            return this.sublist.listIterator();
        }

        @Override
        public ListIterator<E> listIterator(int index) {
            return this.sublist.listIterator(index);
        }

        @Override
        public List<E> subList(int fromIndex, int toIndex) {
            return new SubObservableList(this.sublist.subList(fromIndex, toIndex));
        }

        @Override
        public boolean equals(Object obj) {
            return this.sublist.equals(obj);
        }

        @Override
        public int hashCode() {
            return this.sublist.hashCode();
        }

        public String toString() {
            return this.sublist.toString();
        }
    }
}

