/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.DirtyRegionContainer;
import com.sun.javafx.geom.DirtyRegionPool;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.AbstractShadow;
import com.sun.scenario.effect.BoxShadow;
import com.sun.scenario.effect.Color4f;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.GaussianShadowState;
import com.sun.scenario.effect.impl.state.LinearConvolveKernel;

public class GaussianShadow
extends AbstractShadow {
    private GaussianShadowState state = new GaussianShadowState();

    public GaussianShadow() {
        this(10.0f);
    }

    public GaussianShadow(float radius) {
        this(radius, Color4f.BLACK);
    }

    public GaussianShadow(float radius, Color4f color) {
        this(radius, color, DefaultInput);
    }

    public GaussianShadow(float radius, Color4f color, Effect input) {
        super(input);
        this.state.setRadius(radius);
        this.state.setShadowColor(color);
    }

    @Override
    LinearConvolveKernel getState() {
        return this.state;
    }

    @Override
    public Effect.AccelType getAccelType(FilterContext fctx) {
        return Renderer.getRenderer(fctx).getAccelType();
    }

    @Override
    public final Effect getInput() {
        return this.getInputs().get(0);
    }

    @Override
    public void setInput(Effect input) {
        this.setInput(0, input);
    }

    public float getRadius() {
        return this.state.getRadius();
    }

    public void setRadius(float radius) {
        float old = this.state.getRadius();
        this.state.setRadius(radius);
    }

    public float getHRadius() {
        return this.state.getHRadius();
    }

    public void setHRadius(float hradius) {
        float old = this.state.getHRadius();
        this.state.setHRadius(hradius);
    }

    public float getVRadius() {
        return this.state.getVRadius();
    }

    public void setVRadius(float vradius) {
        float old = this.state.getVRadius();
        this.state.setVRadius(vradius);
    }

    @Override
    public float getSpread() {
        return this.state.getSpread();
    }

    @Override
    public void setSpread(float spread) {
        float old = this.state.getSpread();
        this.state.setSpread(spread);
    }

    @Override
    public Color4f getColor() {
        return this.state.getShadowColor();
    }

    @Override
    public void setColor(Color4f color) {
        Color4f old = this.state.getShadowColor();
        this.state.setShadowColor(color);
    }

    @Override
    public float getGaussianRadius() {
        return this.getRadius();
    }

    @Override
    public float getGaussianWidth() {
        return this.getHRadius() * 2.0f + 1.0f;
    }

    @Override
    public float getGaussianHeight() {
        return this.getVRadius() * 2.0f + 1.0f;
    }

    @Override
    public void setGaussianRadius(float r) {
        this.setRadius(r);
    }

    @Override
    public void setGaussianWidth(float w) {
        this.setHRadius(w < 1.0f ? 0.0f : (w - 1.0f) / 2.0f);
    }

    @Override
    public void setGaussianHeight(float h) {
        this.setVRadius(h < 1.0f ? 0.0f : (h - 1.0f) / 2.0f);
    }

    @Override
    public AbstractShadow.ShadowMode getMode() {
        return AbstractShadow.ShadowMode.GAUSSIAN;
    }

    @Override
    public AbstractShadow implFor(AbstractShadow.ShadowMode mode) {
        int passes = 0;
        switch (mode) {
            case GAUSSIAN: {
                return this;
            }
            case ONE_PASS_BOX: {
                passes = 1;
                break;
            }
            case TWO_PASS_BOX: {
                passes = 2;
                break;
            }
            case THREE_PASS_BOX: {
                passes = 3;
            }
        }
        BoxShadow box = new BoxShadow();
        box.setInput(this.getInput());
        box.setGaussianWidth(this.getGaussianWidth());
        box.setGaussianHeight(this.getGaussianHeight());
        box.setColor(this.getColor());
        box.setPasses(passes);
        box.setSpread(this.getSpread());
        return box;
    }

    @Override
    public BaseBounds getBounds(BaseTransform transform, Effect defaultInput) {
        BaseBounds r = super.getBounds(null, defaultInput);
        int hpad = this.state.getPad(0);
        int vpad = this.state.getPad(1);
        RectBounds ret = new RectBounds(r.getMinX(), r.getMinY(), r.getMaxX(), r.getMaxY());
        ret.grow(hpad, vpad);
        return GaussianShadow.transformBounds(transform, ret);
    }

    @Override
    public Rectangle getResultBounds(BaseTransform transform, Rectangle outputClip, ImageData ... inputDatas) {
        Rectangle r = super.getResultBounds(transform, outputClip, inputDatas);
        int hpad = this.state.getPad(0);
        int vpad = this.state.getPad(1);
        Rectangle ret = new Rectangle(r);
        ret.grow(hpad, vpad);
        return ret;
    }

    @Override
    public boolean reducesOpaquePixels() {
        return true;
    }

    @Override
    public DirtyRegionContainer getDirtyRegions(Effect defaultInput, DirtyRegionPool regionPool) {
        Effect di = this.getDefaultedInput(0, defaultInput);
        DirtyRegionContainer drc = di.getDirtyRegions(defaultInput, regionPool);
        drc.grow(this.state.getPad(0), this.state.getPad(1));
        return drc;
    }
}

