/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

import com.sun.javafx.geom.BaseBounds;
import com.sun.javafx.geom.Point2D;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.Vec2f;
import com.sun.javafx.geom.Vec3f;

public class BoxBounds
extends BaseBounds {
    private float minX;
    private float maxX;
    private float minY;
    private float maxY;
    private float minZ;
    private float maxZ;

    public BoxBounds() {
        this.minZ = 0.0f;
        this.minY = 0.0f;
        this.minX = 0.0f;
        this.maxZ = -1.0f;
        this.maxY = -1.0f;
        this.maxX = -1.0f;
    }

    @Override
    public BaseBounds copy() {
        return new BoxBounds(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    public BoxBounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.setBounds(minX, minY, minZ, maxX, maxY, maxZ);
    }

    public BoxBounds(BoxBounds other) {
        this.setBounds(other);
    }

    @Override
    public BaseBounds.BoundsType getBoundsType() {
        return BaseBounds.BoundsType.BOX;
    }

    @Override
    public boolean is2D() {
        return false;
    }

    @Override
    public float getWidth() {
        return this.maxX - this.minX;
    }

    @Override
    public float getHeight() {
        return this.maxY - this.minY;
    }

    @Override
    public float getDepth() {
        return this.maxZ - this.minZ;
    }

    @Override
    public float getMinX() {
        return this.minX;
    }

    public void setMinX(float minX) {
        this.minX = minX;
    }

    @Override
    public float getMinY() {
        return this.minY;
    }

    public void setMinY(float minY) {
        this.minY = minY;
    }

    @Override
    public float getMinZ() {
        return this.minZ;
    }

    public void setMinZ(float minZ) {
        this.minZ = minZ;
    }

    @Override
    public float getMaxX() {
        return this.maxX;
    }

    public void setMaxX(float maxX) {
        this.maxX = maxX;
    }

    @Override
    public float getMaxY() {
        return this.maxY;
    }

    public void setMaxY(float maxY) {
        this.maxY = maxY;
    }

    @Override
    public float getMaxZ() {
        return this.maxZ;
    }

    public void setMaxZ(float maxZ) {
        this.maxZ = maxZ;
    }

    @Override
    public Vec2f getMin(Vec2f min) {
        if (min == null) {
            min = new Vec2f();
        }
        min.x = this.minX;
        min.y = this.minY;
        return min;
    }

    @Override
    public Vec2f getMax(Vec2f max) {
        if (max == null) {
            max = new Vec2f();
        }
        max.x = this.maxX;
        max.y = this.maxY;
        return max;
    }

    @Override
    public Vec3f getMin(Vec3f min) {
        if (min == null) {
            min = new Vec3f();
        }
        min.x = this.minX;
        min.y = this.minY;
        min.z = this.minZ;
        return min;
    }

    @Override
    public Vec3f getMax(Vec3f max) {
        if (max == null) {
            max = new Vec3f();
        }
        max.x = this.maxX;
        max.y = this.maxY;
        max.z = this.maxZ;
        return max;
    }

    @Override
    public BaseBounds deriveWithUnion(BaseBounds other) {
        if (other.getBoundsType() != BaseBounds.BoundsType.RECTANGLE && other.getBoundsType() != BaseBounds.BoundsType.BOX) {
            throw new UnsupportedOperationException("Unknown BoundsType");
        }
        this.unionWith(other);
        return this;
    }

    @Override
    public BaseBounds deriveWithNewBounds(Rectangle other) {
        if (other.width < 0 || other.height < 0) {
            return this.makeEmpty();
        }
        this.setBounds(other.x, other.y, 0.0f, other.x + other.width, other.y + other.height, 0.0f);
        return this;
    }

    @Override
    public BaseBounds deriveWithNewBounds(BaseBounds other) {
        if (other.isEmpty()) {
            return this.makeEmpty();
        }
        if (other.getBoundsType() != BaseBounds.BoundsType.RECTANGLE && other.getBoundsType() != BaseBounds.BoundsType.BOX) {
            throw new UnsupportedOperationException("Unknown BoundsType");
        }
        this.minX = other.getMinX();
        this.minY = other.getMinY();
        this.minZ = other.getMinZ();
        this.maxX = other.getMaxX();
        this.maxY = other.getMaxY();
        this.maxZ = other.getMaxZ();
        return this;
    }

    @Override
    public BaseBounds deriveWithNewBounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (maxX < minX || maxY < minY || maxZ < minZ) {
            return this.makeEmpty();
        }
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
        return this;
    }

    @Override
    public BaseBounds deriveWithNewBoundsAndSort(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.setBoundsAndSort(minX, minY, minZ, maxX, maxY, maxZ);
        return this;
    }

    @Override
    public RectBounds flattenInto(RectBounds bounds) {
        if (bounds == null) {
            bounds = new RectBounds();
        }
        if (this.isEmpty()) {
            return bounds.makeEmpty();
        }
        bounds.setBounds(this.minX, this.minY, this.maxX, this.maxY);
        return bounds;
    }

    public final void setBounds(BaseBounds other) {
        this.minX = other.getMinX();
        this.minY = other.getMinY();
        this.minZ = other.getMinZ();
        this.maxX = other.getMaxX();
        this.maxY = other.getMaxY();
        this.maxZ = other.getMaxZ();
    }

    public final void setBounds(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.minX = minX;
        this.minY = minY;
        this.minZ = minZ;
        this.maxX = maxX;
        this.maxY = maxY;
        this.maxZ = maxZ;
    }

    @Override
    public void setBoundsAndSort(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        this.setBounds(minX, minY, minZ, maxX, maxY, maxZ);
        this.sortMinMax();
    }

    @Override
    public void setBoundsAndSort(Point2D p1, Point2D p2) {
        this.setBoundsAndSort(p1.x, p1.y, 0.0f, p2.x, p2.y, 0.0f);
    }

    public void unionWith(BaseBounds other) {
        if (other.isEmpty()) {
            return;
        }
        if (this.isEmpty()) {
            this.setBounds(other);
            return;
        }
        this.minX = Math.min(this.minX, other.getMinX());
        this.minY = Math.min(this.minY, other.getMinY());
        this.minZ = Math.min(this.minZ, other.getMinZ());
        this.maxX = Math.max(this.maxX, other.getMaxX());
        this.maxY = Math.max(this.maxY, other.getMaxY());
        this.maxZ = Math.max(this.maxZ, other.getMaxZ());
    }

    public void unionWith(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (maxX < minX || maxY < minY || maxZ < minZ) {
            return;
        }
        if (this.isEmpty()) {
            this.setBounds(minX, minY, minZ, maxX, maxY, maxZ);
            return;
        }
        this.minX = Math.min(this.minX, minX);
        this.minY = Math.min(this.minY, minY);
        this.minZ = Math.min(this.minZ, minZ);
        this.maxX = Math.max(this.maxX, maxX);
        this.maxY = Math.max(this.maxY, maxY);
        this.maxZ = Math.max(this.maxZ, maxZ);
    }

    @Override
    public void add(float x, float y, float z) {
        this.unionWith(x, y, z, x, y, z);
    }

    @Override
    public void add(Point2D p) {
        this.add(p.x, p.y, 0.0f);
    }

    @Override
    public void intersectWith(Rectangle other) {
        float x = other.x;
        float y = other.y;
        this.intersectWith(x, y, 0.0f, x + (float)other.width, y + (float)other.height, 0.0f);
    }

    @Override
    public void intersectWith(BaseBounds other) {
        if (this.isEmpty()) {
            return;
        }
        if (other.isEmpty()) {
            this.makeEmpty();
            return;
        }
        this.minX = Math.max(this.minX, other.getMinX());
        this.minY = Math.max(this.minY, other.getMinY());
        this.minZ = Math.max(this.minZ, other.getMinZ());
        this.maxX = Math.min(this.maxX, other.getMaxX());
        this.maxY = Math.min(this.maxY, other.getMaxY());
        this.maxZ = Math.min(this.maxZ, other.getMaxZ());
    }

    @Override
    public void intersectWith(float minX, float minY, float minZ, float maxX, float maxY, float maxZ) {
        if (this.isEmpty()) {
            return;
        }
        if (maxX < minX || maxY < minY || maxZ < minZ) {
            this.makeEmpty();
            return;
        }
        this.minX = Math.max(this.minX, minX);
        this.minY = Math.max(this.minY, minY);
        this.minZ = Math.max(this.minZ, minZ);
        this.maxX = Math.min(this.maxX, maxX);
        this.maxY = Math.min(this.maxY, maxY);
        this.maxZ = Math.min(this.maxZ, maxZ);
    }

    @Override
    public boolean contains(Point2D p) {
        if (p == null || this.isEmpty()) {
            return false;
        }
        return this.contains(p.x, p.y, 0.0f);
    }

    @Override
    public boolean contains(float x, float y) {
        if (this.isEmpty()) {
            return false;
        }
        return this.contains(x, y, 0.0f);
    }

    public boolean contains(float x, float y, float z) {
        if (this.isEmpty()) {
            return false;
        }
        return x >= this.minX && x <= this.maxX && y >= this.minY && y <= this.maxY && z >= this.minZ && z <= this.maxZ;
    }

    public boolean contains(float x, float y, float z, float width, float height, float depth) {
        if (this.isEmpty()) {
            return false;
        }
        return this.contains(x, y, z) && this.contains(x + width, y + height, z + depth);
    }

    @Override
    public boolean intersects(float x, float y, float width, float height) {
        return this.intersects(x, y, 0.0f, width, height, 0.0f);
    }

    public boolean intersects(float x, float y, float z, float width, float height, float depth) {
        if (this.isEmpty()) {
            return false;
        }
        return x + width >= this.minX && y + height >= this.minY && z + depth >= this.minZ && x <= this.maxX && y <= this.maxY && z <= this.maxZ;
    }

    public boolean intersects(BaseBounds other) {
        if (other == null || other.isEmpty() || this.isEmpty()) {
            return false;
        }
        return other.getMaxX() >= this.minX && other.getMaxY() >= this.minY && other.getMaxZ() >= this.minZ && other.getMinX() <= this.maxX && other.getMinY() <= this.maxY && other.getMinZ() <= this.maxZ;
    }

    @Override
    public boolean disjoint(float x, float y, float width, float height) {
        return this.disjoint(x, y, 0.0f, width, height, 0.0f);
    }

    public boolean disjoint(float x, float y, float z, float width, float height, float depth) {
        if (this.isEmpty()) {
            return true;
        }
        return x + width < this.minX || y + height < this.minY || z + depth < this.minZ || x > this.maxX || y > this.maxY || z > this.maxZ;
    }

    @Override
    public boolean isEmpty() {
        return this.maxX < this.minX || this.maxY < this.minY || this.maxZ < this.minZ;
    }

    @Override
    public void roundOut() {
        this.minX = (float)Math.floor(this.minX);
        this.minY = (float)Math.floor(this.minY);
        this.minZ = (float)Math.floor(this.minZ);
        this.maxX = (float)Math.ceil(this.maxX);
        this.maxY = (float)Math.ceil(this.maxY);
        this.maxZ = (float)Math.ceil(this.maxZ);
    }

    public void grow(float h, float v, float d) {
        this.minX -= h;
        this.maxX += h;
        this.minY -= v;
        this.maxY += v;
        this.minZ -= d;
        this.maxZ += d;
    }

    @Override
    public BaseBounds deriveWithPadding(float h, float v, float d) {
        this.grow(h, v, d);
        return this;
    }

    @Override
    public BoxBounds makeEmpty() {
        this.minZ = 0.0f;
        this.minY = 0.0f;
        this.minX = 0.0f;
        this.maxZ = -1.0f;
        this.maxY = -1.0f;
        this.maxX = -1.0f;
        return this;
    }

    @Override
    protected void sortMinMax() {
        float tmp;
        if (this.minX > this.maxX) {
            tmp = this.maxX;
            this.maxX = this.minX;
            this.minX = tmp;
        }
        if (this.minY > this.maxY) {
            tmp = this.maxY;
            this.maxY = this.minY;
            this.minY = tmp;
        }
        if (this.minZ > this.maxZ) {
            tmp = this.maxZ;
            this.maxZ = this.minZ;
            this.minZ = tmp;
        }
    }

    @Override
    public void translate(float x, float y, float z) {
        this.setMinX(this.getMinX() + x);
        this.setMinY(this.getMinY() + y);
        this.setMaxX(this.getMaxX() + x);
        this.setMaxY(this.getMaxY() + y);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoxBounds other = (BoxBounds)obj;
        if (this.minX != other.getMinX()) {
            return false;
        }
        if (this.minY != other.getMinY()) {
            return false;
        }
        if (this.minZ != other.getMinZ()) {
            return false;
        }
        if (this.maxX != other.getMaxX()) {
            return false;
        }
        if (this.maxY != other.getMaxY()) {
            return false;
        }
        return this.maxZ == other.getMaxZ();
    }

    public int hashCode() {
        int hash = 7;
        hash = 79 * hash + Float.floatToIntBits(this.minX);
        hash = 79 * hash + Float.floatToIntBits(this.minY);
        hash = 79 * hash + Float.floatToIntBits(this.minZ);
        hash = 79 * hash + Float.floatToIntBits(this.maxX);
        hash = 79 * hash + Float.floatToIntBits(this.maxY);
        hash = 79 * hash + Float.floatToIntBits(this.maxZ);
        return hash;
    }

    public String toString() {
        return "BoxBounds { minX:" + this.minX + ", minY:" + this.minY + ", minZ:" + this.minZ + ", maxX:" + this.maxX + ", maxY:" + this.maxY + ", maxZ:" + this.maxZ + "}";
    }
}

