/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font;

import com.sun.javafx.font.CharToGlyphMapper;
import com.sun.javafx.font.CompositeFontResource;
import com.sun.javafx.font.CompositeGlyphMapper;
import com.sun.javafx.font.CompositeStrike;
import com.sun.javafx.font.Disposer;
import com.sun.javafx.font.FontConfigManager;
import com.sun.javafx.font.FontResource;
import com.sun.javafx.font.FontStrike;
import com.sun.javafx.font.FontStrikeDesc;
import com.sun.javafx.font.PGFont;
import com.sun.javafx.font.PrismFont;
import com.sun.javafx.font.PrismFontFactory;
import com.sun.javafx.geom.transform.BaseTransform;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LogicalFont
implements CompositeFontResource {
    public static final String SYSTEM = "System";
    public static final String SERIF = "Serif";
    public static final String SANS_SERIF = "SansSerif";
    public static final String MONOSPACED = "Monospaced";
    public static final String STYLE_REGULAR = "Regular";
    public static final String STYLE_BOLD = "Bold";
    public static final String STYLE_ITALIC = "Italic";
    public static final String STYLE_BOLD_ITALIC = "Bold Italic";
    static final HashMap<String, String> canonicalFamilyMap = new HashMap();
    static LogicalFont[] logicalFonts;
    boolean isBold;
    boolean isItalic;
    private String fullName;
    private String familyName;
    private String styleName;
    private String physicalFamily;
    private String physicalFullName;
    private String physicalFileName;
    private FontResource slot0FontResource;
    private ArrayList<String> linkedFontFiles;
    private ArrayList<String> linkedFontNames;
    private FontResource[] fallbacks;
    private FontResource[] nativeFallbacks;
    CompositeGlyphMapper mapper;
    Map<FontStrikeDesc, WeakReference<FontStrike>> strikeMap = new ConcurrentHashMap<FontStrikeDesc, WeakReference<FontStrike>>();
    private static final int SANS_SERIF_INDEX = 0;
    private static final int SERIF_INDEX = 1;
    private static final int MONOSPACED_INDEX = 2;
    private static final int SYSTEM_INDEX = 3;
    static String[][] logFamilies;
    private int hash;

    static boolean isLogicalFont(String name) {
        int spaceIndex = name.indexOf(32);
        if (spaceIndex != -1) {
            name = name.substring(0, spaceIndex);
        }
        return canonicalFamilyMap.get(name) != null;
    }

    private static String getCanonicalFamilyName(String name) {
        if (name == null) {
            return SANS_SERIF;
        }
        String lcName = name.toLowerCase();
        return canonicalFamilyMap.get(lcName);
    }

    static PGFont getLogicalFont(String familyName, boolean bold, boolean italic, float size) {
        LogicalFont font;
        String canonicalFamilyName = LogicalFont.getCanonicalFamilyName(familyName);
        if (canonicalFamilyName == null) {
            return null;
        }
        int fontIndex = 0;
        fontIndex = canonicalFamilyName.equals(SANS_SERIF) ? 0 : (canonicalFamilyName.equals(SERIF) ? 4 : (canonicalFamilyName.equals(MONOSPACED) ? 8 : 12));
        if (bold) {
            ++fontIndex;
        }
        if (italic) {
            fontIndex += 2;
        }
        if ((font = logicalFonts[fontIndex]) == null) {
            LogicalFont.logicalFonts[fontIndex] = font = new LogicalFont(canonicalFamilyName, bold, italic);
        }
        return new PrismFont(font, font.getFullName(), size);
    }

    static PGFont getLogicalFont(String fullName, float size) {
        int spaceIndex = fullName.indexOf(32);
        if (spaceIndex == -1 || spaceIndex == fullName.length() - 1) {
            return null;
        }
        String family = fullName.substring(0, spaceIndex);
        String canonicalFamily = LogicalFont.getCanonicalFamilyName(family);
        if (canonicalFamily == null) {
            return null;
        }
        String style = fullName.substring(spaceIndex + 1).toLowerCase();
        boolean bold = false;
        boolean italic = false;
        if (!style.equals("regular")) {
            if (style.equals("bold")) {
                bold = true;
            } else if (style.equals("italic")) {
                italic = true;
            } else if (style.equals("bold italic")) {
                bold = true;
                italic = true;
            } else {
                return null;
            }
        }
        return LogicalFont.getLogicalFont(canonicalFamily, bold, italic, size);
    }

    private LogicalFont(String family, boolean bold, boolean italic) {
        this.familyName = family;
        this.isBold = bold;
        this.isItalic = italic;
        this.styleName = !bold && !italic ? STYLE_REGULAR : (bold && !italic ? STYLE_BOLD : (!bold && italic ? STYLE_ITALIC : STYLE_BOLD_ITALIC));
        this.fullName = this.familyName + " " + this.styleName;
        if (PrismFontFactory.isLinux) {
            FontConfigManager.FcCompFont fcCompFont = FontConfigManager.getFontConfigFont(family, bold, italic);
            this.physicalFullName = fcCompFont.firstFont.fullName;
            this.physicalFileName = fcCompFont.firstFont.fontFile;
        } else {
            this.physicalFamily = PrismFontFactory.getSystemFont(this.familyName);
        }
    }

    private FontResource getSlot0Resource() {
        if (this.slot0FontResource == null) {
            PrismFontFactory factory = PrismFontFactory.getFontFactory();
            this.slot0FontResource = this.physicalFamily != null ? factory.getFontResource(this.physicalFamily, this.isBold, this.isItalic, false) : factory.getFontResource(this.physicalFullName, this.physicalFileName, false);
            if (this.slot0FontResource == null) {
                this.slot0FontResource = factory.getDefaultFontResource(false);
            }
        }
        return this.slot0FontResource;
    }

    private void getLinkedFonts() {
        if (this.fallbacks == null) {
            if (PrismFontFactory.isLinux) {
                FontConfigManager.FcCompFont font = FontConfigManager.getFontConfigFont(this.familyName, this.isBold, this.isItalic);
                this.linkedFontFiles = FontConfigManager.getFileNames(font, true);
                this.linkedFontNames = FontConfigManager.getFontNames(font, true);
            } else {
                ArrayList<String>[] linkedFontInfo = PrismFontFactory.getLinkedFonts("Tahoma", true);
                this.linkedFontFiles = linkedFontInfo[0];
                this.linkedFontNames = linkedFontInfo[1];
            }
            this.fallbacks = new FontResource[this.linkedFontFiles.size()];
        }
    }

    @Override
    public int getNumSlots() {
        this.getLinkedFonts();
        int num = this.linkedFontFiles.size();
        if (this.nativeFallbacks != null) {
            num += this.nativeFallbacks.length;
        }
        return num + 1;
    }

    @Override
    public int getSlotForFont(String fontName) {
        FontResource[] tmp;
        this.getLinkedFonts();
        int i = 1;
        for (String linkedFontName : this.linkedFontNames) {
            if (fontName.equalsIgnoreCase(linkedFontName)) {
                return i;
            }
            ++i;
        }
        if (this.nativeFallbacks != null) {
            for (FontResource nativeFallback : this.nativeFallbacks) {
                if (fontName.equalsIgnoreCase(nativeFallback.getFullName())) {
                    return i;
                }
                ++i;
            }
        }
        if (i >= 126) {
            if (PrismFontFactory.debugFonts) {
                System.err.println("\tToo many font fallbacks!");
            }
            return -1;
        }
        PrismFontFactory factory = PrismFontFactory.getFontFactory();
        FontResource fr = factory.getFontResource(fontName, null, false);
        if (fr == null) {
            if (PrismFontFactory.debugFonts) {
                System.err.println("\t Font name not supported \"" + fontName + "\".");
            }
            return -1;
        }
        if (this.nativeFallbacks == null) {
            tmp = new FontResource[1];
        } else {
            tmp = new FontResource[this.nativeFallbacks.length + 1];
            System.arraycopy(this.nativeFallbacks, 0, tmp, 0, this.nativeFallbacks.length);
        }
        tmp[tmp.length - 1] = fr;
        this.nativeFallbacks = tmp;
        return i;
    }

    @Override
    public FontResource getSlotResource(int slot) {
        if (slot == 0) {
            return this.getSlot0Resource();
        }
        this.getLinkedFonts();
        if (--slot >= this.fallbacks.length) {
            if (this.nativeFallbacks == null || (slot -= this.fallbacks.length) >= this.nativeFallbacks.length) {
                return null;
            }
            return this.nativeFallbacks[slot];
        }
        if (this.fallbacks[slot] == null) {
            String file = this.linkedFontFiles.get(slot);
            String name = this.linkedFontNames.get(slot);
            this.fallbacks[slot] = PrismFontFactory.getFontFactory().getFontResource(name, file, false);
            if (this.fallbacks[slot] == null) {
                this.fallbacks[slot] = this.getSlot0Resource();
            }
        }
        return this.fallbacks[slot];
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getPSName() {
        return this.fullName;
    }

    @Override
    public String getFamilyName() {
        return this.familyName;
    }

    @Override
    public String getStyleName() {
        return this.styleName;
    }

    @Override
    public String getLocaleFullName() {
        return this.fullName;
    }

    @Override
    public String getLocaleFamilyName() {
        return this.familyName;
    }

    @Override
    public String getLocaleStyleName() {
        return this.styleName;
    }

    @Override
    public boolean isBold() {
        return this.getSlotResource(0).isBold();
    }

    @Override
    public boolean isItalic() {
        return this.getSlotResource(0).isItalic();
    }

    @Override
    public String getFileName() {
        return this.getSlotResource(0).getFileName();
    }

    @Override
    public int getFeatures() {
        return this.getSlotResource(0).getFeatures();
    }

    @Override
    public Object getPeer() {
        return null;
    }

    @Override
    public boolean isEmbeddedFont() {
        return this.getSlotResource(0).isEmbeddedFont();
    }

    @Override
    public void setPeer(Object peer) {
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    public float[] getGlyphBoundingBox(int glyphCode, float size, float[] retArr) {
        int slot = glyphCode >>> 24;
        int slotglyphCode = glyphCode & 0xFFFFFF;
        FontResource slotResource = this.getSlotResource(slot);
        return slotResource.getGlyphBoundingBox(slotglyphCode, size, retArr);
    }

    @Override
    public float getAdvance(int glyphCode, float size) {
        int slot = glyphCode >>> 24;
        int slotglyphCode = glyphCode & 0xFFFFFF;
        FontResource slotResource = this.getSlotResource(slot);
        return slotResource.getAdvance(slotglyphCode, size);
    }

    @Override
    public CharToGlyphMapper getGlyphMapper() {
        if (this.mapper == null) {
            this.mapper = new CompositeGlyphMapper(this);
        }
        return this.mapper;
    }

    @Override
    public Map<FontStrikeDesc, WeakReference<FontStrike>> getStrikeMap() {
        return this.strikeMap;
    }

    @Override
    public int getDefaultAAMode() {
        return this.getSlot0Resource().getDefaultAAMode();
    }

    @Override
    public FontStrike getStrike(float size, BaseTransform transform) {
        return this.getStrike(size, transform, this.getDefaultAAMode());
    }

    @Override
    public FontStrike getStrike(float size, BaseTransform transform, int aaMode) {
        FontStrikeDesc desc = new FontStrikeDesc(size, transform, aaMode);
        WeakReference<CompositeStrike> ref = this.strikeMap.get(desc);
        CompositeStrike strike = null;
        if (ref != null) {
            strike = (CompositeStrike)ref.get();
        }
        if (strike == null) {
            strike = new CompositeStrike(this, size, transform, aaMode, desc);
            ref = strike.disposer != null ? Disposer.addRecord(strike, strike.disposer) : new WeakReference<CompositeStrike>(strike);
            this.strikeMap.put(desc, ref);
        }
        return strike;
    }

    private static void buildFamily(String[] fullNames, String family) {
        fullNames[0] = family + " " + STYLE_REGULAR;
        fullNames[1] = family + " " + STYLE_BOLD;
        fullNames[2] = family + " " + STYLE_ITALIC;
        fullNames[3] = family + " " + STYLE_BOLD_ITALIC;
    }

    private static void buildFamilies() {
        if (logFamilies == null) {
            String[][] tmpFamilies = new String[4][4];
            LogicalFont.buildFamily(tmpFamilies[0], SANS_SERIF);
            LogicalFont.buildFamily(tmpFamilies[1], SERIF);
            LogicalFont.buildFamily(tmpFamilies[2], MONOSPACED);
            LogicalFont.buildFamily(tmpFamilies[3], SYSTEM);
            logFamilies = tmpFamilies;
        }
    }

    static void addFamilies(ArrayList<String> familyList) {
        familyList.add(SANS_SERIF);
        familyList.add(SERIF);
        familyList.add(MONOSPACED);
        familyList.add(SYSTEM);
    }

    static void addFullNames(ArrayList<String> fullNames) {
        LogicalFont.buildFamilies();
        for (int f = 0; f < logFamilies.length; ++f) {
            for (int n = 0; n < logFamilies[f].length; ++n) {
                fullNames.add(logFamilies[f][n]);
            }
        }
    }

    static String[] getFontsInFamily(String family) {
        String canonicalFamily = LogicalFont.getCanonicalFamilyName(family);
        if (canonicalFamily == null) {
            return null;
        }
        LogicalFont.buildFamilies();
        if (canonicalFamily.equals(SANS_SERIF)) {
            return logFamilies[0];
        }
        if (canonicalFamily.equals(SERIF)) {
            return logFamilies[1];
        }
        if (canonicalFamily.equals(MONOSPACED)) {
            return logFamilies[2];
        }
        return logFamilies[3];
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LogicalFont)) {
            return false;
        }
        LogicalFont other = (LogicalFont)obj;
        return this.fullName.equals(other.fullName);
    }

    public int hashCode() {
        if (this.hash != 0) {
            return this.hash;
        }
        this.hash = this.fullName.hashCode();
        return this.hash;
    }

    static {
        canonicalFamilyMap.put("system", SYSTEM);
        canonicalFamilyMap.put("serif", SERIF);
        canonicalFamilyMap.put("sansserif", SANS_SERIF);
        canonicalFamilyMap.put("sans-serif", SANS_SERIF);
        canonicalFamilyMap.put("dialog", SANS_SERIF);
        canonicalFamilyMap.put("default", SANS_SERIF);
        canonicalFamilyMap.put("monospaced", MONOSPACED);
        canonicalFamilyMap.put("monospace", MONOSPACED);
        canonicalFamilyMap.put("dialoginput", MONOSPACED);
        logicalFonts = new LogicalFont[16];
        logFamilies = null;
    }
}

