/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui;

import com.sun.glass.ui.Application;
import com.sun.glass.ui.ClipboardAssistance;
import com.sun.glass.ui.DelayedCallback;
import com.sun.glass.ui.Pixels;
import com.sun.glass.ui.PlatformFactory;
import com.sun.glass.ui.delegate.ClipboardDelegate;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class Clipboard {
    public static final String TEXT_TYPE = "text/plain";
    public static final String HTML_TYPE = "text/html";
    public static final String RTF_TYPE = "text/rtf";
    public static final String URI_TYPE = "text/uri-list";
    public static final String FILE_LIST_TYPE = "application/x-java-file-list";
    public static final String RAW_IMAGE_TYPE = "application/x-java-rawimage";
    public static final String DRAG_IMAGE = "application/x-java-drag-image";
    public static final String DRAG_IMAGE_OFFSET = "application/x-java-drag-image-offset";
    public static final String IE_URL_SHORTCUT_FILENAME = "text/ie-shortcut-filename";
    public static final int ACTION_NONE = 0;
    public static final int ACTION_COPY = 1;
    public static final int ACTION_MOVE = 2;
    public static final int ACTION_REFERENCE = 0x40000000;
    public static final int ACTION_COPY_OR_MOVE = 3;
    public static final int ACTION_ANY = 0x4FFFFFFF;
    public static final String DND = "DND";
    public static final String SYSTEM = "SYSTEM";
    public static final String SELECTION = "SELECTION";
    private static final Map<String, Clipboard> clipboards = new HashMap<String, Clipboard>();
    private static final ClipboardDelegate delegate = PlatformFactory.getPlatformFactory().createClipboardDelegate();
    private final HashSet<ClipboardAssistance> assistants = new HashSet();
    private final String name;
    private final Object localDataProtector = new Object();
    private HashMap<String, Object> localSharedData;
    private ClipboardAssistance dataSource;
    protected int supportedActions = 1;

    protected Clipboard(String name) {
        Application.checkEventThread();
        this.name = name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ClipboardAssistance assistant) {
        Application.checkEventThread();
        HashSet<ClipboardAssistance> hashSet = this.assistants;
        synchronized (hashSet) {
            this.assistants.add(assistant);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ClipboardAssistance assistant) {
        boolean needClose;
        Application.checkEventThread();
        Object object = this.localDataProtector;
        synchronized (object) {
            if (assistant == this.dataSource) {
                this.dataSource = null;
            }
        }
        Object object2 = this.assistants;
        synchronized (object2) {
            this.assistants.remove(assistant);
            needClose = this.assistants.isEmpty();
        }
        if (needClose) {
            object2 = clipboards;
            synchronized (object2) {
                clipboards.remove(this.name);
            }
            this.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setSharedData(ClipboardAssistance dataSource, HashMap<String, Object> cacheData, int supportedActions) {
        Application.checkEventThread();
        Object object = this.localDataProtector;
        synchronized (object) {
            this.localSharedData = (HashMap)cacheData.clone();
            this.supportedActions = supportedActions;
            this.dataSource = dataSource;
        }
    }

    public void flush(ClipboardAssistance dataSource, HashMap<String, Object> cacheData, int supportedActions) {
        Application.checkEventThread();
        this.setSharedData(dataSource, cacheData, supportedActions);
        this.contentChanged();
    }

    public int getSupportedSourceActions() {
        Application.checkEventThread();
        return this.supportedActions;
    }

    public void setTargetAction(int actionDone) {
        Application.checkEventThread();
        this.actionPerformed(actionDone);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void contentChanged() {
        HashSet _assistants;
        Application.checkEventThread();
        HashSet<ClipboardAssistance> hashSet = this.assistants;
        synchronized (hashSet) {
            _assistants = (HashSet)this.assistants.clone();
        }
        for (ClipboardAssistance assistant : _assistants) {
            assistant.contentChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(int action) {
        Application.checkEventThread();
        Object object = this.localDataProtector;
        synchronized (object) {
            if (null != this.dataSource) {
                this.dataSource.actionPerformed(action);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getData(String mimeType) {
        Application.checkEventThread();
        Object object = this.localDataProtector;
        synchronized (object) {
            if (this.localSharedData == null) {
                return null;
            }
            Object ret = this.localSharedData.get(mimeType);
            Object object2 = ret instanceof DelayedCallback ? ((DelayedCallback)ret).providedData() : ret;
            return object2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] getMimeTypes() {
        Application.checkEventThread();
        Object object = this.localDataProtector;
        synchronized (object) {
            if (this.localSharedData == null) {
                return null;
            }
            Set<String> mimes = this.localSharedData.keySet();
            String[] ret = new String[mimes.size()];
            int i = 0;
            for (String mime : mimes) {
                ret[i++] = mime;
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Clipboard get(String clipboardName) {
        Application.checkEventThread();
        Map<String, Clipboard> map = clipboards;
        synchronized (map) {
            if (!clipboards.keySet().contains(clipboardName)) {
                Clipboard newClipboard = delegate.createClipboard(clipboardName);
                if (newClipboard == null) {
                    newClipboard = new Clipboard(clipboardName);
                }
                clipboards.put(clipboardName, newClipboard);
            }
            return clipboards.get(clipboardName);
        }
    }

    public Pixels getPixelsForRawImage(byte[] rawimage) {
        Application.checkEventThread();
        ByteBuffer size = ByteBuffer.wrap(rawimage, 0, 8);
        int width = size.getInt();
        int height = size.getInt();
        ByteBuffer pixels = ByteBuffer.wrap(rawimage, 8, rawimage.length - 8);
        return Application.GetApplication().createPixels(width, height, pixels.slice());
    }

    public String toString() {
        return "Clipboard: " + this.name + "@" + this.hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void close() {
        Application.checkEventThread();
        Object object = this.localDataProtector;
        synchronized (object) {
            this.dataSource = null;
        }
    }

    public String getName() {
        Application.checkEventThread();
        return this.name;
    }

    public static String getActionString(int action) {
        Application.checkEventThread();
        StringBuilder ret = new StringBuilder("");
        int[] test = new int[]{1, 2, 0x40000000};
        String[] canDo = new String[]{"copy", "move", "link"};
        for (int i = 0; i < 3; ++i) {
            if ((test[i] & action) <= 0) continue;
            if (ret.length() > 0) {
                ret.append(",");
            }
            ret.append(canDo[i]);
        }
        return ret.toString();
    }
}

