/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.ani.util.nix;

import com.ahsay.ani.SystemInfo;
import com.ahsay.ani.util.ComputerInfo;
import com.ahsay.ani.util.nix.DefaultUtil;
import com.ahsay.ani.util.nix.LinuxUtil;
import com.ahsay.ani.util.nix.NixFileHandle;
import com.ahsay.ani.util.nix.NixFileList;
import com.ahsay.ani.util.nix.NixFileList$NixFile;
import com.ahsay.ani.util.nix.NixUtil$CpuModel;
import com.ahsay.ani.util.nix.SosUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;

public class NixUtil {
    public static final boolean IS_SUPPORTED_LIN = SystemInfo.IS_LINUX && (SystemInfo.IS_OS_ARCH_PPC || SystemInfo.IS_OS_ARCH_PPC64 || SystemInfo.IS_OS_ARCH_X86 || SystemInfo.IS_OS_ARCH_X64 || SystemInfo.IS_OS_ARCH_ARM || SystemInfo.IS_OS_ARCH_AARCH64 || SystemInfo.IS_OS_ARCH_SPARC);
    public static final boolean IS_SUPPORTED_FBD = SystemInfo.IS_FREEBSD && (SystemInfo.IS_OS_ARCH_X86 || SystemInfo.IS_OS_ARCH_X64);
    public static final boolean IS_SUPPORTED_OBD = SystemInfo.IS_OPENBSD && (SystemInfo.IS_OS_ARCH_X86 || SystemInfo.IS_OS_ARCH_X64);
    public static final boolean IS_SUPPORTED_SOS = SystemInfo.IS_SUN_OS && (SystemInfo.IS_OS_ARCH_X86 || SystemInfo.IS_OS_ARCH_X64 || SystemInfo.IS_OS_ARCH_SPARC);
    public static final boolean IS_SUPPORTED = IS_SUPPORTED_LIN || IS_SUPPORTED_FBD || IS_SUPPORTED_OBD || IS_SUPPORTED_SOS;
    public static final int UNKNOWN_VALUE = -1;
    public static final int FILE_ATTRIBUTE_NORMAL = 128;
    protected static final long PATH_NOT_EXIST_SIZE = 0L;
    protected static final long UNSUPPORTED_SIZE = 0x20000000000L;
    protected static final String NIXUTIL_DEBUG_PROPERTY = "com.ahsay.afc.util.nix.NixUtil.debug";
    protected static final String DEFAULT_UTIL_DEBUG_PROPERTY = "com.ahsay.afc.util.nix.DefaultUtil.force";
    protected static final boolean NIX_DEBUG = "true".equalsIgnoreCase(System.getProperty("com.ahsay.afc.util.nix.NixUtil.debug"));
    protected static final boolean FORCE_DEFAULT_UTIL = "true".equalsIgnoreCase(System.getProperty("com.ahsay.afc.util.nix.DefaultUtil.force"));
    private static boolean a = false;

    public native NixFileList$NixFile getFileStat(String var1);

    public native int getUID(String var1);

    public native int getGUID(String var1);

    public native int getMode(String var1);

    public native void listFiles(NixFileList var1, String var2);

    public native void setFileModePermission(String var1, int var2, int var3, int var4);

    protected native long createFileN(String var1, int var2);

    protected native long openFileN(String var1);

    public native int read(long var1, byte[] var3, int var4, int var5);

    public native void write(long var1, byte[] var3, int var4, int var5);

    public native long skip(long var1, long var3);

    public native void closeFile(long var1);

    public native void setLastModified(String var1, long var2);

    public boolean isFileSystemPath(String string) {
        return IS_SUPPORTED_LIN ? string.startsWith("/proc") || string.startsWith("/sys") || string.startsWith("/run") || string.startsWith("/var/run") || string.startsWith("/var/lock") : (IS_SUPPORTED_FBD || IS_SUPPORTED_OBD ? string.startsWith("/dev") : IS_SUPPORTED_SOS && (string.startsWith("/proc") || string.startsWith("/devices") || string.startsWith("/system/contract") || string.startsWith("/system/object") || string.startsWith("/dev/fd") || string.startsWith("/tmp") || string.startsWith("/etc/dfs/sharetab")));
    }

    public native boolean isLink(String var1);

    protected NixUtil(boolean bl) {
        if (bl) {
            NixUtil.a();
        }
        this.init("UTF-8".equals(Charset.defaultCharset().name()));
    }

    private static synchronized void a() {
        if (!a) {
            String string = SystemInfo.getNativeLibName("NixUtil");
            System.loadLibrary(string);
            a = true;
        }
    }

    public native boolean createSymbolicLink(String var1, String var2);

    public native boolean isFileAFile(String var1);

    public native boolean isFileASocket(String var1);

    public native boolean isFileABlockDev(String var1);

    public native boolean isFileACharDev(String var1);

    public native boolean isFileANamedPipe(String var1);

    public native boolean isFileADir(String var1);

    public native boolean createNamedPipe(String var1);

    public native boolean getIsPathDir(String var1);

    public native boolean getIsPathFile(String var1);

    public native boolean getIsPathLink(String var1);

    public native boolean getIsPathNamedPipe(String var1);

    public native boolean getIsPathSocket(String var1);

    public native boolean getIsPathBlockDev(String var1);

    public native boolean getIsPathCharDev(String var1);

    public native String getTargetPath(String var1);

    public native byte getFinalTargetType(String var1);

    public native boolean mkdir(String var1);

    public native String getWorkingDir();

    public native boolean isFileExist(String var1);

    public native boolean delete(String var1);

    private native String getVersionN();

    private native String getSystemModelN();

    private native String getMotherboardUUIDN();

    public native String getUBSVersion();

    protected native void getFileStatHpx(String var1, NixFileList$NixFile var2);

    protected native boolean isSELinuxSupportedN();

    protected native boolean isSELinuxEnabledN();

    protected native String getSecurityContextN(String var1);

    protected native boolean setSecurityContextN(String var1, String var2);

    public native void getFileStatSos(String var1, NixFileList$NixFile var2);

    public native long getFreeDiskSpaceN(String var1);

    public native long getTotalDiskSpaceN(String var1);

    private native void getHardDiskSerialNumberN(ComputerInfo var1);

    private native void init(boolean var1);

    public String getSecurityContext(String string) {
        return "";
    }

    public static NixUtil getInstance() {
        if (NIX_DEBUG) {
            System.out.println();
            System.out.println("[NixUtil] [getInstance] FORCE_DEFAULT_UTIL: " + FORCE_DEFAULT_UTIL);
            System.out.println("[NixUtil] [getInstance] IS_SUPPORTED_LIN: " + IS_SUPPORTED_LIN);
            System.out.println("[NixUtil] [getInstance] IS_SUPPORTED_FBD: " + IS_SUPPORTED_FBD);
            System.out.println("[NixUtil] [getInstance] IS_SUPPORTED_OBD: " + IS_SUPPORTED_OBD);
            System.out.println("[NixUtil] [getInstance] IS_SUPPORTED_SUN_OS: " + IS_SUPPORTED_SOS);
        }
        if (FORCE_DEFAULT_UTIL) {
            return new DefaultUtil();
        }
        if (IS_SUPPORTED_LIN) {
            return new LinuxUtil();
        }
        if (IS_SUPPORTED_SOS) {
            return new SosUtil(true);
        }
        if (IS_SUPPORTED_FBD || IS_SUPPORTED_OBD) {
            return new NixUtil(true);
        }
        System.out.println("[NixUtil.getInstance] DefaultUtil is now being used instead because NixUtil is not supported on os.name='" + SystemInfo.OS_NAME + "' os.arch='" + SystemInfo.OS_ARCH + "'.");
        return new DefaultUtil();
    }

    public NixFileHandle createFile(String string) {
        long l = this.createFileN(string, 493);
        return new NixFileHandle(l);
    }

    public NixFileHandle openFile(String string) {
        long l = this.openFileN(string);
        return new NixFileHandle(l);
    }

    public int read(NixFileHandle nixFileHandle, byte[] byArray, int n, int n2) {
        return this.read(nixFileHandle.lHandle, byArray, n, n2);
    }

    public void write(NixFileHandle nixFileHandle, byte[] byArray, int n, int n2) {
        this.write(nixFileHandle.lHandle, byArray, n, n2);
    }

    public long skip(NixFileHandle nixFileHandle, long l) {
        return this.skip(nixFileHandle.lHandle, l);
    }

    public void closeFile(NixFileHandle nixFileHandle) {
        this.closeFile(nixFileHandle.lHandle);
    }

    public NixFileList listFiles(String string) {
        NixFileList nixFileList = new NixFileList();
        this.listFiles(nixFileList, string);
        return nixFileList;
    }

    public void setSecurityContext(String string, String string2) {
    }

    public boolean mkdir(String string, boolean bl) {
        boolean bl2 = this.mkdir(string);
        if (bl2 && bl) {
            try {
                File file = new File(string);
                String string2 = file.getParent();
                int n = this.getUID(string2);
                int n2 = this.getGUID(string2);
                int n3 = this.getMode(string2);
                this.setFileModePermission(string, n, n2, n3);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl2;
    }

    public String getLinkAbsolutePath(NixFileList$NixFile nixFileList$NixFile) {
        if (!nixFileList$NixFile.getCanonicalPath().startsWith("/")) {
            return nixFileList$NixFile.getParent() + "/" + nixFileList$NixFile.getCanonicalPath();
        }
        return nixFileList$NixFile.getCanonicalPath();
    }

    public String getOSVersion() {
        return this.getVersionN().trim();
    }

    public String getSystemModel() {
        return this.getSystemModelN().trim();
    }

    public String getCpuModel() {
        String string = "";
        ArrayList<? extends NixUtil$CpuModel> arrayList = this.getCpuModelList();
        if (arrayList == null || arrayList.isEmpty()) {
            return string;
        }
        for (int i = 0; i < arrayList.size(); ++i) {
            NixUtil$CpuModel nixUtil$CpuModel = arrayList.get(i);
            String string2 = nixUtil$CpuModel.getModelName();
            if (string2 == null || "".equals(string2)) continue;
            if (i > 0) {
                string = string + ",";
            }
            string = string + string2;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<? extends NixUtil$CpuModel> getCpuModelList() {
        File file = new File("/var/run/dmesg.boot");
        if (!file.exists()) {
            throw new IOException("[NixUtil.getCpuModelList] \"" + file.getPath() + "\" not found.");
        }
        ArrayList<NixUtil$CpuModel> arrayList = new ArrayList<NixUtil$CpuModel>();
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));){
            String string;
            int n = 0;
            while ((string = bufferedReader.readLine()) != null) {
                if (!string.startsWith("CPU")) continue;
                String string2 = NixUtil.getValue(string);
                arrayList.add(new NixUtil$CpuModel(Integer.toString(n), string2));
                ++n;
            }
        }
        return arrayList;
    }

    public void getHardDiskSN(ComputerInfo computerInfo) {
        this.getHardDiskSerialNumberN(computerInfo);
    }

    public String getMotherboardUUID() {
        return this.getMotherboardUUIDN().trim();
    }

    public String getUsername() {
        return SystemInfo.USER_NAME;
    }

    public boolean isPathBackupable(String string) {
        if (string == null || "".equals(string) || !this.isFileExist(string) || this.isFileSystemPath(string)) {
            return false;
        }
        try {
            return this.isLink(string) || this.isFileANamedPipe(string) || this.isFileADir(string) || this.isFileAFile(string);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    protected static String getValue(String string) {
        if (string == null || "".equals(string)) {
            return string;
        }
        int n = string.indexOf(":");
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1).trim();
    }
}

