/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.ani.util.nix;

import com.ahsay.ani.util.ComputerInfo;
import com.ahsay.ani.util.nix.LinuxFileList;
import com.ahsay.ani.util.nix.LinuxUtil$CpuModel;
import com.ahsay.ani.util.nix.NixFileList;
import com.ahsay.ani.util.nix.NixUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;

public class LinuxUtil
extends NixUtil {
    private static boolean a = false;
    private static boolean b = false;

    private native void listFilesN(LinuxFileList var1, String var2);

    private native String getVersionN();

    private native String getSystemModelN();

    private native String getMotherboardUUIDN();

    private native void getHardDiskSerialNumberN(ComputerInfo var1);

    public LinuxUtil() {
        super(true);
        if (!a) {
            b = this.isSELinuxEnabledN();
            a = true;
        }
    }

    public boolean isSELinuxEnabled() {
        return b;
    }

    @Override
    public String getSecurityContext(String string) {
        if (!this.isSELinuxEnabled()) {
            return "";
        }
        return this.getSecurityContextN(string);
    }

    @Override
    public void setSecurityContext(String string, String string2) {
        this.setSecurityContextN(string, string2);
    }

    @Override
    public NixFileList listFiles(String string) {
        LinuxFileList linuxFileList = new LinuxFileList();
        this.listFilesN(linuxFileList, string);
        return linuxFileList;
    }

    public void listFiles(LinuxFileList linuxFileList, String string) {
        this.listFilesN(linuxFileList, string);
    }

    @Override
    public String getOSVersion() {
        return this.getVersionN().trim();
    }

    @Override
    public String getSystemModel() {
        return this.getSystemModelN().trim();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<LinuxUtil$CpuModel> getCpuModelList() {
        File file = new File("/proc/cpuinfo");
        if (!file.exists()) {
            throw new IOException("[LinuxUtil.getCpuModelList] \"" + file.getPath() + "\" not found.");
        }
        ArrayList<LinuxUtil$CpuModel> arrayList = new ArrayList<LinuxUtil$CpuModel>();
        try (FileInputStream fileInputStream = new FileInputStream(file);
             BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));){
            String string;
            LinuxUtil$CpuModel linuxUtil$CpuModel = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("processor")) {
                    if (linuxUtil$CpuModel != null && !LinuxUtil$CpuModel.isDuplicated(arrayList, linuxUtil$CpuModel.getPhysicalID())) {
                        arrayList.add(linuxUtil$CpuModel);
                    }
                    linuxUtil$CpuModel = new LinuxUtil$CpuModel(LinuxUtil.getValue(string));
                    continue;
                }
                if (string.startsWith("model name")) {
                    if (linuxUtil$CpuModel == null) continue;
                    linuxUtil$CpuModel.setModelName(LinuxUtil.getValue(string));
                    continue;
                }
                if (!string.startsWith("physical id") || linuxUtil$CpuModel == null) continue;
                linuxUtil$CpuModel.setPhysicalID(LinuxUtil.getValue(string));
            }
            if (linuxUtil$CpuModel != null && !LinuxUtil$CpuModel.isDuplicated(arrayList, linuxUtil$CpuModel.getPhysicalID())) {
                arrayList.add(linuxUtil$CpuModel);
            }
        }
        return arrayList;
    }

    @Override
    public void getHardDiskSN(ComputerInfo computerInfo) {
        this.getHardDiskSerialNumberN(computerInfo);
    }

    @Override
    public String getMotherboardUUID() {
        return this.getMotherboardUUIDN().trim();
    }
}

