/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.ani.util;

import com.ahsay.ani.util.UtilException;
import java.text.NumberFormat;

public class NumberUtil {
    public static final boolean DEFAULT_ENDIAN = true;
    public static final int BYTE_SIZE = 1;
    public static final int SHORT_SIZE = 2;
    public static final int INT_SIZE = 4;
    public static final int LONG_SIZE = 8;
    public static final byte TRUE_BYTE = 1;
    public static final byte FALSE_BYTE = 0;
    private static long a = System.currentTimeMillis();
    private static final char[] b = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static final double round(double d, int n) {
        double d2 = Math.pow(10.0, n);
        return (double)Math.round(d * d2) / d2;
    }

    public static final float round(float f, int n) {
        float f2 = (float)Math.pow(10.0, n);
        return (float)Math.round(f * f2) / f2;
    }

    public static final String toCompSpeedStyle(long l, int n, int n2) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(n);
        numberFormat.setMinimumFractionDigits(n2);
        long l2 = l;
        if (Math.abs(l2) >= 1000000000000L) {
            float f = (float)l2 / 1.0E12f;
            return numberFormat.format(f) + "T";
        }
        if (Math.abs(l2) >= 1000000000L) {
            float f = (float)l2 / 1.0E9f;
            return numberFormat.format(f) + "G";
        }
        if (Math.abs(l2) >= 1000000L) {
            float f = (float)l2 / 1000000.0f;
            return numberFormat.format(f) + "M";
        }
        if (Math.abs(l2) >= 1000L) {
            float f = (float)l2 / 1000.0f;
            return numberFormat.format(f) + "K";
        }
        return Long.toString(l2);
    }

    public static final String toCompStyle(String string, int n) {
        return NumberUtil.toCompStyle(Long.parseLong(string), n);
    }

    public static final String toCompStyle(long l, int n) {
        return NumberUtil.toCompStyle(l, n, 0);
    }

    public static final String toCompStyle(long l, int n, int n2) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        numberFormat.setMaximumFractionDigits(n);
        numberFormat.setMinimumFractionDigits(n2);
        long l2 = l;
        if (Math.abs(l2) >= 0x10000000000L) {
            float f = (float)l2 / 1.0995116E12f;
            return numberFormat.format(f) + "T";
        }
        if (Math.abs(l2) >= 0x40000000L) {
            float f = (float)l2 / 1.0737418E9f;
            return numberFormat.format(f) + "G";
        }
        if (Math.abs(l2) >= 0x100000L) {
            float f = (float)l2 / 1048576.0f;
            return numberFormat.format(f) + "M";
        }
        if (Math.abs(l2) >= 1024L) {
            float f = (float)l2 / 1024.0f;
            return numberFormat.format(f) + "K";
        }
        return Long.toString(l2);
    }

    public static final String toCompStyle(long l) {
        NumberFormat numberFormat = NumberFormat.getInstance();
        long l2 = l;
        if (Math.abs(l2) >= 0x10000000000L) {
            float f = (float)l2 / 1.0995116E12f;
            numberFormat.setMaximumFractionDigits(2);
            return numberFormat.format(f) + "T";
        }
        if (Math.abs(l2) >= 0x40000000L) {
            float f = (float)l2 / 1.0737418E9f;
            numberFormat.setMaximumFractionDigits(2);
            return numberFormat.format(f) + "G";
        }
        if (Math.abs(l2) >= 0x100000L) {
            float f = (float)l2 / 1048576.0f;
            numberFormat.setMaximumFractionDigits(2);
            return numberFormat.format(f) + "M";
        }
        if (Math.abs(l2) >= 1024L) {
            float f = l2 / 1024L;
            numberFormat.setMaximumFractionDigits(1);
            return numberFormat.format(f) + "K";
        }
        return Long.toString(l2);
    }

    public static final int write(boolean bl, byte[] byArray, int n) {
        return NumberUtil.write(bl ? (byte)1 : 0, byArray, n);
    }

    public static final int write(byte by, byte[] byArray, int n) {
        if (byArray == null) {
            return n + 1;
        }
        byArray[n] = by;
        return n + 1;
    }

    public static final int write(byte[] byArray, byte[] byArray2, int n) {
        if (byArray2 == null) {
            return n + byArray.length;
        }
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
        return n + byArray.length;
    }

    public static final int writeBytes(byte[] byArray, byte[] byArray2, int n) {
        if (byArray2 == null) {
            return n + 2 + byArray.length;
        }
        n = NumberUtil.write((short)byArray.length, byArray2, n, true);
        System.arraycopy(byArray, 0, byArray2, n, byArray.length);
        return n + byArray.length;
    }

    public static final byte[] toBytes(short s) {
        return NumberUtil.toBytes(s, true);
    }

    public static final byte[] toBytes(short s, boolean bl) {
        byte[] byArray = new byte[2];
        NumberUtil.write(s, byArray, 0, bl);
        return byArray;
    }

    public static final int write(short s, byte[] byArray, int n) {
        return NumberUtil.write(s, byArray, n, true);
    }

    public static final int write(short s, byte[] byArray, int n, boolean bl) {
        if (byArray == null) {
            return n + 2;
        }
        short s2 = s;
        byArray[n + (bl ? 1 : 0)] = (byte)s2;
        s2 = (short)(s2 >> 8);
        byArray[n + (bl ? 0 : 1)] = (byte)s2;
        return n + 2;
    }

    public static final byte[] toBytes(int n) {
        return NumberUtil.toBytes(n, true);
    }

    public static final byte[] toBytes(int n, boolean bl) {
        byte[] byArray = new byte[4];
        NumberUtil.write(n, byArray, 0, bl);
        return byArray;
    }

    public static final int write(int n, byte[] byArray, int n2) {
        return NumberUtil.write(n, byArray, n2, true);
    }

    public static final int write(int n, byte[] byArray, int n2, boolean bl) {
        if (byArray == null) {
            return n2 + 4;
        }
        int n3 = n;
        byArray[n2 + (bl ? 3 : 0)] = (byte)n3;
        byArray[n2 + (bl ? 2 : 1)] = (byte)(n3 >>= 8);
        byArray[n2 + (bl ? 1 : 2)] = (byte)(n3 >>= 8);
        byArray[n2 + (bl ? 0 : 3)] = (byte)(n3 >>= 8);
        return n2 + 4;
    }

    public static final byte[] toBytes(long l) {
        return NumberUtil.toBytes(l, true);
    }

    public static final byte[] toBytes(long l, boolean bl) {
        byte[] byArray = new byte[8];
        NumberUtil.write(l, byArray, 0, bl);
        return byArray;
    }

    public static final int writeAs6Bytes(long l, byte[] byArray, int n) {
        return NumberUtil.writeAs6Bytes(l, byArray, n, true);
    }

    public static final int writeAs6Bytes(long l, byte[] byArray, int n, boolean bl) {
        if (byArray == null) {
            return n + 6;
        }
        long l2 = l;
        byArray[n + (bl ? 5 : 0)] = (byte)l2;
        byArray[n + (bl ? 4 : 1)] = (byte)(l2 >>= 8);
        byArray[n + (bl ? 3 : 2)] = (byte)(l2 >>= 8);
        byArray[n + (bl ? 2 : 3)] = (byte)(l2 >>= 8);
        byArray[n + (bl ? 1 : 4)] = (byte)(l2 >>= 8);
        byArray[n + (bl ? 0 : 5)] = (byte)(l2 >>= 8);
        return n + 6;
    }

    public static final int writeLess(long l, byte[] byArray, int n, int n2) {
        if (byArray == null) {
            return n + n2;
        }
        long l2 = l;
        for (int i = n2 - 1; i >= 0; --i) {
            byArray[n + i] = (byte)l2;
            l2 >>= 8;
        }
        return n + n2;
    }

    public static final int write(long l, byte[] byArray, int n) {
        return NumberUtil.write(l, byArray, n, true);
    }

    public static final int write(long l, byte[] byArray, int n, boolean bl) {
        if (byArray == null) {
            return n + 8;
        }
        long l2 = l;
        byArray[n + (bl ? 7 : 0)] = (byte)l2;
        byArray[n + (bl ? 6 : 1)] = (byte)(l2 >>= 8);
        byArray[n + (bl ? 5 : 2)] = (byte)(l2 >>= 8);
        byArray[n + (bl ? 4 : 3)] = (byte)(l2 >>= 8);
        byArray[n + (bl ? 3 : 4)] = (byte)(l2 >>= 8);
        byArray[n + (bl ? 2 : 5)] = (byte)(l2 >>= 8);
        byArray[n + (bl ? 1 : 6)] = (byte)(l2 >>= 8);
        byArray[n + (bl ? 0 : 7)] = (byte)(l2 >>= 8);
        return n + 8;
    }

    public static final boolean parseBool(byte[] byArray, int n) {
        return byArray[n] == 1;
    }

    public static final short parseShort(byte[] byArray) {
        return NumberUtil.parseShort(byArray, 0, true);
    }

    public static final short parseShort(byte[] byArray, int n) {
        return NumberUtil.parseShort(byArray, n, true);
    }

    public static final short parseShort(byte[] byArray, int n, boolean bl) {
        if (byArray == null) {
            return 0;
        }
        if (byArray.length - n < 2) {
            return 0;
        }
        int n2 = 0;
        n2 |= byArray[n + (bl ? 0 : 1)] & 0xFF;
        n2 <<= 8;
        return (short)(n2 |= byArray[n + (bl ? 1 : 0)] & 0xFF);
    }

    public static final int parseInt(byte[] byArray) {
        return NumberUtil.parseInt(byArray, 0, true);
    }

    public static final int parseInt(byte[] byArray, int n) {
        return NumberUtil.parseInt(byArray, n, true);
    }

    public static final int parseInt(byte[] byArray, int n, boolean bl) {
        if (byArray == null) {
            return 0;
        }
        if (byArray.length - n < 4) {
            return 0;
        }
        int n2 = 0;
        n2 |= byArray[n + (bl ? 0 : 3)] & 0xFF;
        n2 <<= 8;
        n2 |= byArray[n + (bl ? 1 : 2)] & 0xFF;
        n2 <<= 8;
        n2 |= byArray[n + (bl ? 2 : 1)] & 0xFF;
        n2 <<= 8;
        return n2 |= byArray[n + (bl ? 3 : 0)] & 0xFF;
    }

    public static final long parseLongAs6Bytes(byte[] byArray) {
        return NumberUtil.parseLongAs6Bytes(byArray, 0, true);
    }

    public static final long parseLongAs6Bytes(byte[] byArray, int n) {
        return NumberUtil.parseLongAs6Bytes(byArray, n, true);
    }

    public static final long parseLongAs6Bytes(byte[] byArray, int n, boolean bl) {
        if (byArray == null) {
            return 0L;
        }
        if (byArray.length - n < 6) {
            return 0L;
        }
        long l = 0L;
        l |= (long)(byArray[n + (bl ? 0 : 5)] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + (bl ? 1 : 4)] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + (bl ? 2 : 3)] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + (bl ? 3 : 2)] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + (bl ? 4 : 1)] & 0xFF);
        l <<= 8;
        if ((l |= (long)(byArray[n + (bl ? 5 : 0)] & 0xFF)) > 0x800000000000L) {
            l |= 0xFFFF000000000000L;
        }
        return l;
    }

    public static final long parseLong(byte[] byArray) {
        return NumberUtil.parseLong(byArray, 0, true);
    }

    public static final long parseLong(byte[] byArray, int n) {
        return NumberUtil.parseLong(byArray, n, true);
    }

    public static final long parseLong(byte[] byArray, int n, boolean bl) {
        if (byArray == null) {
            return 0L;
        }
        if (byArray.length - n < 8) {
            return 0L;
        }
        long l = 0L;
        l |= (long)(byArray[n + (bl ? 0 : 7)] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + (bl ? 1 : 6)] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + (bl ? 2 : 5)] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + (bl ? 3 : 4)] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + (bl ? 4 : 3)] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + (bl ? 5 : 2)] & 0xFF);
        l <<= 8;
        l |= (long)(byArray[n + (bl ? 6 : 1)] & 0xFF);
        l <<= 8;
        return l |= (long)(byArray[n + (bl ? 7 : 0)] & 0xFF);
    }

    public static final long parseLess(byte[] byArray, int n, int n2) {
        if (n2 > 8 || n2 < 0) {
            String string = "[NumberUtil.parseLongLess] Invalid iNoOfBytes '" + n2 + "'";
            throw new IllegalArgumentException(string);
        }
        if (byArray == null) {
            return 0L;
        }
        if (byArray.length - n < n2) {
            String string = "[NumberUtil.parseLongLess] Byte array too small. abData.length=" + byArray.length + ", iStartIdx=" + n + ", iNoOfBytes=" + n2;
            throw new IllegalArgumentException(string);
        }
        long l = 0L;
        l |= 0xFFL & (long)byArray[n];
        for (int i = 1; i < n2; ++i) {
            l <<= 8;
            l |= 0xFFL & (long)byArray[n + i];
        }
        return l;
    }

    public static final int parse(byte[] byArray, int n, byte[] byArray2) {
        if (byArray == null) {
            return 0;
        }
        if (byArray.length - n < byArray2.length) {
            return 0;
        }
        System.arraycopy(byArray, n, byArray2, 0, byArray2.length);
        return n + byArray2.length;
    }

    public static final int parseBytes(byte[] byArray, byte[] byArray2) {
        return NumberUtil.parseBytes(byArray, 0, byArray2);
    }

    public static final int parseBytes(byte[] byArray, int n, byte[] byArray2) {
        if (byArray == null) {
            return 0;
        }
        if (byArray.length - n < 2) {
            return 0;
        }
        short s = NumberUtil.parseShort(byArray, n, true);
        System.arraycopy(byArray, n + 2, byArray2, 0, s);
        return n + 2 + s;
    }

    public static final synchronized long getUniqueID() {
        long l = System.currentTimeMillis();
        a = l > a ? l : ++a;
        return a;
    }

    public static final String toHexString(byte[] byArray) {
        if (byArray == null) {
            return "";
        }
        char[] cArray = new char[byArray.length * 2];
        for (int i = 0; i < byArray.length; ++i) {
            int n = byArray[i] & 0xFF;
            cArray[i * 2] = b[n >>> 4];
            cArray[i * 2 + 1] = b[n & 0xF];
        }
        return new String(cArray);
    }

    public static final int roundBitSize(int n, int n2) {
        int n3;
        if (n <= 0) {
            return n2;
        }
        for (n3 = 1; n3 <= n && n3 != Integer.MIN_VALUE; n3 <<= 1) {
        }
        return n3 >>> 1;
    }

    public static final int getBitSize(int n, boolean bl) {
        return NumberUtil.getBitSize((long)n, bl);
    }

    public static final int getBitSize(long l, boolean bl) {
        long l2 = 1L;
        for (int i = 0; i < 64; ++i) {
            if (bl && l2 >= l) {
                return i;
            }
            if (l2 == l) {
                return i;
            }
            l2 <<= 1;
        }
        if (bl) {
            throw new UtilException("[NumberUtil.getBitSize] lNum " + l + " cannot be rounded to the power of 2");
        }
        throw new UtilException("[NumberUtil.getBitSize] lNum " + l + " is not of the power of 2");
    }

    public static final void main(String[] stringArray) {
        int n = -2;
        System.out.println("RoundBitSize of " + n + " is " + NumberUtil.roundBitSize(n, -1));
        n = 0;
        System.out.println("RoundBitSize of " + n + " is " + NumberUtil.roundBitSize(n, -1));
        n = 1;
        System.out.println("RoundBitSize of " + n + " is " + NumberUtil.roundBitSize(n, -1));
        n = 2;
        System.out.println("RoundBitSize of " + n + " is " + NumberUtil.roundBitSize(n, -1));
        n = 3;
        System.out.println("RoundBitSize of " + n + " is " + NumberUtil.roundBitSize(n, -1));
        n = 4;
        System.out.println("RoundBitSize of " + n + " is " + NumberUtil.roundBitSize(n, -1));
        n = 5;
        System.out.println("RoundBitSize of " + n + " is " + NumberUtil.roundBitSize(n, -1));
        n = 0x40001111;
        System.out.println("RoundBitSize of " + n + " is " + NumberUtil.roundBitSize(n, -1));
    }

    public static String getMaxValue(String string, String string2) {
        return Long.toString(Math.max(NumberUtil.parseLong(string), NumberUtil.parseLong(string2)));
    }

    public static long parseLong(String string) {
        return string != null && !"".equals(string = string.trim()) ? Long.parseLong(string) : 0L;
    }
}

