/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.ani.util;

import com.ahsay.ani.util.FileUtil;
import java.io.File;
import java.io.IOException;

public abstract class NativeFile
extends File {
    public static final byte FILE_ATTRIBUTE_DIRECTORY = 16;
    public static final String ENCRYPTED_CONTENT = "EFS=";
    public static final String FILE_PERMISSION_OS = "OS=";
    public static final String FILE_PERMISSION_ATTR = "ATTR=";
    public static final String FILE_PERMISSION_SD = "SD=";
    public static final String FILE_PERMISSION_GID = "GID=";
    public static final String FILE_PERMISSION_UID = "UID=";
    public static final String FILE_PERMISSION_SC = "SC=";
    public static final String FILE_INFO = "INFO=";
    public static final String FILE_RESOURCE_FORK = "FORK=";
    public static final String OS_VERSION = "VERSION=";
    public static final String MAC_FORK_FILE = "MAC_FORK_FILE";
    public static final byte UNKNOWN_TYPE = -1;
    public static final byte DIR_TYPE = 0;
    public static final byte BROKEN_TYPE = 1;
    public static final byte NORMAL_TYPE = 2;
    public static final byte WIN_JUNCTION_TYPE = 16;
    public static final byte WIN_FILE_SYMBOLIC_LINK_TYPE = 17;
    public static final byte WIN_DIR_SYMBOLIC_LINK_TYPE = 18;
    public static final byte WIN_ENCRYPTED = 19;
    public static final byte NIX_SYMBOLIC_LINK_TYPE = 33;
    public static final byte NIX_NAMED_PIPE_TYPE = 34;
    public static final byte NIX_SOCKET_LINK_TYPE = 35;
    public static final byte NIX_BLOCK_SPECIAL_FILE_TYPE = 36;
    public static final byte NIX_CHARACTER_SPECIAL_FILE_TYPE = 37;
    public static final byte MAC_NAME_PIPE_TYPE = 49;
    public static final byte MAC_SYMBOLIC_LINK_TYPE = 50;
    public static final byte MAC_BLOCK_SPECIAL_FILE_TYPE = 51;
    public static final byte MAC_CHARACTER_SPECIAL_FILE_TYPE = 52;
    public static final byte MAC_SOCKET_LINK_TYPE = 53;
    public String sPath;
    public long lSize;
    public long lLastModified;
    public boolean bDir = false;
    public boolean bFile = false;
    public byte bType = (byte)2;
    public long lActualSize;
    public String sLinkTarget;
    protected byte bTargetPathType;
    protected String sEFS = "";

    public NativeFile(String string) {
        super(string);
        this.sPath = string;
    }

    public NativeFile(String string, boolean bl, boolean bl2, long l, long l2, byte by, long l3, String string2) {
        super(string);
        this.sPath = string;
        this.bDir = bl;
        this.bFile = bl2;
        this.lSize = l;
        this.lLastModified = l2;
        this.lActualSize = l3;
        this.sLinkTarget = string2;
        this.bType = by;
    }

    @Override
    public abstract String getPath();

    public abstract boolean isDir();

    @Override
    public abstract boolean isFile();

    public abstract String getFilePermission();

    public abstract long getSize();

    public abstract long getLastModified();

    public abstract long getActualFileSize();

    @Override
    public abstract String getCanonicalPath();

    public abstract boolean isLink();

    public abstract boolean isNamedPipe();

    public abstract boolean isSocket();

    public abstract boolean isBlockDev();

    public abstract boolean isCharDev();

    public void setLinkTargetType() {
        this.bTargetPathType = FileUtil.getTargetPathType(this);
    }

    public abstract byte getLinkType();

    public abstract String FileSystemObjectTargetPath();

    public void setEncryptedContent(String string) {
        this.sEFS = string;
    }

    public boolean isSupported() {
        return true;
    }

    public boolean isEfs() {
        return false;
    }

    public static boolean isAbsolute(String string) {
        boolean bl = string.startsWith("/") || string.length() > 1 && string.charAt(1) == ':' || string.startsWith("\\\\");
        return bl;
    }

    public static String relativeTargetPathIntoAbsolute(String string, String string2) {
        File file = new File(string);
        String string3 = file.getParentFile().getAbsolutePath();
        file = new File(string3, string2);
        try {
            return file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return file.getAbsolutePath();
        }
    }

    public String getTargetAbsolutePath() {
        if (this.sLinkTarget == null || "".equals(this.sLinkTarget)) {
            return this.sPath;
        }
        if (NativeFile.isAbsolute(this.sLinkTarget)) {
            return this.sLinkTarget;
        }
        return NativeFile.relativeTargetPathIntoAbsolute(this.sPath, this.sLinkTarget);
    }
}

