/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.ani.util;

import com.ahsay.ani.SystemInfo;
import com.ahsay.ani.util.ComputerInfo$CpuInfo;
import com.ahsay.ani.util.ComputerInfo$HardDiskInfo;
import com.ahsay.ani.util.MacUtil;
import com.ahsay.ani.util.NasUtil;
import com.ahsay.ani.util.QnapUtil;
import com.ahsay.ani.util.StringUtil;
import com.ahsay.ani.util.SynologyUtil;
import com.ahsay.ani.util.WindowsUtil;
import com.ahsay.ani.util.nix.NixUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TimeZone;

public class ComputerInfo {
    public static final String COMPUTER_INFO_DEBUG_PROPERTY = "com.ahsay.afc.util.ComputerInfo.debug";
    public static final boolean COMPUTER_INFO_DEBUG = "true".equalsIgnoreCase(System.getProperty("com.ahsay.afc.util.ComputerInfo.debug"));
    public static final String COMPUTER_INFO_DEBUG_TAG = "[Debug ComputerInfo] ";
    public static final String COMPUTER_INFO_SKIP_PROPERTY = "com.ahsay.afc.util.ComputerInfo.skip";
    public static final boolean COMPUTER_INFO_SKIP = "true".equalsIgnoreCase(System.getProperty("com.ahsay.afc.util.ComputerInfo.skip"));
    protected static final String UBS_TAG = "UBS";
    protected static final String VMWARE = "VMware";
    protected static final String MICROSOFT = "Microsoft";
    protected static final String VIRTUAL_BOX = "VirtualBox";
    protected String sID;
    protected String sOSName;
    protected String sSystemModel;
    protected String sCpuModel;
    protected long lRamSize;
    protected String sTimeZone;
    protected ArrayList<ComputerInfo$CpuInfo> alCpu = new ArrayList();
    protected ArrayList<ComputerInfo$HardDiskInfo> alDisk = new ArrayList();
    private static WindowsUtil a = null;
    private static MacUtil b = null;
    private static NixUtil c = null;
    private static NasUtil d = null;
    private static String e = "";
    private static long f = -1L;
    protected String sMotherboardUUID = "";

    protected ComputerInfo() {
        this.a();
        this.lRamSize = SystemInfo.getTotalPhysicalMemorySize() / 1024L / 1024L;
        this.sTimeZone = TimeZone.getDefault().getID();
        if (COMPUTER_INFO_DEBUG) {
            try {
                e = SystemInfo.getLocalhostIP();
                f = ComputerInfo.ipToLong(e);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
        }
    }

    private void a() {
        block11: {
            try {
                if (SystemInfo.IS_WINDOWS) {
                    if (WindowsUtil.IS_SUPPORTED) {
                        a = new WindowsUtil();
                    }
                } else if (SystemInfo.IS_MAC) {
                    if (MacUtil.IS_SUPPORTED) {
                        b = new MacUtil();
                    }
                } else if (SystemInfo.IS_NAS) {
                    d = SynologyUtil.IS_SUPPORTED ? new SynologyUtil() : (QnapUtil.IS_SUPPORTED ? new QnapUtil() : null);
                    c = NixUtil.getInstance();
                } else if (SystemInfo.IS_LINUX_RELATED) {
                    c = NixUtil.getInstance();
                }
            }
            catch (Throwable throwable) {
                if (!COMPUTER_INFO_DEBUG) break block11;
                throwable.printStackTrace();
            }
        }
    }

    public ComputerInfo(String string, String string2, String string3, String string4, long l, String string5) {
        this.sID = string;
        this.sOSName = string2;
        this.sSystemModel = string3;
        this.sCpuModel = string4;
        this.lRamSize = l;
        this.sTimeZone = string5;
    }

    public void setID(String string) {
        this.sID = string;
    }

    public String getID() {
        return this.sID;
    }

    public String getOSArch() {
        if (COMPUTER_INFO_DEBUG) {
            return e + SystemInfo.OS_ARCH;
        }
        return SystemInfo.OS_ARCH;
    }

    public void setOSName(String string) {
        this.sOSName = string;
    }

    public String getOSName() {
        if (COMPUTER_INFO_DEBUG) {
            return e + this.sOSName;
        }
        return this.sOSName;
    }

    public String getOSNameWithArch() {
        String string;
        String string2 = this.getOSName();
        String string3 = this.getOSArch();
        if (string2 == null || "".equals(string = string2.trim())) {
            return string2;
        }
        if (string3 != null && !"".equals(string3 = string3.trim())) {
            string = string + " " + string3;
        }
        if (COMPUTER_INFO_DEBUG) {
            return e + string;
        }
        return string;
    }

    public void setSystemModel(String string) {
        this.sSystemModel = string;
    }

    public String getSystemModel() {
        if (COMPUTER_INFO_DEBUG) {
            return e + this.sSystemModel;
        }
        return this.sSystemModel;
    }

    public void setCpuModel(String string) {
        this.sCpuModel = string;
    }

    public String getCpuModel() {
        if (COMPUTER_INFO_DEBUG) {
            return e + this.sCpuModel;
        }
        return this.sCpuModel;
    }

    public int getNumberOfCpus() {
        return StringUtil.split(this.sCpuModel, ",").length;
    }

    public long getRamSize() {
        if (COMPUTER_INFO_DEBUG && this.lRamSize <= 0L) {
            return f;
        }
        return this.lRamSize;
    }

    public String getTimezone() {
        if (COMPUTER_INFO_DEBUG) {
            return e + this.sTimeZone;
        }
        return this.sTimeZone;
    }

    protected static String getUBSVersion() {
        String string;
        block3: {
            if (c == null) {
                return "";
            }
            string = "";
            try {
                string = c.getUBSVersion();
            }
            catch (IOException iOException) {
                if (!COMPUTER_INFO_DEBUG) break block3;
                iOException.printStackTrace();
                System.out.println("Error in getting UBS Version. Reason=" + iOException.getMessage());
            }
        }
        return string;
    }

    protected static String getNixVersion() {
        String string;
        block3: {
            if (c == null) {
                return "";
            }
            string = "";
            try {
                string = c.getOSVersion();
            }
            catch (IOException iOException) {
                if (!COMPUTER_INFO_DEBUG) break block3;
                iOException.printStackTrace();
                System.out.println("Error in getting Nix Version. Reason=" + iOException.getMessage());
            }
        }
        return string;
    }

    protected static String getNasVersion() {
        if (d == null) {
            return "";
        }
        return d.getOSVersion();
    }

    protected static String getMacVersion() {
        String string;
        block3: {
            if (b == null) {
                return "";
            }
            string = "";
            try {
                string = b.getVersion();
            }
            catch (IOException iOException) {
                if (!COMPUTER_INFO_DEBUG) break block3;
                iOException.printStackTrace();
                System.out.println("Error in getting Mac Version. Reason=" + iOException.getMessage());
            }
        }
        return string;
    }

    public String getWindowsSystemModel() {
        String string;
        block3: {
            if (a == null) {
                return "";
            }
            string = "";
            try {
                string = a.getSystemModel().trim();
            }
            catch (Exception exception) {
                if (!COMPUTER_INFO_DEBUG) break block3;
                exception.printStackTrace();
                System.out.println("Error in getting Windows System Model. Reason=" + exception.getMessage());
            }
        }
        return this.validateInfo(string);
    }

    public String getNasSystemModel() {
        String string;
        block3: {
            if (d == null) {
                return "";
            }
            string = "";
            try {
                string = d.getModel();
            }
            catch (Exception exception) {
                if (!COMPUTER_INFO_DEBUG) break block3;
                exception.printStackTrace();
                System.out.println("Error in getting NAS System Model. Reason=" + exception.getMessage());
            }
        }
        return this.validateInfo(string);
    }

    public String getMacSystemModel() {
        String string;
        block3: {
            if (b == null) {
                return "";
            }
            string = "";
            try {
                string = b.getSystemModel();
            }
            catch (Exception exception) {
                if (!COMPUTER_INFO_DEBUG) break block3;
                exception.printStackTrace();
                System.out.println("Error in getting Mac System Model. Reason=" + exception.getMessage());
            }
        }
        return this.validateInfo(string);
    }

    public String getNixSystemModel() {
        String string;
        block3: {
            if (c == null) {
                return "";
            }
            string = "";
            try {
                string = c.getSystemModel();
            }
            catch (Exception exception) {
                if (!COMPUTER_INFO_DEBUG) break block3;
                exception.printStackTrace();
                System.out.println("Error in getting Linux System Model. Reason=" + exception.getMessage());
            }
        }
        return this.validateInfo(string);
    }

    public String getWindowsCpuModel(String string) {
        String string2 = "";
        for (int i = 0; i < this.alCpu.size(); ++i) {
            String string3 = this.validateInfo(this.alCpu.get(i).getName());
            string2 = string2 + ("".equals(string2) ? "" : ",") + string3;
        }
        return this.addPrefix(string, string2);
    }

    public String getNixCpuModel(String string) {
        String string2;
        block3: {
            if (c == null) {
                return "";
            }
            string2 = "";
            try {
                string2 = c.getCpuModel();
            }
            catch (Exception exception) {
                if (!COMPUTER_INFO_DEBUG) break block3;
                exception.printStackTrace();
                System.out.println("Error in getting Nix Cpu Model. Reason=" + exception.getMessage());
            }
        }
        return this.addPrefix(string, this.validateInfo(string2));
    }

    public String getMacCpuModel(String string) {
        String string2;
        block3: {
            if (b == null) {
                return "";
            }
            string2 = "";
            try {
                string2 = b.getCpuModel();
            }
            catch (Exception exception) {
                if (!COMPUTER_INFO_DEBUG) break block3;
                exception.printStackTrace();
                System.out.println("Error in getting Mac Cpu Model. Reason=" + exception.getMessage());
            }
        }
        return this.addPrefix(string, this.validateInfo(string2));
    }

    public int getCPUSocketNum() {
        int n = SystemInfo.IS_WINDOWS ? this.getWinCpuInfo().size() : 1;
        return n > 0 ? n : 1;
    }

    protected void setWinCpuInfo() {
        try {
            a.getProcessorInfo(this);
        }
        catch (IOException iOException) {
            if (COMPUTER_INFO_DEBUG) {
                iOException.printStackTrace();
                System.out.println("Error in getting Windows CPU Info. Reason=" + iOException.getMessage());
            }
            this.alCpu.add(new ComputerInfo$CpuInfo("CPU0", "Unknown", "Unknown", "Unknown", 0L, "Unknown", 0, 0));
        }
    }

    public ArrayList<ComputerInfo$CpuInfo> getWinCpuInfo() {
        return this.alCpu;
    }

    public void addCpuInfo(String string, String string2, String string3, String string4, long l, String string5, int n, int n2) {
        ComputerInfo$CpuInfo computerInfo$CpuInfo = new ComputerInfo$CpuInfo(string, string2, string3, string4, l, string5, n, n2);
        if (!this.alCpu.contains(computerInfo$CpuInfo)) {
            this.alCpu.add(computerInfo$CpuInfo);
        }
    }

    public void addDiskInfo(String string, String string2, boolean bl) {
        if ("".equals(string2 = string2.trim())) {
            return;
        }
        ComputerInfo$HardDiskInfo computerInfo$HardDiskInfo = new ComputerInfo$HardDiskInfo(string, string2, bl);
        if (!this.alDisk.contains(computerInfo$HardDiskInfo)) {
            this.alDisk.add(computerInfo$HardDiskInfo);
        }
        if (COMPUTER_INFO_DEBUG) {
            System.out.println("[ComputerInfo.addDiskInfo] Disk [" + string + "] SN [" + string2 + "] SysDisk [" + bl + "]");
        }
    }

    public void setDiskSerialNumber() {
        block7: {
            try {
                if (a != null) {
                    a.getHardDiskSN(this);
                } else if (b != null) {
                    b.getHardDiskSN(this);
                } else if (c != null) {
                    c.getHardDiskSN(this);
                }
            }
            catch (IOException iOException) {
                if (!COMPUTER_INFO_DEBUG) break block7;
                iOException.printStackTrace();
                System.out.println("Error in getting Hard disk Info. Reason=" + iOException.getMessage());
            }
        }
    }

    public ArrayList<ComputerInfo$HardDiskInfo> getDiskInfo() {
        return this.alDisk;
    }

    public void setMotherboardUUID() {
        block7: {
            try {
                if (a != null) {
                    this.sMotherboardUUID = a.getMotherboardUUID();
                } else if (b != null) {
                    this.sMotherboardUUID = b.getMotherboardUUID();
                } else if (c != null) {
                    this.sMotherboardUUID = c.getMotherboardUUID();
                }
            }
            catch (IOException iOException) {
                if (!COMPUTER_INFO_DEBUG) break block7;
                iOException.printStackTrace();
                System.out.println("Error in getting MotherboardUUID. Reason=" + iOException.getMessage());
            }
        }
    }

    public String getMotherboardUUID() {
        return this.sMotherboardUUID;
    }

    public String addPrefix(String string, String string2) {
        if (string.lastIndexOf(VMWARE) != -1) {
            string2 = "VMware-" + string2;
        } else if (string.lastIndexOf(MICROSOFT) != -1) {
            string2 = "Microsoft-" + string2;
        } else if (string.lastIndexOf(VIRTUAL_BOX) != -1) {
            string2 = "VirtualBox-" + string2;
        }
        return string2;
    }

    public String validateInfo(String string) {
        if (string == null || "".equals(string.trim())) {
            return "";
        }
        return string;
    }

    public static final long ipToLong(String string) {
        String[] stringArray = string.split("\\.");
        long l = 0L;
        if (stringArray.length == 4) {
            for (int i = 0; i < stringArray.length; ++i) {
                byte[] byArray = ComputerInfo.numToBytes(Short.parseShort(stringArray[i]), false);
                l = (l << 8) + (long)(byArray[0] & 0xFF);
            }
        }
        return l;
    }

    public static final byte[] numToBytes(short s, boolean bl) {
        byte[] byArray = new byte[2];
        short s2 = s;
        byArray[0 + (bl ? 1 : 0)] = (byte)s2;
        s2 = (short)(s2 >> 8);
        byArray[0 + (bl ? 0 : 1)] = (byte)s2;
        return byArray;
    }

    public boolean isSystemRunOnVirtualizationPlatform() {
        if (this.sSystemModel == null) {
            return false;
        }
        return this.sSystemModel.lastIndexOf(VMWARE) != -1 || this.sSystemModel.lastIndexOf(MICROSOFT) != -1 || this.sSystemModel.lastIndexOf(VIRTUAL_BOX) != -1;
    }
}

