/*
 * Decompiled with CFR 0.152.
 */
package com.ahsay.ani.console;

import com.ahsay.ani.SystemInfo;
import com.ahsay.ani.console.LineCommand$1;
import com.ahsay.ani.console.LineCommand$2;
import com.ahsay.ani.console.LineCommand$3;
import com.ahsay.ani.console.LineCommand$ImpersonationFailedExpt;
import com.ahsay.ani.console.LineCommand$Output;
import com.ahsay.ani.console.LineCommand$ProcessWithCmd;
import com.ahsay.ani.console.LineCommandEvent;
import com.ahsay.ani.util.Idle;
import com.ahsay.ani.util.StringUtil;
import com.ahsay.ani.util.WinProcess;
import com.ahsay.ani.util.WinProcessInfo;
import com.ahsay.ani.util.WindowsUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;

public class LineCommand {
    protected static final long MAX_WAIT_FOR_9XME = 15000L;
    protected static final long SLEEP_INTERVAL = 500L;
    protected static final long WAIT_FOR_START_INTERVAL = 125L;
    public static final int TIMEOUT_EXIT_CODE = -10;
    protected static final String OS_NAME = System.getProperty("os.name");
    protected static final boolean IS_NETWARE = LineCommand.g(OS_NAME);
    protected static final boolean IS_LINUX_RELATED = LineCommand.n(OS_NAME);
    protected static final boolean IS_MAC = LineCommand.e(OS_NAME);
    protected static final boolean IS_WINDOWS = LineCommand.o(OS_NAME);
    protected static final boolean IS_WIN95 = IS_WINDOWS && OS_NAME.indexOf("95") != -1;
    protected static final boolean IS_WIN98 = IS_WINDOWS && OS_NAME.indexOf("98") != -1;
    protected static final boolean IS_WINME = IS_WINDOWS && OS_NAME.indexOf("Me") != -1;
    protected static final boolean IS_WIN9XME = IS_WIN95 || IS_WIN98 || IS_WINME;

    private static boolean a(String string) {
        return string != null && string.startsWith("AIX");
    }

    private static boolean b(String string) {
        return string != null && string.startsWith("FreeBSD");
    }

    private static boolean c(String string) {
        return string != null && string.startsWith("HP-UX");
    }

    private static boolean d(String string) {
        return string != null && string.startsWith("Linux");
    }

    private static boolean e(String string) {
        return string != null && string.startsWith("Mac");
    }

    private static boolean f(String string) {
        return string != null && string.startsWith("NetBSD");
    }

    private static boolean g(String string) {
        return string != null && string.startsWith("NetWare");
    }

    private static boolean h(String string) {
        return string != null && string.startsWith("OpenBSD");
    }

    private static boolean i(String string) {
        return string != null && string.startsWith("OpenServer");
    }

    private static boolean j(String string) {
        return string != null && string.startsWith("Solaris");
    }

    private static boolean k(String string) {
        return string != null && string.startsWith("SunOS");
    }

    private static boolean l(String string) {
        return string != null && string.startsWith("UNIX_SV");
    }

    private static boolean m(String string) {
        return string != null && (string.startsWith("Unix") || LineCommand.a(string) || LineCommand.i(string) || LineCommand.c(string) || LineCommand.j(string) || LineCommand.k(string) || LineCommand.l(string));
    }

    private static boolean n(String string) {
        return LineCommand.d(string) || LineCommand.m(string) || LineCommand.b(string) || LineCommand.h(string) || LineCommand.f(string);
    }

    private static boolean o(String string) {
        return string != null && string.startsWith("Windows");
    }

    protected static Process createProcess(String[] stringArray, String[] stringArray2, File file) {
        return LineCommand.createProcess(stringArray, stringArray2, file, null, null, null);
    }

    protected static Process createProcess(String[] stringArray, String[] stringArray2, File file, String string, String string2, String string3) {
        boolean bl;
        boolean bl2 = bl = string != null && string2 != null && string3 != null;
        if (bl && !WindowsUtil.IS_SUPPORTED) {
            throw new IOException("[LineCommand.createProcess] WindowsUtil not supported for ExecuteAs operation");
        }
        if (file != null && !file.exists()) {
            file = null;
        }
        if (bl) {
            String string4;
            String string5 = file == null ? "" : file.getAbsolutePath();
            StringBuffer stringBuffer = new StringBuffer();
            for (int i = 0; i < stringArray.length; ++i) {
                string4 = stringArray[i];
                if (string4.indexOf(32) == -1) {
                    stringBuffer.append(string4).append(" ");
                    continue;
                }
                if (string4.indexOf(34) != -1) {
                    string4 = StringUtil.StringReplace(string4, "\"", "\\\"");
                }
                stringBuffer.append("\"").append(string4).append("\"").append(" ");
            }
            try {
                WindowsUtil windowsUtil = new WindowsUtil();
                string4 = stringBuffer.toString();
                WinProcess winProcess = windowsUtil.createProcessAsUser(null, string4, stringArray2, string5, string, string2, string3);
                return new LineCommand$ProcessWithCmd((Process)winProcess, string4);
            }
            catch (IOException iOException) {
                string4 = iOException.getMessage();
                if (string4 != null && string4.indexOf("Failed to LogonUser") != -1) {
                    throw new LineCommand$ImpersonationFailedExpt(string4);
                }
                throw iOException;
            }
        }
        String[] stringArray3 = stringArray;
        if (IS_WINDOWS) {
            boolean bl3;
            boolean bl4 = bl3 = !stringArray[0].toLowerCase().endsWith(".exe") && !stringArray[0].toLowerCase().endsWith(".com");
            if (bl3) {
                String[] stringArray4 = new String[]{IS_WIN9XME ? "command.com" : "cmd.exe", "/C"};
                stringArray3 = LineCommand.mergeArg(stringArray4, stringArray);
            }
        } else if (IS_LINUX_RELATED) {
            if (stringArray[0].toLowerCase().endsWith(".sh")) {
                String[] stringArray5 = new String[]{"sh"};
                stringArray3 = LineCommand.mergeArg(stringArray5, stringArray);
            }
        } else if (IS_MAC) {
            if (stringArray[0].toLowerCase().endsWith(".sh")) {
                String[] stringArray6 = new String[]{"sh"};
                stringArray3 = LineCommand.mergeArg(stringArray6, stringArray);
            }
        } else if (IS_NETWARE) {
            // empty if block
        }
        Process process = Runtime.getRuntime().exec(stringArray3, stringArray2, file);
        return new LineCommand$ProcessWithCmd(process, stringArray3);
    }

    protected static Process createProcess(String[] stringArray, String[] stringArray2, File file, long l) {
        if (!WindowsUtil.IS_SUPPORTED) {
            throw new IOException("[LineCommand.createProcess] WindowsUtil not supported for ExecuteAs operation");
        }
        if (file != null && !file.exists()) {
            file = null;
        }
        String string = file == null ? "" : file.getAbsolutePath();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = stringArray[i];
            if (string2.indexOf(32) == -1) {
                stringBuffer.append(string2).append(" ");
                continue;
            }
            if (string2.indexOf(34) != -1) {
                string2 = StringUtil.StringReplace(string2, "\"", "\\\"");
            }
            stringBuffer.append("\"").append(string2).append("\"").append(" ");
        }
        WindowsUtil windowsUtil = new WindowsUtil();
        return windowsUtil.createProcessAsUserSession(null, stringBuffer.toString(), stringArray2, string, l);
    }

    public static LineCommand$Output execute(String string, String[] stringArray, File file) {
        return LineCommand.execute(string, stringArray, file, true);
    }

    public static LineCommand$Output execute(String string, String[] stringArray, File file, LineCommandEvent lineCommandEvent) {
        return LineCommand.execute(string, stringArray, file, lineCommandEvent, -1L);
    }

    public static LineCommand$Output execute(String string, String[] stringArray, File file, LineCommandEvent lineCommandEvent, long l) {
        String[] stringArray2 = LineCommand.splitArg(string);
        return LineCommand.execute(stringArray2, stringArray, file, lineCommandEvent, true, null, l);
    }

    public static LineCommand$Output execute(String string, String[] stringArray, File file, String string2) {
        return LineCommand.execute(string, stringArray, file, true, string2);
    }

    public static LineCommand$Output execute(String[] stringArray, String[] stringArray2, File file) {
        return LineCommand.execute(stringArray, stringArray2, file, null, null, null, true, null);
    }

    public static LineCommand$Output execute(String[] stringArray, String[] stringArray2, File file, String string) {
        return LineCommand.execute(stringArray, stringArray2, file, null, null, null, true, string);
    }

    public static LineCommand$Output execute(String[] stringArray, String[] stringArray2, File file, String string, String string2, String string3) {
        return LineCommand.execute(stringArray, stringArray2, file, string, string2, string3, null);
    }

    public static LineCommand$Output execute(String[] stringArray, String[] stringArray2, File file, String string, String string2, String string3, String string4) {
        return LineCommand.execute(stringArray, stringArray2, file, string, string2, string3, true, string4);
    }

    public static LineCommand$Output execute(String string, String[] stringArray, File file, boolean bl) {
        return LineCommand.execute(string, stringArray, file, bl, null);
    }

    public static LineCommand$Output execute(String string, String[] stringArray, File file, boolean bl, String string2) {
        String[] stringArray2 = LineCommand.splitArg(string);
        return LineCommand.execute(stringArray2, stringArray, file, bl, string2);
    }

    public static LineCommand$Output execute(String[] stringArray, String[] stringArray2, File file, boolean bl) {
        return LineCommand.execute(stringArray, stringArray2, file, null, null, null, bl, null);
    }

    public static LineCommand$Output execute(String[] stringArray, String[] stringArray2, File file, boolean bl, String string) {
        return LineCommand.execute(stringArray, stringArray2, file, null, null, null, bl, string);
    }

    public static LineCommand$Output execute(String[] stringArray, String[] stringArray2, File file, LineCommandEvent lineCommandEvent, boolean bl, String string, long l) {
        return LineCommand.execute(stringArray, stringArray2, file, lineCommandEvent, null, null, null, bl, string, l);
    }

    public static LineCommand$Output execute(String[] stringArray, String[] stringArray2, File file, String string, String string2, String string3, boolean bl) {
        return LineCommand.execute(stringArray, stringArray2, file, string, string2, string3, bl, null);
    }

    public static LineCommand$Output execute(String[] stringArray, String[] stringArray2, File file, String string, String string2, String string3, boolean bl, String string4) {
        return LineCommand.execute(stringArray, stringArray2, file, string, string2, string3, bl, string4, null);
    }

    public static LineCommand$Output execute(String[] stringArray, String[] stringArray2, File file, LineCommandEvent lineCommandEvent, String string, String string2, String string3, boolean bl, String string4, long l) {
        return LineCommand.execute(stringArray, stringArray2, file, lineCommandEvent, string, string2, string3, bl, string4, null, l);
    }

    public static LineCommand$Output execute(String[] stringArray, String[] stringArray2, File file, String string, String string2, String string3, boolean bl, String string4, String string5) {
        return LineCommand.execute(stringArray, stringArray2, file, null, string, string2, string3, bl, string4, string5);
    }

    public static LineCommand$Output execute(String[] stringArray, String[] stringArray2, File file, LineCommandEvent lineCommandEvent, String string, String string2, String string3, boolean bl, String string4, String string5) {
        return LineCommand.execute(stringArray, stringArray2, file, lineCommandEvent, string, string2, string3, bl, string4, string5, -1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static LineCommand$Output execute(String[] stringArray, String[] stringArray2, File file, LineCommandEvent lineCommandEvent, String string, String string2, String string3, boolean bl, String string4, String string5, long l) {
        int n;
        LineCommand$Output lineCommand$Output = new LineCommand$Output();
        Process process = LineCommand.createProcess(stringArray, stringArray2, file, string, string2, string3);
        LineCommand$1 lineCommand$1 = new LineCommand$1("[LineCommand.execute][ReadErrorStream][3]", process, string5, lineCommand$Output);
        LineCommand$2 lineCommand$2 = new LineCommand$2("[LineCommand.execute][ReadOutputStream][3]", process, string5, lineCommand$Output);
        LineCommand$3 lineCommand$3 = null;
        if (lineCommandEvent != null) {
            lineCommand$3 = new LineCommand$3(lineCommand$1, lineCommand$2, process);
            lineCommandEvent.addListener(lineCommand$3);
        }
        Idle idle = new Idle();
        try {
            idle.sleep(125L);
            if (bl) {
                lineCommand$1.start();
                lineCommand$2.start();
                idle.sleep(125L);
            }
            LineCommand.writeToConsole(process, string4);
            if (l <= 0L) {
                n = process.waitFor();
            } else {
                long l2;
                n = -10;
                long l3 = System.nanoTime();
                long l4 = l2 = TimeUnit.MILLISECONDS.toNanos(l);
                while (true) {
                    try {
                        n = process.exitValue();
                    }
                    catch (IllegalThreadStateException illegalThreadStateException) {
                        if (l4 <= 0L) continue;
                        Thread.sleep(Math.min(TimeUnit.NANOSECONDS.toMillis(l4) + 1L, 100L));
                        if ((l4 = l2 - (System.nanoTime() - l3)) > 0L) continue;
                    }
                    break;
                }
                if (n == -10 && process != null) {
                    LineCommand.b(lineCommand$1, lineCommand$2, process, true);
                }
            }
        }
        finally {
            LineCommand.closeProcessHandles(process);
            if (lineCommandEvent != null) {
                lineCommandEvent.removeListener(lineCommand$3);
            }
        }
        int n2 = 30;
        for (int i = 0; !(!lineCommand$1.isAlive() && !lineCommand$2.isAlive() || IS_WIN9XME && i > n2); ++i) {
            idle.sleep(500L);
        }
        lineCommand$Output.setExitCode(n);
        return lineCommand$Output;
    }

    private static void b(Thread thread, Thread thread2, Process process, boolean bl) {
        if (thread != null) {
            thread.interrupt();
        }
        if (thread2 != null) {
            thread2.interrupt();
        }
        if (process == null) {
            return;
        }
        if (SystemInfo.IS_WINDOWS && process instanceof LineCommand$ProcessWithCmd) {
            WindowsUtil windowsUtil = new WindowsUtil();
            ArrayList<WinProcessInfo> arrayList = null;
            try {
                arrayList = windowsUtil.getProcessInfo("cmd.exe");
            }
            catch (Exception exception) {
                System.out.println("[LineCommand.terminateProcess] Fail to get process info from cmd.exe, Error=" + exception.getMessage());
            }
            if (arrayList == null) {
                System.out.println("[LineCommand.terminateProcess] alInfo is null");
                return;
            }
            String string = LineCommand$ProcessWithCmd.a((LineCommand$ProcessWithCmd)process);
            for (WinProcessInfo winProcessInfo : arrayList) {
                long l = winProcessInfo.lProcessId;
                String string2 = windowsUtil.getProcessCommandLineArguments(l, false);
                if (string2 == null || string2.isEmpty() || string == null || !string.equals(string2)) continue;
                String string3 = "Taskkill /F /PID " + l + " /T";
                Runtime.getRuntime().exec(string3);
                if (bl) continue;
                break;
            }
        } else {
            process.destroy();
        }
    }

    protected static String[] mergeArg(String[] stringArray, String[] stringArray2) {
        int n;
        int n2 = (stringArray == null ? 0 : stringArray.length) + (stringArray2 == null ? 0 : stringArray2.length);
        if (n2 == 0) {
            return new String[0];
        }
        String[] stringArray3 = new String[n2];
        int n3 = 0;
        for (n = 0; stringArray != null && n < stringArray.length; ++n) {
            stringArray3[n3++] = stringArray[n];
        }
        for (n = 0; stringArray2 != null && n < stringArray2.length; ++n) {
            stringArray3[n3++] = stringArray2[n];
        }
        return stringArray3;
    }

    protected static String[] splitArg(String string) {
        ArrayList<String> arrayList;
        block6: {
            int n;
            block5: {
                int n2;
                String string2 = "\"";
                String string3 = " ";
                if (string == null) {
                    return new String[0];
                }
                if (string.indexOf("\"") == -1) {
                    return StringUtil.split(string, " ");
                }
                arrayList = new ArrayList<String>(10);
                n = 0;
                while (true) {
                    int n3 = string.indexOf(" ", n);
                    n2 = string.indexOf("\"", n);
                    if (n3 != -1 && n3 < n2) {
                        String string4 = string.substring(n, n3);
                        if (!"".equals(string4.trim())) {
                            arrayList.add(string4);
                        }
                        n = n3 + 1;
                        continue;
                    }
                    if (n2 == -1) break block5;
                    int n4 = string.indexOf("\"", n2 + 1);
                    if (n4 == -1) break;
                    String string5 = string.substring(n2 + 1, n4);
                    arrayList.add(string5);
                    n = n4 + 1;
                }
                arrayList.add(string.substring(n2 + 1));
                break block6;
            }
            arrayList.add(string.substring(n));
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    protected static void writeToConsole(Process process, String string) {
        if (string != null && !"".equals(string)) {
            if (process instanceof WinProcess || process instanceof LineCommand$ProcessWithCmd && LineCommand$ProcessWithCmd.b((LineCommand$ProcessWithCmd)process) instanceof WinProcess) {
                String string2 = "[LineCommand.writeToConsole] Failed to write to console with p as instance of WinProcess";
                throw new IOException(string2);
            }
            try (PrintWriter printWriter = new PrintWriter(process.getOutputStream());){
                printWriter.println(string);
                System.out.println(string);
            }
        }
    }

    protected static void closeProcessHandles(Process process) {
        if (process instanceof LineCommand$ProcessWithCmd) {
            process = LineCommand$ProcessWithCmd.b((LineCommand$ProcessWithCmd)process);
        }
        if (process instanceof WinProcess) {
            WinProcess winProcess = (WinProcess)process;
            winProcess.closeHandles();
        }
    }

    static /* synthetic */ void a(Thread thread, Thread thread2, Process process, boolean bl) {
        LineCommand.b(thread, thread2, process, bl);
    }
}

