/*
 * Decompiled with CFR 0.152.
 */
package com.jscape.inet.ftp;

import com.jscape.inet.ftp.Ftp;
import com.jscape.inet.ftp.FtpEvent;
import com.jscape.inet.ftp.FtpException;
import com.jscape.inet.ftp.FtpFile;
import com.jscape.inet.ftp.FtpListener;
import com.jscape.util.i;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.Vector;

public abstract class FtpImplementation {
    protected static final int DEFAULT_TIMEOUT = 30000;
    protected static final boolean DEFAULT_KEEPALIVE = false;
    protected static final int DEFAULT_FTP_PORT = 21;
    protected static final int DEFAULT_SFTP_PORT = 22;
    private static final int a = 8192;
    private static final int b = -1;
    private Vector c;
    protected Ftp ftp;
    protected int timeout;
    protected boolean keepAlive;
    protected int linger;
    protected int blockSize;
    protected String host;
    protected String portAddress;
    protected int port;
    protected String user;
    protected String password;
    protected String account;
    protected String encoding;
    protected volatile boolean interrupted;
    protected String targetFile;
    protected String targetPath;
    protected boolean debug;
    protected PrintStream debugStream;
    protected boolean autoMode;
    protected String encodingWire;
    protected String encodingDisk;
    protected boolean autoDetectIpv6;
    private static final int d = 1080;
    private static final String e;
    protected String proxyUsername;
    protected String proxyPassword;
    protected String proxyHostname;
    protected int proxyPort;
    protected String proxyType;
    private static final String[] z;

    public FtpImplementation() {
        boolean bl = FtpEvent.a;
        this.c = new Vector();
        this.ftp = null;
        this.timeout = 30000;
        this.keepAlive = false;
        this.linger = -1;
        this.blockSize = 8192;
        this.host = null;
        this.portAddress = null;
        this.port = 0;
        this.user = null;
        this.password = null;
        this.account = null;
        this.encoding = null;
        this.interrupted = false;
        this.targetFile = null;
        this.targetPath = null;
        this.debug = false;
        this.debugStream = System.out;
        this.autoMode = false;
        this.encodingWire = null;
        this.encodingDisk = null;
        this.autoDetectIpv6 = false;
        this.proxyUsername = null;
        this.proxyPassword = null;
        this.proxyHostname = null;
        this.proxyPort = 1080;
        this.proxyType = e;
        if (bl) {
            int n2 = i.a;
            i.a = ++n2;
        }
    }

    public synchronized void setFtp(Ftp ftp) {
        if (ftp == null) {
            throw new NullPointerException();
        }
        this.ftp = ftp;
    }

    public synchronized void setAutoDetectIpv6(boolean bl) {
        this.autoDetectIpv6 = bl;
    }

    public synchronized boolean getAutoDetectIpv6() {
        return this.autoDetectIpv6;
    }

    public synchronized String getHost() {
        return this.host;
    }

    public synchronized String getAccount() {
        return this.account;
    }

    public synchronized void setAuto(boolean bl) {
        this.autoMode = bl;
    }

    public synchronized void setHost(String string) {
        this.host = string;
    }

    public synchronized void setAccount(String string) {
        this.account = string;
    }

    public synchronized int getPort() {
        return this.port;
    }

    public synchronized void setPort(int n2) {
        this.port = n2;
    }

    public synchronized String getUser() {
        return this.user;
    }

    public synchronized void setUser(String string) {
        this.user = string;
    }

    public abstract void setUseEPSV(boolean var1);

    public abstract boolean getUseEPSV();

    public abstract void setUseEPRT(boolean var1);

    public abstract boolean getUseEPRT();

    public synchronized String getPassword() {
        return this.password;
    }

    public synchronized void setPassword(String string) {
        this.password = string;
    }

    public synchronized int getTimeout() {
        return this.timeout;
    }

    public synchronized void setTimeout(int n2) {
        int n3 = n2;
        if (!FtpEvent.a) {
            n3 = n3 > 0 ? n2 : 0;
        }
        this.timeout = n3;
    }

    public synchronized void setLinger(int n2) {
        this.linger = n2;
    }

    public synchronized int getLinger() {
        return this.linger;
    }

    public synchronized void setKeepAlive(boolean bl) {
        this.keepAlive = bl;
    }

    public synchronized boolean getKeepAlive(boolean bl) {
        return this.keepAlive;
    }

    public synchronized String getEncoding() {
        return this.getDiskEncoding();
    }

    public synchronized void setEncoding(String string) {
        this.setDiskEncoding(string);
    }

    public abstract void setErrorOnSizeCommand(boolean var1);

    public abstract boolean getErrorOnSizeCommand();

    public boolean interrupted() {
        return this.interrupted;
    }

    public void interrupt() {
        this.interrupted = true;
    }

    public void reset() {
        this.interrupted = false;
    }

    public abstract void connect() throws FtpException;

    public abstract void setDataPort(int var1);

    public abstract int getDataPort();

    public abstract void setConnectBeforeCommand(boolean var1);

    public abstract boolean getConnectBeforeCommand();

    public abstract int getDataPortStart();

    public abstract int getDataPortEnd();

    public abstract void setDataPortStart(int var1);

    public abstract void setDataPortEnd(int var1);

    public abstract void connect(boolean var1) throws FtpException;

    public abstract void login() throws FtpException;

    public abstract void changePassword(String var1, String var2) throws FtpException;

    public abstract void disconnect();

    public abstract boolean isConnected();

    public abstract String issueCommand(String var1) throws FtpException;

    public abstract String issueCommandCheck(String var1) throws FtpException;

    public abstract boolean isFeatureSupported(String var1);

    public abstract String upload(InputStream var1, String var2, boolean var3, long var4, long var6, boolean var8) throws FtpException;

    public abstract void download(OutputStream var1, String var2, long var3) throws FtpException;

    public abstract InputStream getInputStream(String var1, long var2) throws FtpException;

    public abstract OutputStream getOutputStream(String var1, boolean var2, long var3) throws FtpException;

    public abstract String uploadUnique(InputStream var1, String var2) throws FtpException;

    public abstract long getFileSize(String var1) throws FtpException;

    public abstract Date getFileTimeStamp(String var1) throws FtpException;

    public abstract void setFileTimeStamp(String var1, Date var2) throws FtpException;

    public abstract void setFileCreationTime(String var1, Date var2) throws FtpException;

    public abstract void setFileModificationTime(String var1, Date var2) throws FtpException;

    public abstract void deleteFile(String var1) throws FtpException;

    public abstract void renameFile(String var1, String var2) throws FtpException;

    public abstract Vector getDirListing(String var1) throws FtpException;

    public abstract Vector getNameListing(String var1) throws FtpException;

    public abstract String getDir() throws FtpException;

    public abstract void setDir(String var1) throws FtpException;

    public abstract void dirUp() throws FtpException;

    public abstract void makeDir(String var1) throws FtpException;

    public abstract void deleteDir(String var1, boolean var2) throws FtpException;

    public synchronized String getDirListingAsString(String string) throws FtpException {
        StringBuffer stringBuffer;
        block2: {
            boolean bl = FtpEvent.a;
            StringBuffer stringBuffer2 = new StringBuffer();
            Vector vector = this.getDirListing(string);
            for (int i2 = 0; i2 < vector.size(); ++i2) {
                stringBuffer = stringBuffer2.append(vector.elementAt(i2).toString()).append(z[4]);
                if (!bl) {
                    if (!bl) continue;
                }
                break block2;
            }
            stringBuffer = stringBuffer2;
        }
        return stringBuffer.toString();
    }

    public abstract FtpFile getMachineFileListing(String var1) throws FtpException;

    public abstract Vector getMachineDirListing(String var1) throws FtpException;

    public abstract Vector getMachineDirListing(String var1, String var2) throws FtpException;

    public abstract Vector getFeatures() throws FtpException;

    public abstract String getSystemType() throws FtpException;

    public abstract String noop() throws FtpException;

    public abstract int getTransferMode();

    public abstract void setTransferMode(int var1) throws FtpException;

    public abstract boolean isPassive();

    public abstract void setPassive(boolean var1);

    public abstract void setNATAddress(String var1) throws FtpException;

    public abstract String getNATAddress();

    public abstract void setCompression(boolean var1);

    public abstract boolean getCompression();

    public abstract int getResponseCode();

    public synchronized int getBlockTransferSize() {
        return this.blockSize;
    }

    public synchronized void setBlockTransferSize(int n2) {
        if (n2 <= 0) {
            throw new IllegalArgumentException(z[0] + n2);
        }
        this.blockSize = n2;
    }

    public synchronized boolean getDebug() {
        return this.debug;
    }

    public synchronized void setDebug(boolean bl) {
        this.debug = bl;
    }

    public synchronized PrintStream getDebugStream() {
        return this.debugStream;
    }

    public synchronized void setDebugStream(PrintStream printStream) {
        this.debugStream = printStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(FtpListener ftpListener) {
        Vector vector = (Vector)this.c.clone();
        vector.addElement(ftpListener);
        FtpImplementation ftpImplementation = this;
        synchronized (ftpImplementation) {
            this.c = vector;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(FtpListener ftpListener) {
        Vector vector = (Vector)this.c.clone();
        vector.removeElement(ftpListener);
        FtpImplementation ftpImplementation = this;
        synchronized (ftpImplementation) {
            this.c = vector;
        }
    }

    public synchronized Vector getListeners() {
        return this.c;
    }

    public synchronized void setListeners(Vector vector) {
        this.c = vector;
    }

    public synchronized void setTargetFile(String string) {
        this.targetFile = string;
    }

    public synchronized void setTargetPath(String string) {
        this.targetPath = string;
    }

    protected synchronized void fireEvent(FtpEvent ftpEvent) {
        boolean bl = FtpEvent.a;
        for (FtpListener ftpListener : this.c) {
            ftpEvent.accept(ftpListener);
            if (!bl) continue;
        }
    }

    protected synchronized boolean hasListeners() {
        boolean bl = this.c.size();
        if (!FtpEvent.a) {
            bl = bl > false;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized InputStreamReader getInputStreamReader(InputStream inputStream) throws FtpException {
        try {
            InputStreamReader inputStreamReader;
            block7: {
                String string;
                block6: {
                    string = this.encodingWire;
                    if (FtpEvent.a) break block6;
                    if (string == null) break block7;
                    string = this.encodingWire;
                }
                if (string.length() > 0) {
                    inputStreamReader = new InputStreamReader(inputStream, this.encodingWire);
                    return inputStreamReader;
                }
            }
            inputStreamReader = new InputStreamReader(inputStream);
            return inputStreamReader;
        }
        catch (Exception exception) {
            throw new FtpException(exception.getMessage(), exception);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected synchronized OutputStreamWriter getOutputStreamWriter(OutputStream outputStream) throws FtpException {
        try {
            OutputStreamWriter outputStreamWriter;
            block7: {
                String string;
                block6: {
                    string = this.encodingWire;
                    if (FtpEvent.a) break block6;
                    if (string == null) break block7;
                    string = this.encodingWire;
                }
                if (string.length() > 0) {
                    outputStreamWriter = new OutputStreamWriter(outputStream, this.encodingWire);
                    return outputStreamWriter;
                }
            }
            outputStreamWriter = new OutputStreamWriter(outputStream);
            return outputStreamWriter;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new FtpException(unsupportedEncodingException.getMessage(), unsupportedEncodingException);
        }
    }

    protected synchronized void debugPrint(String string) {
        block2: {
            block5: {
                int n2;
                boolean bl;
                block4: {
                    String string2;
                    block3: {
                        bl = FtpEvent.a;
                        if (!this.debug) break block2;
                        string2 = string;
                        if (bl) break block3;
                        if (string2 == null) break block2;
                        string2 = string.trim();
                    }
                    n2 = string2.length();
                    if (bl) break block4;
                    if (n2 == 0) break block2;
                    n2 = string.startsWith(z[3]) ? '\u0001' : '\u0000';
                }
                if (n2 == 0) break block5;
                this.debugStream.println(z[2]);
                if (!bl) break block2;
            }
            this.debugStream.println(string);
        }
    }

    protected void skip(InputStream inputStream, long l2) throws FtpException {
        try {
            inputStream.skip(l2);
        }
        catch (IOException iOException) {
            throw new FtpException(iOException.getMessage(), iOException);
        }
    }

    protected synchronized void deleteDirRecursive(String string) throws FtpException {
        block12: {
            boolean bl;
            block11: {
                boolean bl2;
                block10: {
                    bl2 = FtpEvent.a;
                    String string2 = this.getDir();
                    this.setDir(string);
                    Vector vector = this.getDirListing("");
                    for (int i2 = 0; i2 < vector.size(); ++i2) {
                        FtpFile ftpFile = (FtpFile)vector.elementAt(i2);
                        String string3 = ftpFile.getFilename();
                        bl = ftpFile.isDirectory();
                        if (!bl2) {
                            boolean bl3;
                            if (!bl2) {
                                if (!bl) {
                                    this.deleteFile(string3);
                                    if (!bl2) continue;
                                }
                                bl3 = string3.equals(".");
                            }
                            if (!bl2) {
                                if (bl3) continue;
                                bl3 = string3.equals(z[1]);
                            }
                            if (bl3) continue;
                            this.deleteDir(string3, true);
                            if (!bl2) continue;
                        }
                        break block10;
                    }
                    this.setDir(string2);
                    bl = string.equals(".");
                }
                if (bl2) break block11;
                if (bl) break block12;
                bl = string.equals(z[1]);
            }
            if (!bl) {
                this.deleteDir(string, false);
            }
        }
    }

    public String getDiskEncoding() {
        return this.encodingDisk;
    }

    public void setDiskEncoding(String string) {
        this.encodingDisk = string;
    }

    public String getWireEncoding() {
        return this.encodingWire;
    }

    public void setWireEncoding(String string) {
        this.encodingWire = string;
    }

    public String getPortAddress() {
        return this.portAddress;
    }

    public void setPortAddress(String string) {
        this.portAddress = string;
    }

    public void setProxyAuthentication(String string, String string2) {
        this.proxyUsername = string;
        this.proxyPassword = string2;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public String getProxyHostname() {
        return this.proxyHostname;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyType() {
        return this.proxyType;
    }

    public void setProxyHost(String string, int n2) {
        this.proxyHostname = string;
        this.proxyPort = n2;
    }

    public void setProxyType(String string) {
        this.proxyType = string;
    }

    public void clearProxySettings() {
        this.setProxyAuthentication(null, null);
        this.setProxyHost(null, 1080);
        this.setProxyType(e);
    }

    public abstract void readResponse() throws FtpException;

    public abstract void setSendBufferSize(int var1);

    public abstract void setReceiveBufferSize(int var1);

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     */
    static {
        char[] cArray;
        String[] stringArray;
        block59: {
            int n2;
            int n3;
            block58: {
                char[] cArray2;
                Object var0;
                block57: {
                    int n4;
                    block56: {
                        char[] cArray3;
                        block55: {
                            int n5;
                            block54: {
                                char[] cArray4;
                                block53: {
                                    int n6;
                                    block52: {
                                        char[] cArray5;
                                        block51: {
                                            int n7;
                                            block50: {
                                                char[] cArray6;
                                                block49: {
                                                    int n8;
                                                    block48: {
                                                        stringArray = new String[5];
                                                        var0 = null;
                                                        char[] cArray7 = "<q)X.Z".toCharArray();
                                                        cArray6 = cArray7;
                                                        n8 = cArray7.length;
                                                        n3 = 0;
                                                        if (!true) break block48;
                                                        n8 = n8;
                                                        if (n8 <= n3) break block49;
                                                    }
                                                    do {
                                                        int n9;
                                                        cArray6 = cArray6;
                                                        int n10 = n3;
                                                        char c2 = cArray6[n10];
                                                        switch (n3 % 5) {
                                                            case 0: {
                                                                n9 = 111;
                                                                break;
                                                            }
                                                            case 1: {
                                                                n9 = 62;
                                                                break;
                                                            }
                                                            case 2: {
                                                                n9 = 106;
                                                                break;
                                                            }
                                                            case 3: {
                                                                n9 = 19;
                                                                break;
                                                            }
                                                            default: {
                                                                n9 = 125;
                                                            }
                                                        }
                                                        cArray6[n10] = (char)(c2 ^ n9);
                                                        ++n3;
                                                        n8 = n8;
                                                    } while (n8 > n3);
                                                }
                                                e = new String(cArray6).intern();
                                                var0 = null;
                                                char[] cArray8 = "\u0018L\u0005}\u001aO\\\u0006|\u001e\u0004\u001e\u0019z\u0007\n\u001e\u001ar\u000e\u001c[\u000e)]".toCharArray();
                                                cArray5 = cArray8;
                                                n7 = cArray8.length;
                                                n3 = 0;
                                                if (!true) break block50;
                                                n7 = n7;
                                                if (n7 <= n3) break block51;
                                            }
                                            do {
                                                int n11;
                                                cArray5 = cArray5;
                                                int n12 = n3;
                                                char c3 = cArray5[n12];
                                                switch (n3 % 5) {
                                                    case 0: {
                                                        n11 = 111;
                                                        break;
                                                    }
                                                    case 1: {
                                                        n11 = 62;
                                                        break;
                                                    }
                                                    case 2: {
                                                        n11 = 106;
                                                        break;
                                                    }
                                                    case 3: {
                                                        n11 = 19;
                                                        break;
                                                    }
                                                    default: {
                                                        n11 = 125;
                                                    }
                                                }
                                                cArray5[n12] = (char)(c3 ^ n11);
                                                ++n3;
                                                n7 = n7;
                                            } while (n7 > n3);
                                        }
                                        stringArray[0] = new String(cArray5).intern();
                                        var0 = null;
                                        char[] cArray9 = "A\u0010".toCharArray();
                                        cArray4 = cArray9;
                                        n6 = cArray9.length;
                                        n3 = 0;
                                        if (!true) break block52;
                                        n6 = n6;
                                        if (n6 <= n3) break block53;
                                    }
                                    do {
                                        int n13;
                                        cArray4 = cArray4;
                                        int n14 = n3;
                                        char c4 = cArray4[n14];
                                        switch (n3 % 5) {
                                            case 0: {
                                                n13 = 111;
                                                break;
                                            }
                                            case 1: {
                                                n13 = 62;
                                                break;
                                            }
                                            case 2: {
                                                n13 = 106;
                                                break;
                                            }
                                            case 3: {
                                                n13 = 19;
                                                break;
                                            }
                                            default: {
                                                n13 = 125;
                                            }
                                        }
                                        cArray4[n14] = (char)(c4 ^ n13);
                                        ++n3;
                                        n6 = n6;
                                    } while (n6 > n3);
                                }
                                stringArray[1] = new String(cArray4).intern();
                                var0 = null;
                                char[] cArray10 = "?\u007f9@]E\u0014@9WE".toCharArray();
                                cArray3 = cArray10;
                                n5 = cArray10.length;
                                n3 = 0;
                                if (!true) break block54;
                                n5 = n5;
                                if (n5 <= n3) break block55;
                            }
                            do {
                                int n15;
                                cArray3 = cArray3;
                                int n16 = n3;
                                char c5 = cArray3[n16];
                                switch (n3 % 5) {
                                    case 0: {
                                        n15 = 111;
                                        break;
                                    }
                                    case 1: {
                                        n15 = 62;
                                        break;
                                    }
                                    case 2: {
                                        n15 = 106;
                                        break;
                                    }
                                    case 3: {
                                        n15 = 19;
                                        break;
                                    }
                                    default: {
                                        n15 = 125;
                                    }
                                }
                                cArray3[n16] = (char)(c5 ^ n15);
                                ++n3;
                                n5 = n5;
                            } while (n5 > n3);
                        }
                        stringArray[2] = new String(cArray3).intern();
                        var0 = null;
                        char[] cArray11 = "?\u007f9@".toCharArray();
                        cArray2 = cArray11;
                        n4 = cArray11.length;
                        n3 = 0;
                        if (!true) break block56;
                        n4 = n4;
                        if (n4 <= n3) break block57;
                    }
                    do {
                        int n17;
                        cArray2 = cArray2;
                        int n18 = n3;
                        char c6 = cArray2[n18];
                        switch (n3 % 5) {
                            case 0: {
                                n17 = 111;
                                break;
                            }
                            case 1: {
                                n17 = 62;
                                break;
                            }
                            case 2: {
                                n17 = 106;
                                break;
                            }
                            case 3: {
                                n17 = 19;
                                break;
                            }
                            default: {
                                n17 = 125;
                            }
                        }
                        cArray2[n18] = (char)(c6 ^ n17);
                        ++n3;
                        n4 = n4;
                    } while (n4 > n3);
                }
                stringArray[3] = new String(cArray2).intern();
                var0 = null;
                char[] cArray12 = "b4".toCharArray();
                cArray = cArray12;
                n2 = cArray12.length;
                n3 = 0;
                if (!true) break block58;
                n2 = n2;
                if (n2 <= n3) break block59;
            }
            do {
                int n19;
                cArray = cArray;
                int n20 = n3;
                char c7 = cArray[n20];
                switch (n3 % 5) {
                    case 0: {
                        n19 = 111;
                        break;
                    }
                    case 1: {
                        n19 = 62;
                        break;
                    }
                    case 2: {
                        n19 = 106;
                        break;
                    }
                    case 3: {
                        n19 = 19;
                        break;
                    }
                    default: {
                        n19 = 125;
                    }
                }
                cArray[n20] = (char)(c7 ^ n19);
                ++n3;
                n2 = n2;
            } while (n2 > n3);
        }
        stringArray[4] = new String(cArray).intern();
        z = stringArray;
    }
}

