/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.event;

import com.dropbox.event.DbxEventObject;
import java.text.MessageFormat;
import java.util.EventListener;
import java.util.LinkedList;

public class DbxEvent {
    protected final LinkedList<Listener> listenerList = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(Listener ... llListeners) {
        if (llListeners == null) {
            return;
        }
        LinkedList<Listener> linkedList = this.listenerList;
        synchronized (linkedList) {
            for (Listener listener : llListeners) {
                if (listener == null || this.listenerList.contains(listener)) continue;
                this.listenerList.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(Listener ... llListeners) {
        if (llListeners == null) {
            return;
        }
        LinkedList<Listener> linkedList = this.listenerList;
        synchronized (linkedList) {
            for (Listener listener : llListeners) {
                if (listener == null) continue;
                this.listenerList.remove(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllListeners() {
        LinkedList<Listener> linkedList = this.listenerList;
        synchronized (linkedList) {
            this.listenerList.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireDebug(String sMessage, Object ... objects) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        LinkedList<Listener> linkedList = this.listenerList;
        synchronized (linkedList) {
            String sMsg = "";
            try {
                sMsg = MessageFormat.format(sMessage, objects);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            DbxEventObject eventObject = new DbxEventObject(this, sMsg);
            for (Listener listener : this.listenerList) {
                try {
                    listener.doDebug(eventObject);
                }
                catch (Exception ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireInfo(String sMessage, Object ... objects) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        LinkedList<Listener> linkedList = this.listenerList;
        synchronized (linkedList) {
            String sMsg = "";
            try {
                sMsg = MessageFormat.format(sMessage, objects);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            DbxEventObject eventObject = new DbxEventObject(this, sMsg);
            for (Listener listener : this.listenerList) {
                try {
                    listener.doInfo(eventObject);
                }
                catch (Exception ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireWarn(String sMessage, Object ... objects) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        LinkedList<Listener> linkedList = this.listenerList;
        synchronized (linkedList) {
            String sMsg = "";
            try {
                sMsg = MessageFormat.format(sMessage, objects);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            DbxEventObject eventObject = new DbxEventObject(this, sMsg);
            for (Listener listener : this.listenerList) {
                try {
                    listener.doWarn(eventObject);
                }
                catch (Exception ignored) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireError(String sErrorMessage, Throwable throwable, Object ... objects) {
        if (this.listenerList.isEmpty()) {
            return;
        }
        LinkedList<Listener> linkedList = this.listenerList;
        synchronized (linkedList) {
            String sMsg = "";
            try {
                sMsg = MessageFormat.format(sErrorMessage, objects);
            }
            catch (Exception ignored) {
                // empty catch block
            }
            DbxEventObject eventObject = new DbxEventObject(this, sMsg, throwable);
            for (Listener listener : this.listenerList) {
                try {
                    listener.doError(eventObject);
                }
                catch (Exception ignored) {}
            }
        }
    }

    public static abstract class Adaptor
    implements Listener {
        @Override
        public void doDebug(DbxEventObject eventObject) {
        }

        @Override
        public void doInfo(DbxEventObject eventObject) {
        }

        @Override
        public void doWarn(DbxEventObject eventObject) {
        }

        @Override
        public void doError(DbxEventObject eventObject) {
        }
    }

    public static interface Listener
    extends EventListener {
        public void doDebug(DbxEventObject var1);

        public void doInfo(DbxEventObject var1);

        public void doWarn(DbxEventObject var1);

        public void doError(DbxEventObject var1);
    }
}

