/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.data.jpa.repository.query;

import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import javax.persistence.Parameter;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import javax.persistence.criteria.ParameterExpression;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.jpa.repository.query.JpaParametersParameterAccessor;
import org.springframework.data.jpa.repository.query.QueryUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

interface QueryParameterSetter {
    public static final QueryParameterSetter NOOP = (query, values, errorHandling) -> {};

    public void setParameter(BindableQuery var1, JpaParametersParameterAccessor var2, ErrorHandling var3);

    public static class BindableQuery
    extends QueryMetadata {
        private final Query query;
        private final Query unwrapped;

        BindableQuery(QueryMetadata metadata, Query query) {
            super(metadata);
            this.query = query;
            this.unwrapped = Proxy.isProxyClass(query.getClass()) ? (Query)query.unwrap(null) : query;
        }

        private BindableQuery(Query query) {
            super(query);
            this.query = query;
            this.unwrapped = Proxy.isProxyClass(query.getClass()) ? (Query)query.unwrap(null) : query;
        }

        public static BindableQuery from(Query query) {
            return new BindableQuery(query);
        }

        public Query getQuery() {
            return this.query;
        }

        public <T> Query setParameter(Parameter<T> param, T value) {
            return this.unwrapped.setParameter(param, value);
        }

        public Query setParameter(Parameter<Date> param, Date value, TemporalType temporalType) {
            return this.unwrapped.setParameter(param, value, temporalType);
        }

        public Query setParameter(String name, Object value) {
            return this.unwrapped.setParameter(name, value);
        }

        public Query setParameter(String name, Date value, TemporalType temporalType) {
            return this.query.setParameter(name, value, temporalType);
        }

        public Query setParameter(int position, Object value) {
            return this.unwrapped.setParameter(position, value);
        }

        public Query setParameter(int position, Date value, TemporalType temporalType) {
            return this.unwrapped.setParameter(position, value, temporalType);
        }
    }

    public static class QueryMetadata {
        private final boolean namedParameters;
        private final Set<Parameter<?>> parameters;
        private final boolean registerExcessParameters;

        QueryMetadata(Query query) {
            this.namedParameters = QueryUtils.hasNamedParameter(query);
            this.parameters = query.getParameters();
            this.registerExcessParameters = query.getParameters().size() == 0 && QueryMetadata.unwrapClass(query).getName().startsWith("org.eclipse");
        }

        QueryMetadata(QueryMetadata metadata) {
            this.namedParameters = metadata.namedParameters;
            this.parameters = metadata.parameters;
            this.registerExcessParameters = metadata.registerExcessParameters;
        }

        public BindableQuery withQuery(Query query) {
            return new BindableQuery(this, query);
        }

        public Set<Parameter<?>> getParameters() {
            return this.parameters;
        }

        public boolean hasNamedParameters() {
            return this.namedParameters;
        }

        public boolean registerExcessParameters() {
            return this.registerExcessParameters;
        }

        private static Class<?> unwrapClass(Query query) {
            Class<?> queryType = query.getClass();
            try {
                return Proxy.isProxyClass(queryType) ? query.unwrap(null).getClass() : queryType;
            }
            catch (RuntimeException e) {
                LoggerFactory.getLogger(QueryMetadata.class).warn("Failed to unwrap actual class for Query proxy.", (Throwable)e);
                return queryType;
            }
        }
    }

    public static class QueryMetadataCache {
        private Map<String, QueryMetadata> cache = Collections.emptyMap();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public QueryMetadata getMetadata(String cacheKey, Query query) {
            QueryMetadata queryMetadata = this.cache.get(cacheKey);
            if (queryMetadata == null) {
                Map<String, QueryMetadata> cache;
                queryMetadata = new QueryMetadata(query);
                if (this.cache.isEmpty()) {
                    cache = Collections.singletonMap(cacheKey, queryMetadata);
                } else {
                    cache = new HashMap<String, QueryMetadata>(this.cache);
                    cache.put(cacheKey, queryMetadata);
                }
                QueryMetadataCache queryMetadataCache = this;
                synchronized (queryMetadataCache) {
                    this.cache = cache;
                }
            }
            return queryMetadata;
        }
    }

    public static enum ErrorHandling {
        STRICT{

            @Override
            public void execute(Runnable block) {
                block.run();
            }
        }
        ,
        LENIENT{

            @Override
            public void execute(Runnable block) {
                try {
                    block.run();
                }
                catch (RuntimeException rex) {
                    LOG.info("Silently ignoring", (Throwable)rex);
                }
            }
        };

        private static final Logger LOG;

        abstract void execute(Runnable var1);

        static {
            LOG = LoggerFactory.getLogger(ErrorHandling.class);
        }
    }

    public static class NamedOrIndexedQueryParameterSetter
    implements QueryParameterSetter {
        private final Function<JpaParametersParameterAccessor, Object> valueExtractor;
        private final Parameter<?> parameter;
        @Nullable
        private final TemporalType temporalType;

        NamedOrIndexedQueryParameterSetter(Function<JpaParametersParameterAccessor, Object> valueExtractor, Parameter<?> parameter, @Nullable TemporalType temporalType) {
            Assert.notNull(valueExtractor, (String)"ValueExtractor must not be null!");
            this.valueExtractor = valueExtractor;
            this.parameter = parameter;
            this.temporalType = temporalType;
        }

        @Override
        public void setParameter(BindableQuery query, JpaParametersParameterAccessor accessor, ErrorHandling errorHandling) {
            Object value = this.valueExtractor.apply(accessor);
            if (this.temporalType != null) {
                if (this.parameter instanceof ParameterExpression) {
                    errorHandling.execute(() -> query.setParameter(this.parameter, (Date)value, this.temporalType));
                } else if (query.hasNamedParameters() && this.parameter.getName() != null) {
                    errorHandling.execute(() -> query.setParameter(this.parameter.getName(), (Date)value, this.temporalType));
                } else {
                    Integer position = this.parameter.getPosition();
                    if (position != null && (query.getParameters().size() >= this.parameter.getPosition() || query.registerExcessParameters() || errorHandling == ErrorHandling.LENIENT)) {
                        errorHandling.execute(() -> query.setParameter(this.parameter.getPosition(), (Date)value, this.temporalType));
                    }
                }
            } else if (this.parameter instanceof ParameterExpression) {
                errorHandling.execute(() -> query.setParameter(this.parameter, value));
            } else if (query.hasNamedParameters() && this.parameter.getName() != null) {
                errorHandling.execute(() -> query.setParameter(this.parameter.getName(), value));
            } else {
                Integer position = this.parameter.getPosition();
                if (position != null && (query.getParameters().size() >= position || errorHandling == ErrorHandling.LENIENT || query.registerExcessParameters())) {
                    errorHandling.execute(() -> query.setParameter(position, value));
                }
            }
        }
    }
}

