/*
 * Decompiled with CFR 0.152.
 */
package com.eatthepath.otp;

import com.eatthepath.otp.HmacOneTimePasswordGenerator;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.time.Instant;

public class TimeBasedOneTimePasswordGenerator
extends HmacOneTimePasswordGenerator {
    private final Duration timeStep;
    public static final Duration DEFAULT_TIME_STEP = Duration.ofSeconds(30L);
    public static final String TOTP_ALGORITHM_HMAC_SHA1 = "HmacSHA1";
    public static final String TOTP_ALGORITHM_HMAC_SHA256 = "HmacSHA256";
    public static final String TOTP_ALGORITHM_HMAC_SHA512 = "HmacSHA512";

    public TimeBasedOneTimePasswordGenerator() throws NoSuchAlgorithmException {
        this(DEFAULT_TIME_STEP);
    }

    public TimeBasedOneTimePasswordGenerator(Duration timeStep) throws NoSuchAlgorithmException {
        this(timeStep, 6);
    }

    public TimeBasedOneTimePasswordGenerator(Duration timeStep, int passwordLength) throws NoSuchAlgorithmException {
        this(timeStep, passwordLength, TOTP_ALGORITHM_HMAC_SHA1);
    }

    public TimeBasedOneTimePasswordGenerator(Duration timeStep, int passwordLength, String algorithm) throws NoSuchAlgorithmException {
        super(passwordLength, algorithm);
        this.timeStep = timeStep;
    }

    public int generateOneTimePassword(Key key, Instant timestamp) throws InvalidKeyException {
        return this.generateOneTimePassword(key, timestamp.toEpochMilli() / this.timeStep.toMillis());
    }

    public Duration getTimeStep() {
        return this.timeStep;
    }
}

