/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vim25.ws;

import com.vmware.vim25.ManagedObjectReference;
import com.vmware.vim25.mo.util.MorUtil;
import com.vmware.vim25.ws.Argument;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import org.apache.log4j.Logger;
import org.doublecloud.ws.util.ReflectUtil;
import org.doublecloud.ws.util.TypeUtil;
import org.doublecloud.ws.util.XmlUtil;

public abstract class XmlGen {
    private static Logger log = Logger.getLogger(XmlGen.class);

    public static String toXML(String methodName, Argument[] paras, String vimNameSpace) {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:soapenc=\"http://schemas.xmlsoap.org/soap/encoding/\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><soapenv:Body>");
        sb.append("<").append(methodName).append(vimNameSpace);
        for (Argument para : paras) {
            String key = para.getName();
            String type = para.getType();
            Object obj = para.getValue();
            sb.append(XmlGen.toXML(key, type, obj));
        }
        sb.append("</").append(methodName).append(">");
        sb.append("</soapenv:Body></soapenv:Envelope>");
        return sb.toString();
    }

    private static String toXML(String tag, String type, Object obj) {
        if (obj == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        if (TypeUtil.isBasicType(type)) {
            XmlGen.toXML(sb, tag, obj.getClass(), obj);
        } else {
            Class<?> clazz = TypeUtil.getVimClass(type);
            XmlGen.toXML(sb, tag, clazz, obj);
        }
        return sb.toString();
    }

    private static void toXML(StringBuffer sb, String tagName, Class<?> type, Object obj) {
        Class<?> clazz = obj.getClass();
        if (clazz.isArray()) {
            if (obj.getClass() == TypeUtil.INT_ARRAY_CLASS) {
                int[] objs;
                for (int obj1 : objs = (int[])obj) {
                    sb.append("<").append(tagName).append(">");
                    sb.append(obj1);
                    sb.append("</").append(tagName).append(">");
                }
            } else if (obj.getClass() == TypeUtil.BYTE_ARRAY_CLASS) {
                byte[] objs;
                for (byte obj1 : objs = (byte[])obj) {
                    sb.append("<").append(tagName).append(">");
                    sb.append(obj1);
                    sb.append("</").append(tagName).append(">");
                }
            } else if (obj.getClass() == TypeUtil.LONG_ARRAY_CLASS) {
                long[] objs;
                for (long obj1 : objs = (long[])obj) {
                    sb.append("<").append(tagName).append(">");
                    sb.append(obj1);
                    sb.append("</").append(tagName).append(">");
                }
            } else {
                Object[] objs;
                for (Object obj1 : objs = (Object[])obj) {
                    XmlGen.toXML(sb, tagName, type.getComponentType(), obj1);
                }
            }
        } else if (clazz == ManagedObjectReference.class) {
            ManagedObjectReference mor = (ManagedObjectReference)obj;
            if (clazz == type) {
                sb.append("<").append(tagName).append(" type=\"").append(mor.type).append("\">");
            } else {
                sb.append("<").append(tagName).append(" xsi:type=\"ManagedObjectReference\" type=\"").append(mor.type).append("\">");
            }
            sb.append(mor.val);
            sb.append("</").append(tagName).append(">");
        } else if (clazz.getCanonicalName().startsWith("java.lang")) {
            if (clazz != type) {
                sb.append("<").append(tagName).append(" xsi:type=\"").append(TypeUtil.getXSIType(obj)).append("\">");
            } else {
                sb.append("<").append(tagName).append(">");
            }
            if (clazz == String.class) {
                String temp = (String)obj;
                obj = XmlUtil.escapeForXML(temp);
            }
            sb.append(obj);
            sb.append("</").append(tagName).append(">");
        } else if (clazz.isEnum()) {
            sb.append("<").append(tagName).append(">").append(obj).append("</").append(tagName).append(">");
        } else if (obj instanceof Calendar) {
            sb.append("<").append(tagName).append(" xsi:type=\"xsd:dateTime\">").append(DatatypeConverter.printDateTime((Calendar)obj)).append("</").append(tagName).append(">");
        } else {
            Field[] fields;
            if (clazz == type) {
                sb.append("<").append(tagName).append(">");
            } else {
                String nameSpaceType = clazz.getSimpleName();
                sb.append("<").append(tagName).append(" xsi:type=\"").append(nameSpaceType).append("\">");
            }
            for (Field f : fields = ReflectUtil.getAllFields(clazz)) {
                String fName = f.getName();
                Object value = null;
                if (!Modifier.isTransient(f.getModifiers())) {
                    try {
                        value = f.get(obj);
                    }
                    catch (IllegalAccessException iae) {
                        log.error((Object)"IllegalAccessException caught.", (Throwable)iae);
                    }
                }
                if (value == null) continue;
                Class<?> fType = f.getType();
                XmlGen.toXML(sb, fName, fType, value);
            }
            sb.append("</").append(tagName).append(">");
        }
    }

    @Deprecated
    public static ManagedObjectReference createMOR(String type, String value) {
        return MorUtil.createMOR(type, value);
    }

    public abstract Object fromXML(String var1, InputStream var2) throws Exception;
}

