#!/bin/sh

######################
# SCRIPT HISTORY:
# 10600: First Created
######################

############# MIGRATE JVM PROCEDURE ############
## RESOLVING PATHS ##########################################################################################
# NOTE: 1. Assume that the script current path is inside "%APP_HOME%/aua/%VERSION%/upgrade/".
#       2. Assume that all the APP related java processes are killed / shut down before running this script.
#############################################################################################################

############ DEFINE VARIABLES ############
## Variable Defined for Debugging ##
## NOTE: Set "on" to show the debugging messages. ##
_DEBUG="on"

############ GENERAL UTILITY ###########
### Methods for Debugging ###
DEBUG()
{
    [ "$_DEBUG" = "on" ] &&  $@
}

SCRIPT_WORKING_PATH=`pwd`
FILENAME_THIS_SCRIPT=`basename "$0"`

cd "../.."
DIRPATH_AUA_HOME=`pwd`
DIRPATH_APP_HOME=`dirname "$DIRPATH_AUA_HOME"`

case `uname -s` in
	## Mac OS X
	"Darwin")
		if [[ "$DIRPATH_APP_HOME" != *.app ]]
		then
			DIRPATH_APP_HOME="$DIRPATH_APP_HOME.app"
		fi
	;;
	*)
	;;
esac	

DIRPATH_APP_BIN_DIR="$DIRPATH_APP_HOME/bin"
DIRPATH_APP_JVM_HOME="$DIRPATH_APP_HOME/jvm"
DIRPATH_APP_JVM_BIN_DIR="$DIRPATH_APP_JVM_HOME/bin"

FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_X86="jre-std-linux-x86-586.tar.gz"
FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_X64="jre-std-linux-amd64.tar.gz"
FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_ARM32="jre-std-linux-arm32.tar.gz"
FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_AARCH64="jre-std-linux-arm64.tar.gz"

FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_MAC="jre-std-mac.tar.gz"

chmod_jvm_home()
{
    [ -d "$DIRPATH_APP_JVM_HOME" ] && chmod 755 "$DIRPATH_APP_JVM_HOME" && DEBUG echo "Chmod 755 \"$DIRPATH_APP_JVM_HOME\"."
    [ -d "$DIRPATH_APP_JVM_BIN_DIR" ] && chmod -R 755 "$DIRPATH_APP_JVM_BIN_DIR" && DEBUG echo "Chmod 755 \"$DIRPATH_APP_JVM_BIN_DIR\" and its files / subdirectories."
}

is_extract_and_update_jvm_done_successfully()
{
	case `uname -s` in
		Linux*)
			case `uname -m` in
				*86)
					FILENAME_EXTRACT_JVM_TGZ_ARCHIVE="$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_X86"
				;;
				x86_64 | amd64)
					FILENAME_EXTRACT_JVM_TGZ_ARCHIVE="$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_X64"
				;;
				arm*)
					FILENAME_EXTRACT_JVM_TGZ_ARCHIVE="$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_ARM32"
				;;
				aarch64*)
					FILENAME_EXTRACT_JVM_TGZ_ARCHIVE="$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_AARCH64"
				;;
				*)
					return 1
				;;
			esac
		;;
		## Mac OS X
		"Darwin")
			FILENAME_EXTRACT_JVM_TGZ_ARCHIVE="$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_MAC"
		;;
		*) 
			return 1
	esac
	
    # Note: If the old JVM Home exist, remove it and its contents before extracting the JRE archive.
    [ ! -L "$DIRPATH_APP_JVM_HOME" ] && [ -d "$DIRPATH_APP_JVM_HOME" ] && rm -rf "$DIRPATH_APP_JVM_HOME" && DEBUG echo "Removed the directory \"$DIRPATH_APP_JVM_HOME\" and its contents."
    # Note: If the old JVM Home is symlink, remove it
    [ -L "$DIRPATH_APP_JVM_HOME" ] && rm -f "$DIRPATH_APP_JVM_HOME" && DEBUG echo "Removed the symlink \"$DIRPATH_APP_JVM_HOME\"."
    [ ! -d "$DIRPATH_APP_JVM_HOME" ] && mkdir -p "$DIRPATH_APP_JVM_HOME" && DEBUG echo "Created the directory \"$DIRPATH_APP_JVM_HOME\"."
    [ -f "$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE" ] && tar zxf "$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE" -C "$DIRPATH_APP_JVM_HOME" && DEBUG echo "Extract the file \"$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE\" to the directory \"$DIRPATH_APP_JVM_HOME\"."
    return 0
}

remove_the_jvm_archives()
{
    [ -f "$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_X86" ] && rm -f "$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_X86" && DEBUG echo "Removed the file \"$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_X86\"."
    [ -f "$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_X64" ] && rm -f "$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_X64" && DEBUG echo "Removed the file \"$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_X64\"."
    [ -f "$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_ARM32" ] && rm -f "$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_ARM32" && DEBUG echo "Removed the file \"$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_ARM32\"."
    [ -f "$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_AARCH64" ] && rm -f "$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_AARCH64" && DEBUG echo "Removed the file \"$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_LIN_AARCH64\"."
    [ -f "$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_MAC" ] && rm -f "$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_MAC" && DEBUG echo "Removed the file \"$SCRIPT_WORKING_PATH/$FILENAME_EXTRACT_JVM_TGZ_ARCHIVE_MAC\"."
}

remove_this_shell_script()
{
    [ -f "$SCRIPT_WORKING_PATH/$FILENAME_THIS_SCRIPT" ] && rm -f "$SCRIPT_WORKING_PATH/$FILENAME_THIS_SCRIPT" && DEBUG echo "Removed the file \"$SCRIPT_WORKING_PATH/$FILENAME_THIS_SCRIPT\"."
}

## MAIN ##
#########################

eval is_extract_and_update_jvm_done_successfully

result=$?

if [ $result -ne 0 ]   # If jvm extract and update failed
then
	DEBUG echo "JVM migration failed. ExitCode=" + $result
else
	DEBUG echo "JVM migration finished."
    chmod_jvm_home
fi

remove_the_jvm_archives
remove_this_shell_script

#########################

exit $result
