#!/bin/sh

# Download the jvm from server
obtain_package "jvm" "jre-std-linux-arm64.tar.gz" "jvm"
log "Download others libraries"
# [Start] 50623: Use *-native-nix-x64.tar.gz because arm64 libraries were already moved here from *-native-nix-others.tar.gz (Task #42960)
# obtain_package "component" "app-native-nix-others.tar.gz" "nix-native"
# obtain_package "component" "aua-native-nix-others.tar.gz" "aua-native"
if [ "$CLIENT_MAJOR_VERSION" = "$FALLBACK_MAJOR_VERSION" ]; then
    obtain_package "component" "app-native-nix-others.tar.gz" "nix-native"
    obtain_package "component" "aua-native-nix-others.tar.gz" "aua-native"
else
    obtain_package "component" "app-native-nix-x64.tar.gz" "nix-native"
    obtain_package "component" "aua-native-nix-x64.tar.gz" "aua-native"
fi
# [End] 50623

# Another approach is to bundle the jvm in $APP_INST
#if [ -f $APP_INST/jvm.tar.gz ]; then
#    $CMD_TAR -zxf $APP_INST/jvm.tar.gz -C $APP_HOME
#fi

if [ -f $APP_INST/jvmLib.tar.gz ]; then
    log "Extract JVM library"
    $CMD_TAR -zxf $APP_INST/jvmLib.tar.gz -C $APP_HOME
fi

# if [ -z "$CMD_PYTHON" ] && [ -f $APP_INST/python.tar.gz ]; then
#     log "No suitable Python executable found, install bundled Python now"
#     py_inst_dir=$APP_HOME/python
#     export PYTHONHOME=$py_inst_dir

#     $CMD_TAR -zxf $APP_INST/python.tar.gz -C $APP_HOME
#     CMD_PYTHON=$py_inst_dir/bin/python
#     $CMD_PYTHON -m compileall $py_inst_dir/lib/python2.7 2>&1 >/dev/null
#     log "Bundled Python installed at: $CMD_PYTHON"
# fi
