#!/bin/sh

############################### getEnvInfo.sh ##################################
# Do not run this script directly.                                             #
# This script is used and called by other scripts to declare variables         #
#    containing environment information.                                       #
################################################################################

################################################################################
#           S Y S T E M    O S     A N D     A R C H I T E C T U R E           #
################################################################################

SYSTEM_OS=`uname`
SYSTEM_ARCH=`uname -m`
DEP_LIB_PATH=

################################################################################
#                                O S   N A M E                                 #
################################################################################

OS_NAME=
case "${SYSTEM_OS}" in
  Linux* )
    OS_NAME="Lin"
    ;;
  * )
    echo "OS \"${SYSTEM_OS}\" is not supported. Exit now."
    exit 1
    ;;
esac

################################################################################
#                        O S    A R C H I T E C T U R E                        #
################################################################################

OS_ARCH=
if [ -z "${DEP_LIB_PATH}" ]; then
    case "${SYSTEM_ARCH}" in
        i[3-6]86 | 32)
            OS_ARCH="X86"
        ;;
        x86_64 | amd64 | 64)
            OS_ARCH="X64"
        ;;
        armv6*)
            OS_ARCH="Av6"
        ;;
        armv7*)
            OS_ARCH="Av7"
        ;;
        armv5*)
            OS_ARCH="Arm"
        ;;
        aarch64*)
            OS_ARCH="A64"
        ;;
        * )
            echo "Arch \"${SYSTEM_ARCH}\" is not supported. Exit now."
            exit 1
        ;;
    esac
    DEP_LIB_PATH=${OS_NAME}${OS_ARCH}
fi
