#!/bin/bash

# uninstall logic for Ahsay A-Click Backup 10.1.6.0
# The root privilege is required to uninstall the application

###############################################################################
#             S H U T - D O W N                 S E R V I C E S               #
###############################################################################

# Shutdown Scheduler
if [ -e "/Applications/AhsayACB.app/ipc/Scheduler/running" ]; then
    echo "Shutdown Scheduler for Ahsay A-Click Backup"
    touch "/Applications/AhsayACB.app/ipc/Scheduler/stop"
    echo "Wait 5 seconds before Scheduler exits"
    sleep 5
fi

# Shutdown AutoUpdateAgent
#if [ -e "/Applications/AhsayACB/aua/bin" ]; then
#    echo "Shutdown AutoUpdateAgent for Ahsay A-Click Backup"
#    sh "/Applications/AhsayACB/aua/bin/shutdown.sh"
#    echo "Wait 5 seconds before AutoUpdateAgent exits"
#    sleep 5
#fi

###############################################################################
#        T A S K K I L L       A L L      J A V A       P R O C E S S         #
###############################################################################

# Kill all running process
sh "/Applications/AhsayACB.app/bin/taskkill" "/Applications/AhsayACB.app/jvm/bin/bJW"
sh "/Applications/AhsayACB.app/bin/taskkill" "/Applications/AhsayACB.app/jvm/bin/bschJW"
sh "/Applications/AhsayACB.app/bin/taskkill" "/Applications/AhsayACB.app/jvm/bin/java"


###############################################################################
#                 R E M O V E                   S E R V I C E S               #
###############################################################################

# Remove Scheduler
if [ -e "/Library/StartupItems/AhsayACB" ]; then
    echo "Remove Scheduler for Ahsay A-Click Backup from service"
    rm -rf "/Library/StartupItems/AhsayACB"
fi

# Remove Launch Daemons
if [ -e "/Library/LaunchDaemons/com.AhsayACB.scheduler.plist" ]; then
    echo "Remove LaunchDaemons for com.AhsayACB.scheduler from service"
    launchctl unload "/Library/LaunchDaemons/com.AhsayACB.scheduler.plist"
    rm -f "/Library/LaunchDaemons/com.AhsayACB.scheduler.plist"
fi
# Remove AutoUpdateAgent
#if [ -e "/Library/StartupItems/AhsayACB-AutoUpdate" ]; then
#    echo "Remove AutoUpdateAgent for Ahsay A-Click Backup from service"
#    rm -rf "/Library/StartupItems/AhsayACB-AutoUpdate"
#fi

###############################################################################
#      R E M O V E        U S E R         D E S K T O P      L I N K          #
###############################################################################

# Remove Desktop Symbolic Link
find /Users -name Desktop -type d -maxdepth 3 -mindepth 2 | while read DESKTOP_PATH;
do
    if [ -e "${DESKTOP_PATH}/AhsayACB" ]; then
        echo "Remove Desktop Link AhsayACB from path ${DESKTOP_PATH}"
        rm -f "${DESKTOP_PATH}/AhsayACB"
        echo "Removed AhsayACB Desktop Link"
    fi

    if [ -e "${DESKTOP_PATH}/Ahsay A-Click Backup" ]; then
        echo "Remove Desktop Link Ahsay A-Click Backup from path ${DESKTOP_PATH}"
        rm -f "${DESKTOP_PATH}/Ahsay A-Click Backup"
        echo "Removed Ahsay A-Click Backup Desktop Link"
    fi

    if [ -e "${DESKTOP_PATH}/AhsayACB" ]; then
        echo "Remove Desktop Link AhsayACB from path ${DESKTOP_PATH}"
        rm -f "${DESKTOP_PATH}/AhsayACB"
        echo "Removed AhsayACB Desktop Link"
    fi

done

###############################################################################
#       R E M O V E        F I R E W A L L        R U L E                     #
###############################################################################

echo "Remove firewall rule"
sh "/Applications/AhsayACB.app/bin/UpdateFirewallRule.sh" "/Applications/AhsayACB.app/Contents/MacOS/AhsayACB" false

###############################################################################
#        R E M O V E           A P P L I C A T I O N           H O M E        #
###############################################################################

# Remove Ahsay A-Click Backup
cd /
if [ -e "/Applications/AhsayACB.app" ]; then
    echo "Remove AhsayACB from Your Mac OS X"
    rm -rf "/Applications/AhsayACB.app"
fi

###############################################################################
#        R E M O V E             M A C     O S        R E C E I P T S         #
###############################################################################

# Remove Mac OS X Receipts
if [ -e "/Library/Receipts/acb-mac.pkg" ]; then
    echo "Remove Mac OS X Receipt for acb-mac.pkg (Path: /Library/Receipts/acb-mac.pkg)"
    rm -rf "/Library/Receipts/acb-mac.pkg"
fi