#!/bin/sh

################################################################################
#          R E T R I E V E     A P P _ H O M E     P A T H                     #
################################################################################

EXE_DIR=`pwd`
SCRIPT_HOME=`dirname "$0"`
cd "$SCRIPT_HOME"
APP_BIN=`pwd`
APP_HOME=`dirname "$APP_BIN"`

SYSTEM_OS=`uname`
SYSTEM_ARCH=`uname -m`
DEP_LIB_PATH=

OS_NAME=
case "${SYSTEM_OS}" in
  Linux* )
    OS_NAME="Lin"
    ;;
  *BSD* )
    OS_NAME="Fbd"
    ;;
  SunOS )
    OS_NAME="Sos"
    SYSTEM_ARCH=`isainfo -b`
    ;;
  * )
    echo "OS \"${SYSTEM_OS}\" is not supported. Exit now."
    exit 1
    ;;
esac

OS_ARCH=
if [ -z "${DEP_LIB_PATH}" ]; then
    case "${SYSTEM_ARCH}" in
        i[3-6]86 | 32)
            OS_ARCH="X86"
        ;;
        x86_64 | amd64 | 64)
            OS_ARCH="X64"
        ;;
        armv6*)
            OS_ARCH="Av6"
        ;;
        armv7*)
            OS_ARCH="Av7"
        ;;
        armv5*)
            OS_ARCH="Arm"
        ;;
        aarch64*)
            OS_ARCH="A64"
        ;;
        * )
            echo "Arch \"${SYSTEM_ARCH}\" is not supported. Exit now."
            exit 1
        ;;
    esac
    DEP_LIB_PATH=${OS_NAME}${OS_ARCH}
fi

################################################################################
#          R E T R I E V E     J A V A _ H O M E     P A T H                   #
################################################################################

# Note that the $JAVA_HOME variable is needed to be modified for other NIX OS.
# The value "${APP_HOME}/jre32" is applied on Linux only.

JAVA_HOME="${APP_HOME}/jvm"
JAVA_EXE="${JAVA_HOME}/bin/java"

################################################################################
#      V E R I V I C A T I O N   T O   R U N    T H E    S C R I P T           #
################################################################################

# Verify if the Java Home existence.
if [ ! -x "${JAVA_HOME}" ];
then
    echo "\"${JAVA_HOME}\" does not exist!"
    exit 1
fi

# Verify the JAVA_EXE whether it can be executed or not.
if [ ! -x "${JAVA_EXE}" ]
then
    echo "The Java Executable file \"${JAVA_EXE}\" cannot be executed. Exit \""`basename "$0"`"\" now."
    exit 1
fi

# Verify the JAVA_EXE whether it is a valid JAVA Executable or not.
STRING_JAVA_VERSION="java version,openjdk version"
OUTPUT_JAVA_VERSION=`"${JAVA_EXE}" -version 2>&1`
OUTPUT_JVM_SUPPORT=0
BACKUP_IFS=$IFS
IFS=","
for word in $STRING_JAVA_VERSION; do
    if [ `echo "${OUTPUT_JAVA_VERSION}" | grep "${word}" | grep -cv "grep ${word}"` -le 0 ]
    then
      #echo "The Java Executable \"${JAVA_EXE}\" is not a valid Java Executable. Exit \""`basename "$0"`"\" now."
      continue;
    else
      OUTPUT_JVM_SUPPORT=1
      break;
    fi
done
IFS=$BACKUP_IFS
if [ $OUTPUT_JVM_SUPPORT -eq 0 ]
then
    echo "The Java Executable \"${JAVA_EXE}\" is not a valid Java Executable. Exit \""`basename "$0"`"\" now."
    exit 1
fi

################################################################################
#            E X E C U T I O N     J A V A     P R O P E R T I E S             #
################################################################################

# Set LD_LIBRARY_PATH for Lotus Notes on Linux
if [ "Linux" = "${SYSTEM_OS}" ];
then
    NOTES_PROGRAM=`cat "$APP_HOME/bin/notesenv"`
    LD_LIBRARY_PATH="$APP_HOME/bin:$NOTES_PROGRAM:$LD_LIBRARY_PATH"
    export NOTES_PROGRAM
else
    LD_LIBRARY_PATH="$APP_HOME/bin:$LD_LIBRARY_PATH"
fi

export LD_LIBRARY_PATH

################################################################################
#                         J A V A     E X E C U T I O N                        #
################################################################################

# Change to APP_BIN for JAVA execution
cd "${APP_BIN}"

# Reference path will be used to avoid empty space in the parent directory
LIB_HOME=.
JAVA_OPTS="-Xrs -Xms128m -Xmx2048m -XX:MaxDirectMemorySize=512m -client -Dsun.nio.PageAlignDirectMemory=true"
JNI_PATH="-Djava.library.path=$LIB_HOME:$LIB_HOME/${DEP_LIB_PATH}"
CLASSPATH="$LIB_HOME:$LIB_HOME/cb.jar"
LD_LIBRARY_PATH=$1
JAVA_SYSTEM_PROPERTIES=$2
MAIN_CLASS=$3

# Do not include double-quote for java options, jni path, classpath and
# main class.
# Only apply double-quote for path to java executable and execution arguments
"${JAVA_EXE}" $JAVA_OPTS $JNI_PATH $JAVA_SYSTEM_PROPERTIES -cp $CLASSPATH $MAIN_CLASS "${APP_HOME}" "$4" "$5" "$6" "$7" "$8"

################################################################################
#                   R E S E T          A N D          E X I T                  #
################################################################################

cd "${EXE_DIR}"
exit 0
