<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent">
  
<h1 class="colorSystemPanel">Restore Drill Status</h1>
<P>All restore drill jobs that are currently running or pending.  Once a restore drill job is completed the entry will be immediately removed from the Live Activities.</P>
<BR><BR>

<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Login Name (Alias)</td>
        <td>The alias name of the backup account.  
        </td>
      </tr>
      <tr>
        <td width="20%">Owner</td>
        <td>Ownership of the backup account.
        </td>
      </tr>
	  <tr>
        <td width="20%">Backup Set</td>
        <td>Name of the backup set. 
        </td>
      </tr>
	  <tr>
        <td width="20%">Destination</td>
        <td>Storage destination of the backup set. 
        </td>
      </tr>
      <tr>
        <td width="20%">Mode</td>
        <td>The restore drill mode, there are five modes: Running, Pending, Pending for encrypt key, Paused, Completed. 
        </td>
      </tr>
      <tr>
        <td width="20%">Status</td>
        <td>The progress of the restore drill shown in percentage.  
        </td>
      </tr>
      <tr>
        <td width="20%">Current File</td>
        <td>The current restore file. 
        </td>
      </tr>
      <tr>
        <td width="20%">Start Time</td>
        <td>The time the restore drill started. 
        </td>
      </tr>
      <tr>
        <td width="20%">Action</td>
        <td>The status of the restore drill job, there are seven (7) status: Start, Paused, Stop, Move to First, Move to Last, Resume and Restart. 
        </td>
      </tr>
</table>
<BR><BR>

<P>By default all restore drill jobs that are currently running will be displayed.  It will be displayed alphabetically according to the backup users login name.  There are five (5) filters that can be used to narrow down the results:</P>
<UL>
<LI><b>Client Type</b> - restore drill jobs can be filtered based on type either <%=HelpManager.getObmShortName(request)%> or <%=HelpManager.getAcbShortName(request)%> client.  </LI>
<LI><b>User</b> - restore drill jobs can also be filtered based on the first letter of the backup users login name.  It can also be based on subscription type which is Paid or Trial.  It can also be based on status which is Suspended or Locked.  Additional criteria are Others (login name does not start with a letter, instead it starts with a number, @, ., - or _) and Inactive (backup user's last login, backup start time or register date is more than one day).  </LI>
<LI><b>User Group</b> - restore drill jobs can be filtered based on the user group the backup user belongs to.  </LI>
<LI><b>Mode</b> - restore drill jobs can be filtered based on the mode of the restore drill. The choices are Running, Pending, Pending for encrypt key, Paused, Completed. </LI>
<LI><b>Status</b> - restore drill jobs can be filtered based on the status of the job. The choices are >25%, >50% and >75%. </LI>
</UL>

<BR>
<P>Here are several examples on how the filters can be combined to reduce the number of results: </P>

<UL>
<LI>To display restore drill jobs of <%=HelpManager.getObmShortName(request)%> paid user accounts, configure the following filters: <BR>
  Client Type: <%=HelpManager.getObmShortName(request)%> <BR>
  User: Paid </LI>
<LI>To display restore drill jobs of <%=HelpManager.getObmShortName(request)%> trial user accounts, configure the following filters: <BR>
  Client Type: <%=HelpManager.getObmShortName(request)%> <BR>
  User: Trial   <BR>
<LI>To display restore drill jobs of <%=HelpManager.getAcbShortName(request)%> paid user accounts with completed job, configure the following filters: <BR>
  Client Type: <%=HelpManager.getAcbShortName(request)%> <BR>
  User: Paid   <BR>
  Mode: Completed </LI>
<LI>To display restore drill jobs status of <%=HelpManager.getAcbShortName(request)%> paid user accounts that are currently running with >50% status, configure the following filters: <BR>
  Client Type: <%=HelpManager.getAcbShortName(request)%> <BR>
  User: Paid   <BR>
  Mode: Running <BR>
  Status: >50%	</LI>  
</UL>

<BR><BR>
<BR><BR>


</div>
<jsp:include page="footer.jsp" />
</body>

</html>
