<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent"> 
<h1 class="colorUtilities">How to setup storage quota for OpenStack tenant (project) and user?</h1> 

<H3>Introduction:</H3>
<P>This chapter will show you how to setup the storage quota in the OpenStack for your backup users. </P>
<P>If you are new to OpenStack, you should check with their documentation on general setup available at <a href="http://docs.openstack.org/">http://docs.openstack.org/</a></P>
<P>If you already have a running OpenStack, you can follow our steps to setup the storage quota. </P>
<BR><BR>

<H3>Assumptions:</H3>
<P>Here are the OpenStack version used in the following examples:</P>
<UL>
   <LI>OpenStack Havana Series, Release 2013.2.3 </LI>
   <LI>Swift version: 2.0.2</LI>
   <LI>Keystone version: 0.7.1</LI>
</UL>
<BR>
<P>Here are the values used in the following examples:</P>
<UL>
   <LI>OpenStack admin user name: admin </LI>
   <LI>OpenStack admin user password: admin</LI>
   <LI>Tenant (project) name: mybackup</LI>
   <LI>Keystone server IP: 10.7.54.7 </LI>
   <LI>Keystone user authentication URL: http://10.7.54.7:5000/v2.0 </LI>
   <LI>Keystone admin URL: http://10.7.54.7:35357/v2.0 </LI>
   <LI>Keystone admin token: 7b05dab9722d44e7b9a82dc0d1ff74ea </LI>
</UL>
<BR>
<P>Note: The value of the Keystone admin token can be found in the variable name "admin_token" defined inside the keystone configuration file at /etc/keystone/keystone.conf .</P>
<BR><BR>

<H3>Requirements and preparations:</H3>
<P>Please setup the following variables in bash profile and filters in the proxy-server.conf before you setup a tenant (project), user, roles and storage quota etc.</P>
<B>Step 1: Add the environment variable in the .bash_profile </B>
<br><br>
<I>Example</I> (/root/.bash_profile)<BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">    :
    :
  Trimmed
    :
    :
export OS_USERNAME=admin
export OS_PASSWORD=admin
export OS_TENANT_NAME=mybackup
export OS_AUTH_URL=http://10.7.54.7:5000/v2.0
export OS_SERVICE_ENDPOINT=http://10.7.54.7:35357/v2.0
export OS_SERVICE_TOKEN=7b05dab9722d44e7b9a82dc0d1ff74ea
    :
    :
  Trimmed
    :
    :</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR>
<P>Please login again for profile to take effect. </P>
<P>Note: The value of the OS_SERVICE_TOKEN can be found in the variable name "admin_token" defined inside the keystone configuration file at /etc/keystone/keystone.conf . </P>
<BR><BR>

<B>Step 2: Enable quota restriction in swift-proxy (/etc/swift/proxy-server.conf)</B>
<P>Edit the file proxy-server.conf , add the contents that are highlighted in <font color=red>red</font> in the below example.</P>
<I>Example</I> (/etc/swift/proxy-server.conf)<BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">    :
    :
    :
  Trimmed
    :
    :
    :

[pipeline:main]
pipeline = healthcheck cache authtoken keystone <font color="red">container-quotas account-quotas</font> proxy-server

    :
    :
    :
  Trimmed
    :
    :
    :

<font color="red">[filter:keystone]
use = egg:swift#keystoneauth
operator_roles = admin, SwiftOperator, ResellerAdmin
is_admin = true

[filter:container-quotas]
use = egg:swift#container_quotas

[filter:account-quotas]
use = egg:swift#account_quotas</font></font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>

<B>Step 3: Restart the proxy services</B>
<P>Restart the proxy service after you have modified the config file /etc/swift/proxy-server.conf . </P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# swift-init proxy restart
Signal proxy-server  pid: 13453  signal: 15
proxy-server (13453) appears to have stopped
Starting proxy-server...(/etc/swift/proxy-server.conf)
WARNING: SSL should only be enabled for testing purposes. Use external SSL termination for a production deployment.

[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>

<B>Step 4: Create ResellerAdmin role</B>
<P>Create a role called ResellerAdmin for user that can change the quota of an account. You need to create a role with keystone and add this to your admin user. </P>
<P>Usage: keystone role-create --name &lt;role-name&gt;</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone role-create --name ResellerAdmin 
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
+----------+----------------------------------+
| Property |              Value               |
+----------+----------------------------------+
|    id    | 464e592192554bdd8201b367997886f1 |
|   name   |          ResellerAdmin           |
+----------+----------------------------------+
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>Please verify the role setup by the following command:</P>
<P>Usage: keystone role-list</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone role-list
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
+----------------------------------+-----------------+
|                id                |       name      |
+----------------------------------+-----------------+
| 464e592192554bdd8201b367997886f1 |  ResellerAdmin  |
| e34c3a339a924180b07e2099842c727f |  SwiftOperator  |
| 9fe2ff9ee4384b1894a90878d3e92bab |     _member_    |
| 3e61686683c94fd9a24beab378dfef81 |      admin      |
+----------------------------------+-----------------+
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>If you want to remove the role:</P>
<P>Usage: keystone role-delete &lt;role&gt;</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone role-delete ResellerAdmin
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>

<B>Step 5: Assign the ResellerAdmin role to admin</B>
<P>Usage: keystone user-role-add --user &lt;user&gt; --role &lt;role&gt; --tenant &lt;tenant&gt; </P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone user-role-add --user admin --role ResellerAdmin --tenant mybackup
WARNING: Bypassing authentication using a token & endpoint (authentication credentials are being ignored).
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>Please verify the setup by the following command:</P>
<P>Usage: keystone user-role-list --user &lt;user&gt; --tenant &lt;tenant&gt; </P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone user-role-list --user admin --tenant mybackup
WARNING: Bypassing authentication using a token & endpoint (authentication credentials are being ignored).
+----------------------------------+-----------------+----------------------------------+----------------------------------+
|                id                |       name      |             user_id              |            tenant_id             |
+----------------------------------+-----------------+----------------------------------+----------------------------------+
| 464e592192554bdd8201b367997886f1 |  ResellerAdmin  | 70a0cf53001d4798b02aae61e935e5df | 49f2482ecff9431bae1d32fa2a004026 |
| 3e61686683c94fd9a24beab378dfef81 |      admin      | 70a0cf53001d4798b02aae61e935e5df | 49f2482ecff9431bae1d32fa2a004026 |
+----------------------------------+-----------------+----------------------------------+----------------------------------+
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>If you want to remove the assigned role:</P>
<P>Usage: keystone user-role-remove --user &lt;user&gt; --role &lt;role&gt; --tentant &lt;tentant&gt; </P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone user-role-remove --user admin --role ResellerAdmin --tenant mybackup
WARNING: Bypassing authentication using a token & endpoint (authentication credentials are being ignored).
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>

<B>Step 6: Setup a storage quota for this tenant (project):</B>
<P>In this example, we will apply 10GB for this tenant (project). All containers within this project will share this quota.</P>
<P>Usage: swift post -m quota-bytes:&lt;value&gt; </P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# swift post -m quota-bytes:10737418240
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>Please verify the storage quota setup by the following command:<P>
<P>Usage: swift stat <P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# swift stat
       Account: AUTH_49f2482ecff9431bae1d32fa2a004026
    Containers: 4
       Objects: 260
         Bytes: 694896
Meta Quota-Bytes: <B>10737418240</B>
   X-Timestamp: 1412574345.10669
  Content-Type: text/plain; charset=utf-8
 Accept-Ranges: bytes
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>If you want to remove a storage quota for this tenant (project):</P>
<P>Usage: swift post -m quota-bytes: </P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# swift post -m quota-bytes:
[root@os ~]# </font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>

<B>Step 7: Setup a storage quota for this container</B>
<P>To setup a storage quota for this user to use this container, eg: applying 2GB for user1</P>
<P>Usage: swift post &lt;container name&gt; -H "X-Container-Meta-Quota-Bytes: &lt;size in bytes&gt;"</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# swift post user1 -H "X-Container-Meta-Quota-Bytes: 2147483648"
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>Please verify the container quota setup:</P>
<P>Usage: swift stat &lt;container name&gt;</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# swift stat user1
       Account: AUTH_49f2482ecff9431bae1d32fa2a004026
     Container: user1
       Objects: 0
         Bytes: 0
      Read ACL: mybackup:user1
     Write ACL: mybackup:user1
       Sync To:
      Sync Key:
Meta Quota-Bytes: <B>2147483648</B>
 Accept-Ranges: bytes
   X-Timestamp: 1412578586.50844
  Content-Type: text/plain; charset=utf-8
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>If you want to remove a storage quota for a user:</P>
<P>Usage: swift post &lt;container name&gt; -H "X-Container-Meta-Quota-Bytes:" </P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# swift post user6 -H "X-Container-Meta-Quota-Bytes:"
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<BR><BR>
<BR><BR>



<BR><BR>


</div>
<jsp:include page="footer.jsp" />
</body>

</html>
 