<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent">
  
<h1 class="colorUserManagement">Others</h1>

<h2>Temporary Directory</h2>
<P>The temporary directory is used for various purposes, such as storage of temporary spooled file (for database specific backup type in <%=HelpManager.getObmShortName(request)%>), remote file list, local file list, temporary delta file and other files of temporary nature.</P>

<P>For database backup in <%=HelpManager.getObmShortName(request)%>, it is highly recommended that the temporary directory or volume used for these modules is not a system volume (e.g. not the same partition which the operating system is installed on) and it has at least storage space of 150% of the expected backup size.</P>

<h3>To configure the temporary directory location:</h3> 
<OL>
<LI>Enter the directory path for storing the temporary data, for example: Windows D:\temp, MacOS /Users/admin/tmp, Linux/FreeBSD /tmp </LI>
<LI>Option: Check the "Remove temporary files after backup" if necessary.</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>

<div id="tipsContainer">
	<div class="icon">!</div>
   <p>Administrators need to pay attention to the maximum file size limitation of different file system format, so that database file can be spooled to the temporary directory.</P>
</div>
<BR>

<BR>
<hr>

<h2>Follow Link <span style="font-size:14px; font-weight:normal;" >(For file backup set only)</span></h2> 
<P>Follow Link defines whether to follow a symbolic link during backup.</P>
<h3>To enable the follow link option:</h3> 
<OL>
<LI>Check the "Follow link of the backup files" checkbox.</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>



<BR>
<hr>

<h2>Volume Shadow Copy <span style="font-size:14px; font-weight:normal;" >(For file backup set on Windows platform only)</span></h2>
<P>Enabling the Volume Shadow Copy option will allow backup of local files that are exclusively opened during the backup process (e.g. Outlook PST file).</P>  
<TABLE cellspacing="0" cellpadding="4">
<TR>
<TD class="firstTitles">Volume Shadow Copy</TD><TD class="titles">Action</TD>
</TR>
<TR>
<TD>Enabled</TD>
<TD>Create a snapshot of the data to be backed up for exclusively opened file.
</TD>
</TR>
<TR>
<TD>Disabled</TD>
<TD>Do not create a snapshot of the data to be backed up for exclusively opened file.<BR><BR>
Error message will be shown for files that are opened during the backup process.
</TD>
</TR>
</TABLE>
<BR>

<h3>Requirements of the Volume Shadow Copy option:</h3> 
<UL>
<LI>The Volume Shadow Copy Add-on Module must be enabled in the User Profile of the backup user account. </LI>
<LI>Volume Shadow Copy can only be applied for local drive; exclusively opened file on network shared drive cannot be backed up even with the Volume Shadow Copy option enabled.</LI>
<LI>Volume Shadow Copy is only available on Windows platforms released after Windows 2000 (e.g. Windows XP/Vista/7/8/8.1/10, Windows 2003/2008/2008R2/ 2012/ 2012R2/2016/2019).</LI>
<LI>The user using the backup application must have administrative privileges to access the Volume Shadow Copy service on a computer.</LI>
<LI>At least one of the partitions on the machine must be in NTFS or ReFS format.</LI>
</UL>
<BR>
<P>For more technical information on Volume Shadow Copy, please refer to following page from Microsoft for details:</P> 
<P><A href="http://technet.microsoft.com/en-us/library/cc785914(WS.10).aspx">http://technet.microsoft.com/en-us/library/cc785914(WS.10).aspx</A>
</P>
<h3>To enable the volume shadow copy option:</h3> 
<OL>
<LI>Check the "Enable Windows' Volume Shadow Copy for open file backup" checkbox.</LI> 
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR>
<hr>

<h2>File Permission <span style="font-size:14px; font-weight:normal;" >(For file backup set only)</span></h2>
<P>Backup file permission defines whether to backup operating system file permission of the data selected as backup source.</P>

<h3>To enable the file permission backup option:</h3> 
<OL>
<LI>Check the "Backup files' permission" checkbox.</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR>
<hr>

<H2>Archived log deletion <span style="font-size:14px; font-weight:normal;" >(For Oracle backup only)</span></H2>
<P>This option remove the archived logs that are older than the defined number of days after the backup. </P>
<OL>
<LI>Slide the switch to right hand side for archived log deletion setup. </LI>
<LI>Select the number of days to "Delete archived logs"</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>

<BR>
<!--hr>
<h2>Granular Restore <span style="font-size:14px; font-weight:normal;" >(For VMware/ Hyper-V backup set only)</span></h2>
<P>Uses OpenDirect technology to make file-level restore possible, to support of the restore of individual files inside a guest virtual machine . This feature can only be enabled during backup set creation process. Once Granular Restore feature is enabled and the backup set is saved, it is NOT possible to disable it afterwards, or vice versa. A new backup set will have to be created again if you wish to do so.</P>
<BR>
<hr>

<h2>OpenDirect <span style="font-size:14px; font-weight:normal;" >(For file backup set on Windows platform only)</span></h2>
<P>Uses OpenDirect technology to make file-level restore possible, to support opening of backup data directly without restoration from compressed/images files.  This feature can only be enabled during backup set creation process. Once OpenDirect feature is enabled and the backup set is saved, it is NOT possible to disable it afterwards, or vice versa.  A new backup set will have to be created again if you wish to do so.</P>


<BR-->
<hr>

<h2>Compressions</h2>
<P>Compression type defines the compression method that the backup application will use during backup (for the corresponding backup set).  The compression type can be changed at any time (e.g. after backup set creation or even after a backup job) unless the compression type is fixed as in a pre-empted backup set.  If the compression type is changed, the new compression method will take effect on the next backup job run.</P>
<BR>
<P>There are 4 compression types available.  By default, newly created backup sets are configured to use "Fast with optimization for local".  Basically, there is a trade off between Compression Type and CPU usage.</P> 
<UL>
<LI>No Compression - file will not be compressed before backup.</LI>
<LI>Normal - compression is comparable to gzip Normal compression ratio.</LI>
<LI>Fast (Compressed file size larger than normal) - compression will be faster but with less compression and lower CPU usage compared to Normal.</LI>
<LI>Fast with optimization for local - uses Snappy compression library when backing up to local destination only, otherwise setting will default to gzip if backing up to other destinations. Has the lowest CPU usage, very high speed and reasonable compression but compressed file size may be larger than Fast. </LI>
</UL>
<br>


<div id="tipsContainer">
	<div class="icon">!</div>
   <p>For File, VMware ESXi/vCenter, and Hyper-V backup sets if OpenDirect, Granular Restore, or Run Direct is enabled, then the compression type is automatically set to "No Compression" in order to ensure optimal restore performance.</P>
</div>

<BR>
<hr>

<h2>Encryption</h2>
<P>The encryption section shows you the current encryption settings. </P>

<P>Encryption settings are set at a backup set's creation time, even if the password is changed afterwards, the encryption key remains the same and cannot be modified afterwards.</P>

<table cellspacing="0" cellpadding="4" >
      <tr>
        <td width="20%">Encryption Key</td>
        <td>The hashed key will not be shown.
        </td>
      </tr>
      <tr>
        <td>Algorithm</td>
        <td>One of the following 3 backup algorithms will be shown.
<UL>
   <LI>Twofish: Twofish algorithm</LI>
   <LI>DESede: Triple DES algorithm</LI>
   <LI>AES: Advanced Encryption Standard algorithm</LI>
</UL>
        </td>
      </tr>
      <tr>
        <td>Method</td>
        <td>One of the following backup method will be shown.
<UL>
   <LI>ECB: Electronic Cook Book mode</LI>
   <LI>CBC: Cipher Block Chaining mode</LI>
</UL>
        </td>
      </tr>
      <tr>
        <td>Key length</td>
        <td>One of the following key length will be shown.
<UL>
   <LI>128-bit</LI>
   <LI>256 bit</LI>
</UL>
        </td>
      </tr>
</table>   

<% if (HelpManager.isShowRecoverEncryptKey(request)) { %>
<h3>Recover Encryption Key</h3>
<div id="tipsContainer">
<div class="icon">!</div>
<p>Encryption key is recoverable only if the following three settings are <b>ENABLED</b>:<p>
<UL>
	<LI>The Upload Encryption Key feature under the <b>Backup/Restore > User, Groups & Policies > Policy Group > %Policy Group Name% > User Settings > Encryption Key</b> menu on the web console.</LI>
	<LI>The Encryption Recovery feature under the <b>Profile > Encryption Recovery</b> menu in your <%=HelpManager.getObmShortName(request)%> or <%=HelpManager.getAcbShortName(request)%>.</LI>
	<LI>The Upload Encryption Key feature under the <b>Users, Group & Policies > Backup User > %User Name % > User Profile</b> of the backup user requesting for key recovery.</LI>
</UL>	
<p>With these three features on, encryption keys will be uploaded to the backup server during the backup process, so as to make recovery possible.</P>
</div>
<BR>

<P><b>Getting Started:</b></P>
<P>First, you must have a valid login credentials to log on to the Ahsay Shopping Centre. And you also need to have valid maintenance to engage in this Professional Service.</P>
<BR>
<P><b>Step:</b>
<P>Click on the <b>Recover Encryption Key</b> button. You will be re-directed to the Shopping Centre for purchase of the Encryption Key Recovery Service. Follow the on-screen instructions there to finish the recovery request and payment.</P>

<P>Within 15 minutes after the payment has been processed successfully, the decrypted key will be emailed to the backup user directly if email is provided in his/her profile. Otherwise, it will be sent to either your Primary or Alternative Email registered under your account.</P>
<% } %>



<BR>
<hr>

<h2>Recycle Bin</h2>
<P>After a file is removed from the backup server based on Retention Policy or Data Integrity Check, user can define the number of days it will remain in the Recycle Bin. By default this is enabled and set to 7 days.</P>
<BR>
<OL>
<LI>Slide the switch to the right hand side for Recycle Bin setup. </LI>
<LI>Select the number of days to "Keep the deleted files for".</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>
<br>


<hr>

<h2>Restore Drill</h2>
<P>Once this feature is enabled, it checks the backup data for corrupted files. If any corrupted files are detected, depending on the settings, an email will be sent to the user to inform them so that they can perform another backup to replace the corrupted files. Restore Drill can be scheduled to run every 6, 12, or 24 months.</P>
<BR>
<OL>
<LI>Slide the switch to the right hand side for Restore Drill setup. </LI>
<LI>Select the interval in months to run the Restore Drill.</LI>
<LI>Click <img src="../images/save.png"> to save the settings.</LI>
</OL>
<br>


<hr>

<h2>File Viewer</h2>
<P>The File Viewer allows viewing of backup files of a particular backup set. To enable simply tick the "Enable viewing list of backed up files on backup server without encryption key" checkbox. </P>
 


<BR><BR>
<BR><BR>
<BR><BR>
<BR><BR>
<BR><BR>

</div>
<jsp:include page="footer.jsp" />
</body>

</html>
