<!DOCTYPE html>
<html>
<!-- Modified: 2022-05-27; Version 9.3 -->
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>


<body>
<div class="helpcontent">
  
<h1 class="colorUserManagement">Source Page of Backup Set</h1>
<P>You can modify the backup source of the Microsoft 365 Backup Set on this page. For  <%=HelpManager.getAcbShortName(request)%> user accounts only a single Microsoft 365 account will be displayed.</P>
<BR>

   
<p>Below are the supported backup source for Microsoft 365 Backup and Restore.</p>

<p><b>Mailbox Level:</b> Outlook, OneDrive, Personal Site, Public Folders and Site Collections</p>

<p><b>Folder Level for Outlook Mailbox:</b> Inbox, Drafts, Sent Items, Deleted Items, Archive, Calendar, Clutter, Contacts, Junk Email, Notes, RSS Feeds, Tasks and Trash </p>

<p><b>OneDrive Items:</b> Folders, Files and Access Permissions</p>

<p><b>Teams Items:</b> Group Mail, Group Site, Teams Channel and Teams Chat </p>

<p><b>SharePoint Items:</b> Announcements, Assets Libraries, Bright Banner, Calendar, Contacts, Custom Lists, Data Connection Libraries, Discussion Boards, Form Libraries, General Settings, Import Spreadsheets, Issue Tracking, Links, Permissions and Management, Picture and Libraries, Report Libraries, Site Page, Survey, Version History and Wiki / Page Libraries </p>

<p><b>Public Folders Level:</b> Folders and Files</p>
<BR>

<H3>To modify backup source of <%=HelpManager.getObmShortName(request)%> with <u>Entire organization</u> selected as the backup scope:</H3>
<OL>
    <LI>Select the user(s) that you want to backup, either:
        <UL>
            <LI>Backup all Users or</LI>
			<LI>Select Specific  
        <BR> If "Select Specific" is chosen, click on the [Select] button to select the users for backup. Once done click the <img src="../images/ok.png"> button. </LI>
		</UL>
		Optional: Tick the "Auto-exclude any Microsoft 365 unlicensed user during backup" checkbox to exclude unlicensed users from the backup. 
	</LI>
	<LI>Select the data type for backup, choices are: 
	    <UL>
		    <LI>Outlook </LI>
			<LI>OneDrive </LI>
			<LI>Personal Site </LI>
			<LI>Teams Chat </LI>
			<LI>Teams
                <BR>Select to:
					<UL>
                        <LI>Backup all teams groups or </LI>
					    <LI>Select Specific 
					    <BR>If "Select Specific" is chosen, click on the [Select] button to select the groups for backup. Once done click the <img src="../images/ok.png"> button. </LI>
					</UL>
				Optional: Tick the "Group Mail" checkbox to backup the Group Mail.
               <BR> Optional: Tick the "Group Site" checkbox to backup the Group Site.		
			   <BR> Optional: Tick the "Teams Channel" checkbox to backup the Teams Channel.
			</LI>
			<LI>SharePoint Sites 
			    <BR>Select to:
					<UL>
                        <LI>Backup all SharePoint sites or </LI>
					    <LI>Select Specific 
					    <BR>If "Select Specific" is chosen, click on the [Select] button to select the SharePoint sites for backup. Once done click the <img src="../images/ok.png"> button. </LI>
					</UL>
			</LI>
			<LI>Public Folders 
			    <BR>Select to:
					<UL>
                        <LI>Backup all public folders or </LI>
					    <LI>Select Specific 
					    <BR>If "Select Specific" is chosen, click on the [Select] button to select the public folders for backup. Once done click the <img src="../images/ok.png"> button. </LI>
					</UL>
			</LI>
		</UL>	
	</LI>
	<LI>Optional: Slide the switch to the right to enable the exclude filter and click the <img src="../images/add.png"> button to create a filter. </LI>
	<LI>Click the <img src="../images/save.png"> button to save the changes. </LI>
</OL>

<BR><BR>

<H3>To modify backup source of <%=HelpManager.getObmShortName(request)%> with <u>This Microsoft 365 user only</u> selected as the backup scope or <%=HelpManager.getAcbShortName(request)%>:</H3>
<OL>
    <LI>Select the items and folders that you want to backup:
        <UL>
            <LI>Outlook</LI>
			<LI>OneDrive</LI>
			<LI>Personal Site</LI>
			<LI>Public Folders</LI>
			<LI>Teams Chat</LI>
		</UL>
    </LI>	
    <LI>Optional: Slide the switch to the right to enable the exclude filter and click the <img src="../images/add.png"> button to create a filter. </LI>
	<LI>Click the <img src="../images/save.png"> button to save the changes. </LI>
</OL>	

<BR><BR>

<H3>To modify an existing filter:</H3>
<OL>
<LI>Click on the existing filter.</LI>
<LI>Configure the settings according to your requirement.</LI> 
<LI>Click on <img src="../images/ok.png"> to continue.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>

<H3>To delete an existing filter:</H3>
<OL>
<LI>Click on the check box at the front of the filter.</LI>
<LI>Click on <img src="../images/trash.png"> in the Filter (Exclude) section.</LI>
<LI>Click on [OK] to delete or [Cancel] to cancel the operation.</LI> 
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL>
<BR><BR>


<BR><BR>


</div>
<jsp:include page="footer.jsp" />
</body>

</html>

