<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent">
  
<h1 class="colorUserManagement">Add New Backup Set</h1>

<P>You can create a backup set here on the Backup Server. For details and requirement on the setup, please also refer to the help document in <%=HelpManager.getObmShortName(request)%>.</P>

<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Name</td>
        <td>This is the name of the backup set. You can create a meaningful name for it. 
        </td>
      </tr>
      <tr>
        <td width="20%">Backup set type</td>
        <td>Select the correct backup set type from the drop down box, e.g. Cloud File Backup.
        </td>
      </tr>
      <tr>
        <td width="20%">Run On</td>
          <td>You can choose whether to run the backup job on the Client Backup Agent (Client) or the Backup Server (Server).
        </td>
      </tr>
	  <tr>
        <td width="20%">Platform</td>
        <td>Select the correct operating system from the drop down box.  There are three (3) choices which are Windows, Mac or Linux.  Default is Windows.  
        </td>
	  </tr>	
      <tr>
        <td width="20%">Backup From</td>
        <td>This allows you to select the cloud storage destination from which backup is run.
        </td>
      </tr>
      <tr>
        <td width="20%">Host</td>
        <td>This is the host of the cloud storage service provider. 
        </td>
      </tr>
      <tr>
        <td width="20%">Port</td>
        <td>This is the listening port of the cloud storage service provider. 
        </td>
      </tr>
      <tr>
        <td width="20%">Access Key ID / Access Key / Storage Account Name / Username</td>
        <td>This is the ID or username of your selected cloud storage backup source.
        </td>
      </tr>
      <tr>
        <td width="20%">Secret Access Key / Secret / Access Key / Password</td>
        <td>This is the access key or password to log in to the selected cloud storage backup source.
        </td>
      </tr>
	  <tr>
        <td width="20%">Authorization code</td>
        <td>Enter the authorization code generated by your cloud storage service provider.
        </td>
      </tr>
	  <tr>
        <td width="20%">Backup Scope</td>
        <td>Determines the scope of backup sources that are available for backup. <br></br> <b>Entire team</b> allows the backup of all folders / categories (e.g. Shared Folders, Team Folders, Team Members)<br><br><b>This Dropbox user only</b> allows the backup of only "Team Folders" and "Team Members" folders / categories.
        </td>
      </tr>
      <tr>
        <td width="20%">Connect with SSL</td>
        <td>Enable this option to connect with SSL.
        </td>
      </tr>
      <tr>
        <td width="20%">Access the Internet through Proxy</td>
        <td>Enable this option if you need to access the Internet through Proxy.
        </td>
      </tr>
	<tr>
        <td width="20%">Test</td>
        <td>The <b>Test</b> button is used to verify if the login information is correct. 
        </td>
      </tr>
      <tr>
        <td width="20%">Sign up for (Cloud Storage Service Provider)</td>
        <td>This link is used to sign up for an account with the cloud storage service provider you have selected.
        </td>
      </tr>
     
</table>
<BR><BR>

<H3>To create a backup set:</H3>
<OL>
<LI>Enter a meaningful backup set name.</LI>
<LI>Select <B>Cloud File Backup</B> in the <B>Backup set type</B> drop down list.</LI>
<LI>Select where the backup set will be run. If you select <B>Server</B>, the backup set will be run on <%=HelpManager.getCbsShortName(request)%> server. If you select <B>Client</B>, the backup set will be run on the Client Backup Agent which means you cannot trigger the backup from the <%=HelpManager.getCbsShortName(request)%> server.</LI>
<LI>In the <b>Platform</b> dropdown list, select the operating system, e.g. Windows. </LI>
<LI>In the <b>Backup From</b> dropdown list, select the backup destination, e.g. Amazon S3. </LI>
<LI>If you don't have an account with the cloud storage service provider you have selected, click the <b>Sign up for (Cloud Storage Service Provider)</b> link at the bottom to create one.</LI>
<LI>Enter the <b>Access Key ID / Access Key / Storage Account Name / Username</b> of your selected cloud storage backup source.</LI>
<LI>Enter the <b>Secret Access Key / Secret / Access Key / Password</b> of your selected cloud storage backup source.</LI>
<LI>Enter the <b>Authorization code</b> generated by your cloud storage service provider if necessary.</LI>
<LI>Click the Test button to verify that the authorization code is correct.</LI>
<LI>Click <img src="../images/next.png"> button to continue.</LI>
</OL> 

<div id="tipsContainer"><div class="icon">!</div>
<UL> 
<LI>Whether you choose to run the backup set on Client or Server, this setting cannot be altered after it is set. The only way to change this setting is to create a new backup set and back up the data all over again.</LI>
<LI>As a backup user, you will not be able to trigger a backup on the <%=HelpManager.getCbsShortName(request)%> server if the backup set is set as <b>Run on Client</b>. Only the system administrator has the permission to do so.</LI>
<LI>For backup sets created in <b>Run on Server</b> backup type, the backup destination is restricted to <%=HelpManager.getCbsShortName(request)%> by default and cannot be altered. If you wish to back up to other destinations, backup sets should be created in <b>Run on Client</b> backup type instead.</LI>
</UL>
</div>

<BR><BR>
<BR><BR>
<BR><BR>
<BR><BR>
<BR><BR>
<BR><BR>
<BR><BR>
<BR><BR>
    
</div>
<jsp:include page="footer.jsp" />
</body>

</html>
