<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent">
  
<h1 class="colorSystemPanel">SMTP Servers</h1>
<P>Manage the SMTP Servers to be used for sending emails below. If you don't have your own SMTP Server, free third party SMTP Server can be used, such as Google's SMTP Server.</P>

<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
	  <tr>
        <td width="20%">Mail Server</td>
        <td>This is the mail server type. There are two choices: Microsoft 365 or Customize. Microsoft 365 is selected by default.
        </td>
      </tr>
	  <tr>
        <td width="20%">Region</td>
        <td>Region that is registered in the Microsoft 365 account. This will only be displayed if 'Microsoft 365' is selected as the mail server.
        </td>
      </tr>
      <tr>
        <td width="20%">Host Name</td>
        <td>This is the host name of the SMTP server. This will only be displayed if 'Customize' is selected as the mail server.
        </td>
      </tr>
      <tr>
        <td width="20%">Port</td>
        <td>This is the connection port of the SMTP server. This will only be displayed if 'Customize' is selected as the mail server. 
        </td>
      </tr>
	  <tr>
        <td width="20%">Require SMTP Authentication </td>
        <td>Enable the SMTP authentication if login credentials are required to access the SMTP server. This will only be displayed if 'Customize' is selected as the mail server.
        </td>
      </tr>
      <tr>
        <td width="20%">Login Name</td>
        <td>The login name to the SMTP server.  Will only be enabled if 'Require SMTP Authentication' is checked. This will only be displayed if 'Customize' is selected as the mail server.
        </td>
      </tr>
	  <tr>
        <td width="20%">Password</td>
        <td>The login password to the SMTP server.  Will only be enabled if 'Require SMTP Authentication' is checked. This will only be displayed if 'Customize' is selected as the mail server.
        </td>
      </tr>
	  <tr>
        <td width="20%">Use secure protocol</td>
        <td>Enable secure protocol to login. This will only be displayed if 'Customize' is selected as the mail server.
        </td>
      </tr>
	  <tr>
        <td width="20%">Protocol</td>
        <td>Protocol used to login.  Will only be enabled if 'Use secure protocol' is checked. This will only be displayed if 'Customize' is selected as the mail server.
        </td>
      </tr>
	  <tr>
        <td width="20%">Name</td>
        <td>Name of the sender.  
        </td>
      </tr>
	  <tr>
        <td width="20%">Email</td>
        <td>The email address of the sender.  
        </td>
      </tr>
	  <tr>
        <td width="20%">Sign all outgoing emails digitally</td>
        <td>Sign the email with the digital certificate. 
        </td>
      </tr>
	  
</table>
<BR>

<h3>To add a new SMTP server:</h3>
<OL>
<LI>Select the mail server that will be used.</LI>
<LI>Fields that will be displayed will depend on the mail server selected.
    <UL>
	    <LI>If Microsoft 365 is selected, select the Region.</LI>
		<LI>If Customize is selected, enter the host name and port. <br>
		    Option: Check 'Require SMTP Authentication' if necessary. Enter the login name and password. <br>
            Option: Check 'Use secure protocol' if necessary.  Select the protocol.	 </LI>
    </UL>
<LI>Enter the name of the report sender. </LI>
<LI>Enter the email address of the report sender. </LI>
<LI>Option: Check 'Sign all outgoing emails digitally' to add a digital certificate.</LI> 
<LI>Click on the [Test] button.</LI>
<LI>The following will only be displayed if the mail server selected is 'Microsoft 365' otherwise skip to the next step. 
    <UL>
    <LI>Click [Authorize] to continue. </LI>
	<LI>Sign in to your account. </LI>
	<LI>Accept the permission request for Microsoft 365. </LI>
	<LI>Copy the authorization code. </LI>
    <LI>Paste it in <%=HelpManager.getCbsShortName(request)%> then click [OK]. </LI>
	</UL>
</LI>
<LI>Click [OK] to continue. </LI>
<LI>Click <img src="../images/ok.png"> to continue.</LI>
<LI>Click on <img src="../images/save.png"> to save the settings.</LI>
</OL> 
<BR>



<P>
<div id="tipsContainer"><div class="icon">!</div>
<UL>
<LI><%=HelpManager.getCbsShortName(request)%> supports SMTP servers which use either TLS v1.0, v1.1 or v1.2. </LI> 

<LI>When using Gmail account (@gmail.com or a custom domain with Gmail as the mail server), using the 'Customize' option, you need to configure it using App Password. For more information regarding App Password, please refer to this article <a href="https://support.google.com/accounts/answer/185833">Sign in with App Passwords</a> <br>
While for Microsoft 365, you can either use the 'Microsoft 365' option (new OAuth method) or 'Customize' option (the legacy method).
</LI>
</UL> </div>
</P>
<BR><BR>
<BR><BR>

<BR><BR>
<BR><BR>

</div>
<jsp:include page="footer.jsp" />
</body>

</html>
