<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent">  
<h1 class="colorUtilities">How to setup the Rackspace storage quota for backup users?</h1> 

<H3>Introduction:</H3>
<P>This chapter will show you how to setup the container quota in the Rackspace for your backup users to backup on Rackspace storage container. </P>
<P>If you are new to Rackspace, you should check with their documentation on general setup available at <a href="http://support.rackspace.com/">http://support.rackspace.com/</a></P>
<P>If you have tried Rackspace before, you can follow our steps to setup the storage for your backup users. Our steps will guide you to complete the followings:</P>
<UL>
   <LI>collect the access token</LI>
   <LI>use the access token to set the quota in the container of a tenant</LI>
</UL>
<P>After you have completed these steps, the container quota can be set. </P> 
<BR><BR>


<H3>Assumption:</H3>
<P>Before setting up storage quota in the steps below, we assumed that the storage has already created on your Rackspace by the backup client. The name of the container is named in the following syntax eg:"mybackup-&lt;username&gt;". </P>
<BR><BR>


<H3>Setup:</H3>
<B>Step 1: Login to your Rackspace Cloud Control Panel.</B>
<P>Collect your users' API key from the "User Management" &gt; "Username" (Click on the user name that you need to get the API key.) &gt; "Login Details" &gt; "API Key"</P>
<img src="/cbs/images/Rackspace/005.png">
<P>Click on "Show" to display the masked key.</P>
<img src="/cbs/images/Rackspace/006.png">
<BR><BR>
<BR><BR>

<B>Step 2: Obtain the access token. </B>
<P>Connect to a Linux machine with the curl package. To obtain the access token, you need to use the curl command to post the request to the Rackspace server.</P>
<P>Usage: curl -v -k -s https://identity.api.rackspacecloud.com/v2.0/tokens -X "POST" -d "{\"auth\":{\"RAX-KSKEY:apiKeyCredentials\":{\"username\":\"<b>&lt;user name&gt;</b>\", \"apiKey\":\"<b>&lt;API Key&gt;</b>\"}}}" -H "Content-Type: application/json"</P>
<P>Note: The API key can be collected from previous step.</P>
<BR>
<I>Example</I><BR>
<pre>----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# curl -v -k -s https://identity.api.rackspacecloud.com/v2.0/tokens -
X "POST" -d "{\"auth\":{\"RAX-KSKEY:apiKeyCredentials\":{\"username\":\"DavidCha
n\", \"apiKey\":\"778b2d84b63334e36a2d841339663446\"}}}" -H "Content-Type: appli
cation/json"
* About to connect() to identity.api.rackspacecloud.com port 443 (#0)
*   Trying 72.3.138.129... connected
* Connected to identity.api.rackspacecloud.com (72.3.138.129) port 443 (#0)
    :
    :
    :
  Trimmed
    :
    :
    :
{"access":{"token":{"id":"<b>e85127fa63824a9f85ba437d1061b5c0</b>","expires":"2014-11-1
8T07:26:16.071Z","tenant":{"id":"926819","name":"926819"},"RAX-AUTH:authenticate
dBy":["APIKEY"]},"<b>serviceCatalog</b>":[{"name":"cloudFilesCDN","endpoints":{"region"
:"HKG","tenantId":"MossoCloudFS_926819","publicURL":"https:\/\/cdn6.clouddrive.c
om\/v1\/MossoCloudFS_926819"},{"region":"SYD","tenantId":"MossoCloudFS_926819","
publicURL":"https:\/\/cdn4.clouddrive.com\/v1\/MossoCloudFS_926819"},{"region":"
DFW","tenantId":"MossoCloudFS_926819","publicURL":"https:\/\/cdn1.clouddrive.com
\/v1\/MossoCloudFS_926819"},{"region":"IAD","tenantId":"MossoCloudFS_926819","pu
blicURL":"https:\/\/cdn5.clouddrive.com\/v1\/MossoCloudFS_926819"},{"region":"OR
D","tenantId":"MossoCloudFS_926819","publicURL":"https:\/\/cdn2.clouddrive.com\/
v1\/MossoCloudFS_926819"}],"type":"rax:object-cdn"},{"<b>name</b>":"<b>cloudFiles</b>","endpoi
nts":[{"<b>region</b>":"<b>HKG</b>","tenantId":"MossoCloudFS_926819","<b>publicURL</b>":"<b>https:\/\/st
orage101.hkg1.clouddrive.com\/v1\/MossoCloudFS_926819</b>","internalURL":"https:\/\/
snet-storage101.hkg1.clouddrive.com\/v1\/MossoCloudFS_926819"},
    :
    :
    :
  Trimmed
    :
    :
    :
"<b>user</b>":{"id":"0c3001f01cb94856a87f8653ab875117","roles":[{"id":"10000256","descr
iption":"Object Store Admin Role for Account User","name":"object-store:admin"},
{"tenant* Connection #0 to host identity.api.rackspacecloud.com left intact * Cl
osing connection #0 Id":"926819","id":"6","description":"A Role that allows a us
er access to keystone Service methods","name":"compute:default"},{"tenantId":"Mo
ssoCloudFS_926819","id":"5","description":"A Role that allows a user access to k
eystone Service methods","name":"object-store:default"},{"id":"2","description":
"Default Role.","name":"identity:default"}],"name":"DavidChan","<b>RAX-AUTH:default
Region</b>":"<b>HKG</b>"}}}[root@os ~]#
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR>
<P>The above highlighted value is required to collect before you can submit another curl command to set the quota. As the returned string is long with scattered information, you can also use third party parser eg: JSON viewer to interpret the above string.</P>

<P>Note:<BR>
The above example is trimmed to fit into this document.<BR>
If you are using the JSON viewer, you need to copy the following string<BR>

<pre><font style="color:#0000D0; font-size:12px;">{"access":{"token  ......Trimmed...... defaultRegion":"HKG"}}}</font></pre>

, and show it in the JSON viewer. </P>
<BR><BR>
<BR><BR>

<B>Step 3: Collect the information required before you set the quota.</B>
<P>To configure the quota, you need to extract the following 3 pieces of information from the string returned from the previous step.</P>
<UL>
    <LI>Token id</LI>
    <LI>RAX-AUTH:defaultRegion</LI>
    <LI>endpoints public URL</LI>
</UL>
<P>and collect the container name from the Rackspace Cloud Control Panel. </P>
<BR>
<P>3.1 token id</P>
<P>The token id can be collected in the token object.<br>
e.g. e85127fa63824a9f85ba437d1051b5c0</P>
<BR><BR>
<I>Example</I><BR>
<pre>----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">    :
    :
    :
{"access":{"<b>token":{"id":"e85127fa63824a9f85ba437d1061b5c0</b>","expires":"2014-11-1
8T07:26:16.071Z","tenant":{"id":"926819","name":"926819"},"RAX-AUTH:authenticate
dBy":["APIKEY"]}
    :
    :
    :</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR>
<P>From JSON Viewer:</P>
<img src="/cbs/images/Rackspace/J01.png">
<BR><BR>
<BR><BR>
<P>3.2 RAX-AUTH:defaultRegion</P>
<P>The default region can be collected in the user object.<br>
e.g. HKG</P>
<BR><BR>

<I>Example</I><BR>
<pre>----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">    :
    :
    :
"<b>user</b>":{"id":"0c3001f01cb94856a87f8653ab875117","roles":[{"id":"10000256","descr
iption":"Object Store Admin Role for Account User","name":"object-store:admin"},
{"tenant* Connection #0 to host identity.api.rackspacecloud.com left intact * Cl
osing connection #0 Id":"926819","id":"6","description":"A Role that allows a us
er access to keystone Service methods","name":"compute:default"},"tenantId":"Mos
soCloudFS_926819","id":"5","description":"A Role that allows a user access to ke
ystone Service methods","name":"object-store:default"},{"id":"2","description":"
Default Role.","name":"identity:default"}],"name":"DavidChan","<b>RAX-AUTH:defaultR
egion":"HKG</b>"}}
    :
    :
    :</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR>
<P>From JSON Viewer:</P>
<img src="/cbs/images/Rackspace/J02.png">
<BR><BR>
<BR><BR>
<P>3.3 endpoints public URL</P>
<P>You need to find the endpoints public URL from serviceCatalog object, with the sub-object name called "cloudFiles", search inside the endpoint with your default region (e.g. HKG), then you can find the public URL path.<br>
e.g. https://storage101.hkg1.clouddrive.com/v1/MossoCloudFS_926819</P>
<BR><BR>
<I>Example</I><BR>
<pre>----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">    :
    :
    :
"<b>serviceCatalog</b>":[{"name":"cloudFilesCDN","endpoints":[{"region":"HKG","tenantId
":"MossoCloudFS_926819","publicURL":"https:\/\/cdn6.clouddrive.com\/v1\/MossoClo
udFS_926819"},{"region":"SYD","tenantId":"MossoCloudFS_926819","publicURL":"http
s:\/\/cdn4.clouddrive.com\/v1\/MossoCloudFS_926819"},{"region":"DFW","tenantId":
"MossoCloudFS_926819","publicURL":"https:\/\/cdn1.clouddrive.com\/v1\/MossoCloud
FS_926819"},{"region":"IAD","tenantId":"MossoCloudFS_926819","publicURL":"https:
\/\/cdn5.clouddrive.com\/v1\/MossoCloudFS_926819"},{"region":"ORD","tenantId":"M
ossoCloudFS_926819","publicURL":"https:\/\/cdn2.clouddrive.com\/v1\/MossoCloudFS
_926819"}],"type":"rax:object-cdn"},{"<b>name":"cloudFiles</b>","endpoints":[{"region":
"HKG","tenantId":"MossoCloudFS_926819","<b>publicURL":"https:\/\/storage101.hkg1.cl
ouddrive.com\/v1\/MossoCloudFS_926819</b>","internalURL":"https:\/\/snet-storage101.
hkg1.clouddrive.com\/v1\/MossoCloudFS_926819"},    
    :
    :
    :</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR>
<P>From JSON Viewer:</P>
<img src="/cbs/images/Rackspace/J03.png">
<BR><BR>
<BR><BR>
<P>3.4 Container name</P>
<P>After the backup set is created in the backup client, the container name can be found in the "Files" tag in the Rackspace Cloud Control Panel<br>
eg: mybackup-davidchan</P>
<img src="/cbs/images/Rackspace/012.png">
<BR><BR>
<BR><BR>

<B>Step 4: Set the container quota in tenant.</B>
<P>In this example, we will set the quota of the container to 2MB (2097152 bytes).</P>
<P>Usage: curl -v -k -X PUT -H "X-Container-Meta-Quota-Bytes: <b>&lt;quota&gt;</b>" -H "X-Auth-Token: <b>&lt;token id&gt;" &lt;endpoints public URL&gt;/&lt;container name&gt;</b></P>
<BR>
<P>Note:<BR>
The Rackspace container URL is the endpoints public URL and the container name that was created for your user, which is</P>
<P><b>https://storage101.hkg1.clouddrive.com/v1/MossoCloudFS_926819</b> and <b>mybackup-davidchan</b></P>
<P>You need to put a slash "<font color=red>/</font>" in between the 2 values.</P>
<P>Eg: <b>https://storage101.hkg1.clouddrive.com/v1/MossoCloudFS_926819</b><font color=red>/</font><b>mybackup-davidchan</b></P>
<BR><BR>
<I>Example</I><BR>
<pre>----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# curl -v -k -X PUT -H "X-Container-Meta-Quota-Bytes: 2097152" -H "X-
Auth-Token: e85127fa63824a9f85ba437d1061b5c0" https://storage101.hkg1.clouddrive
.com/v1/MossoCloudFS_926819/mybackup-davidchan
* About to connect() to storage101.hkg1.clouddrive.com port 443 (#0)
*   Trying 119.9.64.232... connected
* Connected to storage101.hkg1.clouddrive.com (119.9.64.232) port 443 (#0)
* Initializing NSS with certpath: sql:/etc/pki/nssdb
* warning: ignoring value of ssl.verifyhost
* skipping SSL peer certificate verification
* SSL connection using TLS_DHE_RSA_WITH_AES_256_CBC_SHA
* Server certificate:
*       subject: CN=storage101.hkg1.clouddrive.com,OU=Domain Validated,OU=Thawte
 SSL123 certificate,OU=Go to https://www.thawte.com/repository/index.html
*       start date: Aug 15 00:00:00 2013 GMT
*       expire date: Aug 15 23:59:59 2015 GMT
*       common name: storage101.hkg1.clouddrive.com
*       issuer: CN=Thawte DV SSL CA,OU=Domain Validated SSL,O="Thawte, Inc.",C=U
S
&gt; PUT /v1/MossoCloudFS_926819/mybackup-davidchan HTTP/1.1
&gt; User-Agent: curl/7.19.7 (x86_64-redhat-linux-gnu) libcurl/7.19.7 NSS/3.15.3 zl
ib/1.2.3 libidn/1.18 libssh2/1.4.2
&gt; Host: storage101.hkg1.clouddrive.com
&gt; Accept: */*
&gt; X-Container-Meta-Quota-Bytes: 2097152
&gt; X-Auth-Token: e85127fa63824a9f85ba437d1061b5c0
&gt;
&lt; HTTP/1.1 202 <b>Accepted</b>
&lt; Content-Length: 76
&lt; Content-Type: text/html; charset=UTF-8
&lt; X-Trans-Id: tx682827faeba84b3bba3ee-005469b15ahkg1
&lt; Date: Mon, 17 Nov 2014 08:27:06 GMT
&lt;
* Connection #0 to host storage101.hkg1.clouddrive.com left intact
* Closing connection #0
&lt;html&gt;&lt;h1&gt;<b>Accepted</b>&lt;/h1&gt;&lt;p&gt;The request is accepted for processing.&lt;/p&gt;&lt;/html&gt;[roo
t@os ~]#
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR>
<P>When you see the "Accepted" message returned, the 2MB quota is set successfully. </P>
<BR><BR>
<BR><BR>
<BR><BR>


</div>
<jsp:include page="footer.jsp" />
</body>

</html>
 