<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent">

<h1 class="colorUtilities">How to setup OpenStack storage for backup users?</h1> 

<H3>Introduction:</H3>
<P>This chapter will show you how to setup the storage in the OpenStack for your backup users to backup on OpenStack storage container. </P>
<P>If you are new to OpenStack, you should check with their documentation on general setup available at <a href="http://docs.openstack.org/">http://docs.openstack.org/</a></P>
<P>If you already have a running OpenStack, you can follow our steps to setup the storage for your backup users. Our steps will guide you to complete the followings:</P>
<UL>
   <LI>create a project</LI>
   <LI>create user account</LI>
   <LI>create container with name identical to user name</LI>
   <LI>grant access privilege</LI>
</UL>
<P>After you have completed these steps, the backup client will be able to use the containers automatically.</P> 
<BR><BR>

<H3>Assumptions:</H3>
<P>Here are the OpenStack version used in the following examples:</P>
<UL>
   <LI>OpenStack Havana Series, Release 2013.2.3 </LI>
   <LI>Swift version: 2.0.2</LI>
   <LI>Keystone version: 0.7.1</LI>
</UL>
<BR>
<P>Here are the values used in the following examples:</P>
<UL>
   <LI>OpenStack admin user name: admin </LI>
   <LI>OpenStack admin user password: admin</LI>
   <LI>Tenant (project) name: mybackup</LI>
   <LI>Keystone server IP: 10.7.54.7 </LI>
   <LI>Keystone user authentication URL: http://10.7.54.7:5000/v2.0 </LI>
   <LI>Keystone admin URL: http://10.7.54.7:35357/v2.0 </LI>
   <LI>Keystone admin token: 7b05dab9722d44e7b9a82dc0d1ff74ea </LI>
</UL>
<BR>
<P>Note: The value of the Keystone admin token can be found in the variable name "admin_token" defined inside the keystone configuration file at /etc/keystone/keystone.conf .</P>
<BR><BR>

<H3>Requirements and preparations:</H3>
<P>Please setup the following variables in bash profile before you setup a tenant (project), user, roles and storage quota etc. </P>
<P><B>Add the environment variable in the .bash_profile </B></P>

<I>Example</I> (/root/.bash_profile)<BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">    :
    :
  Trimmed
    :
    :
export OS_USERNAME=admin
export OS_PASSWORD=admin
export OS_TENANT_NAME=mybackup
export OS_AUTH_URL=http://10.7.54.7:5000/v2.0
export OS_SERVICE_ENDPOINT=http://10.7.54.7:35357/v2.0
export OS_SERVICE_TOKEN=7b05dab9722d44e7b9a82dc0d1ff74ea
    :
    :
  Trimmed
    :
    :</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR>
<P>Please login again for profile to take effect. </P>
<P>Note: The value of the OS_SERVICE_TOKEN can be found in the variable name "admin_token" defined inside the keystone configuration file at /etc/keystone/keystone.conf . </P>
<BR><BR>

<H3>Setup:</H3>
<B>Step 1: Create a tenant (project) for "mybackup"</B>
<P>Usage: keystone tenant-create --name &lt;tenant-name&gt; --description &lt;tenant-description&gt; </P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone tenant-create --name mybackup --description 'mybackup Project'
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
+-------------+----------------------------------+
|   Property  |              Value               |
+-------------+----------------------------------+
| description |        mybackup Project          |
|   enabled   |               True               |
|      id     | b769bfb2de75490088d8af7b7483e8f8 |
|     name    |             mybackup             |
+-------------+----------------------------------+
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>Please verify the tenant (project) setup by the following command:</P>
<P>Usage: keystone tenant-list</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone tenant-list
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
+----------------------------------+--------------------+---------+
|                id                |        name        | enabled |
+----------------------------------+--------------------+---------+
| 6fe9e9d101df4b69944f7d4c40d15116 |       admin        |   True  |
| 3880c8dbf75040e9b78a44b6becdcd78 |      alt_demo      |   True  |
| b769bfb2de75490088d8af7b7483e8f8 |      mybackup      |   True  |
| e43182f5ad57464e9d08052d872adf34 |        demo        |   True  |
| ca35c74d6ec54dfabb0a1f9946d43da6 |      services      |   True  |
+----------------------------------+--------------------+---------+
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>If you want to remove a tenant (project):</P>
<P>Usage: keystone tenant-delete &lt;tenant&gt; </P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone tenant-delete mybackup
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<P><font color=red>Warning: Any objects created under this tenant (project) will be removed; including users, roles, container storages. As there is no confirmation in the command line, please handle this command with care.</font></P>
<BR><BR>
<BR><BR>

<B>Step 2: Create a user role</B>
<P>Create a role called mybackup-role for all users who use the "mybackup" tenant. </P>
<P>Usage: keystone role-create --name &lt;role-name&gt;</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone role-create --name mybackup-role 
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
+----------+----------------------------------+
| Property |              Value               |
+----------+----------------------------------+
|    id    | 5973dc8f56b34c0ebc748c969b5ea20b |
|   name   |          mybackup-role           |
+----------+----------------------------------+
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>Please verify the role setup by the following command:</P>
<P>Usage: keystone role-list</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone role-list
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
+----------------------------------+-----------------+
|                id                |       name      |
+----------------------------------+-----------------+
| 464e592192554bdd8201b367997886f1 |  ResellerAdmin  |
| e34c3a339a924180b07e2099842c727f |  SwiftOperator  |
| 9fe2ff9ee4384b1894a90878d3e92bab |     _member_    |
| 3e61686683c94fd9a24beab378dfef81 |      admin      |
| 5973dc8f56b34c0ebc748c969b5ea20b |  mybackup-role  |
+----------------------------------+-----------------+
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>If you want to remove the role:</P>
<P>Usage: keystone role-delete &lt;role&gt;</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone role-delete mybackup-role
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<BR><BR>

<B>Step 3: Create a new user</B>
<P>Create a new user eg. user1, whose default tenant (project) is mybackup that was created in previous step. It is recommended to create a new user for each backup user.</P> 
<P>Usage: keystone user-create --name &lt;user-name&gt; --tenant &lt;tenant&gt; --pass &lt;user password&gt; --email &lt;user email&gt;</P> 
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone user-create --name user1 --tenant mybackup --pass abc123$% --email user1@abc.com
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
+----------+----------------------------------+
| Property |              Value               |
+----------+----------------------------------+
|  email   |          user1@abc.com           |
| enabled  |               True               |
|    id    | df2a64b224ec4d298c4d32661738194d |
|   name   |              user1               |
| tenantId | b769bfb2de75490088d8af7b7483e8f8 |
+----------+----------------------------------+
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>Please verify the user setup by the following command:</P>
<P>Usage: keystone user-list</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone user-list
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
+----------------------------------+------------+---------+------------------------+
|                id                |    name    | enabled |         email          |
+----------------------------------+------------+---------+------------------------+
| 70a0cf53001d4798b02aae61e935e5df |   admin    |   True  |     test@test.com      |
| 1b763f0cc253419597f7aae76041c39b |  alt_demo  |   True  |                        |
| 8d21745db067410ba44f11400adc8a50 | ceilometer |   True  |  ceilometer@localhost  |
| e370793a075148609116cc35ba01c216 |   cinder   |   True  |    cinder@localhost    |
| e7cc62d800f349fc92100521f184ccec |    demo    |   True  |                        |
| 30786a08d6004ab28556acae5ee20d56 |   glance   |   True  |    glance@localhost    |
| 578a16a390b14da3a9cf2f158535e353 |  neutron   |   True  |   neutron@localhost    |
| fd73f4613ed54710a82c6a90fbfb8ff8 |    nova    |   True  |     nova@localhost     |
| 516ea23e239d48cdba8708754e0115c1 |   swift    |   True  |    swift@localhost     |
| df2a64b224ec4d298c4d32661738194d |   user1    |   True  |     user1@abc.com      |
+----------------------------------+------------+---------+------------------------+
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>If you want to update the user's password:</P>
<P>Usage: keystone user-password-update --pass &lt;new password&gt; &lt;user&gt;</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone user-password-update --pass 123456 user1
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>If you want to update the user details:</P>
<P>Usage: keystone user-update --name &lt;new user-name&gt; --email &lt;new email&gt; --enabled &lt;true|false&gt; &lt;existing-user&gt;</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone user-update --name user2 --email user2@abc.com --enabled true user1
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
User has been updated.
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>If you want to remove a user:</P>
<P>Usage: keystone user-delete &lt;user&gt;</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone user-delete user1
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<BR><BR>

<B>Step 4: Create a user role for backup client and map a user to it</B>
<P>Map the user1 with the role created in previous step.</P>
<P>Usage: keystone user-role-add --user &lt;user&gt; --role &lt;role&gt; --tenant &lt;tenant&gt;</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone user-role-add --user user1 --role mybackup-role --tenant mybackup
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>Please verify the role setup on user1 by the following command:</P>
<P>Usage: keystone user-role-list --user &lt;user&gt; --tenant &lt;tenant&gt;</P> 
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone user-role-list --user user1 --tenant mybackup
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
+----------------------------------+-------------+----------------------------------+----------------------------------+
|                id                |     name    |             user_id              |            tenant_id             |
+----------------------------------+-------------+----------------------------------+----------------------------------+
| 9fe2ff9ee4384b1894a90878d3e92bab |   _member_  | df2a64b224ec4d298c4d32661738194d | b769bfb2de75490088d8af7b7483e8f8 |  
| 5973dc8f56b34c0ebc748c969b5ea20b |   mybackup  | df2a64b224ec4d298c4d32661738194d | b769bfb2de75490088d8af7b7483e8f8 |
+----------------------------------+-------------+----------------------------------+----------------------------------+
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>If you want to remove the assigned user role:</P>
<P>Usage: keystone user-role-remove --user &lt;user&gt; --role &lt;role&gt; --tenant &lt;tenant&gt; </P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone user-role-remove --user user1 --role mybackup-role --tenant mybackup
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<BR><BR>

<B>Step 5: Setup a container</B>
<P>Administrator is required to setup containers for different backup users to store their data. You are recommended to use the user name as the container name in the mybackup tenant (project), and grant read/write access of this container to this user. This is because, it simplifies the backup client destination setup for backup users.</P>
<P>Usage: swift post &lt;container name&gt; -r $OS_TENANT_NAME:&lt;user&gt; -w $OS_TENANT_NAME:&lt;user&gt;</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# swift post user1 -r $OS_TENANT_NAME:user1 -w $OS_TENANT_NAME:user1
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>Please verify the container setup by the following command:</P>
<P>Usage: swift stat &lt;user&gt; </P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# swift stat user1
       Account: AUTH_49f2482ecff9431bae1d32fa2a004026
     Container: user1
       Objects: 0
         Bytes: 0
      Read ACL: mybackup:user1
     Write ACL: mybackup:user1
       Sync To:
      Sync Key:
 Accept-Ranges: bytes
   X-Timestamp: 1412578586.50844
  Content-Type: text/plain; charset=utf-8
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P>If you want to remove a container:</P>
<P>Usage: swift delete &lt;container&gt; </P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# swift delete user1
1390527034510/files/2014-10-21-12-00-00/437b40c7/5e7e48e1/_$folder$
1390527034510/files/2014-10-20-12-00-00/_$folder$
    :
    :
    :
  Trimmed
    :
    :
    :</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<P><font color=red>Warning: Any files uploaded to this container will be removed. As there is no confirmation in the command line, please handle this command with care.</font></P> 
<BR><BR>
<BR><BR>


<h4>Related topics</h4>
<UL>
<LI><A HREF="Destination_OpenStack_How_To_Setup_Storage_Quota_For_Tenant_And_Users.jsp">How to setup storage quota for OpenStack tenant (project) and user?</A></LI>
<LI><A HREF="Destination_OpenStack_How_To_Setup_SSL_Connection.jsp">How to setup SSL connection for OpenStack?</A></LI>
<LI><A HREF="Destination_OpenStack_How_To_Setup_Different_Region.jsp">How to setup a different region?</A></LI>
</UL>
<BR><BR>
<BR><BR>
<BR><BR>


</div>
<jsp:include page="footer.jsp" />
</body>

</html>
 