<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent"> 
<h1 class="colorUtilities">How to setup SSL connection for OpenStack?</h1> 

<H3>Introduction:</H3>
<P>This chapter will show you how to enable the SSL in OpenStack for your backup users. </P>
<P>If you are new to OpenStack, you should check with their documentation on general setup available at <a href="http://docs.openstack.org/">http://docs.openstack.org/</a></P>
<P>If you already have a running OpenStack, you can follow our steps to enable SSL.</P>
<BR><BR>

<H3>Assumptions:</H3>
<P>Here are the OpenStack version used in the following examples:</P>
<UL>
   <LI>OpenStack Havana Series, Release 2013.2.3 </LI>
   <LI>Swift version: 2.0.2</LI>
   <LI>Keystone version: 0.7.1</LI>
</UL>
<BR>
<P>Here are the values used in the following examples:</P>
<UL>
   <LI>OpenStack admin user name: admin </LI>
   <LI>OpenStack admin user password: admin</LI>
   <LI>Tenant (project) name: mybackup</LI>
   <LI>Keystone server IP: 10.7.54.7 </LI>
   <LI>Keystone user authentication URL: https://10.7.54.7:5000/v2.0 </LI>
   <LI>Keystone admin URL: https://10.7.54.7:35357/v2.0  </LI>
   <LI>Keystone admin token: 7b05dab9722d44e7b9a82dc0d1ff74ea </LI>
</UL>
<BR>
<P>Note: The value of the Keystone admin token can be found in the variable name "admin_token" defined inside the keystone configuration file at /etc/keystone/keystone.conf . </P>
<BR><BR>

<H3>Requirements and preparations:</H3>
<P>Please setup the following variables in bash profile and filters in the proxy-server.conf before you setup a tenant (project), user, roles and storage quota etc.</P>
<P><B>Step 1: Add the environment variable in the .bash_profile </B></P>

<I>Example</I> (/root/.bash_profile)<BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">    :
    :
  Trimmed
    :
    :
export OS_USERNAME=admin
export OS_PASSWORD=admin
export OS_TENANT_NAME=mybackup
export OS_AUTH_URL=https://10.7.54.7:5000/v2.0
export OS_SERVICE_ENDPOINT=https://10.7.54.7:35357/v2.0
export OS_SERVICE_TOKEN=7b05dab9722d44e7b9a82dc0d1ff74ea
    :
    :
  Trimmed
    :
    :</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR>
<P>Please login again for profile to take effect. </P>
<P>Note: The value of the OS_SERVICE_TOKEN can be found in the variable name "admin_token" defined inside the keystone configuration file at /etc/keystone/keystone.conf . </P>
<BR><BR>

<B>Step 2: Setup SSL connection for keystone and swift</B>
<P>To setup the SSL certificates, edit the file /etc/keystone/keystone.conf </P>
<P>Assume you have valid certificate files in<BR>
/etc/keystone/ssl_cert.pem<BR>
/etc/keystone/ssl_key.pem<BR>
/etc/keystone/cacert.pem</P>
<P>which<BR>
ssl_cert.pem is the public key file,<BR>
ssl_key.pem is the private key file, and<BR>
cacert.pem is the CA root certificate file.</P>
<P>Since the format of the certificate issued by CA may be different, please always check with your CA with the correct instruction on chaining the certificates.</P>
<I>Example</I> (/etc/swift/proxy-server.conf)<BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">    :
    :
    :
  Trimmed
    :
    :
    :

[ssl]
enable = True
certfile = /etc/keystone/ssl_cert.pem
keyfile = /etc/keystone/ssl_key.pem
ca_certs = /etc/keystone/cacert.pem

    :
    :
    :
  Trimmed
    :
    :
    :</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>

<B>Step 3: Restart keystone service</B>
<BR><BR>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# service openstack-keystone restart
Stopping keystone:                                         [  OK  ]
Starting keystone:                                         [  OK  ]
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>

<B>Step 4: List existing service and mark down the id for the swift</B>
<P>It is required to use the '--insecure' switch if an untrusted SSL cert is used.</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone --insecure service-list
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
+----------------------------------+------------+--------------+--------------------------------+
|                id                |    name    |     type     |          description           |
+----------------------------------+------------+--------------+--------------------------------+
| 5f805cc7df2a43eb90db6fe11ed682f6 | ceilometer |   metering   |   Openstack Metering Service   |
| 3134116675a8420a88ef01cdcb0c8728 |   cinder   |    volume    |         Cinder Service         |
| b703b91737954d01a2d180f6c3d575ba | cinder_v2  |   volumev2   |       Cinder Service v2        |
| cc787cf0258e46d6a342e1502e7bf6be |   glance   |    image     |    Openstack Image Service     |
| b3af7d0a95d34aa7883629df7a7f7f56 |  keystone  |   identity   |   OpenStack Identity Service   |
| 10f1a022ada246138aba5834e3622a91 |  neutron   |   network    |   Neutron Networking Service   |
| 218b5356d65e4d8382297f72d65c8bbb |    nova    |   compute    |   Openstack Compute Service    |
| a809ad43f380400cb55ff2520bb27ab0 |  nova_ec2  |     ec2      |          EC2 Service           |
| <b>8b517bd82d4345c895384f9596a29880</b> |   swift    | object-store | Openstack Object-Store Service |
| 11882e74696547b0ba1e4d276074ae37 |  swift_s3  |      s3      |      Openstack S3 Service      |
+----------------------------------+------------+--------------+--------------------------------+
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<P>The swift id is shown in <b>bold</b>. </P>
<BR><BR>

<B>Step 5: List existing swift service endpoints</B>
<BR><BR>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone --insecure endpoint-list
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
+----------------------------------+-----------+---                     ---+----------------------------------+
|                id                |  region   |    ......Trimmed......    |            service_id            |
+----------------------------------+-----------+---                     ---+----------------------------------+
| 00a39b6e21a24562b470b61a1b82902d | RegionOne |  h                     )s | 218b5356d65e4d8382297f72d65c8bbb |
| 047f9c3dd19743e280a553d8a34a9202 | RegionOne |    ......Trimmed......    | 10f1a022ada246138aba5834e3622a91 |
| 2b89407a81574b2c8f0fdef9eefc507a | RegionOne |                           | 5f805cc7df2a43eb90db6fe11ed682f6 |
| 47b6d5974d744c21a04b6ca2781f57a0 | RegionOne |                        )s | b703b91737954d01a2d180f6c3d575ba |
| 485ba5a748fc4f1e865d08774fae8ff7 | RegionOne |                           | b3af7d0a95d34aa7883629df7a7f7f56 |
| 90bb1d878b7045f086e2ada7ce853308 | RegionOne | ht ......Trimmed...... )s | 3134116675a8420a88ef01cdcb0c8728 |
| 9ac0472cb48f49b3b44cb4e3365be01a | RegionOne |                           | 11882e74696547b0ba1e4d276074ae37 |
<b>| a1af6685d3e04e5fa7b71f6c244f1393 | RegionOne | ht                        | 8b517bd82d4345c895384f9596a29880 |</b>
| a9b9c9fbef6a44669788c1946a3c8e48 | RegionOne |                           | cc787cf0258e46d6a342e1502e7bf6be |
| c370061d0cc64386a470a5a0fb01e424 | RegionOne |    ......Trimmed...... n  | a809ad43f380400cb55ff2520bb27ab0 |
+----------------------------------+-----------+---                     ---+----------------------------------+ 
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<P>Lookup the endpoint for the swift service with the service_id=<b>8b517bd82d4345c895384f9596a29880</b></P>
<BR><BR>

<B>Step 6: Delete the insecure swift service endpoint</B>
<P>Delete the service endpoint with the id a1af6685d3e04e5fa7b71f6c244f1393 which can be found in the same row in the swift service.</P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone --insecure endpoint-delete a1af6685d3e04e5fa7b71f6c244f1393
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
Endpoint has been deleted. 
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>

<B>Step 7: Recreate the endpoint with https:// instead</B>
<BR><BR>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# keystone --insecure endpoint-create --region RegionOne --service-id=8b517bd82d4345c895384f9596a29880 
--publicurl 'https://10.7.54.7:8080/v1/AUTH_%(tenant_id)s' --adminurl 'https://10.7.54.7:8080/v1' --internalurl '
https://10.7.54.7:8080/v1/AUTH_%(tenant_id)s'
WARNING: Bypassing authentication using a token &amp; endpoint (authentication credentials are being ignored).
+-------------+----------------------------------------------+
|  Property   |                   Value                      |
+-------------+----------------------------------------------+
|  adminurl   |           https://10.7.54.7:8080/v1          |
|     id      |        fb937c038fd34724bd7415fff3ee7736      |
| internalurl | https://10.7.54.7:8080/v1/AUTH_%(tenant_id)s |
|  publicurl  | https://10.7.54.7:8080/v1/AUTH_%(tenant_id)s |
|   region    |                 RegionOne                    |
| service_id  |       8b517bd82d4345c895384f9596a29880       |
+-------------+----------------------------------------------+ 
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>

<B>Step 8: Setup the /etc/swift/proxy-server.conf for swift</B>
<P>Edit the file proxy-server.conf , add the contents that are highlighted in <font color=red>red</font> in the below example.<P>
<P>Assume you have valid certificate files in<BR>
/etc/swift/ssl_cert.pem<BR>
/etc/swift/ssl_key.pem</P>
<P>which<BR>
ssl_cert.pem is the public key file, and<BR>
ssl_key.pem is the private key file.</P>
<P>Since the format of the certificate issued by CA may be different, please always check with your CA with the correct instruction on chaining the certificates.</P>
<I>Example</I> (/etc/swift/proxy-server.conf)<BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;"># This file is managed by puppet.  Do not edit
#
<font color=red>[DEFAULT]
bind_port = 8080
bind_ip = 10.7.54.7</font>
    :
    :
    :
  Trimmed
    :
    :
    :
<font color=red>cert_file = /etc/swift/ssl_cert.pem
key_file = /etc/swift/ssl_key.pem</font>
    :
    :
    :
  Trimmed
    :
    :
    :

[filter:authtoken]
    :
    :
    :
  Trimmed
    :
    :
    :
auth_protocol = <font color=red>https
auth_uri = https://10.7.54.7:5000
insecure = true</font></font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>

<B>Step 9: Restart the swift related services</B>
<P>Restart the swift related service after you have modified the config file /etc/swift/proxy-server.conf . </P>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# swift-init main restart
Signal proxy-server  pid: 17166  signal: 15
Signal container-server  pid: 17167  signal: 15
Signal account-server  pid: 17168  signal: 15
Signal object-server  pid: 17169  signal: 15
object-server (17169) appears to have stopped
container-server (17167) appears to have stopped
account-server (17168) appears to have stopped
proxy-server (17166) appears to have stopped
Starting proxy-server...(/etc/swift/proxy-server.conf)
Starting container-server...(/etc/swift/container-server.conf)
Starting account-server...(/etc/swift/account-server.conf)
Starting object-server...(/etc/swift/object-server.conf)
WARNING: SSL should only be enabled for testing purposes. Use external SSL termination for a production deployment.

[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>

<B>Step 10: Test with the swift command</B>
<BR><BR>
<I>Example</I><BR>
<pre>
----------------------------------------------------------------------------------------------------
<font style="color:#0000D0; font-size:12px;">[root@os ~]# swift --insecure stat

       Account: AUTH_49f2482ecff9431bae1d32fa2a004026
    Containers: 8
       Objects: 480
         Bytes: 189030388 
Meta Quota-Bytes: 10737418240
   X-Timestamp: 1412574345.10669
  Content-Type: text/plain; charset=utf-8
 Accept-Ranges: bytes
[root@os ~]#</font>
----------------------------------------------------------------------------------------------------
</pre>
<BR><BR>
<BR><BR>
<BR><BR>



<BR><BR>


</div>
<jsp:include page="footer.jsp" />
</body>

</html>
 