<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent">
  
<h1 class="colorUserManagement">Add New Backup Set</h1>

<P>You can configure the backup set here in the Backup Server. Please refer to the following link for further details about ShadowProtect: <A href="https://oldsite.storagecraft.com/support/book/export/html/15269#node_15362">https://oldsite.storagecraft.com/support/book/export/html/15269#node_15362</A> </P>

<h2>Backup Requirements (on Client Backup Machine)</h2>
<P>Please ensure that the following requirements are met on client backup machine:</P>
<OL>
<LI>Supported StorageCraft ShadowProtect Version: ShadowProtect 5.2.7 Desktop/ Server. </LI>
<LI>Supported Operating System: Please refer to the Software Compatibility List (SCL) for supported OS. 
<div id="tipsContainer"><div class="icon">!</div>
<p>Please kindly note that <%=HelpManager.getObmShortName(request)%> will provide best effort support for the Windows 2003 and Windows XP. </p>
</div>
</LI>
<LI>Supported File System: FAT16, FAT16X, FAT32, FAT32X, NTFS. </LI>
<LI>Make sure that the latest version of <%=HelpManager.getObmShortName(request)%> and ShadowProtect are installed on the client backup machine to be backed up. </LI>
<LI>Make sure that the ShadowProtect System Backup feature has been enabled as an add-on module in your <%=HelpManager.getObmShortName(request)%> user account. </LI>
<LI>Make sure that your <%=HelpManager.getObmShortName(request)%> user account has sufficient storage quota assigned to accommodate the storage of ShadowProtect system backup set and retention policy. </LI>
<LI>The default Java heap size setting on <%=HelpManager.getObmShortName(request)%> is 2048MB. For ShadowProtect System backup it is highly recommended to increase the Java heap size setting to be at least 4096MB to improve backup and restore performance. The actual heap size is dependent on amount of free memory available on your client backup machine. </LI>
<LI>As the ShadowProtect image file will be spooled to a temporary directory before being uploaded to the backup destination, it is recommended that the temporary directory has disk space of at least 150% of the total in-use size of all volumes selected for backup because the default Delta ratio is 50%. The actual free disk space required depends on various factors including the size of the volume(s), number of backup destinations, backup frequency, in-file delta settings etc. </LI>
<LI>To ensure optimal backup/ restoration performance, it is recommended that the temporary directory is set to a local drive, but not the system drive to minimize any potential performance impact on Windows operating system. 
<div id="tipsContainer"><div class="icon">!</div>
<p>Please kindly note that the temporary directory cannot be set to a folder within a volume selected for backup. </p>
</div>
</LI>
<LI>Port Requirement: TCP port 139 and 445 must be open for ShadowProtect to access network shares. </LI>
<LI>Make sure the "ShadowProtect Service" is "Running". </LI>
</OL>


<h2>Limitation</h2>
<OL>
<LI>ShadowProtect does not support Windows Cluster Shared Volumes (CSV). </LI>
<LI>ShadowProtect does not support:
<UL>
<LI>exFAT or ReFS file systems</LI>
<LI>Windows Storage Spaces storage pools</LI>
<LI>Windows Server Cluster Shared Volumes</LI>
<LI>Using VirtualBoot with UEFI-based system volumes</LI>
</UL>
</LI>
</OL>

<h2>Best Practice and Recommendation</h2>
<OL>
<LI>Turn off disk defrag software when using incremental backup. When ShadowProtect takes an incremental backup, it writes a file identifying those sectors that changed since the last backup. Disk defrag software change many sectors on the disk, which greatly increases the time it takes to run the next incremental backup. </LI>
<LI>Test the StorageCraft Recovery Environment to make sure that you have access to both any local drives and network devices that you might need. </LI>
<LI>Pay extra attention to the disk space usage where ShadowProtect stores backup images. If the location runs out of space, backup jobs will fail. </LI>
<LI>Use password encryption to protect backup image files. The default setting of algorithm for encryption key is RC4 128-bit (Fastest, but least secure), it is recommended to apply AES 256-bit (The most secure, but slowest).
<div id="warningContainer"><div class="icon">!</div>
<p>Please kindly note that the encryption key generated by checking the "Encrypt the image file in temporary directory" option CANNOT be recovered by Encryption Key Recovery feature. So please keep the encryption key properly with several copies in case of lost of it. </p>
</div>
</LI>
<LI>For maximum data protection and restore options, it is recommended to configure: 
<OL>
<UL>At least one offsite or cloud destination</UL>
<UL>At least one local destination for fast recovery</UL>
</OL>
</LI>
<LI>Perform test restores periodically to ensure your backup is set up and performed properly. Performing recovery test can also help identify potential issues or gaps in your recovery plan. It's important that you do not try to make the test easier, as the objective of a successful test is not to demonstrate that everything is flawless. There might be flaws identified in the plan throughout the test and it is important to identify those flaws.</LI>
</OL>


<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Name</td>
        <td>This is the name of the backup set. You can create a meaningful name for it. 
        </td>
      </tr>
      <tr>
        <td width="20%">Backup set type</td>
        <td>The backup set type. 
        </td>
      </tr>
      <tr>
        <td width="20%">Path to StorageCraft ShadowProtect</td>
        <td>The path where you installed ShadowProtect.
        </td>
      </tr>
	  <tr>
        <td width="20%">Encrypt the image file in temporary directory</td>
        <td>Check the option if you want to encrypt the image file in temporary directory for encrypted security.
        </td>
      </tr>
</table>
<BR><BR>

<H3>To create a backup set name:</H3>
<OL>
<LI>Type in a meaningful backup set name.</LI> 
<LI>Select the correct backup type, eg: ShadowProtect System Backup </LI>
<LI>Enter the path to StorageCraft ShadowProtect, eg: C:\Program Files (x86)\StorageCraft\ShadowProtect</LI>
<LI>Option: Check the "Encrypt the image file in temporary directory" option if you want to encrypt the image file in temporary directory for encrypted security. </LI>
<LI>Click <img src="../images/next.png"> button to continue.</LI>
</OL> 
<BR><BR>
<BR><BR>

<BR><BR>
<BR><BR>



</div>
<jsp:include page="footer.jsp" />
</body>

</html>
