<!DOCTYPE html>
<html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />

<%@ page language="java" contentType="text/html; charset=UTF-8" pageEncoding="UTF-8"%>
<%@ page import="com.ahsay.cbs.help.HelpManager"%><jsp:include page="header.jsp" />
<jsp:include page="include.jsp" />
</head>

<body>
<div class="helpcontent">
  
<h1 class="colorUserManagement">Add New Backup Set</h1>

<P>You can configure the backup set here in the Backup Server. For details and requirement on the setup, please also refer to the help document in <%=HelpManager.getObmShortName(request)%>.</P>

<H3>Key:</H3>
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="20%">Field</td>
        <td class="titles">Description</td>
      </tr>
      <tr>
        <td width="20%">Name</td>
        <td>This is the name of the backup set. You can create a meaningful name for it. 
        </td>
      </tr>
      <tr>
        <td width="20%">Backup set type</td>
        <td>MS Exchange Mail Level Backup. 
        </td>
      </tr>
	  <tr>
        <td width="20%">Version</td>
        <td>Version of the Exchange server. 
        </td>
	  </tr>
	  <tr>
        <td width="20%">Mode</td>
        <td>Backup mode of the Exchange server.  This will only be visible if Microsoft Exchange Server 2013 / Microsoft Exchange Server 2013 (DAG) is selected.  
        </td>
	  </tr>
	  <tr>
        <td width="20%">Host</td>
        <td>Hostname of the Exchange server (for standalone backup option) or DAG Member Server (for DAG backup option).  This will only be visible if the version selected is 2013 or later. 
        </td>
      </tr>
	  <tr>
        <td width="20%">Username</td>
        <td>Username of the Windows user account used for backup of the Exchange server.  This will only be visible if the version selected is 2013 or later. 
        </td>
      </tr>
	  <tr>
        <td width="20%">Password</td>
        <td>Password of the Windows user account used for backup of the Exchange server, cannot be edited.  This will only be visible if the version selected is 2013 or later. 
        </td>
      </tr>
	  <tr>
        <td width="20%">Access the Internet through Proxy</td>
        <td>Checkbox will be ticked if proxy will be used to access the internet, cannot be edited.  This will only be visible if the version selected is 2013 or later. 
        </td>
      </tr>
</table>
<BR><BR>

<H2>Overview</H2>
<p>Mail Level Backup must be utilized in conjunction with full Information Store Backup as Mail Level backup for Microsoft Exchange Server is not designed to fully protect an Exchange Server, but to facilitate easy backup and fast restoration of individual emails, contacts, calendars or public folder, etc. </p>
<P><%=HelpManager.getObmShortName(request)%> supports standalone backup option and Database Availability Group (DAG) backup option for Exchange server mail level backup.</P>
<BR>

<H3>Advisory on Supported Protocol for Microsoft Exchange 2013</H3>
<p>This advisory will explain the supported protocol for the Microsoft Exchange Server 2013. It will also discuss the difference of the old and new protocol to allow users to understand more effectively. </p>
<p>Microsoft Exchange Server 2013 mail level backups which uses the protocol Messaging Application Programming Interface (MAPI) will no longer be supported as of MS Exchange 2013 Cumulative Update 23 and later due to limitations and functionality issues with MAPI. instead this will be replaced by EWS API.</p>

<H3>What is the difference between MAPI and EWS API?</H3>
<p>MAPI is a client protocol that lets users access their mailbox by using Outlook or other MAPI email clients originally designed by Microsoft in 1987. </p>
<p>EWS API is a newer protocol that allows programmers to access Microsoft Exchange items such as calendars, contacts, and email. </p>
<p>Both are protocols introduced by Microsoft intended for client applications to access information stored in MS Exchange.  However, due to limitations with MAPI, it will be replaced by the EWS API. </p>

<BR><HR>

<H2>Exchange Server 2013/2016/2019 (EWS API)</H2>

<p>Mail Level Backup must be utilized in conjunction with full Information Store Backup as Mail Level backup for Microsoft Exchange Server is not designed to fully protect an Exchange Server, but to facilitate easy backup and fast restoration of individual emails, contacts, calendars or public folder, etc. </p>
<P><%=HelpManager.getObmShortName(request)%> supports standalone backup option and Database Availability Group (DAG) backup option for Exchange server mail level backup.</P>
<H3>Requirements:</H3>
<p>You are strongly recommended to configure or check all the settings below to confirm all the requirements are met before you proceed with the Exchange Mail Level backup and restoration.</p>

<OL>
<LI><%=HelpManager.getObmShortName(request)%> v8.1.0.0 or later must be installed either on the Exchange Server 2016 / 2019 hosting the database or on the remote backup machine.</LI> 
<LI><%=HelpManager.getObmShortName(request)%> v8.3.0.96 or later must be installed either on the Exchange Server 2013 hosting the database or on the remote backup machine.</LI> 
<LI>Make sure the Microsoft Exchange Mailbox feature has been enabled as an add-on module in your <%=HelpManager.getObmShortName(request)%> user account and there is sufficient Microsoft Exchange Mailbox license quota to cover the backup of your mailboxes. </LI>
<LI>To avoid unexpected java crash, if the Windows machine is a guest VM hosted on a VMware Host then it is highly recommended that the VMware tools version installed on the guest VM must be 10.0.5 or later. </LI>
<LI>As <%=HelpManager.getObmShortName(request)%> licenses are calculated on a per device basis: 
    <UL>
	<LI>For backup of mailboxes on a standalone Microsoft Exchange 2013/2016/2019 Server, one <%=HelpManager.getObmShortName(request)%> license is required.</LI>
	<LI>For backup of mailboxes on a Microsoft Exchange Server 2013/2016/2019 DAG setup, the number of <%=HelpManager.getObmShortName(request)%> licenses required is equal to the number of members (nodes) in the DAG. For example, if there are three members then three <%=HelpManager.getObmShortName(request)%> licenses are required.</LI>
	</UL>   </LI>
<LI>Make sure that your <%=HelpManager.getObmShortName(request)%> user account has sufficient storage quota assigned to accommodate the storage of additional Exchange mailbox and public folder items for the new mail level backup set and retention policy. </LI>
<LI>The Continuous backup add-on module is required if you would like to enable the continuous backup feature. </LI>
<LI>The default Java heap size setting of <%=HelpManager.getObmShortName(request)%> is 2048MB. For Exchange 2013/2016/2019 mail level backup, it is highly recommended to increase the Java heap size setting to be at least 4096MB to improve backup and restore performance. The actual heap size is dependent on amount of free memory available on your Exchange 2013/2016/2019 server. </LI>
<LI>Temporary Directory folder is used by <%=HelpManager.getObmShortName(request)%> for storing backup set index files and any incremental or differential delta files generated during a backup job. To ensure optimal backup/restoration performance, it is recommended that the temporary directory folder is located on a local drive with sufficient free disk space. </LI>
<LI>Scheduled backup is required if you choose to back up in DAG option on Exchange server as <%=HelpManager.getObmShortName(request)%>  on all DAG members will base on the scheduled backup time to start backup on all the individual DAG member at the same time. However, scheduled backup is not required for backup and restore on the remote backup machine as the operation for single node can be done either manually or automatically.  </LI>
<LI>Ensure all the nodes have mailbox role by accessing the Exchange Admin Center (EAC). </LI>
<LI>For <%=HelpManager.getObmShortName(request)%> installed on the Exchange Server 2013/2016/2019, the operating system must be Windows Server 2012/ 2012 R2/ 2016 or later. For <%=HelpManager.getObmShortName(request)%> installed on the remote backup machine, the operating system must be Windows 7/ 8/ 8.1/ 10 or Windows Server 2008/ 2008 R2/ 2012/ 2012 R2/ 2016 or later. </LI>
<LI>One Microsoft Exchange Mailbox license is required for the backup of each user mailbox. No license is required for public folder.  </LI>
<LI>Supported Exchange Server 2013/2016/2019 Version: 
    <UL>
	<LI>MS Exchange Server 2019 Cumulative Update 1 (CU1) or later is supported </LI>
	<LI>MS Exchange Server 2016 Cumulative Update 4 (CU4) or later is supported </LI>
	<LI>MS Exchange Server 2013 Cumulative Update 3 (CU3) or later is supported </LI>
	</UL>   </LI>
<LI>Windows User account used for the backup must be a member of the following security groups. 
    <UL>
	<LI>Discovery Management (including ApplicationImpersonation and Mailbox Search) </LI>
	<LI>Organization Management </LI>
	<LI>Public Folder Management </LI>
	</UL>   </LI>
<LI>Windows user account must have an Exchange Server mailbox. Refer to the following URL for more information: <a href="http://support.microsoft.com/kb/275636/en-us">http://support.microsoft.com/kb/275636/en-us </a> </LI>
<LI>Ensure that the “Hide from address lists” option is unchecked for all mailboxes to be selected for backup. Mailbox hidden from the address list will not be shown in the backup source selection menu. </LI>

<LI>As Exchange Server 2013/2016/2019 uses EWS API, please ensure port 443 is configured to allow communication between <%=HelpManager.getObmShortName(request)%> and Exchange Server 2013/2016/2019.</LI>

<LI>Ensure that all MS Exchange related services have been started, particularly the <b>MS Exchange Information Store</b>.</LI>

<LI>Ensure the MS Exchange Mailbox and Public Folder databases are mounted.</LI>
<LI>Windows PowerShell 
	<UL>
	<LI>For Exchange Server 2016/2019, ensure the Windows PowerShell 5.1 Engine is installed. </LI>
	<LI>For Exchange Server 2013, ensure the Windows PowerShell 2.0 Engine is installed. </LI>
	</UL>   </LI>
<LI>.Net Framework
    <UL>
	<LI>For Exchange Server 2016/2019, ensure .Net Framework 4.6.2 Features is installed. Please refer to the following URL for detailed information: <a href="https://technet.microsoft.com/en-us/library/aa996719(v=exchg.160).aspx">https://technet.microsoft.com/en-us/library/aa996719(v=exchg.160).aspx </a> </LI>
	<LI>For Exchange Server 2013 on Windows Server 2012, ensure .Net Framework 3.5 Features is installed. </LI>
	</UL>   </LI>
<LI>For MS Exchange Server 2013, the Remote Exchange Management Shell must be enabled for the operating system account used for the backup. </LI>
</OL>


<H3>Supported Backup Source</H3>

<p>Below is the supported backup source for mail level backup and restore of Exchange Server 2016. </p>
<BR>
<OL>
<LI>Mailbox Level: User mailbox, Public Folder mailbox, Public Folder, Room Mailbox, Equipment Mailbox, Shared Mailbox.  </LI>
<LI>Folder Level: Inbox, Drafts, Sent Items, Deleted Items, Archive, Clutter, Junk Email, RSS Feeds, Trash, Tasks, Calendar, Contacts, Notes.  </LI>
</OL>


<H3>Limitations:</H3>
<OL>
<LI>For restore of Exchange 2013/2016/2019 Mail Level backup set to alternate location, there are some limitation:  
    <UL>
    <LI>If you are trying to restore item(s) from one mailbox to an alternate location mailbox, <%=HelpManager.getObmShortName(request)%> will restore the item(s) to their respective destination folder(s) with the same name of the original folder(s). 
	<br><B>Example:</B> Item from "Inbox" folder of Mailbox-A will be restored to the "Inbox" folder of the alternate location Mailbox-B; Item from "Drafts" folder of Mailbox-A will be restored to the "Drafts" folder of the alternate location Mailbox-B.   </LI>
	<LI>If you are trying to restore item(s) from several mailbox to an alternate location mailbox, <%=HelpManager.getObmShortName(request)%> will restore the item(s) to their respective destination folder(s) with the same name of the original folder(s). 
	<br><B>Example:</B> Item from "Inbox" folder of Mailbox-A and Mailbox-B will be restored to the "Inbox" folder of the alternate location Mailbox-C.   </LI>
	<LI>Restore of public folder item(s) to an alternate location mailbox is not supported.  
	<br><B>Example:</B> Restore of public folder items from Mailbox-A to alternate location Mailbox-B is not supported.   </LI>
</LI>
<LI>Restore of mailbox items or public folder items is only supported if the according mailbox or public folder exists. </LI>
<LI>Only Alternate Location is supported for restoring mailbox items to another domain. </LI>
<LI>If you are trying to restore the mailbox item to a destination mailbox which has a different language setting than the original mailbox, <%=HelpManager.getObmShortName(request)%> will restore mailbox item(s) to their respective destination folder based on the translation listed below. For folders such as 'Calendar' or 'Notes', a new folder 'Calendar' or 'Notes' will be created.
<table cellspacing="0" cellpadding="4" >
      <tr>
        <td class="firstTitles" width="30%">Backup source (English)</td>
        <td class="titles" width="30%">Action</td>
		<td class="titles">Destination mailbox with Chinese as default language settings</td>
      </tr>
      <tr>
        <td class="firstTitles" width="30%">Inbox</td>
        <td class="titles">Merge</td>
		<td class="titles">收件箱</td>
      </tr>
	  <tr>
        <td class="firstTitles" width="30%">Outbox</td>
        <td class="titles">Merge</td>
		<td class="titles">寄件匣</td>
      </tr>
	  <tr>
        <td class="firstTitles" width="30%">Sent Items</td>
        <td class="titles">Merge</td>
		<td class="titles">寄件備份</td>
      </tr>
	  <tr>
        <td class="firstTitles" width="30%">Deleted Items</td>
        <td class="titles">Merge</td>
		<td class="titles">刪除的郵件</td>
      </tr>
	  <tr>
        <td class="firstTitles" width="30%">Drafts</td>
        <td class="titles">Merge</td>
		<td class="titles">草稿</td>
      </tr>
	  <tr>
        <td class="firstTitles" width="30%">Junk E-Mail</td>
        <td class="titles">Merge</td>
		<td class="titles">垃圾電郵</td>
      </tr>
	  <tr>
        <td class="firstTitles" width="30%">Calendar</td>
        <td class="titles">Create new folder</td>
		<td class="titles">Calendar</td>
      </tr>
	  <tr>
        <td class="firstTitles" width="30%">Notes</td>
        <td class="titles">Create new folder</td>
		<td class="titles">Notes</td>
      </tr>	
</table>  	  
</LI>
</OL>



<H3>Best Practice and Recommendation</H3>

<P>The following are some best practices or recommendations we strongly recommend you to follow before you start any Exchange Server 2013/2016/2019 Mail Level backup and restore:</p>
<OL>
<LI>Mail Level Backup must be utilized in conjunction with Database Level Backup to fully protect an Exchange Server. </LI>
<LI>Active Directory server should be protected by regular full Windows System Backup at least once every two weeks. </LI>
<LI>For <%=HelpManager.getObmShortName(request)%> installed on Exchange Server, enable scheduled backup jobs when system activity is low to achieve the best possible performance. </LI>
<LI>The remote backup machine should be on the same LAN as the MS Exchange server for optimal backup and restore performance. </LI>
<LI>
To provide maximum data protection and flexible restore options, it is recommended to configure: 
<UL>
<LI>At least one offsite or cloud destination</LI>
<LI>At least one local destination for fast recovery</LI>
</UL>
</LI>
<LI>Perform test restores periodically to ensure your backup is set up and performed properly. Performing recovery test can also help identify potential issues or gaps in your recovery plan. It's important that you do not try to make the test easier, as the objective of a successful test is not to demonstrate that everything is flawless. There might be flaws identified in the plan throughout the test and it is important to identify those flaws. </LI>
<LI>For backup of multiple or mass backup sets, to achieve better backup performance and to minimize any unnecessary loading on the Exchange server, please consider deploying <%=HelpManager.getObmShortName(request)%> on remote backup machines as distributed backup solution instead of on the MS Exchange server. </LI>
<LI>For backup of a large number of mailboxes, it is recommended to divide all mailboxes into multiple backup sets. </LI>
</OL>




<div class="app_name" show="CloudBacko"><H3>Setup example for DAG</H3>

<H4>Assumption:</H4>
<OL>
<LI>There are 3 nodes in the DAG setup, in the following example, we called it node1, node2 and node3. </LI>
<LI>All the 3 nodes are located in the same timezone. </LI>
<LI>They can connect to the same backup location, e.g. a local shared destination with the same access permission. </LI>
</OL>

	
<H4>Notes:</H4>
<OL>
<LI>As the same backup set setting is needed to apply on all the machines when  
    <UL>
	<LI>the backup set is created or </LI>
	<LI>any changes is applied to the backup set, <BR>
	e.g.
	   <UL>
	   <LI>change backup schedule</LI>
	   <LI>backup source selection</LI>
	   <LI>backup destination</LI> </UL>  
	It is required to export the settings from the node with the last changes and then import to all other nodes. Otherwise, the backup set settings are not synchronized.   <BR>
	e.g. <BR>
	If the backup schedule is changed on node1, if the backup set is not synchronized, other nodes will keep running on an old backup schedule and may cause the backup job to not reflect the actual servers status at the backup moment.  
	</LI>  </UL>
</LI>
<LI>When the settings is imported from other nodes, all the backup set settings on the node will be overwritten.  </LI>
</OL>	
	


<H4>Steps:</H4>
<OL>
<LI>Create/modify Exchange Mail Level DAG backup set in node1, make sure the schedule backup is turned on. </LI>
<LI>Export settings from node1 in [Utilities] > [Ex/Import Settings]  </LI>
<LI>Import the node1 settings into node2 in [Utilities] > [Ex/Import Settings]</LI>
<LI>Enable the Schedule backup in node2. </LI>
<LI>Export settings from node2 in [Utilities] &GT; [Ex/Import Settings]</LI>
<LI>Import the node2 settings into node3 in [Utilities] &GT; [Ex/Import Settings]</LI>
<LI>Enable the Schedule backup in node3.</LI>
<LI>Export settings from node3 in [Utilities] &GT; [Ex/Import Settings]</LI>
<LI>Import the node3 settings into node1 and node2 in [Utilities] &GT; [Ex/Import Settings] </LI>
</OL>
<BR><BR>
</div>	





<H3>To create a backup set for standalone backup option:</H3>
<OL>
<LI>Type in a meaningful backup set name.</LI> 
<LI>Select correct backup type, e.g. MS Exchange Mail Level Backup. </LI>
<LI>Select the version of Exchange server, e.g. Microsoft Exchange Server 2016. </LI>
<LI>Enter the hostname of the Exchange server 2016.</LI>
<LI>Enter the username of the Windows user account used for backup of the Exchange server 2016.</LI>
<!--LI>Enter the password of the Windows user account used for backup of the Exchange server 2016.</LI>
<LI>Check the box "Access the Internet through Proxy" if required.</LI-->
<LI>Click <img src="../images/next.png"> button to continue.</LI>
</OL> 

<H3>To create a backup set for DAG backup option:</H3>
<OL>
<LI>Type in a meaningful backup set name.</LI> 
<LI>Enter correct backup type, e.g. MS Exchange Mail Level Backup. </LI>
<LI>Enter the version of Exchange server, e.g. Microsoft Exchange Server 2016 (DAG). </LI>
<LI>Add the hostname of all the DAG Member Server.</LI>
<LI>Enter the username of the Windows user account used for backup of the Exchange server 2016.</LI>
<!--LI>Enter the password of the Windows user account used for backup of the Exchange server 2016.</LI>
<LI>Check the box "Access the Internet through proxy" if required.</LI-->
<LI>Click <img src="../images/next.png"> button to continue.</LI>
</OL> 

<BR>
<hr>


<H2>Exchange Server 2007/2010/2013 (MAPI)</H2>


<H3>Requirements:</H3>
<p>Please ensure that following requirements are met by the MS Exchange server / DAG:</p>

<OL>
<LI><%=HelpManager.getObmShortName(request)%> is installed on the MS Exchange node with Mailbox role.</LI> 
<LI>If you are using Exchange server 2013 on Windows server 2012, please install ".Net Framework 3.5 Features" under Server Manager > Dashboard > Add Roles and Features Wizard > Feature Page. </LI>
<LI>PowerShell 2.0 Engine is installed. </LI>
<LI>LAN Manager authentication level is set to 3 or later. If the LAN Manager authentication level is not set to 3 or later, the error message will be prompted and <%=HelpManager.getObmShortName(request)%> will ask for the reconfiguration. Server restart is required. 
<BR>
To check on the setting, refer to this <A HREF="https://technet.microsoft.com/en-us/library/jj852207%28v=ws.10%29.aspx">KB article from Microsoft.</A>. </LI>
<LI>Microsoft Messaging Application Programming Interface (MAPI) is installed on the MS Exchange server. (Microsoft Exchange Server MAPI Client and Collaboration Data Objects 1.2.1 (version 6.5.8320.0 or later) is installed)</LI>
<LI>The operating system account to be running the Mail Level backup (e.g. administrator) must have a mailbox and is not hidden from the Global Mailbox List.<BR>
Scheduled backup is performed using the operating system account configured in the "User Authentication for Windows" field.<BR>
If such setting is not configured, the scheduled backup would proceed with the default Local System account (default log on account for <%=HelpManager.getObmShortName(request)%> scheduler).<BR>
In this case, the backup will most likely fail with permission denied error.
</LI>
</OL>

<h3>Granting Privileges:</h3>
<P>Mail Level backup requires "Full Mailbox Access" permission for the user running <%=HelpManager.getObmShortName(request)%>.</P> 
<P>Please refer to the following instruction for granting permission to the operating system account to be running the Mail Level backup:</P><br>

<p><strong>For one specific mailbox</strong> </P>
<P>Use the following procedure to grant access to Exchange 2007 mailbox:</P>
<OL>
<LI>Start the [Active Directory Users and Computers] applet.</LI>
<LI>On the [View] menu, ensure that the [Advanced Features] option is selected.</LI>
<LI>Right click the user whose mailbox you want to give permissions to and choose [Properties].</LI>
<LI>On the [Exchange] Advanced tab, click [Mailbox Rights].</LI>
<LI>Notice that the Domain Admins and Enterprise Admins have both been given Deny access to Full Mailbox access.</LI>
<LI>Click [Add], click the user or group who you want to have access to this mailbox, and then click [OK].</LI>
<LI>Ensure that the user or group is selected in the Name box.</LI>
<LI>In the [Permissions] list, click [Allow] next to [Full Mailbox Access], and then click [OK].</LI>
<LI>Click [OK] all the way out.</LI>
<LI>Restart the [Microsoft Exchange Information Store] service.</LI>
</OL>

<br>
<p>
<strong>For mailboxes located within a specific mailbox store</strong>  </p>
<P>Use the following procedure to grant access to Exchange 2007 mailbox found on a specific mail store:</P>
<OL>
<LI>Start the [Exchange System Manager] applet.</LI>
<LI>Navigate to the server object within the appropriate Administrative Group.</LI>
<LI>Expand the server object and find the required mailbox store within the appropriate Storage Group. Right click it and choose [Properties].</LI>
<LI>In the [Properties] window, go to the [Security] tab.</LI>
<LI>Click [Add], click the user or group who you want to have access to the mailboxes, and then click [OK].</LI>
<LI>Be sure that the user or group is selected in the Name box.</LI>
<LI>In the [Permission] list, check [Allow] next to [Full Control], and then click [OK].</LI>
<LI>Click [Apply] and [OK].</LI>
<LI>Restart the [Microsoft Exchange Information Store] service.</LI>
</OL>

<br>
<P><strong>For Exchange 2007, please refer to the following instructions:</strong></P>
<OL>
<LI>Add an operating system account to the Exchange 2007 server.
<br>This account must be a member of the following groups:
<UL>
  <LI>Local Administrators (Built in) </LI>
  <LI>Domain Admins group</LI>
  <LI>Enterprise Admins group</LI>
</UL>
</LI>

<LI>Enter the following command in Exchange Management Shell:
<div id="command_text">
Get-MailboxServer | Add-ADPermission -User "%USER%" -AccessRights GenericAll -ExtendedRights ms-exch-store-admin,receive-as,send-as -InheritanceType All
</div>

Example, to grant the permission for local account "system"
<div id="command_text">
Get-MailboxServer | Add-ADPermission -User "system" -AccessRights GenericAll -ExtendedRights ms-exch-store-admin,receive-as,send-as -InheritanceType All
</div>

To show added permission for an AD account
<div id="command_text">
Get-MailboxServer | Get-ADPermission -User "%USER%" 
</div>

Example, to show added permission for local account "system"
<div id="command_text">
Get-MailboxServer | Get-ADPermission -User "system" 
</div>

To remove permission from an AD account
<div id="command_text">
Get-MailboxServer | Remove-ADPermission -User "%USER%" -AccessRights GenericAll -ExtendedRights ms-exch-store-admin,receive-as,send-as -InheritanceType All
</div>

Example, to remove permission from local account "system"
<div id="command_text">
Get-MailboxServer | Get-ADPermission -User "system"
</div>

To remove permission from an AD account
<div id="command_text">
Get-MailboxServer | Remove-ADPermission -User "%USER%" -AccessRights GenericAll -ExtendedRights ms-exch-store-admin,receive-as,send-as -InheritanceType All
</div>

Example, to remove permission from local account "system"
<div id="command_text">
Get-MailboxServer | Remove-ADPermission -User "minimal" -AccessRights GenericAll -ExtendedRights ms-exch-store-admin,receive-as,send-as -InheritanceType All
</div>
</LI>
</OL>

<br>
<P><strong>For Exchange Server 2010 and 2013, please refer to the following instructions:</strong></P>
<OL>
<LI>Add an operating system account to the Exchange 2010/2013 server.
<br>This account must be a member of the following security groups:
<UL>
  <LI>Microsoft Exchange Security\Organization Management</LI>
  <LI>Users\Administrator</LI>
  <LI>Users\Domain Admins</LI>
  <LI>Users\Enterprise Admins</LI>
</UL>
</LI>

<LI>For Exchange 2010, ensure that Update Rollup 3 for Exchange Server 2010 (KB981401) is installed. 
<br>Please refer to the following article for more details: <A HREF="http://www.microsoft.com/download/en/details.aspx?displayLang=en&id=415">http://www.microsoft.com/download/en/details.aspx?displayLang=en&id=415</A> . 
</LI>
<LI>Enter the following command in Exchange Management Shell:
<div id="command_text"> 
Get-Mailbox | Add-MailboxPermission -User "%OS_USERNAME%" -AccessRights FullAccess
</div>
Example:
<div id="command_text"> 
Get-Mailbox | Add-MailboxPermission -User "system" -AccessRights FullAccess
</div>
Other useful commands:
Remove permission from an AD account
<div id="command_text"> 
Get-Mailbox | Remove-MailboxPermission -User "%OS_USERNAME%" -AccessRights FullAccess
</div>
Example:
<div id="command_text"> 
Get-Mailbox | Remove-MailboxPermission -User "system" -AccessRights FullAccess
</div>
To view the mailbox permission of a user
<div id="command_text"> 
Get-Mailbox | Get-MailboxPermission -User "%OS_USERNAME%"
</div>
Example:
<div id="command_text"> 
Get-Mailbox | Get-MailboxPermission -User "SYSTEM"
</div>
</LI>
</OL>
<BR>	
	

<div class="app_name" show="CloudBacko"><h3>Setup example for DAG:</h3>
<h4>Assumptions:</h4>
<OL>
<LI>There are 3 nodes in the DAG setup, in the following example, we called it node1, node2 and node3.</LI>
<LI>All the 3 nodes are located in the same timezone.</LI>
<LI>They can connect to the same backup location, e.g. a local shared destination with the same access permission.</LI>
</OL>
<BR>
<h4>Notes:</h4>
<OL>
<LI>As the same backup set setting is needed to apply on all the machines when
   <UL>
     <LI>the backup set is created or</LI> 
     <LI>any changes is applied to the backup set, <BR>
         e.g. 
		 <UL>
		     <LI>change backup schedule</LI>
	         <LI>backup source selection</LI>
		     <LI>backup destination</LI>
		 </UL> 
         It is required to export the settings from the node with the last changes and then import to all other nodes. 
         Otherwise, the backup set settings are not synchronized. <BR>
         e.g. <BR>
	     If the backup schedule is changed on node1, if the backup set is not synchronized, other nodes will keep running on old backup schedule and may cause the backup job to not reflect the actual servers status at the backup moment. 
     </LI>
   </UL>
 </LI>  
<LI>When the settings is imported from other nodes, all the backup set settings on the node will be overwritten. </LI>
</OL>
<BR>
<h4>Steps:</h4>
<OL>
<LI>Create/modify Exchange Mail Level DAG backup set in node1, make sure the schedule backup is turned on. </LI>
<LI>Export settings from node1 in [Utilities] &GT; [Ex/Import Settings] </LI>
<LI>Import the node1 settings into node2 in [Utilities] &GT; [Ex/Import Settings]</LI>
<LI>Enable the Schedule backup in node2. </LI>
<LI>Export settings from node2 in [Utilities] &GT; [Ex/Import Settings]</LI>
<LI>Import the node2 settings into node3 in [Utilities] &GT; [Ex/Import Settings]</LI>
<LI>Enable the Schedule backup in node3.</LI>
<LI>Export settings from node3 in [Utilities] &GT; [Ex/Import Settings]</LI>
<LI>Import the node3 settings into node1 and node2 in [Utilities] &GT; [Ex/Import Settings] </LI>
</OL>
<BR><BR></div>



<H3>To create a backup set</H3>
<OL>
<LI>Type in a meaningful backup set name.</LI> 
<LI>Select correct backup type, e.g. MS Exchange Mail Level Backup. </LI>
<LI>Select the version of Exchange server, e.g. Microsoft Exchange Server 2016. </LI>
<LI>Click <img src="../images/next.png"> button to continue.</LI>
</OL> 


</div>
<jsp:include page="footer.jsp" />
</body>

</html>
