#!/bin/sh
# Ahsay Cloud Backup Suite (version 10.1.6.0)

# functions
func_query_parse_tag_value()
{
    SCRIPT_FILE="$1"
    SCRIPT_TAG="$2"
    SCRIPT_VALUE=$3

    SYSTEM_TYPE=""
    case "`uname`" in
      Linux* )  SYSTEM_TYPE="linux"   ;;
      *BSD* )   SYSTEM_TYPE="bsd"     ;;
      Darwin* ) SYSTEM_TYPE="macos"   ;;
      SunOS )   SYSTEM_TYPE="solaris" ;;
      * )       SYSTEM_TYPE="unknown" ;;
    esac
    if [ "$SYSTEM_TYPE" = "solaris" ]; then
        SED_CMD="/usr/xpg4/bin/sed"
        # get first match
        SEARCH_RESULT="`cat "${SCRIPT_FILE}" | grep "${SCRIPT_TAG}" | head -n 1`"
        #echo "result_1: ${SEARCH_RESULT}"
        # trim space
        SEARCH_RESULT="`echo "${SEARCH_RESULT}" | ${SED_CMD} 's/^[[:space:]]*//;s/[[:space:]]*$//'`"
        #echo "result_2: ${SEARCH_RESULT}"
        if [ ! -z "${SEARCH_RESULT}" ]; then
            # remove tag
            SED_SCRIPT=`echo "${SCRIPT_TAG}" | ${SED_CMD} -e 's/[[:space:]]/[[:space:]]/g'`
            #echo "result_3a: ${SED_SCRIPT}"
            SED_SCRIPT=`echo "s/"${SED_SCRIPT}"//"`
            #echo "result_3b: ${SED_SCRIPT}"
            SEARCH_RESULT="`echo "${SEARCH_RESULT}" | ${SED_CMD} -e ${SED_SCRIPT}`"
            #echo "result_3: ${SEARCH_RESULT}"
            # remove double quotes
            SEARCH_RESULT="`echo "${SEARCH_RESULT}" | ${SED_CMD} 's/^\"*//;s/\"*$//'`"
            #echo "result_4: ${SEARCH_RESULT}"
            # trim space
            SEARCH_RESULT="`echo "${SEARCH_RESULT}" | ${SED_CMD} 's/^[[:space:]]*//;s/[[:space:]]*$//'`"
            #echo "result_5: ${SEARCH_RESULT}"
            eval $SCRIPT_VALUE="'${SEARCH_RESULT}'"
        fi  

    else
        # get first match
        SEARCH_RESULT="`cat "${SCRIPT_FILE}" | grep -m 1 "${SCRIPT_TAG}"`"
        #echo "result_1: ${SEARCH_RESULT}"
        # trim space
        SEARCH_RESULT="`echo "${SEARCH_RESULT}" | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//'`"
        #echo "result_2: ${SEARCH_RESULT}"
        if [ ! -z "${SEARCH_RESULT}" ]; then
            # remove tag
            SED_SCRIPT=`echo "${SCRIPT_TAG}" | sed -e 's/[[:space:]]/[[:space:]]/g'`
            #echo "result_3a: ${SED_SCRIPT}"
            SED_SCRIPT=`echo "s/"${SED_SCRIPT}"//"`
            #echo "result_3b: ${SED_SCRIPT}"
            SEARCH_RESULT="`echo "${SEARCH_RESULT}" | sed -e ${SED_SCRIPT}`"
            #echo "result_3: ${SEARCH_RESULT}"
            # remove double quotes
            SEARCH_RESULT="`echo "${SEARCH_RESULT}" | sed -e 's/^"//' -e 's/"$//'`"
            #echo "result_4: ${SEARCH_RESULT}"
            # trim space
            SEARCH_RESULT="`echo "${SEARCH_RESULT}" | sed -e 's/^[[:space:]]*//' -e 's/[[:space:]]*$//'`"
            #echo "result_5: ${SEARCH_RESULT}"
            eval $SCRIPT_VALUE="'${SEARCH_RESULT}'"
        fi
    fi
}

func_query_service()
{
    SCRIPT_NAME=${SERVICE_NAME}

    # check system type
    case "`uname`" in
      Linux*)   INSTALL_TYPE=NIX ;;
      Solaris*) INSTALL_TYPE=NIX ;;
      SunOS*)   INSTALL_TYPE=NIX ;;
      OpenBSD*) INSTALL_TYPE=OPENBSD ;;
      *BSD*)    INSTALL_TYPE=BSD ;;
      **)       INSTALL_TYPE=NOT_SUPPORTED ;;
    esac

    SCRIPT_PATH=""
    if [ "${SYSTEM_IDENTITY}" = "${UBS_SYSTEM_IDENTITY}" ]; then
        SCRIPT_PATH="/etc/rc.d/cbsnfs"
    else
        if [ "${INSTALL_TYPE}" = "NIX" ]; then
          if [ -d "/etc/init.d" ]; then
            SCRIPT_PATH="/etc/init.d/${SCRIPT_NAME}"
          else
            if [ -d "/etc/rc.d/init.d" ]; then
              SCRIPT_PATH="/etc/rc.d/init.d/${SCRIPT_NAME}"
            fi
          fi

        elif [ "${INSTALL_TYPE}" = "BSD" ]; then
            SCRIPT_PATH="/usr/local/etc/rc.d/${SCRIPT_NAME}"

        elif [ "${INSTALL_TYPE}" = "OPENBSD" ]; then
            #get OpenBSD version
            OPENBSD_VERSION=`uname -r | cut -f1 -d"."`
            if [ "${OPENBSD_VERSION}" -ge 5 ]; then
              SCRIPT_PATH="/etc/rc.d/${SCRIPT_NAME}"
            else
              SCRIPT_PATH="/etc/${SCRIPT_NAME}"
            fi

        fi
    fi

    if [ -z "${SCRIPT_PATH}" ]; then
        SERVICE_STATUS="${TAG_STATUS_UNKNOWN}"
    else
        if [ -f "${SCRIPT_PATH}" ]; then
            SERVICE_STATUS="${TAG_STATUS_RUNNING}"
            func_query_parse_tag_value "${SCRIPT_PATH}" "CBSNFS_UTIL_STARTUP=" SERVICE_EXEC_PATH
        else
            SERVICE_STATUS="${TAG_STATUS_NOT_INSTALL}"
        fi
    fi    
}

func_query_nfs()
{
    TAG_QUERY_SERVER_STATUS_NOT_ACCESSIBLE="NotAccessible"
    TAG_QUERY_SERVER_STATUS_STARTED="Started"
    TAG_QUERY_SERVER_STATUS_STOPPED="Stopped"
    TAG_QUERY_SERVER_VERSION="Server Version:"
    TAG_QUERY_SERVER_STATUS="Server Status:"
    TAG_QUERY_SERVER_NUM_MOUNT_POINT="Number of Mount Point:"
    TAG_QUERY_SERVER_NUM_SESSION="Number of Session:"

    # decide executable to use by system architecture
    NFS_EXE=""

    SYSTEM_TYPE=""
    case "`uname`" in
      Linux* )  SYSTEM_TYPE="linux"   ;;
      *BSD* )   SYSTEM_TYPE="bsd"     ;;
      Darwin* ) SYSTEM_TYPE="macos"   ;;
      SunOS )   SYSTEM_TYPE="solaris" ;;
      * )       SYSTEM_TYPE="unknown" ;;
    esac

    SYSTEM_ARCH=`uname -m`
    case "${SYSTEM_TYPE}" in
      linux)
        case "${SYSTEM_ARCH}" in
          i[3-6]86)
            NFS_EXE="NfsLinX86"
            ;;
          x86_64 | amd64)
            NFS_EXE="NfsLinX64"
            ;;
          *)
            ;;
        esac
        ;;
      bsd)
        case "${SYSTEM_ARCH}" in
          i[3-6]86)
            NFS_EXE="NfsFbdX86"
            ;;
          x86_64 | amd64)
            NFS_EXE="NfsFbdX64"
            ;;
          *)
            ;;
        esac
        ;;
      macos)
        case "${SYSTEM_ARCH}" in
          x86_64 | amd64)
            NFS_EXE="NfsFbdX64"
            ;;
          *)
            NFS_EXE="NfsFbdX86"
            ;;
        esac
        ;;
      solaris)
        IS_32BIT_KERNEL="`isainfo -v | grep -c 64-bit`"
        IS_SPARC_ARCH="`isainfo -v |grep -c sparc*`"
        if [ "${IS_32BIT_KERNEL}" != "0" ] && [ "${IS_SPARC_ARCH}" = "0" ]; then
            SOLARIS_ARCH="`/usr/bin/isainfo -kv`"
            case "${SOLARIS_ARCH}" in
              64-bit*)
                NFS_EXE="NfsSosX64"
                ;;
              *)
                NFS_EXE="NfsSosX86"
                ;;
            esac
        fi
        ;;
      *)
        ;;
    esac

    if [ -z "${NFS_EXE}" ]; then
        NFS_STATUS="${TAG_STATUS_UNKNOWN}"
    else
        WORKING_DIR="`pwd`"
        # Add special handling for UBS instances
        if [ "${SYSTEM_IDENTITY}" = "${UBS_SYSTEM_IDENTITY}" ]; then
            WORKING_DIR="/ubs/storage/obsr/nfs"
        fi
        NFS_QUERY_RESULT="${WORKING_DIR}/nfs.query"
        "./${NFS_EXE}" "-query">"${NFS_QUERY_RESULT}"
        func_query_parse_tag_value "${NFS_QUERY_RESULT}" "${TAG_QUERY_SERVER_VERSION}" NFS_VERSION
        func_query_parse_tag_value "${NFS_QUERY_RESULT}" "${TAG_QUERY_SERVER_STATUS}" NFS_STATUS
        func_query_parse_tag_value "${NFS_QUERY_RESULT}" "${TAG_QUERY_SERVER_NUM_MOUNT_POINT}" NFS_NUM_MOUNT_POINT
        func_query_parse_tag_value "${NFS_QUERY_RESULT}" "${TAG_QUERY_SERVER_NUM_SESSION}" NFS_NUM_RUNNING_SESSION
        if [ "${NFS_STATUS}" = "${TAG_QUERY_SERVER_STATUS_NOT_ACCESSIBLE}" ]; then
            NFS_STATUS="${TAG_STATUS_NOT_ACCESSIBLE}"
        fi
        if [ "${NFS_STATUS}" = "${TAG_QUERY_SERVER_STATUS_STARTED}" ]; then
            NFS_STATUS="${TAG_STATUS_RUNNING}"
        fi
        if [ "${NFS_STATUS}" = "${TAG_QUERY_SERVER_STATUS_STOPPED}" ]; then
            NFS_STATUS="${TAG_STATUS_STOPPED}"
        fi
        if [ -f "${NFS_QUERY_RESULT}" ]; then
            rm "${NFS_QUERY_RESULT}"
        fi
    fi
}

# main
# get application home
EXE_HOME=`pwd`
cd `dirname "$0"`

#define sytem identity
UBS_SYSTEM_IDENTITY="UBS"
SYSTEM_IDENTITY="`uname -i`"

#define query result tag
TAG_STATUS_UNKNOWN="Unknown"
TAG_STATUS_NOT_INSTALL="NotInstall"
TAG_STATUS_NOT_ACCESSIBLE="NotAccessible"
TAG_STATUS_RUNNING="Running"
TAG_STATUS_STOPPED="Stopped"

# query service
SERVICE_NAME="cbsnfs"
SERVICE_DISPLAY_NAME="NFS Service (Ahsay Systems Corporation)"
SERVICE_DESCRIPTION="NFS Service (Ahsay Systems Corporation)"
SERVICE_EXEC_PATH=""
SERVICE_STATUS="${TAG_STATUS_UNKNOWN}"
func_query_service

echo "Service Name:         ${SERVICE_NAME}"
echo "Service Display Name: ${SERVICE_DISPLAY_NAME}"
echo "Service Description:  ${SERVICE_DESCRIPTION}"
echo "Service Path:         ${SERVICE_EXEC_PATH}"
echo "Service Status:       ${SERVICE_STATUS}"

# query NFS
NFS_VERSION=""
NFS_STATUS="${TAG_STATUS_UNKNOWN}"
NFS_NUM_MOUNT_POINT="-1"
NFS_NUM_RUNNING_SESSION="-1"
func_query_nfs

echo "NFS Version:          ${NFS_VERSION}"
echo "NFS Status:           ${NFS_STATUS}"
echo "NFS Mount Point:      ${NFS_NUM_MOUNT_POINT}"
echo "NFS Running Session:  ${NFS_NUM_RUNNING_SESSION}"

cd "${EXE_HOME}"

if [ "$1" = "returnInUse" ]; then
  QUERY_EXIT_CODE=0
  if [ ${NFS_NUM_MOUNT_POINT} -gt 0 ]; then
    QUERY_EXIT_CODE=${NFS_NUM_MOUNT_POINT}
  fi
  if [ ${NFS_NUM_RUNNING_SESSION} -gt 0 ]; then
    QUERY_EXIT_CODE=${NFS_NUM_RUNNING_SESSION}
  fi
  exit ${QUERY_EXIT_CODE}
fi
exit 0
