#!/bin/sh
# [Ahsay Cloud Backup Suite] (version 10.1.6.0)

# --------------------------- Retrieve CBS_HOME --------------------------------
cd `dirname "$0"`
CBS_BIN=`pwd`
CBS_HOME=`dirname $CBS_BIN`
JAVA_HOME=$CBS_HOME/java
CBS_UTIL_BIN=$CBS_HOME/util/bin

# ---------------------- Print Logging Message Header --------------------------
echo "Log Time: `date`"

# ------------ Verify if the privilege is enough for install ------------------
# Comment on 30-Aug-2010:
## Verify the privilege if the shell script "privilege.sh" exist. (which is aligned with the OBC)
echo ""
if [ -f "$CBS_UTIL_BIN/privilege.sh" ]
then
  echo "Verifying current user privilege ..."
  "$CBS_UTIL_BIN/privilege.sh" "uninstall"
  [ $? -ne 0 ] && echo "Exit \"`basename $0`\" now!" && exit 1
else
  echo "The shell script \"$CBS_UTIL_BIN/privilege.sh\" is missing."
  echo "Exit \"`basename $0`\" now!" && exit 1
fi
echo "Current user has enough privilege to \"uninstall\"."
echo ""

# -------------------- Print Logging Message -----------------------------------
export CBS_HOME JAVA_HOME

echo "Using CBS_HOME: $CBS_HOME"
echo "Using JAVA_HOME: $JAVA_HOME"

# ------------------------------ Shutdown service ------------------------------

echo "Try to shutdown [ Ahsay Cloud Backup Suite ]"
sh "$CBS_BIN/shutdown.sh"
sleep 5
echo "Wait 5 seconds before [ Ahsay Cloud Backup Suite ] is down"

# ------------------------------ Remove service --------------------------------
SCRIPT_NAME=cbs

echo "Remove [ Ahsay Cloud Backup Suite ] ($SCRIPT_NAME) from service"

sh "${CBS_UTIL_BIN}/remove-service.sh" $SCRIPT_NAME

echo "[ Ahsay Cloud Backup Suite ] uninstall service is complete!"

# ------------------------------ Remove NFS --------------------------------
NFS_UNINSTALL_SCRIPT="$CBS_HOME/nfs/bin/uninstall.sh"
if [ -f "$NFS_UNINSTALL_SCRIPT" ]; then
    "$NFS_UNINSTALL_SCRIPT" "skipVerify"
fi

echo "It is now safe to remove files from $CBS_HOME"
