#!/bin/sh

##################################################################
# Resolve OBSR based path

# if [ -z "$CBS_HOME" ]; then
EXE_DIR=`pwd`
SCRIPT_HOME=`dirname "$0"`
cd "$SCRIPT_HOME"
APP_BIN=`pwd`
APP_HOME=`dirname "$APP_BIN"`

CBS_HOME=$APP_HOME

export APP_BIN APP_HOME CBS_HOME

cd "$CBS_HOME"
# fi

# Migrate if ssl.key not exist
if [ ! -f "$APP_HOME/conf/ssl.key" ];
   then if [  -f "$APP_BIN/migrate.sh" ];
           then sh "$APP_BIN/migrate.sh"
   fi
fi

# Define Temporary JAVA_HOME
# JAVA_HOME="../jre-linux-amd64"

##################################################################
# System Debug Flag, enabled by default (0 - Disable, 1 - Enable)
SYSTEM_DEBUG=1

##################################################################
# Since OBSR 5.5.5.0, we have integrated the shell scripts for the following OS-ARCH.
# OS : from `uname`
# ARCH: from `uname -m`

# Linux-i386 | Linux-i486 | Linux-i586 | Linux-i686 | Linux-amd64 | Linux-x86_64 | Linux-arm | Linux-ppc
# FreeBSD-i386 | FreeBSD-amd64
# OpenBSD-i386 | OpenBSD-amd64

SYSTEM_OS=`uname`
SYSTEM_ARCH=`uname -m`

SYSTEM_IDENTITY=`uname -i`
case "${SYSTEM_OS}" in
  OpenBSD* )
    # OpenBSD does not support "uname -i"
    ;;
  * )
    SYSTEM_IDENTITY=`uname -i`
    ;;
esac

SYSTEM_TYPE=
case "${SYSTEM_OS}" in
  Linux* )
    SYSTEM_TYPE="linux"
    ;;
  *BSD* )
    SYSTEM_TYPE="bsd"
    ;;
  Darwin* )
    SYSTEM_TYPE="macos"
    ;;
  SunOS )
    SYSTEM_TYPE="solaris"
    ;;
  * )
    SYSTEM_TYPE="unknown"
    ;;
esac

##################################################################
if [ "$SYSTEM_TYPE" = "solaris" ];
    then
        IS_32BIT_KERNEL="`isainfo -v | grep -c 64-bit`"
        if [ "$SYSTEM_TYPE" = "solaris" ] && [ "$IS_32BIT_KERNEL" = "0" ];
            then
            echo "'32 bit OS /Oracle SPARC' does not support in Ahsay CBS v7, Please refer to Ahsay support platform list for details."
            echo "Supported platforms: 'https://forum.ahsay.com/viewtopic.php?f=22&t=9795'"
            exit 0
        fi
fi

if [ "$SYSTEM_TYPE" = "solaris" ];
    then
        IS_SPARC_ARCH="`isainfo -v |grep -c sparc*`"
        if [ "$SYSTEM_TYPE" = "solaris" ] && [ "$IS_SPARC_ARCH" != "0" ];
            then
            echo "'32 bit OS /Oracle SPARC' does not support in Ahsay CBS v7, Please refer to Ahsay support platform list for details."
            echo "Supported platforms: 'https://forum.ahsay.com/viewtopic.php?f=22&t=9795'"
            exit 0
        fi
fi

##################################################################
# Unit Functions for all NIX OS

log_message() {
  echo "$1"
}

log_string() {
  case "${SYSTEM_TYPE}" in
    solaris )
      echo "$1\c"
      ;;
    * )
      echo -n "$1"
      ;;
  esac
}

log_debug_message() {
  [ $SYSTEM_DEBUG -eq 1 ] && log_message "$1"
}

set_system_timezone() {
  if command -v timedatectl >/dev/null 2>&1; then
    SYSTEM_TIMEZONE=$(timedatectl show -p Timezone --value 2>/dev/null)
    if [ -z "$SYSTEM_TIMEZONE" ]; then
      SYSTEM_TIMEZONE=$(timedatectl 2>/dev/null | awk -F': +' '/Time zone/ {print $2; exit}' | awk '{print $1}')
    fi
  fi
  if [ -z "$SYSTEM_TIMEZONE" ]; then
    echo "timedatectl not available, skipping timezone detection."
  else
    JAVA_OPTS="${JAVA_OPTS} -Duser.timezone=$SYSTEM_TIMEZONE"
  fi
}

# [Start] 41483: Do the java home setting in install.sh
# create_symlink_for_java_home() {
#     cd "$CBS_HOME"
#     JAVA_USER=jvm
#     USER_JVM_HOME="$JAVA_HOME"
#     if [ ! -n "$USER_JVM_HOME" ]; then
#         # 41483: Starting v10, java 21 will be used
#         # echo "Please enter your java 1.8 home: "
#         echo "Please enter your java 21 home: "
#         read USER_JVM_HOME
#         if [ -z "$USER_JVM_HOME" ]; then
#             echo "Invalid java home!"
#             exit 1
#         fi
#         if [ ! -d "$USER_JVM_HOME" ]; then
#             echo "$USER_JVM_HOME does not exist!"
#             exit 1
#         fi
#     fi
#     # 41483: Starting v10, java 21 will be used
#     # echo "Copy java 1.8 from $USER_JVM_HOME"
#     echo "Copy java 21 from $USER_JVM_HOME"
#     if [ ! -d "$JAVA_USER" ]; then
#         cp -rf "$USER_JVM_HOME" "$JAVA_USER"
#     else
#         cp -rf $USER_JVM_HOME/* $JAVA_USER
#     fi
#     JVM_SECURITY="${CBS_HOME}/util/jvm/lib/security"
#     if [ -d "$JVM_SECURITY" ]; then
#         cp -rf $JVM_SECURITY/* $JAVA_USER/lib/security
#         ln -sf "${JAVA_USER}" "java"
#     else
#         # 41483: Starting v10, java 21 will be used
#         # JVM_SECURITY="${CBS_HOME}/java-linux-x64/lib/security"
#         JVM_SECURITY="${CBS_HOME}/${JAVA_DIR}/lib/security"
#         if [ -d "$JVM_SECURITY" ]; then
#             cp $JVM_SECURITY/cacerts $JAVA_USER/lib/security
#             ln -sf "${JAVA_USER}" "java"
#         fi
#     fi
# }
# [End] 41483

process_count_with_pid() {
  PID_VALUE=$1
  PS_OPTIONS=" "
  case "${SYSTEM_TYPE}" in
    solaris )
      PS_OPTIONS="-e"
      ;;
    * )
      ;;
  esac
  COUNT=`ps $PS_OPTIONS | awk -F" " '{print " "$1" "$2" "}' | grep -c " $PID_VALUE "`
  echo $COUNT
}

##################################################################
# Memory related functions

get_column_value() {
  local STRING_PATTERN="$1"
  local COL_NUM=$2
  echo $STRING_PATTERN | awk -F " " '{print $'"${COL_NUM}"'}'
}

get_physical_memory_in_kb() {
  case "${SYSTEM_TYPE}" in
    linux )
      linux_get_ram_info_in_kb
      ;;
    bsd )
      bsd_macos_get_ram_info_in_kb
      ;;
    macos )
      bsd_macos_get_ram_info_in_kb
      ;;
    solaris )
      solaris_get_ram_info_in_kb
      ;;
    * )
      echo "0"
      ;;
  esac
}

linux_get_ram_info_in_kb() {
  # Check the value by "cat /proc/meminfo"
  MEMORY_INFO=`cat /proc/meminfo | grep MemTotal:`
  TOTAL_MEMORY_IN_KB=`get_column_value "$MEMORY_INFO" 2`
  echo "$TOTAL_MEMORY_IN_KB"
}

bsd_macos_get_ram_info_in_kb() {
  REAL_MEM="`/sbin/sysctl -n hw.physmem`"
  REAL_MEM_IN_KB="`expr $REAL_MEM / 1024`"
  echo "${REAL_MEM_IN_KB}"
}

solaris_get_ram_info_in_kb() {
  REAL_MEM="`/usr/bin/kstat -p unix:0:system_pages:physmem | cut -f2`"
  PAGESIZE="`/usr/bin/pagesize`"
  REAL_MEM_IN_KB="`expr "$REAL_MEM" "*" "$PAGESIZE" "/" "1024"`"
  echo "${REAL_MEM_IN_KB}"
}

##################################################################
# Check dependency for JAVA 8

# 22765: Verify if GNU Libc version is supported for Linux
# 26508: Support Debian
# DIST=`grep DISTRIB_ID /etc/*-release | awk -F '=' '{print $2}'`
DIST=`grep -w ID /etc/os-release | awk -F '=' '{print $2}'`
# if [ "$DIST" != "Ubuntu" ]; then
if [ "$DIST" != "ubuntu" -a "$DIST" != "debian" ]; then
    case "`uname`" in
        Linux*)
            MINIMUM_SUPPORTED_GLIBC_VERSION=2.17 # The GLibc supported version is defined in APP v8.0 onwards
            GLIBC_VERSION=`ldd --version | awk '/ldd/{print $NF}'`
            GLIBC_VERSION="${GLIBC_VERSION/./}"
            GLIBC_VERSION="${GLIBC_VERSION//.*/}"
            if [ $GLIBC_VERSION -lt 217 ]
            then
                echo "The GNU LIBC version is less than required \"$MINIMUM_SUPPORTED_GLIBC_VERSION\". Exit \""`basename "$0"`"\" now."
                exit 1
            fi
            ;;
        *)
            ;;
    esac
fi

##################################################################
# Setup JAVA environment, including JAVA_HOME and the options limit

# Prepare JAVA_HOME

# If $CBS_HOME/java exist, it will always be used as JRE_HOME.
# Otherwise, we have to create symbolic link for the $CBS_HOME/java to the predefined JRE_HOME

if [ -z "$JRE_HOME" ]; then
if [ -d "$CBS_HOME/java" ];then
  JRE_HOME="$CBS_HOME/java"
  # [Start] 41483: Do the java home setting in install.
  CBS_UTIL_BIN="$CBS_HOME/util/bin"
  MINIMUM_SUPPORTED_JVM_VERSION=21.0
  echo "Minimum supported JVM version: $MINIMUM_SUPPORTED_JVM_VERSION"
  [ ! -f "$CBS_UTIL_BIN/verify-jvm-version.sh" ] && echo "The shell script \"$CBS_UTIL_BIN/verify-jvm-version.sh\" is missing." && echo "Exit \"`basename $0`\" now!" && exit 1
  "$CBS_UTIL_BIN/verify-jvm-version.sh" "$CBS_HOME/java" "$MINIMUM_SUPPORTED_JVM_VERSION" 1>"/dev/null" 2>&1
  if [ $? -ne 0 ]
  then
      echo "The JVM version is lower than \"$MINIMUM_SUPPORTED_JVM_VERSION\" which is not supported by the CBS."
      [ -L "$CBS_HOME/java" ] && rm -f "$CBS_HOME/java" && echo "Removed the Symlink \"$CBS_HOME/java\"."
      echo "Java home is not set. Please finish CBS setup by running \"install.sh\"."
      exit 1
  fi
  echo "Current JVM version is supported."
  # [End] 41483
else
  case "${SYSTEM_TYPE}" in
    # Modify JRE_HOME for Mac OS X
    # It is required to be here for this file will be used in upgrade patch as well
    macos)
      JRE_HOME=/System/Library/Frameworks/JavaVM.framework/Home
      ln -sf "$JRE_HOME" "$CBS_HOME/java"
      ;;
    linux)
      # [Start] 41483: Do the java home setting in install.sh
#       #  use bundled java if available
#       case "${SYSTEM_ARCH}" in
#         i[3-6]86)
#           if [ -d $CBS_HOME/java-linux-x86 ]; then
#             JRE_HOME=$CBS_HOME/java-linux-x86
#             cd $CBS_HOME
#             ln -sf "java-linux-x86" "java"
#           else
#             create_symlink_for_java_home
#           fi
#           ;;
#         x86_64 | amd64)
#           # [Start] 41483: Starting v10, java 21 will be used
#           # if [ -d $CBS_HOME/java-linux-x64 ]; then
#           if [ -d "$CBS_HOME/${JAVA_DIR}" ]; then
#             # JRE_HOME=$CBS_HOME/java-linux-x64
#             JRE_HOME="$CBS_HOME/${JAVA_DIR}"
#             # ln -sf "java-linux-x64" "java"
#             ln -sf "${JAVA_DIR}" "java"
#           else
#             create_symlink_for_java_home
#           fi
#           # [End] 41483
#           ;;
#         arm*)
#           ;;
#         ppc*)
#           ;;
#         *)
#           create_symlink_for_java_home
#           ;;
#       esac
      echo "Java home is not set. Please finish CBS setup by running \"install.sh\"."
      exit 1
      # [End] 41483
      ;;
    bsd)
      # [Start] 41483: Do the java home setting in install.sh
#       #  use bundled java if available
#       case "${SYSTEM_ARCH}" in
#         i[3-6]86)
#           if [ -d "$CBS_HOME/java-freebsd-x86" ]; then
#             JRE_HOME=$CBS_HOME/java-freebsd-x86
#           else
#             create_symlink_for_java_home
#           fi
#           ;;
#         x86_64 | amd64)
#           if [ -d "$CBS_HOME/java-freebsd-x64" ]; then
#             JRE_HOME=$CBS_HOME/java-freebsd-x64
#           else
#             create_symlink_for_java_home
#           fi
#           ;;
#         *)
#           create_symlink_for_java_home
#           ;;
#       esac
#       ;;
#     *)
#       create_symlink_for_java_home
      echo "Java home is not set. Please finish CBS setup by running \"install.sh\"."
      exit 1
      # [End] 41483
      ;;
  esac
fi

# Assumed we always have this directory for JAVA_HOME and JRE_HOME at this stage
[ -d "$CBS_HOME/java" ] && JRE_HOME=$CBS_HOME/java
JAVA_HOME=$JRE_HOME
fi

# Mount the process file system required by java 1.8 which is not mounted by default on FreeBSD
case "${SYSTEM_TYPE}" in
  bsd)
    mount -t procfs -v  | grep "on /proc" > /dev/null
    if [ 0 -ne $? ];
    then
      mount -t procfs proc /proc
    else
      echo "PROC FS already mounted"
    fi
    ;;
  *)
    ;;
esac

set_system_timezone

##################################################################
# Define "JAVA limits" /"LD_LIBRARY_PATH" /"ROTATELOGS"

SYSTEM_PHYSICAL_MEMORY_IN_KB=`get_physical_memory_in_kb`
SYSTEM_PHYSICAL_MEMORY_IN_MB=`expr $SYSTEM_PHYSICAL_MEMORY_IN_KB / 1024`

JAVA_EXTRA_OPTS="-verbose:gc -Xrs -XX:MetaspaceSize=64m -XX:MaxMetaspaceSize=128m -XX:MinHeapFreeRatio=25 -XX:MaxHeapFreeRatio=50"

case "${SYSTEM_TYPE}" in
  # Modify JRE_HOME for Mac OS X
  # It is required to be here for this file will be used in upgrade patch as well

  linux)
    case "${SYSTEM_ARCH}" in
      i[3-6]86)
        LD_LIBRARY_PATH="$CBS_HOME/lib/LinX86"
        ROTATELOGS="$CBS_HOME/bin/LinX86/rotatelogs"
        export LD_LIBRARY_PATH ROTATELOGS
        ;;
      x86_64 | amd64)
        LD_LIBRARY_PATH="$CBS_HOME/lib/LinX64"
        ROTATELOGS="$CBS_HOME/bin/LinX64/rotatelogs"
        export LD_LIBRARY_PATH ROTATELOGS
        ;;
      arm*)
        JAVA_EXTRA_OPTS=""
        ;;
      ppc*)
        ;;
      *)
        ;;
    esac
    ;;
  bsd)
    case "${SYSTEM_ARCH}" in
      i[3-6]86)
        LD_LIBRARY_PATH="$CBS_HOME/lib/FbdX86"
        ROTATELOGS="$CBS_HOME/bin/FbdX86/rotatelogs"
        export LD_LIBRARY_PATH ROTATELOGS
        ;;
      x86_64 | amd64)
        LD_LIBRARY_PATH="$CBS_HOME/lib/FbdX64"
        ROTATELOGS="$CBS_HOME/bin/FbdX64/rotatelogs"
        export LD_LIBRARY_PATH ROTATELOGS
        ;;
      *)
        ;;
    esac
    ;;
  macos)
    case "${SYSTEM_ARCH}" in
      x86_64 | amd64)
        LD_RUN_PATH="$CBS_HOME/lib/FbdX64"
        ROTATELOGS="$CBS_HOME/bin/FbdX64/rotatelogs"
        export LD_LIBRARY_PATH ROTATELOGS
        ;;
      *)
        LD_LIBRARY_PATH="$CBS_HOME/lib/FbdX86"
        ROTATELOGS="$CBS_HOME/bin/FbdX86/rotatelogs"
        export LD_LIBRARY_PATH ROTATELOGS
        ;;
    esac
    ;;
  solaris)
    SOLARIS_ARCH="`/usr/bin/isainfo -kv`"
    case "${SOLARIS_ARCH}" in
      64-bit*)
        JAVA_EXTRA_OPTS="-d64 ${JAVA_EXTRA_OPTS}"
        LD_LIBRARY_PATH="$CBS_HOME/lib/SosX64"
        export LD_LIBRARY_PATH
        # Taks #10888
        # ROTATELOGS="$CBS_HOME/bin/SosX64/rotatelogs"
        # export LD_LIBRARY_PATH ROTATELOGS
        ;;
      *)
        LD_LIBRARY_PATH="$CBS_HOME/lib/SosX86"
        export LD_LIBRARY_PATH ROTATELOGS
        # Taks #10888
        # ROTATELOGS="$CBS_HOME/bin/SosX86/rotatelogs"
        # export LD_LIBRARY_PATH ROTATELOGS
        ;;
    esac
    ;;
  *)
    ;;
esac

# Added for the non-UTF-8 locale
export LC_ALL="en_US.UTF-8"

# Add special handling for UBS instances
if [ "${SYSTEM_IDENTITY}" = "UBS" ]; then
  if [ ! -f "$APP_HOME/conf/cbssvc.ini" ]; then
    cp ${APP_HOME}/conf.default/cbssvc.ini ${APP_HOME}/conf/cbssvc.ini
  fi
  # Create a symbolic link for tmp dir to avoid a disk full problem by java temporary files
  mkdir /ubs/mnt/eslsfw/system/var/log/tmp
  mkdir /ubs/mnt/eslsfw/system/var/tmp
  rm -r /tmp
  rm -r /var/tmp
  ln -sf /ubs/mnt/eslsfw/system/var/log/tmp /
  ln -sf /ubs/mnt/eslsfw/system/var/tmp /var
fi


##################################################################
# Define tomcat environment

PATH=$JRE_HOME/bin:$PATH

CATALINA_HOME=$CBS_HOME/tomcat
CATALINA_BASE=$CBS_HOME
[ -z "$CATALINA_PID" ] && CATALINA_PID=/var/run/obsr.pid

[ -z "$TC_HOME" ] && TC_HOME=$CBS_HOME
TC_LOG_PATH=$TC_HOME/logs
TC_WORK_PATH=$TC_HOME/work
CATALINA_TMPDIR=$TC_HOME/temp

# Define java environment
JAVA_JNI_OPTS="-Djava.library.path=$LD_LIBRARY_PATH"
if [ "${JAVA_OPTS}" = "" ]; then
    JAVA_OPTS="${JAVA_JNI_OPTS} -DCATALINA_PID=$CATALINA_PID";
else 
    JAVA_OPTS="${JAVA_OPTS} ${JAVA_JNI_OPTS} -DCATALINA_PID=$CATALINA_PID";
fi
if [ "${SYSTEM_IDENTITY}" = "UBS" ]; then
    JAVA_OPTS="${JAVA_OPTS} -Dorg.sqlite.lib.path=$LD_LIBRARY_PATH -Dorg.xerial.snappy.lib.path=$LD_LIBRARY_PATH"
fi

##################################################################
# Export all required environment variables

export CBS_HOME JAVA_HOME JRE_HOME PATH
export CATALINA_HOME CATALINA_BASE CATALINA_PID CATALINA_TMPDIR
export CATALINA_OPTS

##################################################################
# Setup System limits

# Increase opened file limit
case "${SYSTEM_TYPE}" in
  linux)
    ulimit -n 32768
    ;;
  bsd)
    sysctl kern.maxvnodes=65536 > /dev/null
    ;;
  macos)
    ulimit -S -n 8192
    ;;
  solaris)
    ulimit -n 65536
    ;;
  *)
    ;;
esac

##################################################################
# Service startup execution detail
[ -d "${CBS_HOME}/work" ] && rm -rf "${CBS_HOME}/work/*"
[ ! -d "${CBS_HOME}/work" ] && mkdir "${CBS_HOME}/work"
if [ -d "${CATALINA_TMPDIR}" ]; then
  for TMPFILE in "${CATALINA_TMPDIR}"/*
  do
    [ ! "${TMPFILE}" = "${CATALINA_TMPDIR}/ros" ] && rm -rf "${TMPFILE}"
  done
fi
[ ! -d "${CATALINA_TMPDIR}" ] && mkdir "${CATALINA_TMPDIR}"
[ ! -d "${TC_LOG_PATH}" ] && mkdir "${TC_LOG_PATH}"

if [ -n "$EXE_DIR" ]; then
[ ! -d "/var" ] && mkdir "/var"
[ ! -d "/var/run" ] && mkdir "/var/run"
fi

# Add UBS Support
if [ "${SYSTEM_IDENTITY}" = "UBS" ];then
  SYSTEM_TYPE="${SYSTEM_TYPE} (UBS)"
fi

##################################################################
OBSR_USER=${USER}
if [ "${OBSR_USER}" = "" ] ; then
  # handle the case if environment variable $USER is not defined (e.g. in SunOS 5.11)
  OBSR_USER=${LOGNAME}
fi

echo "Run MigrateV7 script"
sh "${APP_BIN}/migrateV7.sh" "$APP_HOME" >$APP_HOME/logs/migrateV7.log

JAVA_OPTS_CONF="$CBS_HOME/conf/cbssvc.ini"
if [ "$SYSTEM_TYPE" = "solaris" ]; then
    JAVA_OPTS_TMP="$CBS_HOME/conf/cbssvc.ini.bak"
    if [ -f "${JAVA_OPTS_TMP}" ]; then
        rm "${JAVA_OPTS_TMP}"
    fi
    while read line ; do
        # ignore comment lines, non "-D" or "-X" or "--add" prefixed lines
        echo "$line" | grep -v "^\(\-D\)" | grep -v "^\(\-X\)" | grep -v "^\(\--add\)" >/dev/null 2>&1 && continue
        # if not empty, append the value to JAVA_OPTS and remove DOS end-of-line characters if found
        if [ ! -z "$line" ]; then
            SED_CMD=`echo "s/\r//"`
            printf " `echo \"$line\" | sed ${SED_CMD}`" >> "${JAVA_OPTS_TMP}"
        fi
    done < $JAVA_OPTS_CONF
    if [ -f "${JAVA_OPTS_TMP}" ]; then
        JAVA_OPTS="${JAVA_OPTS} `cat ${JAVA_OPTS_TMP}`"
        rm "${JAVA_OPTS_TMP}"
    fi
    SOLARIS_ARCH="`/usr/bin/isainfo -kv`"
    case "${SOLARIS_ARCH}" in
      64-bit*)
        JAVA_OPTS="-d64 ${JAVA_OPTS}"
        ;;
      *)
        ;;
    esac
else
    while read line ; do
        # ignore comment lines, non "-D" or "-X" or "--add" prefixed lines
        echo "$line" | grep -v "^\(-D\|-X\|--add\)" >/dev/null 2>&1 && continue
        # 2015-11-30 Don't ignore java memory options
        # ignore lines of -Xrs, -Xms, -Xmx, -Xss since it is auto-detect in shell script
        # echo "$line" | grep "^\(-Xrs\|-Xms\|-Xmx\|-Xss\)" >/dev/null 2>&1 && continue
        # if not empty, append the value to JAVA_OPTS and remove DOS end-of-line characters if found
        [ ! -z "$line" ] && JAVA_OPTS="${JAVA_OPTS} `echo "$line" | awk '{ sub("\r$", ""); print }'`"
    done < $JAVA_OPTS_CONF
fi

export JAVA_OPTS

log_debug_message "-----------------------------------------------------------------------"
log_debug_message "You may set SYSTEM_DEBUG=0 to disable the debug message"
log_debug_message "-----------------------------------------------------------------------"
log_debug_message "Current User Name   : $OBSR_USER"
log_debug_message "Using SYSTEM_TYPE   : $SYSTEM_TYPE"
log_debug_message "Using SYSTEM_ARCH   : $SYSTEM_ARCH"
log_debug_message "Using PHYSICAL_MEM  : $SYSTEM_PHYSICAL_MEMORY_IN_MB (MB)"
log_debug_message "-----------------------------------------------------------------------"
log_debug_message "Using CBS_HOME      : $CBS_HOME"
log_debug_message "Using JAVA_HOME     : $JAVA_HOME"
log_debug_message "Using CATALINA_HOME : $CATALINA_HOME"
log_debug_message "Using JAVA_OPTS     : $JAVA_OPTS"
log_debug_message "Using CATALINA_OPTS : $CATALINA_OPTS"
log_debug_message "Using CATALINA_PID  : $CATALINA_PID"
log_debug_message "-----------------------------------------------------------------------"

log_message "Starting AhsayCBS service"
[ "$EXE_DIR" ] && cd "$CBS_HOME"

# "Oracle" will not use rotatelogs --- task #10888
if [ "$SYSTEM_TYPE" = "solaris" ];
    then
        #nohup sh "${CATALINA_HOME}/bin/catalina.sh" start > /dev/null 2>&1
        sh "${CATALINA_HOME}/bin/catalina.sh" start
    else
        ROTATELOGS_CONSOLE="|$ROTATELOGS -f $CBS_HOME/logs/console_%Y-%m-%d.log 86400"
        export ROTATELOGS_CONSOLE
        #nohup sh "${CATALINA_HOME}/bin/catalina.sh" start > /dev/null 2>&1
        sh "${CATALINA_HOME}/bin/catalina.sh" start
fi
