@ECHO OFF
SET APP_JVM_HOME=..\jvm
SET AUA_JVM_HOME=.\jvm
SET JVM_HOME=%APP_JVM_HOME%
IF "%~4"=="MIGRATE" (
  ECHO Use JVM home in AUA folder for migration
  SET JVM_HOME=%AUA_JVM_HOME%
) ELSE (
  IF NOT "%~4"=="" (
    ECHO Use custom JVM home in AUA folder for migration
    SET JVM_HOME="%~4"
  )
)

IF NOT Exist "%JVM_HOME%\bin\javau.exe" (
  ECHO Copy from %JVM_HOME%\bin\java.exe to %JVM_HOME%\bin\javau.exe
  copy %JVM_HOME%\bin\java.exe %JVM_HOME%\bin\javau.exe
)

IF "%PROCESSOR_ARCHITECTURE%"=="x86" (
  SET "DEP_LIB_PATH=X86"
) ELSE (
  SET "DEP_LIB_PATH=X64"
)
SET JAVA_LIB_PATH=-Djava.library.path=.\lib;.\lib\%DEP_LIB_PATH%

ECHO Start update application process
%JVM_HOME%\bin\javau %JAVA_LIB_PATH% -cp .\lib;.\lib\aua.jar;.\lib\bcmail-jdk15to18-164.jar;.\lib\bcpkix-jdk15to18-164.jar;.\lib\bcprov-jdk15to18-164.jar;.\lib\commons-logging-1.2.jar;.\lib\httpclient-4.5.12.jar;.\lib\httpcore-4.4.13.jar;.\lib\jackson-annotations-2.7.4.jar;.\lib\jackson-core-2.9.9.jar;.\lib\jackson-databind-2.7.4.jar;.\lib\jdom.jar;.\lib\jersey-apache-client4-1.18.1.jar;.\lib\jersey-bundle-1.18.1.jar;.\lib\jersey-multipart-1.18.1.jar;.\lib\log4j.jar;.\lib\org.json-20150730.jar;.\lib\snappy-java-1.1.7.3.jar;.\lib\sqlite-jdbc-3.27.2.1.1.jar -Xrs -Xmx128m AuaI %1 %2 %~3
IF NOT "%ERRORLEVEL%"=="0" (
  ECHO Update not completed, terminate now
  exit 0
)
IF "%~3"=="UI" (
  REM Do not ECHO message here since it will cause UI not started
  cd ..\bin
  IF "%PROCESSOR_ARCHITECTURE%"=="AMD64" (
    START SystemTray64.exe -UI
  ) ELSE (
    IF "%PROCESSOR_ARCHITECTURE%"=="x64" (
      START SystemTray64.exe -UI
    ) ELSE (
      START SystemTray.exe -UI
    )
  )
)
