#!/bin/sh
APP_JVM_HOME="../jvm"
AUA_JVM_HOME="./jvm"
JVM_HOME="$APP_JVM_HOME"

if [ "$4" = "MIGRATE" ]; then
    JVM_HOME="$AUA_JVM_HOME"
else
    # add to support define JVM home on java
    if [ ! -z "$4" ]; then
        JVM_HOME="$4"
    fi
fi

if [ -f "$JVM_HOME/bin/javau" ]; then 
    echo "javau exists. Continue update." 
else 
    # copy java as javau to distinguish update process and other processes
    cp "$JVM_HOME/bin/java" "$JVM_HOME/bin/javau" 
    echo "javau added, continue update."
fi

JAVA_EXE="$JVM_HOME/bin/javau"

SYSTEM_OS=`uname`
SYSTEM_ARCH=`uname -m`
DEP_LIB_PATH=

OS_NAME=
case "${SYSTEM_OS}" in
  Linux* )
    OS_NAME="Lin"
    ;;
  *BSD* )
    OS_NAME="Fbd"
    ;;
  SunOS )
    OS_NAME="Sos"
    SYSTEM_ARCH=`isainfo -b`
    ;;
  * )
    echo "OS \"${SYSTEM_OS}\" is not supported. Exit now."
    exit 1
    ;;
esac

OS_ARCH=
if [ -z "${DEP_LIB_PATH}" ]; then
    case "${SYSTEM_ARCH}" in
        i[3-6]86 | 32)
            OS_ARCH="X86"
        ;;
        x86_64 | amd64 | 64)
            OS_ARCH="X64"
        ;;
        armv6*)
            OS_ARCH="Av6"
        ;;
        armv7*)
            OS_ARCH="Av7"
        ;;
        armv5*)
            OS_ARCH="Arm"
        ;;
        aarch64*)
            OS_ARCH="A64"
        ;;
        * )
            echo "Arch \"${SYSTEM_ARCH}\" is not supported. Exit now."
            exit 1
        ;;
    esac
    DEP_LIB_PATH=${OS_NAME}${OS_ARCH}
fi

LIB_HOME="./lib"
JAVA_OPTS="-Xrs -Xmx128m"
JNI_PATH="-Djava.library.path=$LIB_HOME:$LIB_HOME/${DEP_LIB_PATH}"
# AuaI need jdom.jar because Xml classes likes ConfigXML use jdom to parse xml
CLASSPATH="$LIB_HOME:$LIB_HOME/aua.jar:$LIB_HOME/bcmail-jdk15to18-164.jar:$LIB_HOME/bcpkix-jdk15to18-164.jar:$LIB_HOME/bcprov-jdk15to18-164.jar:$LIB_HOME/commons-logging-1.2.jar:$LIB_HOME/httpclient-4.5.12.jar:$LIB_HOME/httpcore-4.4.13.jar:$LIB_HOME/jackson-annotations-2.7.4.jar:$LIB_HOME/jackson-core-2.9.9.jar:$LIB_HOME/jackson-databind-2.7.4.jar:$LIB_HOME/jdom.jar:$LIB_HOME/jersey-apache-client4-1.18.1.jar:$LIB_HOME/jersey-bundle-1.18.1.jar:$LIB_HOME/jersey-multipart-1.18.1.jar:$LIB_HOME/log4j.jar:$LIB_HOME/org.json-20150730.jar:$LIB_HOME/snappy-java-1.1.7.3.jar:$LIB_HOME/sqlite-jdbc-3.27.2.1.1.jar"
MAIN_CLASS=AuaI
"$JAVA_EXE" "$JAVA_OPTS" "$JNI_PATH" -cp "$CLASSPATH" "$MAIN_CLASS" "$1" "$2" "$3" > ../log/Update.log
if [ "$?" != "0" ]; then
    exit
fi
if [ "$3" = "UI" ]; then
    sh "../bin/RunCB.sh"
fi
exit
