/*
 * Decompiled with CFR 0.152.
 */
package io.github.zabuzard.fastcdc4j.internal.util;

import java.util.function.Function;
import java.util.function.Predicate;

public final class Validations {
    public static long requirePositive(long value, String valueName) {
        if (valueName == null) {
            throw new IllegalArgumentException("The parameter valueName is null.");
        }
        Validations.require(value >= 0L, valueName + " must be positive.");
        return value;
    }

    public static long requirePositiveNonZero(long value, String valueName) {
        if (valueName == null) {
            throw new IllegalArgumentException("The parameter valueName is null.");
        }
        Validations.require(value > 0L, valueName + " must be positive and not zero.");
        return value;
    }

    public static int requirePositive(int value, String valueName) {
        if (valueName == null) {
            throw new IllegalArgumentException("The parameter valueName is null.");
        }
        Validations.require(value >= 0, valueName + " must be positive.");
        return value;
    }

    public static int requirePositiveNonZero(int value, String valueName) {
        if (valueName == null) {
            throw new IllegalArgumentException("The parameter valueName is null.");
        }
        Validations.require(value > 0, valueName + " must be positive and not zero.");
        return value;
    }

    public static <E extends RuntimeException> void requireNotThrow(Class<E> expectedException, Runnable runnable, String message) {
        block5: {
            if (expectedException == null) {
                throw new IllegalArgumentException("The parameter expectedException is null.");
            }
            if (runnable == null) {
                throw new IllegalArgumentException("The parameter runnable is null.");
            }
            if (message == null) {
                throw new IllegalArgumentException("The parameter message is null.");
            }
            try {
                runnable.run();
            }
            catch (RuntimeException e) {
                if (!expectedException.isInstance(e)) break block5;
                throw new IllegalArgumentException(message, e);
            }
        }
    }

    public static <T> T require(Predicate<? super T> predicate, T object, String message) {
        if (message == null) {
            throw new IllegalArgumentException("The parameter message is null.");
        }
        if (predicate == null) {
            throw new IllegalArgumentException("The parameter predicate is null.");
        }
        Validations.require(predicate.test(object), message);
        return object;
    }

    public static void require(boolean predicate, String message) {
        if (message == null) {
            throw new IllegalArgumentException("The parameter message is null.");
        }
        Validations.require(predicate, IllegalArgumentException::new, message);
    }

    public static <T, E extends RuntimeException> T require(Predicate<? super T> predicate, T object, Function<? super String, E> exceptionSupplier, String message) {
        if (predicate == null) {
            throw new IllegalArgumentException("The parameter predicate is null.");
        }
        if (exceptionSupplier == null) {
            throw new IllegalArgumentException("The parameter exceptionSupplier is null.");
        }
        if (message == null) {
            throw new IllegalArgumentException("The parameter message is null.");
        }
        Validations.require(predicate.test(object), exceptionSupplier, message);
        return object;
    }

    public static <E extends RuntimeException> void require(boolean predicate, Function<? super String, E> exceptionSupplier, String message) {
        if (exceptionSupplier == null) {
            throw new IllegalArgumentException("The parameter exceptionSupplier is null.");
        }
        if (message == null) {
            throw new IllegalArgumentException("The parameter message is null.");
        }
        if (predicate) {
            return;
        }
        throw (RuntimeException)exceptionSupplier.apply(message);
    }

    private Validations() {
        throw new UnsupportedOperationException("Utility class, no implementation");
    }
}

