/*
 * Decompiled with CFR 0.152.
 */
package io.github.zabuzard.fastcdc4j.external.chunking;

import io.github.zabuzard.fastcdc4j.external.chunking.Chunker;
import io.github.zabuzard.fastcdc4j.external.chunking.ChunkerOption;
import io.github.zabuzard.fastcdc4j.external.chunking.HashTableOption;
import io.github.zabuzard.fastcdc4j.external.chunking.IterativeStreamChunkerCore;
import io.github.zabuzard.fastcdc4j.external.chunking.MaskOption;
import io.github.zabuzard.fastcdc4j.internal.chunking.FastCdcChunkerCore;
import io.github.zabuzard.fastcdc4j.internal.chunking.FixedSizeChunkerCore;
import io.github.zabuzard.fastcdc4j.internal.chunking.HashTables;
import io.github.zabuzard.fastcdc4j.internal.chunking.IterativeStreamChunker;
import io.github.zabuzard.fastcdc4j.internal.chunking.MaskGenerator;
import io.github.zabuzard.fastcdc4j.internal.chunking.NlfiedlerRustChunkerCore;
import io.github.zabuzard.fastcdc4j.internal.util.Validations;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class ChunkerBuilder {
    private static final int DEFAULT_EXPECTED_CHUNK_SIZE = 8192;
    private static final String DEFAULT_HASH_METHOD = "SHA-1";
    private static final long DEFAULT_MASK_GENERATION_SEED = 941568351L;
    private static final double DEFAULT_MAX_SIZE_FACTOR = 8.0;
    private static final double DEFAULT_MIN_SIZE_FACTOR = 0.25;
    private static final int DEFAULT_NORMALIZATION_LEVEL = 2;
    private Chunker chunker;
    private IterativeStreamChunkerCore chunkerCore;
    private ChunkerOption chunkerOption = ChunkerOption.FAST_CDC;
    private int expectedChunkSize = 8192;
    private String hashMethod = "SHA-1";
    private long[] hashTable;
    private HashTableOption hashTableOption = HashTableOption.RTPAL;
    private long maskGenerationSeed = 941568351L;
    private Long maskLarge;
    private MaskOption maskOption = MaskOption.FAST_CDC;
    private Long maskSmall;
    private int iMaximalChunkSize = 65536;
    private int iMinimalChunkSize = 2048;
    private int normalizationLevel = 2;

    public Chunker build() {
        if (this.chunker != null) {
            return this.chunker;
        }
        this.chunker = new IterativeStreamChunker(this.buildCore(), this.hashMethod);
        return this.chunker;
    }

    public IterativeStreamChunkerCore buildCore() {
        IterativeStreamChunkerCore coreToUse;
        long[] hashTableToUse;
        if (this.chunkerCore != null) {
            return this.chunkerCore;
        }
        long[] lArray = hashTableToUse = this.hashTable != null ? this.hashTable : null;
        if (hashTableToUse == null) {
            switch (this.hashTableOption) {
                case RTPAL: {
                    hashTableToUse = HashTables.getRtpal();
                    break;
                }
                case NLFIEDLER_RUST: {
                    hashTableToUse = HashTables.getNlfiedlerRust();
                }
            }
        }
        MaskGenerator maskGenerator = new MaskGenerator(this.maskOption, this.normalizationLevel, this.expectedChunkSize, this.maskGenerationSeed);
        long maskSmallToUse = this.maskSmall != null ? this.maskSmall.longValue() : maskGenerator.generateSmallMask();
        long maskLargeToUse = this.maskLarge != null ? this.maskLarge.longValue() : maskGenerator.generateLargeMask();
        int minimalChunkSize = this.iMinimalChunkSize;
        int maximalChunkSize = this.iMaximalChunkSize;
        IterativeStreamChunkerCore iterativeStreamChunkerCore = coreToUse = this.chunkerCore != null ? this.chunkerCore : null;
        if (coreToUse == null) {
            switch (this.chunkerOption) {
                case FAST_CDC: {
                    coreToUse = new FastCdcChunkerCore(this.expectedChunkSize, minimalChunkSize, maximalChunkSize, hashTableToUse, maskSmallToUse, maskLargeToUse);
                    break;
                }
                case NLFIEDLER_RUST: {
                    coreToUse = new NlfiedlerRustChunkerCore(this.expectedChunkSize, minimalChunkSize, maximalChunkSize, hashTableToUse, maskSmallToUse, maskLargeToUse);
                    break;
                }
                case FIXED_SIZE_CHUNKING: {
                    coreToUse = new FixedSizeChunkerCore(this.expectedChunkSize);
                }
            }
        }
        this.chunkerCore = coreToUse;
        return this.chunkerCore;
    }

    public ChunkerBuilder fastCdc() {
        return this.fastCdc(8192, this.iMinimalChunkSize, this.iMaximalChunkSize, 2);
    }

    public ChunkerBuilder fastCdc(int iChunkSize, int iMinimalChunkSize, int iMaximalChunkSize, int iNormalizationLevel) {
        this.chunkerOption = ChunkerOption.FAST_CDC;
        this.hashMethod = DEFAULT_HASH_METHOD;
        this.expectedChunkSize = iChunkSize;
        this.iMinimalChunkSize = iMinimalChunkSize;
        this.iMaximalChunkSize = iMaximalChunkSize;
        this.hashTableOption = HashTableOption.RTPAL;
        this.normalizationLevel = iNormalizationLevel;
        this.maskOption = MaskOption.FAST_CDC;
        this.maskGenerationSeed = 941568351L;
        return this;
    }

    public ChunkerBuilder fsc(int iMinimalChunkSize, int iMaximalChunkSize) {
        this.chunkerOption = ChunkerOption.FIXED_SIZE_CHUNKING;
        this.hashMethod = DEFAULT_HASH_METHOD;
        this.expectedChunkSize = 8192;
        this.iMinimalChunkSize = iMinimalChunkSize;
        this.iMaximalChunkSize = iMaximalChunkSize;
        return this;
    }

    public ChunkerBuilder nlFiedlerRust(int iChunkSize, int iMinimalChunkSize, int iMaximalChunkSize, int iNormalizationLevel) {
        this.chunkerOption = ChunkerOption.NLFIEDLER_RUST;
        this.hashMethod = DEFAULT_HASH_METHOD;
        this.expectedChunkSize = iChunkSize;
        this.iMinimalChunkSize = iMinimalChunkSize;
        this.iMaximalChunkSize = iMaximalChunkSize;
        this.hashTableOption = HashTableOption.NLFIEDLER_RUST;
        this.normalizationLevel = iNormalizationLevel;
        this.maskOption = MaskOption.NLFIEDLER_RUST;
        return this;
    }

    public ChunkerBuilder setChunker(Chunker chunker) {
        if (chunker == null) {
            throw new NullPointerException("The parameter ChunkerModified is null.");
        }
        this.chunker = chunker;
        return this;
    }

    public ChunkerBuilder setChunkerCore(IterativeStreamChunkerCore chunkerCore) {
        if (chunkerCore == null) {
            throw new NullPointerException("The parameter IterativeStreamChunkerCore is null.");
        }
        this.chunkerCore = chunkerCore;
        return this;
    }

    public ChunkerBuilder setChunkerOption(ChunkerOption chunkerOption) {
        if (chunkerOption == null) {
            throw new NullPointerException("The parameter ChunkerOption is null.");
        }
        this.chunkerOption = chunkerOption;
        return this;
    }

    public ChunkerBuilder setExpectedChunkSize(int expectedChunkSize) {
        this.expectedChunkSize = Validations.requirePositiveNonZero(expectedChunkSize, "Expected chunk size");
        return this;
    }

    public ChunkerBuilder setHashMethod(String hashMethod) {
        if (hashMethod == null) {
            throw new NullPointerException("The parameter hashMethod is null.");
        }
        try {
            MessageDigest.getInstance(hashMethod);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalArgumentException("The given hash method is not supported, was: " + hashMethod, e);
        }
        this.hashMethod = hashMethod;
        return this;
    }

    public ChunkerBuilder setHashTable(long[] hashTable) {
        if (hashTable == null) {
            throw new NullPointerException("The parameter hashTable is null.");
        }
        Validations.require(hashTable.length == 256, "Hash table must have a length of 256, one hash per byte value, was: " + hashTable.length);
        this.hashTable = (long[])hashTable.clone();
        return this;
    }

    public ChunkerBuilder setHashTableOption(HashTableOption hashTableOption) {
        if (hashTableOption == null) {
            throw new NullPointerException("The parameter hashTableOption is null.");
        }
        this.hashTableOption = hashTableOption;
        return this;
    }

    public ChunkerBuilder setMaskGenerationSeed(long maskGenerationSeed) {
        this.maskGenerationSeed = maskGenerationSeed;
        return this;
    }

    public ChunkerBuilder setMaskLarge(long maskLarge) {
        this.maskLarge = maskLarge;
        return this;
    }

    public ChunkerBuilder setMaskOption(MaskOption maskOption) {
        if (maskOption == null) {
            throw new NullPointerException("The parameter maskOption is null.");
        }
        this.maskOption = maskOption;
        return this;
    }

    public ChunkerBuilder setMaskSmall(long maskSmall) {
        this.maskSmall = maskSmall;
        return this;
    }

    public ChunkerBuilder setNormalizationLevel(int normalizationLevel) {
        this.normalizationLevel = Validations.requirePositive(normalizationLevel, "Normalization level");
        return this;
    }
}

