/*
 * Decompiled with CFR 0.152.
 */
package io.github.zabuzard.fastcdc4j.external.chunking;

import io.github.zabuzard.fastcdc4j.external.chunking.Chunk;
import io.github.zabuzard.fastcdc4j.internal.util.FlatIterator;
import io.github.zabuzard.fastcdc4j.internal.util.Validations;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.stream.Stream;

public interface Chunker {
    public Iterable<Chunk> chunk(InputStream var1, long var2);

    default public Iterable<Chunk> chunk(Stream<? extends Path> paths) {
        if (paths == null) {
            throw new NullPointerException("The parameter paths should not be null.");
        }
        return () -> new FlatIterator(paths.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).iterator(), path -> this.chunk((Path)path).iterator());
    }

    default public Iterable<Chunk> chunk(byte[] data) {
        if (data == null) {
            throw new NullPointerException("The parameter data should not be null.");
        }
        Validations.require(data.length > 0, "Data must not be empty");
        return this.chunk(new ByteArrayInputStream(data), data.length);
    }

    default public Iterable<Chunk> chunk(Path path) {
        if (path == null) {
            throw new NullPointerException("The parameter path should not be null.");
        }
        try {
            if (Files.isDirectory(path, new LinkOption[0])) {
                return this.chunk(Files.walk(path, new FileVisitOption[0]));
            }
            if (Files.isRegularFile(path, new LinkOption[0])) {
                return this.chunk(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])), Files.size(path));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        throw new IllegalArgumentException("Only existing regular files or directories are supported");
    }
}

