/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.implementation;

import com.azure.core.management.Resource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.ComputeManager;
import com.azure.resourcemanager.compute.fluent.ComputeManagementClient;
import com.azure.resourcemanager.compute.fluent.models.SnapshotInner;
import com.azure.resourcemanager.compute.models.AccessLevel;
import com.azure.resourcemanager.compute.models.CreationData;
import com.azure.resourcemanager.compute.models.CreationSource;
import com.azure.resourcemanager.compute.models.Disk;
import com.azure.resourcemanager.compute.models.DiskCreateOption;
import com.azure.resourcemanager.compute.models.DiskSkuTypes;
import com.azure.resourcemanager.compute.models.GrantAccessData;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.Snapshot;
import com.azure.resourcemanager.compute.models.SnapshotSku;
import com.azure.resourcemanager.compute.models.SnapshotSkuType;
import com.azure.resourcemanager.compute.models.SnapshotStorageAccountTypes;
import com.azure.resourcemanager.resources.fluentcore.arm.Manager;
import com.azure.resourcemanager.resources.fluentcore.arm.ResourceUtils;
import com.azure.resourcemanager.resources.fluentcore.arm.models.implementation.GroupableResourceImpl;
import com.azure.resourcemanager.resources.fluentcore.model.implementation.IndexableRefreshableWrapperImpl;
import com.azure.resourcemanager.resources.fluentcore.utils.ResourceManagerUtils;
import reactor.core.publisher.Mono;

class SnapshotImpl
extends GroupableResourceImpl<Snapshot, SnapshotInner, SnapshotImpl, ComputeManager>
implements Snapshot,
Snapshot.Definition,
Snapshot.Update {
    private final ClientLogger logger = new ClientLogger(SnapshotImpl.class);

    SnapshotImpl(String name, SnapshotInner innerModel, ComputeManager computeManager) {
        super(name, (Resource)innerModel, (Manager)computeManager);
    }

    @Override
    public SnapshotSkuType skuType() {
        if (((SnapshotInner)((Object)this.innerModel())).sku() == null) {
            return null;
        }
        return SnapshotSkuType.fromSnapshotSku(((SnapshotInner)((Object)this.innerModel())).sku());
    }

    @Override
    public DiskCreateOption creationMethod() {
        return ((SnapshotInner)((Object)this.innerModel())).creationData().createOption();
    }

    @Override
    public boolean incremental() {
        return ((SnapshotInner)((Object)this.innerModel())).incremental();
    }

    @Override
    public int sizeInGB() {
        return ResourceManagerUtils.toPrimitiveInt((Integer)((SnapshotInner)((Object)this.innerModel())).diskSizeGB());
    }

    @Override
    public OperatingSystemTypes osType() {
        return ((SnapshotInner)((Object)this.innerModel())).osType();
    }

    @Override
    public CreationSource source() {
        return new CreationSource(((SnapshotInner)((Object)this.innerModel())).creationData());
    }

    @Override
    public String grantAccess(int accessDurationInSeconds) {
        return (String)this.grantAccessAsync(accessDurationInSeconds).block();
    }

    @Override
    public Mono<String> grantAccessAsync(int accessDurationInSeconds) {
        GrantAccessData grantAccessDataInner = new GrantAccessData();
        grantAccessDataInner.withAccess(AccessLevel.READ).withDurationInSeconds(accessDurationInSeconds);
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getSnapshots().grantAccessAsync(this.resourceGroupName(), this.name(), grantAccessDataInner).map(accessUriInner -> accessUriInner.accessSas());
    }

    @Override
    public void revokeAccess() {
        this.revokeAccessAsync().block();
    }

    @Override
    public Mono<Void> revokeAccessAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getSnapshots().revokeAccessAsync(this.resourceGroupName(), this.name());
    }

    @Override
    public SnapshotImpl withLinuxFromVhd(String vhdUrl) {
        return this.withLinuxFromVhd(vhdUrl, this.constructStorageAccountId(vhdUrl));
    }

    @Override
    public SnapshotImpl withLinuxFromVhd(String vhdUrl, String storageAccountId) {
        ((SnapshotInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl).withStorageAccountId(storageAccountId);
        return this;
    }

    @Override
    public SnapshotImpl withLinuxFromDisk(String sourceDiskId) {
        ((SnapshotInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceDiskId);
        return this;
    }

    @Override
    public SnapshotImpl withLinuxFromDisk(Disk sourceDisk) {
        this.withLinuxFromDisk(sourceDisk.id());
        if (sourceDisk.osType() != null) {
            this.withOSType(sourceDisk.osType());
        }
        this.withSku(sourceDisk.sku());
        return this;
    }

    @Override
    public SnapshotImpl withLinuxFromSnapshot(String sourceSnapshotId) {
        ((SnapshotInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.LINUX).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceSnapshotId);
        return this;
    }

    @Override
    public SnapshotImpl withLinuxFromSnapshot(Snapshot sourceSnapshot) {
        this.withLinuxFromSnapshot(sourceSnapshot.id());
        if (sourceSnapshot.osType() != null) {
            this.withOSType(sourceSnapshot.osType());
        }
        this.withSku(sourceSnapshot.skuType());
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromVhd(String vhdUrl) {
        return this.withWindowsFromVhd(vhdUrl, this.constructStorageAccountId(vhdUrl));
    }

    @Override
    public SnapshotImpl withWindowsFromVhd(String vhdUrl, String storageAccountId) {
        ((SnapshotInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl).withStorageAccountId(storageAccountId);
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromDisk(String sourceDiskId) {
        ((SnapshotInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceDiskId);
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromDisk(Disk sourceDisk) {
        this.withWindowsFromDisk(sourceDisk.id());
        if (sourceDisk.osType() != null) {
            this.withOSType(sourceDisk.osType());
        }
        this.withSku(sourceDisk.sku());
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromSnapshot(String sourceSnapshotId) {
        ((SnapshotInner)((Object)this.innerModel())).withOsType(OperatingSystemTypes.WINDOWS).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(sourceSnapshotId);
        return this;
    }

    @Override
    public SnapshotImpl withWindowsFromSnapshot(Snapshot sourceSnapshot) {
        this.withWindowsFromSnapshot(sourceSnapshot.id());
        if (sourceSnapshot.osType() != null) {
            this.withOSType(sourceSnapshot.osType());
        }
        this.withSku(sourceSnapshot.skuType());
        return this;
    }

    @Override
    public SnapshotImpl withDataFromVhd(String vhdUrl) {
        return this.withDataFromVhd(vhdUrl, this.constructStorageAccountId(vhdUrl));
    }

    @Override
    public SnapshotImpl withDataFromVhd(String vhdUrl, String storageAccountId) {
        ((SnapshotInner)((Object)this.innerModel())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.IMPORT).withSourceUri(vhdUrl).withStorageAccountId(storageAccountId);
        return this;
    }

    @Override
    public SnapshotImpl withDataFromSnapshot(String snapshotId) {
        ((SnapshotInner)((Object)this.innerModel())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(snapshotId);
        return this;
    }

    @Override
    public SnapshotImpl withDataFromSnapshot(Snapshot snapshot) {
        return this.withDataFromSnapshot(snapshot.id());
    }

    @Override
    public SnapshotImpl withDataFromDisk(String managedDiskId) {
        ((SnapshotInner)((Object)this.innerModel())).withCreationData(new CreationData()).creationData().withCreateOption(DiskCreateOption.COPY).withSourceResourceId(managedDiskId);
        return this;
    }

    @Override
    public SnapshotImpl withDataFromDisk(Disk managedDisk) {
        return this.withDataFromDisk(managedDisk.id()).withOSType(managedDisk.osType()).withSku(managedDisk.sku());
    }

    @Override
    public SnapshotImpl withSizeInGB(int sizeInGB) {
        ((SnapshotInner)((Object)this.innerModel())).withDiskSizeGB(sizeInGB);
        return this;
    }

    @Override
    public SnapshotImpl withIncremental(boolean enabled) {
        ((SnapshotInner)((Object)this.innerModel())).withIncremental(enabled);
        return this;
    }

    @Override
    public SnapshotImpl withOSType(OperatingSystemTypes osType) {
        ((SnapshotInner)((Object)this.innerModel())).withOsType(osType);
        return this;
    }

    private SnapshotImpl withSku(DiskSkuTypes sku) {
        SnapshotSku snapshotSku = new SnapshotSku();
        snapshotSku.withName(SnapshotStorageAccountTypes.fromString(sku.accountType().toString()));
        ((SnapshotInner)((Object)this.innerModel())).withSku(snapshotSku);
        return this;
    }

    @Override
    public SnapshotImpl withSku(SnapshotSkuType sku) {
        ((SnapshotInner)((Object)this.innerModel())).withSku(new SnapshotSku().withName(sku.accountType()));
        return this;
    }

    public Mono<Snapshot> createResourceAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getSnapshots().createOrUpdateAsync(this.resourceGroupName(), this.name(), (SnapshotInner)((Object)this.innerModel())).map(this.innerToFluentMap((IndexableRefreshableWrapperImpl)this));
    }

    protected Mono<SnapshotInner> getInnerAsync() {
        return ((ComputeManagementClient)((ComputeManager)this.manager()).serviceClient()).getSnapshots().getByResourceGroupAsync(this.resourceGroupName(), this.name());
    }

    private String constructStorageAccountId(String vhdUrl) {
        try {
            return ResourceUtils.constructResourceId((String)((ComputeManager)this.manager()).subscriptionId(), (String)this.resourceGroupName(), (String)"Microsoft.Storage", (String)"storageAccounts", (String)vhdUrl.split("\\.")[0].replace("https://", ""), (String)"");
        }
        catch (RuntimeException ex) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException(String.format("%s is not valid URI of a blob to import.", vhdUrl)));
        }
    }
}

