/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.management.Resource;
import com.azure.core.management.SubResource;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineExtensionInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetVMInstanceViewInner;
import com.azure.resourcemanager.compute.fluent.models.VirtualMachineScaleSetVMPropertiesInner;
import com.azure.resourcemanager.compute.models.AdditionalCapabilities;
import com.azure.resourcemanager.compute.models.DiagnosticsProfile;
import com.azure.resourcemanager.compute.models.HardwareProfile;
import com.azure.resourcemanager.compute.models.NetworkProfile;
import com.azure.resourcemanager.compute.models.OSProfile;
import com.azure.resourcemanager.compute.models.Plan;
import com.azure.resourcemanager.compute.models.SecurityProfile;
import com.azure.resourcemanager.compute.models.Sku;
import com.azure.resourcemanager.compute.models.StorageProfile;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMNetworkProfileConfiguration;
import com.azure.resourcemanager.compute.models.VirtualMachineScaleSetVMProtectionPolicy;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import java.util.Map;

public final class VirtualMachineScaleSetVMInner
extends Resource {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(VirtualMachineScaleSetVMInner.class);
    @JsonProperty(value="instanceId", access=JsonProperty.Access.WRITE_ONLY)
    private String instanceId;
    @JsonProperty(value="sku", access=JsonProperty.Access.WRITE_ONLY)
    private Sku sku;
    @JsonProperty(value="properties")
    private VirtualMachineScaleSetVMPropertiesInner innerProperties;
    @JsonProperty(value="plan")
    private Plan plan;
    @JsonProperty(value="resources", access=JsonProperty.Access.WRITE_ONLY)
    private List<VirtualMachineExtensionInner> resources;
    @JsonProperty(value="zones", access=JsonProperty.Access.WRITE_ONLY)
    private List<String> zones;

    public String instanceId() {
        return this.instanceId;
    }

    public Sku sku() {
        return this.sku;
    }

    private VirtualMachineScaleSetVMPropertiesInner innerProperties() {
        return this.innerProperties;
    }

    public Plan plan() {
        return this.plan;
    }

    public VirtualMachineScaleSetVMInner withPlan(Plan plan) {
        this.plan = plan;
        return this;
    }

    public List<VirtualMachineExtensionInner> resources() {
        return this.resources;
    }

    public List<String> zones() {
        return this.zones;
    }

    public VirtualMachineScaleSetVMInner withLocation(String location) {
        super.withLocation(location);
        return this;
    }

    public VirtualMachineScaleSetVMInner withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    public Boolean latestModelApplied() {
        return this.innerProperties() == null ? null : this.innerProperties().latestModelApplied();
    }

    public String vmId() {
        return this.innerProperties() == null ? null : this.innerProperties().vmId();
    }

    public VirtualMachineScaleSetVMInstanceViewInner instanceView() {
        return this.innerProperties() == null ? null : this.innerProperties().instanceView();
    }

    public HardwareProfile hardwareProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().hardwareProfile();
    }

    public VirtualMachineScaleSetVMInner withHardwareProfile(HardwareProfile hardwareProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withHardwareProfile(hardwareProfile);
        return this;
    }

    public StorageProfile storageProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().storageProfile();
    }

    public VirtualMachineScaleSetVMInner withStorageProfile(StorageProfile storageProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withStorageProfile(storageProfile);
        return this;
    }

    public AdditionalCapabilities additionalCapabilities() {
        return this.innerProperties() == null ? null : this.innerProperties().additionalCapabilities();
    }

    public VirtualMachineScaleSetVMInner withAdditionalCapabilities(AdditionalCapabilities additionalCapabilities) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withAdditionalCapabilities(additionalCapabilities);
        return this;
    }

    public OSProfile osProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().osProfile();
    }

    public VirtualMachineScaleSetVMInner withOsProfile(OSProfile osProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withOsProfile(osProfile);
        return this;
    }

    public SecurityProfile securityProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().securityProfile();
    }

    public VirtualMachineScaleSetVMInner withSecurityProfile(SecurityProfile securityProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withSecurityProfile(securityProfile);
        return this;
    }

    public NetworkProfile networkProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().networkProfile();
    }

    public VirtualMachineScaleSetVMInner withNetworkProfile(NetworkProfile networkProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withNetworkProfile(networkProfile);
        return this;
    }

    public VirtualMachineScaleSetVMNetworkProfileConfiguration networkProfileConfiguration() {
        return this.innerProperties() == null ? null : this.innerProperties().networkProfileConfiguration();
    }

    public VirtualMachineScaleSetVMInner withNetworkProfileConfiguration(VirtualMachineScaleSetVMNetworkProfileConfiguration networkProfileConfiguration) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withNetworkProfileConfiguration(networkProfileConfiguration);
        return this;
    }

    public DiagnosticsProfile diagnosticsProfile() {
        return this.innerProperties() == null ? null : this.innerProperties().diagnosticsProfile();
    }

    public VirtualMachineScaleSetVMInner withDiagnosticsProfile(DiagnosticsProfile diagnosticsProfile) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withDiagnosticsProfile(diagnosticsProfile);
        return this;
    }

    public SubResource availabilitySet() {
        return this.innerProperties() == null ? null : this.innerProperties().availabilitySet();
    }

    public VirtualMachineScaleSetVMInner withAvailabilitySet(SubResource availabilitySet) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withAvailabilitySet(availabilitySet);
        return this;
    }

    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    public String licenseType() {
        return this.innerProperties() == null ? null : this.innerProperties().licenseType();
    }

    public VirtualMachineScaleSetVMInner withLicenseType(String licenseType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withLicenseType(licenseType);
        return this;
    }

    public String modelDefinitionApplied() {
        return this.innerProperties() == null ? null : this.innerProperties().modelDefinitionApplied();
    }

    public VirtualMachineScaleSetVMProtectionPolicy protectionPolicy() {
        return this.innerProperties() == null ? null : this.innerProperties().protectionPolicy();
    }

    public VirtualMachineScaleSetVMInner withProtectionPolicy(VirtualMachineScaleSetVMProtectionPolicy protectionPolicy) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withProtectionPolicy(protectionPolicy);
        return this;
    }

    public String userData() {
        return this.innerProperties() == null ? null : this.innerProperties().userData();
    }

    public VirtualMachineScaleSetVMInner withUserData(String userData) {
        if (this.innerProperties() == null) {
            this.innerProperties = new VirtualMachineScaleSetVMPropertiesInner();
        }
        this.innerProperties().withUserData(userData);
        return this;
    }

    public void validate() {
        if (this.sku() != null) {
            this.sku().validate();
        }
        if (this.innerProperties() != null) {
            this.innerProperties().validate();
        }
        if (this.plan() != null) {
            this.plan().validate();
        }
        if (this.resources() != null) {
            this.resources().forEach(e -> e.validate());
        }
    }
}

