/*
 * Decompiled with CFR 0.152.
 */
package com.azure.resourcemanager.compute.fluent.models;

import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.compute.models.Disallowed;
import com.azure.resourcemanager.compute.models.GalleryImageFeature;
import com.azure.resourcemanager.compute.models.GalleryImageIdentifier;
import com.azure.resourcemanager.compute.models.GalleryImagePropertiesProvisioningState;
import com.azure.resourcemanager.compute.models.HyperVGeneration;
import com.azure.resourcemanager.compute.models.ImagePurchasePlan;
import com.azure.resourcemanager.compute.models.OperatingSystemStateTypes;
import com.azure.resourcemanager.compute.models.OperatingSystemTypes;
import com.azure.resourcemanager.compute.models.RecommendedMachineConfiguration;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.OffsetDateTime;
import java.util.List;

public final class GalleryImageProperties {
    @JsonIgnore
    private final ClientLogger logger = new ClientLogger(GalleryImageProperties.class);
    @JsonProperty(value="description")
    private String description;
    @JsonProperty(value="eula")
    private String eula;
    @JsonProperty(value="privacyStatementUri")
    private String privacyStatementUri;
    @JsonProperty(value="releaseNoteUri")
    private String releaseNoteUri;
    @JsonProperty(value="osType", required=true)
    private OperatingSystemTypes osType;
    @JsonProperty(value="osState", required=true)
    private OperatingSystemStateTypes osState;
    @JsonProperty(value="hyperVGeneration")
    private HyperVGeneration hyperVGeneration;
    @JsonProperty(value="endOfLifeDate")
    private OffsetDateTime endOfLifeDate;
    @JsonProperty(value="identifier", required=true)
    private GalleryImageIdentifier identifier;
    @JsonProperty(value="recommended")
    private RecommendedMachineConfiguration recommended;
    @JsonProperty(value="disallowed")
    private Disallowed disallowed;
    @JsonProperty(value="purchasePlan")
    private ImagePurchasePlan purchasePlan;
    @JsonProperty(value="provisioningState", access=JsonProperty.Access.WRITE_ONLY)
    private GalleryImagePropertiesProvisioningState provisioningState;
    @JsonProperty(value="features")
    private List<GalleryImageFeature> features;

    public String description() {
        return this.description;
    }

    public GalleryImageProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    public String eula() {
        return this.eula;
    }

    public GalleryImageProperties withEula(String eula) {
        this.eula = eula;
        return this;
    }

    public String privacyStatementUri() {
        return this.privacyStatementUri;
    }

    public GalleryImageProperties withPrivacyStatementUri(String privacyStatementUri) {
        this.privacyStatementUri = privacyStatementUri;
        return this;
    }

    public String releaseNoteUri() {
        return this.releaseNoteUri;
    }

    public GalleryImageProperties withReleaseNoteUri(String releaseNoteUri) {
        this.releaseNoteUri = releaseNoteUri;
        return this;
    }

    public OperatingSystemTypes osType() {
        return this.osType;
    }

    public GalleryImageProperties withOsType(OperatingSystemTypes osType) {
        this.osType = osType;
        return this;
    }

    public OperatingSystemStateTypes osState() {
        return this.osState;
    }

    public GalleryImageProperties withOsState(OperatingSystemStateTypes osState) {
        this.osState = osState;
        return this;
    }

    public HyperVGeneration hyperVGeneration() {
        return this.hyperVGeneration;
    }

    public GalleryImageProperties withHyperVGeneration(HyperVGeneration hyperVGeneration) {
        this.hyperVGeneration = hyperVGeneration;
        return this;
    }

    public OffsetDateTime endOfLifeDate() {
        return this.endOfLifeDate;
    }

    public GalleryImageProperties withEndOfLifeDate(OffsetDateTime endOfLifeDate) {
        this.endOfLifeDate = endOfLifeDate;
        return this;
    }

    public GalleryImageIdentifier identifier() {
        return this.identifier;
    }

    public GalleryImageProperties withIdentifier(GalleryImageIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    public RecommendedMachineConfiguration recommended() {
        return this.recommended;
    }

    public GalleryImageProperties withRecommended(RecommendedMachineConfiguration recommended) {
        this.recommended = recommended;
        return this;
    }

    public Disallowed disallowed() {
        return this.disallowed;
    }

    public GalleryImageProperties withDisallowed(Disallowed disallowed) {
        this.disallowed = disallowed;
        return this;
    }

    public ImagePurchasePlan purchasePlan() {
        return this.purchasePlan;
    }

    public GalleryImageProperties withPurchasePlan(ImagePurchasePlan purchasePlan) {
        this.purchasePlan = purchasePlan;
        return this;
    }

    public GalleryImagePropertiesProvisioningState provisioningState() {
        return this.provisioningState;
    }

    public List<GalleryImageFeature> features() {
        return this.features;
    }

    public GalleryImageProperties withFeatures(List<GalleryImageFeature> features) {
        this.features = features;
        return this;
    }

    public void validate() {
        if (this.osType() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property osType in model GalleryImageProperties"));
        }
        if (this.osState() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property osState in model GalleryImageProperties"));
        }
        if (this.identifier() == null) {
            throw this.logger.logExceptionAsError((RuntimeException)new IllegalArgumentException("Missing required property identifier in model GalleryImageProperties"));
        }
        this.identifier().validate();
        if (this.recommended() != null) {
            this.recommended().validate();
        }
        if (this.disallowed() != null) {
            this.disallowed().validate();
        }
        if (this.purchasePlan() != null) {
            this.purchasePlan().validate();
        }
        if (this.features() != null) {
            this.features().forEach(e -> e.validate());
        }
    }
}

