/*
 * Decompiled with CFR 0.152.
 */
package net.extg.cabinetmaker;

import java.util.ArrayList;
import java.util.Vector;
import net.extg.cabinetmaker.CFData;
import net.extg.cabinetmaker.CFFile;
import net.extg.cabinetmaker.CFFolder;
import net.extg.cabinetmaker.CFHeader;

public class CabFile {
    private CFHeader header = new CFHeader();
    private Vector<CFFolder> folders;
    private Vector<CFFile> files;
    private Vector<CFData> cfdata = new Vector();
    private Vector<Byte> data;

    /*
     * WARNING - void declaration
     */
    public CabFile(Vector<String> filenames, Vector<byte[]> fileContents) {
        Vector<Byte> alldata = new Vector<Byte>();
        for (byte[] b : fileContents) {
            for (int i = 0; i < b.length; ++i) {
                alldata.add(b[i]);
            }
        }
        ArrayList dataSet = new ArrayList();
        while (alldata.size() > 0) {
            Vector tempBytes = new Vector();
            for (int i = 0; i < 32768 && i < alldata.size(); ++i) {
                tempBytes.add(alldata.get(i));
            }
            dataSet.add(tempBytes);
            if (alldata.size() >= 32768) {
                alldata.subList(0, 32768).clear();
                continue;
            }
            alldata.clear();
        }
        for (Vector vector : dataSet) {
            this.cfdata.add(new CFData(vector));
        }
        boolean bl = false;
        this.files = new Vector();
        for (int i2 = 0; i2 < filenames.size(); ++i2) {
            void var6_11;
            CFFile tempFile = new CFFile(filenames.get(i2), fileContents.get(i2).length, (int)var6_11, 0);
            var6_11 += fileContents.get(i2).length;
            this.files.add(tempFile);
        }
        this.folders = new Vector();
        CFFolder tempFolder = new CFFolder();
        tempFolder.setCCFData(this.cfdata.size());
        this.folders.add(tempFolder);
        int dataBlockOffset = this.header.makeByteArray().size();
        for (CFFolder cFFolder : this.folders) {
            dataBlockOffset += cFFolder.makeByteArray().size();
        }
        int filesBlockOffset = dataBlockOffset;
        for (CFFile cFFile : this.files) {
            dataBlockOffset += cFFile.makeByteArray().size();
        }
        this.folders.get(0).setCoffCabStart(dataBlockOffset);
        this.header.setCFolders(this.folders.size());
        this.header.setCFiles(this.files.size());
        this.header.setCoffFiles(filesBlockOffset);
        int cabFileSize = 0;
        for (CFData cFData : this.cfdata) {
            cabFileSize += cFData.makeByteArray().size();
        }
        this.header.setCbCabinet(dataBlockOffset + cabFileSize);
        this.data = new Vector();
        this.data.addAll(this.header.makeByteArray());
        for (CFFolder cFFolder : this.folders) {
            this.data.addAll(cFFolder.makeByteArray());
        }
        for (CFFile cFFile : this.files) {
            this.data.addAll(cFFile.makeByteArray());
        }
        for (CFData cFData : this.cfdata) {
            this.data.addAll(cFData.makeByteArray());
        }
    }

    public byte[] getCabFile() {
        byte[] bytes = new byte[this.data.size()];
        for (int i = 0; i < this.data.size(); ++i) {
            bytes[i] = this.data.get(i);
        }
        return bytes;
    }
}

