/*
 * Decompiled with CFR 0.152.
 */
package net.extg.cabinetmaker;

import java.util.Calendar;
import java.util.Vector;

public class CFFile {
    private int cbFile;
    private int uoffFolderStart;
    private int iFolder;
    private int date;
    private int time;
    private int attribs;
    private int[] szName;

    public CFFile(String filename, int size, int offset, int folderNumber) {
        Calendar c = Calendar.getInstance();
        int year = c.get(1);
        int month = c.get(2);
        int day = c.get(5);
        int hours = c.get(11);
        int minutes = c.get(12);
        int seconds = c.get(13);
        this.date = (year - 1980 << 9) + (month << 5) + day;
        this.time = (hours << 11) + (minutes << 5) + seconds / 2;
        this.attribs = 128;
        this.setFilename(filename);
        this.cbFile = size;
        this.uoffFolderStart = offset;
        this.iFolder = folderNumber;
    }

    private void setFilename(String filename) {
        this.szName = new int[filename.length() + 1];
        for (int i = 0; i < filename.length(); ++i) {
            this.szName[i] = filename.charAt(i);
        }
        this.szName[filename.length()] = 0;
    }

    public Vector<Byte> makeByteArray() {
        Vector<Byte> b = new Vector<Byte>();
        b.addAll(this.convertToByte(this.cbFile, 4));
        b.addAll(this.convertToByte(this.uoffFolderStart, 4));
        b.addAll(this.convertToByte(this.iFolder, 2));
        b.addAll(this.convertToByte(this.date, 2));
        b.addAll(this.convertToByte(this.time, 2));
        b.addAll(this.convertToByte(this.attribs, 2));
        for (int i = 0; i < this.szName.length; ++i) {
            b.addAll(this.convertToByte(this.szName[i], 1));
        }
        return b;
    }

    private Vector<Byte> convertToByte(int val, int numBytes) {
        Vector<Byte> b = new Vector<Byte>();
        if (numBytes == 1) {
            Integer tempInt = new Integer(val);
            Byte byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
        } else if (numBytes == 2) {
            Integer tempInt = new Integer(0xFF & val);
            Byte byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF00 & val) >>> 8);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
        } else if (numBytes == 3) {
            Integer tempInt = new Integer(0xFF & val);
            Byte byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF00 & val) >>> 8);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF0000 & val) >>> 16);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
        } else if (numBytes == 4) {
            Integer tempInt = new Integer(0xFF & val);
            Byte byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF00 & val) >>> 8);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF0000 & val) >>> 16);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
            tempInt = new Integer((0xFF000000 & val) >>> 24);
            byteToAdd = new Byte(tempInt.byteValue());
            b.add(byteToAdd);
        } else {
            b.add(new Byte("255"));
        }
        return b;
    }
}

