/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.tasks;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.tasks.TasksRequest;
import com.google.api.services.tasks.TasksRequestInitializer;
import com.google.api.services.tasks.model.Task;
import com.google.api.services.tasks.model.TaskList;
import com.google.api.services.tasks.model.TaskLists;
import java.io.IOException;

public class Tasks
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://tasks.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://tasks.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://tasks.googleapis.com/";

    public Tasks(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    Tasks(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Tasklists tasklists() {
        return new Tasklists();
    }

    public TasksOperations tasks() {
        return new TasksOperations();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Google Tasks API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return Tasks.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://tasks.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), Tasks.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(Tasks.DEFAULT_BATCH_PATH);
        }

        public Tasks build() {
            return new Tasks(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setTasksRequestInitializer(TasksRequestInitializer tasksRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)tasksRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }

        public Builder setUniverseDomain(String universeDomain) {
            return (Builder)super.setUniverseDomain(universeDomain);
        }
    }

    public class TasksOperations {
        public Clear clear(String tasklist) throws IOException {
            Clear result = new Clear(tasklist);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Delete delete(String tasklist, String task) throws IOException {
            Delete result = new Delete(tasklist, task);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String tasklist, String task) throws IOException {
            Get result = new Get(tasklist, task);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(String tasklist, Task content) throws IOException {
            Insert result = new Insert(tasklist, content);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list(String tasklist) throws IOException {
            List result = new List(tasklist);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Move move(String tasklist, String task) throws IOException {
            Move result = new Move(tasklist, task);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String tasklist, String task, Task content) throws IOException {
            Patch result = new Patch(tasklist, task, content);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String tasklist, String task, Task content) throws IOException {
            Update result = new Update(tasklist, task, content);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends TasksRequest<Task> {
            private static final String REST_PATH = "tasks/v1/lists/{tasklist}/tasks/{task}";
            @Key
            private String tasklist;
            @Key
            private String task;

            protected Update(String tasklist, String task, Task content) {
                super(Tasks.this, "PUT", REST_PATH, (Object)content, Task.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)tasklist, (Object)"Required parameter tasklist must be specified.");
                this.task = (String)Preconditions.checkNotNull((Object)task, (Object)"Required parameter task must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Update setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            public String getTask() {
                return this.task;
            }

            public Update setTask(String task) {
                this.task = task;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends TasksRequest<Task> {
            private static final String REST_PATH = "tasks/v1/lists/{tasklist}/tasks/{task}";
            @Key
            private String tasklist;
            @Key
            private String task;

            protected Patch(String tasklist, String task, Task content) {
                super(Tasks.this, "PATCH", REST_PATH, (Object)content, Task.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)tasklist, (Object)"Required parameter tasklist must be specified.");
                this.task = (String)Preconditions.checkNotNull((Object)task, (Object)"Required parameter task must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Patch setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            public String getTask() {
                return this.task;
            }

            public Patch setTask(String task) {
                this.task = task;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class Move
        extends TasksRequest<Task> {
            private static final String REST_PATH = "tasks/v1/lists/{tasklist}/tasks/{task}/move";
            @Key
            private String tasklist;
            @Key
            private String task;
            @Key
            private String destinationTasklist;
            @Key
            private String parent;
            @Key
            private String previous;

            protected Move(String tasklist, String task) {
                super(Tasks.this, "POST", REST_PATH, null, Task.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)tasklist, (Object)"Required parameter tasklist must be specified.");
                this.task = (String)Preconditions.checkNotNull((Object)task, (Object)"Required parameter task must be specified.");
            }

            public Move set$Xgafv(String $Xgafv) {
                return (Move)super.set$Xgafv($Xgafv);
            }

            public Move setAccessToken(String accessToken) {
                return (Move)super.setAccessToken(accessToken);
            }

            public Move setAlt(String alt) {
                return (Move)super.setAlt(alt);
            }

            public Move setCallback(String callback) {
                return (Move)super.setCallback(callback);
            }

            public Move setFields(String fields) {
                return (Move)super.setFields(fields);
            }

            public Move setKey(String key) {
                return (Move)super.setKey(key);
            }

            public Move setOauthToken(String oauthToken) {
                return (Move)super.setOauthToken(oauthToken);
            }

            public Move setPrettyPrint(Boolean prettyPrint) {
                return (Move)super.setPrettyPrint(prettyPrint);
            }

            public Move setQuotaUser(String quotaUser) {
                return (Move)super.setQuotaUser(quotaUser);
            }

            public Move setUploadType(String uploadType) {
                return (Move)super.setUploadType(uploadType);
            }

            public Move setUploadProtocol(String uploadProtocol) {
                return (Move)super.setUploadProtocol(uploadProtocol);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Move setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            public String getTask() {
                return this.task;
            }

            public Move setTask(String task) {
                this.task = task;
                return this;
            }

            public String getDestinationTasklist() {
                return this.destinationTasklist;
            }

            public Move setDestinationTasklist(String destinationTasklist) {
                this.destinationTasklist = destinationTasklist;
                return this;
            }

            public String getParent() {
                return this.parent;
            }

            public Move setParent(String parent) {
                this.parent = parent;
                return this;
            }

            public String getPrevious() {
                return this.previous;
            }

            public Move setPrevious(String previous) {
                this.previous = previous;
                return this;
            }

            @Override
            public Move set(String parameterName, Object value) {
                return (Move)super.set(parameterName, value);
            }
        }

        public class List
        extends TasksRequest<com.google.api.services.tasks.model.Tasks> {
            private static final String REST_PATH = "tasks/v1/lists/{tasklist}/tasks";
            @Key
            private String tasklist;
            @Key
            private String completedMax;
            @Key
            private String completedMin;
            @Key
            private String dueMax;
            @Key
            private String dueMin;
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;
            @Key
            private Boolean showAssigned;
            @Key
            private Boolean showCompleted;
            @Key
            private Boolean showDeleted;
            @Key
            private Boolean showHidden;
            @Key
            private String updatedMin;

            protected List(String tasklist) {
                super(Tasks.this, "GET", REST_PATH, null, com.google.api.services.tasks.model.Tasks.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)tasklist, (Object)"Required parameter tasklist must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public List setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            public String getCompletedMax() {
                return this.completedMax;
            }

            public List setCompletedMax(String completedMax) {
                this.completedMax = completedMax;
                return this;
            }

            public String getCompletedMin() {
                return this.completedMin;
            }

            public List setCompletedMin(String completedMin) {
                this.completedMin = completedMin;
                return this;
            }

            public String getDueMax() {
                return this.dueMax;
            }

            public List setDueMax(String dueMax) {
                this.dueMax = dueMax;
                return this;
            }

            public String getDueMin() {
                return this.dueMin;
            }

            public List setDueMin(String dueMin) {
                this.dueMin = dueMin;
                return this;
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            public Boolean getShowAssigned() {
                return this.showAssigned;
            }

            public List setShowAssigned(Boolean showAssigned) {
                this.showAssigned = showAssigned;
                return this;
            }

            public Boolean getShowCompleted() {
                return this.showCompleted;
            }

            public List setShowCompleted(Boolean showCompleted) {
                this.showCompleted = showCompleted;
                return this;
            }

            public Boolean getShowDeleted() {
                return this.showDeleted;
            }

            public List setShowDeleted(Boolean showDeleted) {
                this.showDeleted = showDeleted;
                return this;
            }

            public Boolean getShowHidden() {
                return this.showHidden;
            }

            public List setShowHidden(Boolean showHidden) {
                this.showHidden = showHidden;
                return this;
            }

            public String getUpdatedMin() {
                return this.updatedMin;
            }

            public List setUpdatedMin(String updatedMin) {
                this.updatedMin = updatedMin;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends TasksRequest<Task> {
            private static final String REST_PATH = "tasks/v1/lists/{tasklist}/tasks";
            @Key
            private String tasklist;
            @Key
            private String parent;
            @Key
            private String previous;

            protected Insert(String tasklist, Task content) {
                super(Tasks.this, "POST", REST_PATH, (Object)content, Task.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)tasklist, (Object)"Required parameter tasklist must be specified.");
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Insert setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            public String getParent() {
                return this.parent;
            }

            public Insert setParent(String parent) {
                this.parent = parent;
                return this;
            }

            public String getPrevious() {
                return this.previous;
            }

            public Insert setPrevious(String previous) {
                this.previous = previous;
                return this;
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends TasksRequest<Task> {
            private static final String REST_PATH = "tasks/v1/lists/{tasklist}/tasks/{task}";
            @Key
            private String tasklist;
            @Key
            private String task;

            protected Get(String tasklist, String task) {
                super(Tasks.this, "GET", REST_PATH, null, Task.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)tasklist, (Object)"Required parameter tasklist must be specified.");
                this.task = (String)Preconditions.checkNotNull((Object)task, (Object)"Required parameter task must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Get setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            public String getTask() {
                return this.task;
            }

            public Get setTask(String task) {
                this.task = task;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends TasksRequest<Void> {
            private static final String REST_PATH = "tasks/v1/lists/{tasklist}/tasks/{task}";
            @Key
            private String tasklist;
            @Key
            private String task;

            protected Delete(String tasklist, String task) {
                super(Tasks.this, "DELETE", REST_PATH, null, Void.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)tasklist, (Object)"Required parameter tasklist must be specified.");
                this.task = (String)Preconditions.checkNotNull((Object)task, (Object)"Required parameter task must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Delete setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            public String getTask() {
                return this.task;
            }

            public Delete setTask(String task) {
                this.task = task;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }

        public class Clear
        extends TasksRequest<Void> {
            private static final String REST_PATH = "tasks/v1/lists/{tasklist}/clear";
            @Key
            private String tasklist;

            protected Clear(String tasklist) {
                super(Tasks.this, "POST", REST_PATH, null, Void.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)tasklist, (Object)"Required parameter tasklist must be specified.");
            }

            public Clear set$Xgafv(String $Xgafv) {
                return (Clear)super.set$Xgafv($Xgafv);
            }

            public Clear setAccessToken(String accessToken) {
                return (Clear)super.setAccessToken(accessToken);
            }

            public Clear setAlt(String alt) {
                return (Clear)super.setAlt(alt);
            }

            public Clear setCallback(String callback) {
                return (Clear)super.setCallback(callback);
            }

            public Clear setFields(String fields) {
                return (Clear)super.setFields(fields);
            }

            public Clear setKey(String key) {
                return (Clear)super.setKey(key);
            }

            public Clear setOauthToken(String oauthToken) {
                return (Clear)super.setOauthToken(oauthToken);
            }

            public Clear setPrettyPrint(Boolean prettyPrint) {
                return (Clear)super.setPrettyPrint(prettyPrint);
            }

            public Clear setQuotaUser(String quotaUser) {
                return (Clear)super.setQuotaUser(quotaUser);
            }

            public Clear setUploadType(String uploadType) {
                return (Clear)super.setUploadType(uploadType);
            }

            public Clear setUploadProtocol(String uploadProtocol) {
                return (Clear)super.setUploadProtocol(uploadProtocol);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Clear setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            @Override
            public Clear set(String parameterName, Object value) {
                return (Clear)super.set(parameterName, value);
            }
        }
    }

    public class Tasklists {
        public Delete delete(String tasklist) throws IOException {
            Delete result = new Delete(tasklist);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Get get(String tasklist) throws IOException {
            Get result = new Get(tasklist);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Insert insert(TaskList content) throws IOException {
            Insert result = new Insert(content);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public List list() throws IOException {
            List result = new List();
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Patch patch(String tasklist, TaskList content) throws IOException {
            Patch result = new Patch(tasklist, content);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Update update(String tasklist, TaskList content) throws IOException {
            Update result = new Update(tasklist, content);
            Tasks.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public class Update
        extends TasksRequest<TaskList> {
            private static final String REST_PATH = "tasks/v1/users/@me/lists/{tasklist}";
            @Key
            private String tasklist;

            protected Update(String tasklist, TaskList content) {
                super(Tasks.this, "PUT", REST_PATH, (Object)content, TaskList.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)tasklist, (Object)"Required parameter tasklist must be specified.");
            }

            public Update set$Xgafv(String $Xgafv) {
                return (Update)super.set$Xgafv($Xgafv);
            }

            public Update setAccessToken(String accessToken) {
                return (Update)super.setAccessToken(accessToken);
            }

            public Update setAlt(String alt) {
                return (Update)super.setAlt(alt);
            }

            public Update setCallback(String callback) {
                return (Update)super.setCallback(callback);
            }

            public Update setFields(String fields) {
                return (Update)super.setFields(fields);
            }

            public Update setKey(String key) {
                return (Update)super.setKey(key);
            }

            public Update setOauthToken(String oauthToken) {
                return (Update)super.setOauthToken(oauthToken);
            }

            public Update setPrettyPrint(Boolean prettyPrint) {
                return (Update)super.setPrettyPrint(prettyPrint);
            }

            public Update setQuotaUser(String quotaUser) {
                return (Update)super.setQuotaUser(quotaUser);
            }

            public Update setUploadType(String uploadType) {
                return (Update)super.setUploadType(uploadType);
            }

            public Update setUploadProtocol(String uploadProtocol) {
                return (Update)super.setUploadProtocol(uploadProtocol);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Update setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            @Override
            public Update set(String parameterName, Object value) {
                return (Update)super.set(parameterName, value);
            }
        }

        public class Patch
        extends TasksRequest<TaskList> {
            private static final String REST_PATH = "tasks/v1/users/@me/lists/{tasklist}";
            @Key
            private String tasklist;

            protected Patch(String tasklist, TaskList content) {
                super(Tasks.this, "PATCH", REST_PATH, (Object)content, TaskList.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)tasklist, (Object)"Required parameter tasklist must be specified.");
            }

            public Patch set$Xgafv(String $Xgafv) {
                return (Patch)super.set$Xgafv($Xgafv);
            }

            public Patch setAccessToken(String accessToken) {
                return (Patch)super.setAccessToken(accessToken);
            }

            public Patch setAlt(String alt) {
                return (Patch)super.setAlt(alt);
            }

            public Patch setCallback(String callback) {
                return (Patch)super.setCallback(callback);
            }

            public Patch setFields(String fields) {
                return (Patch)super.setFields(fields);
            }

            public Patch setKey(String key) {
                return (Patch)super.setKey(key);
            }

            public Patch setOauthToken(String oauthToken) {
                return (Patch)super.setOauthToken(oauthToken);
            }

            public Patch setPrettyPrint(Boolean prettyPrint) {
                return (Patch)super.setPrettyPrint(prettyPrint);
            }

            public Patch setQuotaUser(String quotaUser) {
                return (Patch)super.setQuotaUser(quotaUser);
            }

            public Patch setUploadType(String uploadType) {
                return (Patch)super.setUploadType(uploadType);
            }

            public Patch setUploadProtocol(String uploadProtocol) {
                return (Patch)super.setUploadProtocol(uploadProtocol);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Patch setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            @Override
            public Patch set(String parameterName, Object value) {
                return (Patch)super.set(parameterName, value);
            }
        }

        public class List
        extends TasksRequest<TaskLists> {
            private static final String REST_PATH = "tasks/v1/users/@me/lists";
            @Key
            private Integer maxResults;
            @Key
            private String pageToken;

            protected List() {
                super(Tasks.this, "GET", REST_PATH, null, TaskLists.class);
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public List set$Xgafv(String $Xgafv) {
                return (List)super.set$Xgafv($Xgafv);
            }

            public List setAccessToken(String accessToken) {
                return (List)super.setAccessToken(accessToken);
            }

            public List setAlt(String alt) {
                return (List)super.setAlt(alt);
            }

            public List setCallback(String callback) {
                return (List)super.setCallback(callback);
            }

            public List setFields(String fields) {
                return (List)super.setFields(fields);
            }

            public List setKey(String key) {
                return (List)super.setKey(key);
            }

            public List setOauthToken(String oauthToken) {
                return (List)super.setOauthToken(oauthToken);
            }

            public List setPrettyPrint(Boolean prettyPrint) {
                return (List)super.setPrettyPrint(prettyPrint);
            }

            public List setQuotaUser(String quotaUser) {
                return (List)super.setQuotaUser(quotaUser);
            }

            public List setUploadType(String uploadType) {
                return (List)super.setUploadType(uploadType);
            }

            public List setUploadProtocol(String uploadProtocol) {
                return (List)super.setUploadProtocol(uploadProtocol);
            }

            public Integer getMaxResults() {
                return this.maxResults;
            }

            public List setMaxResults(Integer maxResults) {
                this.maxResults = maxResults;
                return this;
            }

            public String getPageToken() {
                return this.pageToken;
            }

            public List setPageToken(String pageToken) {
                this.pageToken = pageToken;
                return this;
            }

            @Override
            public List set(String parameterName, Object value) {
                return (List)super.set(parameterName, value);
            }
        }

        public class Insert
        extends TasksRequest<TaskList> {
            private static final String REST_PATH = "tasks/v1/users/@me/lists";

            protected Insert(TaskList content) {
                super(Tasks.this, "POST", REST_PATH, (Object)content, TaskList.class);
            }

            public Insert set$Xgafv(String $Xgafv) {
                return (Insert)super.set$Xgafv($Xgafv);
            }

            public Insert setAccessToken(String accessToken) {
                return (Insert)super.setAccessToken(accessToken);
            }

            public Insert setAlt(String alt) {
                return (Insert)super.setAlt(alt);
            }

            public Insert setCallback(String callback) {
                return (Insert)super.setCallback(callback);
            }

            public Insert setFields(String fields) {
                return (Insert)super.setFields(fields);
            }

            public Insert setKey(String key) {
                return (Insert)super.setKey(key);
            }

            public Insert setOauthToken(String oauthToken) {
                return (Insert)super.setOauthToken(oauthToken);
            }

            public Insert setPrettyPrint(Boolean prettyPrint) {
                return (Insert)super.setPrettyPrint(prettyPrint);
            }

            public Insert setQuotaUser(String quotaUser) {
                return (Insert)super.setQuotaUser(quotaUser);
            }

            public Insert setUploadType(String uploadType) {
                return (Insert)super.setUploadType(uploadType);
            }

            public Insert setUploadProtocol(String uploadProtocol) {
                return (Insert)super.setUploadProtocol(uploadProtocol);
            }

            @Override
            public Insert set(String parameterName, Object value) {
                return (Insert)super.set(parameterName, value);
            }
        }

        public class Get
        extends TasksRequest<TaskList> {
            private static final String REST_PATH = "tasks/v1/users/@me/lists/{tasklist}";
            @Key
            private String tasklist;

            protected Get(String tasklist) {
                super(Tasks.this, "GET", REST_PATH, null, TaskList.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)tasklist, (Object)"Required parameter tasklist must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public Get set$Xgafv(String $Xgafv) {
                return (Get)super.set$Xgafv($Xgafv);
            }

            public Get setAccessToken(String accessToken) {
                return (Get)super.setAccessToken(accessToken);
            }

            public Get setAlt(String alt) {
                return (Get)super.setAlt(alt);
            }

            public Get setCallback(String callback) {
                return (Get)super.setCallback(callback);
            }

            public Get setFields(String fields) {
                return (Get)super.setFields(fields);
            }

            public Get setKey(String key) {
                return (Get)super.setKey(key);
            }

            public Get setOauthToken(String oauthToken) {
                return (Get)super.setOauthToken(oauthToken);
            }

            public Get setPrettyPrint(Boolean prettyPrint) {
                return (Get)super.setPrettyPrint(prettyPrint);
            }

            public Get setQuotaUser(String quotaUser) {
                return (Get)super.setQuotaUser(quotaUser);
            }

            public Get setUploadType(String uploadType) {
                return (Get)super.setUploadType(uploadType);
            }

            public Get setUploadProtocol(String uploadProtocol) {
                return (Get)super.setUploadProtocol(uploadProtocol);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Get setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            @Override
            public Get set(String parameterName, Object value) {
                return (Get)super.set(parameterName, value);
            }
        }

        public class Delete
        extends TasksRequest<Void> {
            private static final String REST_PATH = "tasks/v1/users/@me/lists/{tasklist}";
            @Key
            private String tasklist;

            protected Delete(String tasklist) {
                super(Tasks.this, "DELETE", REST_PATH, null, Void.class);
                this.tasklist = (String)Preconditions.checkNotNull((Object)tasklist, (Object)"Required parameter tasklist must be specified.");
            }

            public Delete set$Xgafv(String $Xgafv) {
                return (Delete)super.set$Xgafv($Xgafv);
            }

            public Delete setAccessToken(String accessToken) {
                return (Delete)super.setAccessToken(accessToken);
            }

            public Delete setAlt(String alt) {
                return (Delete)super.setAlt(alt);
            }

            public Delete setCallback(String callback) {
                return (Delete)super.setCallback(callback);
            }

            public Delete setFields(String fields) {
                return (Delete)super.setFields(fields);
            }

            public Delete setKey(String key) {
                return (Delete)super.setKey(key);
            }

            public Delete setOauthToken(String oauthToken) {
                return (Delete)super.setOauthToken(oauthToken);
            }

            public Delete setPrettyPrint(Boolean prettyPrint) {
                return (Delete)super.setPrettyPrint(prettyPrint);
            }

            public Delete setQuotaUser(String quotaUser) {
                return (Delete)super.setQuotaUser(quotaUser);
            }

            public Delete setUploadType(String uploadType) {
                return (Delete)super.setUploadType(uploadType);
            }

            public Delete setUploadProtocol(String uploadProtocol) {
                return (Delete)super.setUploadProtocol(uploadProtocol);
            }

            public String getTasklist() {
                return this.tasklist;
            }

            public Delete setTasklist(String tasklist) {
                this.tasklist = tasklist;
                return this;
            }

            @Override
            public Delete set(String parameterName, Object value) {
                return (Delete)super.set(parameterName, value);
            }
        }
    }
}

