/*
 * Decompiled with CFR 0.152.
 */
package org.xerial.snappy;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xerial.snappy.Snappy;
import org.xerial.snappy.SnappyCodec;
import org.xerial.snappy.SnappyErrorCode;
import org.xerial.snappy.SnappyIOException;
import org.xerial.snappy.SnappyOutputStream;
import org.xerial.snappy.SnappyUtil;

public class SnappyInputStream
extends InputStream {
    private boolean finishedReading = false;
    protected final InputStream in;
    private byte[] compressed;
    private byte[] uncompressed;
    private int uncompressedCursor = 0;
    private int uncompressedLimit = 0;
    private byte[] header = new byte[SnappyCodec.headerSize()];

    public SnappyInputStream(InputStream input) throws IOException {
        this.in = input;
        this.readHeader();
    }

    @Override
    public void close() throws IOException {
        this.compressed = null;
        this.uncompressed = null;
        if (this.in != null) {
            this.in.close();
        }
    }

    protected void readHeader() throws IOException {
        int readBytes;
        int ret;
        for (readBytes = 0; readBytes < this.header.length && (ret = this.in.read(this.header, readBytes, this.header.length - readBytes)) != -1; readBytes += ret) {
        }
        if (readBytes == 0) {
            throw new SnappyIOException(SnappyErrorCode.EMPTY_INPUT, "Cannot decompress empty stream");
        }
        if (readBytes < this.header.length || !SnappyCodec.hasMagicHeaderPrefix(this.header)) {
            this.readFully(this.header, readBytes);
            return;
        }
    }

    private static boolean isValidHeader(byte[] header) throws IOException {
        SnappyCodec codec = SnappyCodec.readHeader(new ByteArrayInputStream(header));
        if (codec.isValidMagicHeader()) {
            if (codec.version < 1) {
                throw new SnappyIOException(SnappyErrorCode.INCOMPATIBLE_VERSION, String.format("Compressed with an incompatible codec version %d. At least version %d is required", codec.version, 1));
            }
            return true;
        }
        return false;
    }

    protected void readFully(byte[] fragment, int fragmentLength) throws IOException {
        if (fragmentLength == 0) {
            this.finishedReading = true;
            return;
        }
        this.compressed = new byte[Math.max(8192, fragmentLength)];
        System.arraycopy(fragment, 0, this.compressed, 0, fragmentLength);
        int cursor = fragmentLength;
        int readBytes = 0;
        while ((readBytes = this.in.read(this.compressed, cursor, this.compressed.length - cursor)) != -1) {
            if ((cursor += readBytes) < this.compressed.length) continue;
            byte[] newBuf = new byte[this.compressed.length * 2];
            System.arraycopy(this.compressed, 0, newBuf, 0, this.compressed.length);
            this.compressed = newBuf;
        }
        this.finishedReading = true;
        int uncompressedLength = Snappy.uncompressedLength(this.compressed, 0, cursor);
        this.uncompressed = new byte[uncompressedLength];
        Snappy.uncompress(this.compressed, 0, cursor, this.uncompressed, 0);
        this.uncompressedCursor = 0;
        this.uncompressedLimit = uncompressedLength;
    }

    @Override
    public int read(byte[] b, int byteOffset, int byteLength) throws IOException {
        int writtenBytes = 0;
        while (writtenBytes < byteLength) {
            if (this.uncompressedCursor >= this.uncompressedLimit) {
                if (this.hasNextChunk()) continue;
                return writtenBytes == 0 ? -1 : writtenBytes;
            }
            int bytesToWrite = Math.min(this.uncompressedLimit - this.uncompressedCursor, byteLength - writtenBytes);
            System.arraycopy(this.uncompressed, this.uncompressedCursor, b, byteOffset + writtenBytes, bytesToWrite);
            writtenBytes += bytesToWrite;
            this.uncompressedCursor += bytesToWrite;
        }
        return writtenBytes;
    }

    public int rawRead(Object array, int byteOffset, int byteLength) throws IOException {
        int writtenBytes = 0;
        while (writtenBytes < byteLength) {
            if (this.uncompressedCursor >= this.uncompressedLimit) {
                if (this.hasNextChunk()) continue;
                return writtenBytes == 0 ? -1 : writtenBytes;
            }
            int bytesToWrite = Math.min(this.uncompressedLimit - this.uncompressedCursor, byteLength - writtenBytes);
            Snappy.arrayCopy(this.uncompressed, this.uncompressedCursor, bytesToWrite, array, byteOffset + writtenBytes);
            writtenBytes += bytesToWrite;
            this.uncompressedCursor += bytesToWrite;
        }
        return writtenBytes;
    }

    public int read(long[] d, int off, int len) throws IOException {
        return this.rawRead(d, off * 8, len * 8);
    }

    public int read(long[] d) throws IOException {
        return this.read(d, 0, d.length);
    }

    public int read(double[] d, int off, int len) throws IOException {
        return this.rawRead(d, off * 8, len * 8);
    }

    public int read(double[] d) throws IOException {
        return this.read(d, 0, d.length);
    }

    public int read(int[] d) throws IOException {
        return this.read(d, 0, d.length);
    }

    public int read(int[] d, int off, int len) throws IOException {
        return this.rawRead(d, off * 4, len * 4);
    }

    public int read(float[] d, int off, int len) throws IOException {
        return this.rawRead(d, off * 4, len * 4);
    }

    public int read(float[] d) throws IOException {
        return this.read(d, 0, d.length);
    }

    public int read(short[] d, int off, int len) throws IOException {
        return this.rawRead(d, off * 2, len * 2);
    }

    public int read(short[] d) throws IOException {
        return this.read(d, 0, d.length);
    }

    private int readNext(byte[] dest, int offset, int len) throws IOException {
        int readBytes;
        int ret;
        for (readBytes = 0; readBytes < len; readBytes += ret) {
            ret = this.in.read(dest, readBytes + offset, len - readBytes);
            if (ret != -1) continue;
            this.finishedReading = true;
            return readBytes;
        }
        return readBytes;
    }

    protected boolean hasNextChunk() throws IOException {
        int actualUncompressedLength;
        int ret;
        if (this.finishedReading) {
            return false;
        }
        this.uncompressedCursor = 0;
        this.uncompressedLimit = 0;
        int readBytes = this.readNext(this.header, 0, 4);
        if (readBytes < 4) {
            return false;
        }
        int chunkSize = SnappyOutputStream.readInt(this.header, 0);
        if (chunkSize > SnappyOutputStream.DEFAULT_MAX_COMPRESSED_LENGTH) {
            throw new SnappyIOException(SnappyErrorCode.INVALID_CHUNK_SIZE, String.format("Unexpected chunk size %,d bytes", chunkSize));
        }
        if (chunkSize == SnappyCodec.MAGIC_HEADER_HEAD) {
            int remainingHeaderSize = SnappyCodec.headerSize() - 4;
            readBytes = this.readNext(this.header, 4, remainingHeaderSize);
            if (readBytes < remainingHeaderSize) {
                throw new SnappyIOException(SnappyErrorCode.FAILED_TO_UNCOMPRESS, String.format("Insufficient header size in a concatenated block", new Object[0]));
            }
            if (SnappyInputStream.isValidHeader(this.header)) {
                return this.hasNextChunk();
            }
            return false;
        }
        if (this.compressed == null || chunkSize > this.compressed.length) {
            this.compressed = new byte[chunkSize];
        }
        for (readBytes = 0; readBytes < chunkSize && (ret = this.in.read(this.compressed, readBytes, chunkSize - readBytes)) != -1; readBytes += ret) {
        }
        if (readBytes < chunkSize) {
            throw new IOException("failed to read chunk");
        }
        int uncompressedLength = Snappy.uncompressedLength(this.compressed, 0, chunkSize);
        if (uncompressedLength > 32768) {
            throw new SnappyIOException(SnappyErrorCode.INVALID_CHUNK_SIZE, String.format("Unexpected uncomperssed length %,d bytes", uncompressedLength));
        }
        if (this.uncompressed == null || uncompressedLength > this.uncompressed.length) {
            this.uncompressed = new byte[uncompressedLength];
        }
        if (uncompressedLength != (actualUncompressedLength = Snappy.uncompress(this.compressed, 0, chunkSize, this.uncompressed, 0))) {
            throw new SnappyIOException(SnappyErrorCode.INVALID_CHUNK_SIZE, String.format("expected %,d bytes, but decompressed chunk has %,d bytes", uncompressedLength, actualUncompressedLength));
        }
        this.uncompressedLimit = actualUncompressedLength;
        return true;
    }

    @Override
    public int read() throws IOException {
        if (this.uncompressedCursor < this.uncompressedLimit) {
            return this.uncompressed[this.uncompressedCursor++] & 0xFF;
        }
        if (this.hasNextChunk()) {
            return this.read();
        }
        return -1;
    }

    @Override
    public int available() throws IOException {
        if (this.uncompressedCursor < this.uncompressedLimit) {
            return this.uncompressedLimit - this.uncompressedCursor;
        }
        if (this.hasNextChunk()) {
            return this.uncompressedLimit - this.uncompressedCursor;
        }
        return 0;
    }

    static {
        SnappyUtil.initLibPath();
    }
}

